/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gCLINE.data;

import com.sshtools.common.authentication.KBIRequestHandlerDialog;
import com.sshtools.common.authentication.PasswordAuthenticationDialog;
import com.sshtools.common.hosts.AbstractHostKeyVerification;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.KBIAuthenticationClient;
import com.sshtools.j2ssh.authentication.KBIRequestHandler;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationPrompt;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import edu.harvard.mgh.purcell.gCLINE.StartFrame;
import edu.harvard.mgh.purcell.gCLINE.data.AutoUpdater;
import edu.harvard.mgh.purcell.gCLINE.data.KeyWords;
import edu.harvard.mgh.purcell.gCLINE.data.Lock;
import edu.harvard.mgh.purcell.gCLINE.data.OperationInfo;
import edu.harvard.mgh.purcell.gCLINE.data.RunCommand;
import edu.harvard.mgh.purcell.gCLINE.general.ErrorManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Record
extends DefaultTreeModel
implements KeyWords {
    public static String DEFAULT_EDITOR;
    private String OP_LOG_EXT = ".log";
    public StartFrame frame;
    protected Properties remoteConfig;
    protected Properties globalConfig;
    protected Properties localConfig;
    public boolean isNew;
    private HashMap<String, String> globalFileNotes;
    public Lock myLock;
    private SshClient conn;
    public AutoUpdater update;
    private static Logger logger;

    static {
        String temp = System.getProperty("os.name");
        DEFAULT_EDITOR = temp.matches(".*[wW]indow.*") ? "write" : (temp.matches(".*[mM]ac.*") ? "open -a /Applications/TextEdit.app" : "emacs");
        logger = Logger.getLogger(Record.class);
    }

    public void setLocalUpdateSec(int sec) {
        this.globalConfig.setProperty("local_update", new Integer(sec).toString());
    }

    public void setRemoteUpdateSec(int sec) {
        this.globalConfig.setProperty("remote_update", new Integer(sec).toString());
    }

    public abstract void setAutoUpdater(AutoUpdater var1);

    public void setLog(String ext) {
        this.OP_LOG_EXT = ext;
    }

    public void setConnData(SshClient c, String host, String port, String user) {
        this.conn = c;
        this.remoteConfig.setProperty("host", host);
        this.remoteConfig.setProperty("port", port);
        this.remoteConfig.setProperty("user", user);
    }

    public void setAltEditor(String editor) {
        this.globalConfig.setProperty("editor", editor);
    }

    public void setLastProject() {
        String localFolderName = this.getLocalFolder().getAbsolutePath();
        if (this.getP1() != null && this.getP1().equals(localFolderName)) {
            return;
        }
        if (this.getP2() != null && this.getP2().equals(localFolderName)) {
            this.setP2(this.getP1());
            this.setP1(localFolderName);
        } else if (this.getP3() != null && this.getP3().equals(localFolderName)) {
            this.setP3(this.getP2());
            this.setP2(this.getP1());
            this.setP1(localFolderName);
        } else {
            this.setP4(this.getP3());
            this.setP3(this.getP2());
            this.setP2(this.getP1());
            this.setP1(localFolderName);
        }
    }

    public void setP1(String name) {
        if (name != null) {
            this.globalConfig.setProperty("project1", name);
        }
    }

    public void setP2(String name) {
        if (name != null) {
            this.globalConfig.setProperty("project2", name);
        }
    }

    public void setP3(String name) {
        if (name != null) {
            this.globalConfig.setProperty("project3", name);
        }
    }

    public void setP4(String name) {
        if (name != null) {
            this.globalConfig.setProperty("project4", name);
        }
    }

    public int getLocalUpdateSec() {
        return new Integer(this.globalConfig.getProperty("local_update", "5"));
    }

    public int getRemoteUpdateSec() {
        return new Integer(this.globalConfig.getProperty("remote_update", "30"));
    }

    public String getP1() {
        return this.globalConfig.getProperty("project1", null);
    }

    public String getP2() {
        return this.globalConfig.getProperty("project2", null);
    }

    public String getP3() {
        return this.globalConfig.getProperty("project3", null);
    }

    public String getP4() {
        return this.globalConfig.getProperty("project4", null);
    }

    public String getAltEditor() {
        return this.globalConfig.getProperty("editor", null);
    }

    public SshClient getConn() {
        return this.conn;
    }

    public String getRemoteFolder() {
        if (this.remoteConfig == null) {
            return null;
        }
        return this.remoteConfig.getProperty("remote_folder", null);
    }

    public File getLocalFolder() {
        if (this.localConfig == null) {
            return null;
        }
        String localFolder = this.localConfig.getProperty("local_folder", null);
        if (localFolder == null) {
            return null;
        }
        return new File(localFolder);
    }

    public String getHomeFolder() {
        if (this.isRemote()) {
            return this.getRemoteFolder();
        }
        if (this.getLocalFolder() != null) {
            return String.valueOf(this.getLocalFolder().getAbsolutePath()) + File.separator;
        }
        return "";
    }

    public Vector<String> getHomeFiles() {
        Vector<String> ans = new Vector<String>();
        logger.info("[getHomeFiles()] getting files for");
        if (this.isRemote()) {
            RunCommand getFileList = new RunCommand("ls " + this.getRemoteFolder(), this);
            getFileList.run();
            ans = getFileList.outputLines;
        } else {
            String[] temp = null;
            if (this.getLocalFolder() != null) {
                temp = this.getLocalFolder().list();
            }
            if (temp == null) {
                return ans;
            }
            String[] stringArray = temp;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String f = stringArray[n];
                ans.add(f);
                ++n;
            }
        }
        Collections.sort(ans);
        logger.info("[getHomeFiles()] list of files: " + ans.toString());
        return ans;
    }

    public String getGlobalNote(String filename) {
        return this.globalFileNotes.get(filename);
    }

    public Vector<OperationInfo> getAllOp() {
        Vector<OperationInfo> ans = new Vector<OperationInfo>();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        int numOp = root.getChildCount();
        int i = 0;
        while (i < numOp) {
            ans.add((OperationInfo)root.getChildAt(i));
            ++i;
        }
        return ans;
    }

    public OperationInfo getOp(String opName) {
        Vector<OperationInfo> allOperations = this.getAllOp();
        for (OperationInfo op : allOperations) {
            if (!op.getName().equals(opName)) continue;
            return op;
        }
        return null;
    }

    public String getLogExt() {
        return this.OP_LOG_EXT;
    }

    public boolean loadData(File metaFile, String homefile, boolean remote) {
        Document info;
        boolean ans = false;
        logger.info("[loadData(File, String, boolean)] " + metaFile.getAbsolutePath() + " is being loaded with a " + " home file as: " + homefile + " and remote flag: " + remote);
        this.localConfig.setProperty("local_folder", metaFile.getParent());
        this.setLastProject();
        this.setRoot(new DefaultMutableTreeNode(homefile));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        DocumentBuilder parser = null;
        try {
            parser = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.frame.messanger.createError("Error trying to create a new document builder.", "loadData@Record.java");
        }
        if (metaFile.exists()) {
            ans = true;
            try {
                info = parser.parse(metaFile);
            }
            catch (SAXException e) {
                this.frame.messanger.createError("Error trying to create project, can not parse log file.\n Creating new project, please import old operations.\n ", "loadData@Record.java");
                metaFile.delete();
                return this.loadData(metaFile, homefile, remote);
            }
            catch (IOException e) {
                this.frame.messanger.createError("Error trying to create project, IOException.\n Creating newproject, please import old operations.\n ", "loadData@Report.java");
                metaFile.delete();
                return this.loadData(metaFile, homefile, remote);
            }
        } else {
            ans = false;
            info = parser.newDocument();
            Element root = info.createElement("project");
            root.setAttribute("home", homefile);
            info.appendChild(root);
            info.getDocumentElement().setAttribute("local_folder", metaFile.getParent());
            Element globalDisc = info.createElement("folder");
            root.appendChild(globalDisc);
        }
        if (remote) {
            info.getDocumentElement().setAttribute("remote_folder", homefile);
        } else {
            info.getDocumentElement().removeAttribute("remote_folder");
        }
        this.populateNodes(info);
        logger.info("[loadData(File, String, boolean)] ... exiting");
        return ans;
    }

    private void populateNodes(Document info) {
        logger.info("[populateNodes(Document)] Entering...");
        this.localConfig.setProperty("home", info.getDocumentElement().getAttribute("home"));
        Node opIndex = info.getDocumentElement().getFirstChild();
        while (opIndex != null) {
            if (opIndex.getNodeName().equals("folder")) {
                Node fileIndex = opIndex.getFirstChild();
                while (fileIndex != null) {
                    if (fileIndex.getNodeName().equals("entity")) {
                        this.setGlobalFileDisc(((Element)fileIndex).getAttribute("name"), fileIndex.getTextContent());
                    }
                    fileIndex = fileIndex.getNextSibling();
                }
            }
            if (opIndex.getNodeName().equals("operation")) {
                String opName = ((Element)opIndex).getAttribute("name");
                String cline = ((Element)opIndex).getAttribute("cline");
                String opDisc = "";
                Vector<String[]> infiles = new Vector<String[]>();
                Vector<String[]> outfiles = new Vector<String[]>();
                Node fileGroupIndex = opIndex.getFirstChild();
                while (fileGroupIndex != null) {
                    if (fileGroupIndex.getNodeType() == 3) {
                        opDisc = fileGroupIndex.getNodeValue();
                    } else {
                        Node fileIndex = fileGroupIndex.getFirstChild();
                        while (fileIndex != null) {
                            if (fileGroupIndex.getNodeName().equals("input")) {
                                infiles.add(new String[]{((Element)fileIndex).getAttribute("name"), fileIndex.getTextContent()});
                            }
                            if (fileGroupIndex.getNodeName().equals("output")) {
                                outfiles.add(new String[]{((Element)fileIndex).getAttribute("name"), fileIndex.getTextContent()});
                            }
                            fileIndex = fileIndex.getNextSibling();
                        }
                    }
                    fileGroupIndex = fileGroupIndex.getNextSibling();
                }
                String time = ((Element)opIndex).getAttribute("time");
                if (time == null || time.matches("^\\s*$")) {
                    time = OperationInfo.DATEFORMAT.format(new Date(OperationInfo.getLog(this.getLocalFolder(), this.OP_LOG_EXT, outfiles).lastModified()));
                }
                this.addOperation(opName, opDisc, cline, time, infiles, outfiles);
            }
            opIndex = opIndex.getNextSibling();
        }
        logger.info("[populateNodes(Document)] ...exiting");
    }

    private Document processNodes() {
        logger.info("[processNodes()] Entering...");
        DefaultMutableTreeNode recordRoot = (DefaultMutableTreeNode)this.getRoot();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        DocumentBuilder parser = null;
        try {
            parser = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.error("(processNodes()) Error trying to create a new document builder.");
            this.frame.messanger.createError("Error trying to create a new document builder.", "processNodes@Record.java");
            return null;
        }
        Document info = parser.newDocument();
        Element root = info.createElement("project");
        root.setAttribute("home", this.getHomeFolder());
        if (this.isRemote()) {
            root.setAttribute("remote_folder", this.getRemoteFolder());
        }
        Element globalNotes = info.createElement("folder");
        for (String key : this.globalFileNotes.keySet()) {
            Element fileNote = info.createElement("entity");
            fileNote.setAttribute("name", key);
            fileNote.setTextContent(this.globalFileNotes.get(key));
            globalNotes.appendChild(fileNote);
        }
        root.appendChild(globalNotes);
        if (!recordRoot.isLeaf()) {
            OperationInfo opIndex = (OperationInfo)recordRoot.getFirstChild();
            while (opIndex != null) {
                root.appendChild(opIndex.asElement(info));
                opIndex = (OperationInfo)opIndex.getNextSibling();
            }
        }
        info.appendChild(root);
        logger.info("[processNodes()] ...exiting");
        return info;
    }

    private void loadGlobalConfig() {
        logger.info("[loadGlobalConfig()] Entering...  [" + GLOBAL_CONFIG + "]");
        File globalFile = new File(GLOBAL_CONFIG);
        try {
            this.globalConfig.load(new FileInputStream(globalFile));
        }
        catch (FileNotFoundException e) {
            logger.error("(loadGlobalConfig) File not found exception.");
        }
        catch (IOException e) {
            logger.error("(loadGlobalConfig) IOException");
        }
        logger.info("[loadGlobalConfig()] ...exiting");
    }

    protected abstract void loadRemoteConfig();

    protected abstract void saveRemoteConfig();

    public void saveConfig() {
        if (this.globalConfig == null) {
            return;
        }
        logger.info("[saveConfig()] Entering...");
        File globalFile = new File(GLOBAL_CONFIG);
        if (this.isRemote()) {
            logger.info("[saveConfig()] data flaged as remote");
            try {
                this.remoteConfig.store(new FileOutputStream(new File(this.getLocalFolder(), ".remote_gPLINK")), "Remote Configuretion");
            }
            catch (FileNotFoundException e) {
                logger.error("[saveConfig()] FileNotFoundException trying to store remote config file.");
                this.frame.messanger.createError("Can not store remote information. File not found.", "saveConfig()@Record.java");
            }
            catch (IOException e) {
                logger.error("[saveConfig()] IOException trying to store remote config file.");
                this.frame.messanger.createError("Can not store remote information.", "saveConfig()@Record.java");
            }
            this.saveRemoteConfig();
        } else {
            logger.info("(saveConfig) saving global configuration [" + GLOBAL_CONFIG + "]");
            try {
                this.globalConfig.store(new FileOutputStream(globalFile), "Global configuration for gCLINE");
            }
            catch (FileNotFoundException e) {
                logger.error("[saveConfig()] FileNotFoundException trying to store global config file.");
                this.frame.messanger.createError("Can not store remote information. File not found.", "saveConfig()@Record.java");
            }
            catch (IOException e) {
                logger.error("[saveConfig()] IOException trying to store global config file.");
                this.frame.messanger.createError("Can not store remote information.", "saveConfig()@Record.java");
            }
        }
        logger.info("[saveConfig()] ...exiting");
    }

    public boolean addOperation(String opName, String opDisc, String cline, String createTime, Vector<String[]> infiles, Vector<String[]> outfiles) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        if (opName == null || opDisc == null || cline == null || infiles == null || outfiles == null) {
            return false;
        }
        int index = this.removeOperation(opName);
        OperationInfo newOp = this.getOp(opName);
        newOp = new OperationInfo(opName, opDisc, cline, createTime, this);
        for (String[] file : infiles) {
            newOp.addFile("input", file[0], file[1], this.globalFileNotes.get(file[0]));
        }
        for (String[] file : outfiles) {
            newOp.addFile("output", file[0], file[1], this.globalFileNotes.get(file[0]));
        }
        if (index == -1) {
            index = this.getChildCount(root);
        }
        logger.info("[addOperation(String, ...)] adding operation" + opName + "to index: " + index);
        this.insertNodeInto(newOp, root, index);
        this.nodeStructureChanged(root);
        if (this.update != null) {
            this.update.addOp(opName);
        }
        return true;
    }

    public int removeOperation(String opName) {
        OperationInfo oldOp = this.getOp(opName);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        int ans = -1;
        if (oldOp != null) {
            ans = root.getIndex(oldOp);
            this.removeNodeFromParent(oldOp);
        }
        return ans;
    }

    public void setGlobalFileDisc(String fileName, String fileDisc) {
        this.globalFileNotes.put(fileName, fileDisc);
    }

    public boolean isRemote() {
        String ans = this.getRemoteFolder();
        logger.info("[isRemote()] the project is remote: " + ans);
        return ans != null;
    }

    public boolean saveInfo() {
        return this.saveInfo(new File(this.getLocalFolder(), ".metafile_gPLINK"));
    }

    public boolean backupInfo() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MMM-dd-HH-mm-ss");
        Date date = new Date();
        File outputFile = new File(this.getLocalFolder(), "backup" + dateFormat.format(date) + ".xml");
        return this.saveInfo(outputFile);
    }

    public boolean saveInfo(File metaFile) {
        logger.info("(saveInfo(File)) Entering");
        if (this.frame.getBrowseOnly()) {
            logger.warn("[saveInfo(File)] not saving project because we are browse only");
            return false;
        }
        if (this.myLock.availableLock() && !this.myLock.lockFile()) {
            logger.warn("[saveInfo(File)] unable to lock file(1)");
            return false;
        }
        if (!this.myLock.hasLock() && !this.myLock.stealLock()) {
            this.frame.setBrowseOnly(true);
            logger.warn("[saveInfo(File)] unable to steal the lock");
            return false;
        }
        Document info = this.processNodes();
        if (this.isRemote()) {
            try {
                this.remoteConfig.store(new FileOutputStream(new File(this.getLocalFolder(), ".remote_gPLINK")), "Remote Configuretion");
            }
            catch (FileNotFoundException e) {
                this.frame.messanger.createError("Can not store remote information. File not found.", "saveInfo@Record.java");
            }
            catch (IOException e) {
                this.frame.messanger.createError("Can not store remote information.", "saveInfo@Record.java");
            }
        }
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = tFactory.newTransformer();
        }
        catch (TransformerConfigurationException e1) {
            this.frame.messanger.createError("Error trying to create transformer.", "saveInfo@Record.java");
            logger.warn("[saveInfo(File)] error creating transformer, returning false");
            return false;
        }
        DOMSource source = new DOMSource(info);
        StreamResult ofile = null;
        try {
            logger.info("(saveInfo())Write the project info to: " + metaFile.getAbsolutePath() + "in the file: " + this.getLocalFolder());
            ofile = new StreamResult(new FileWriter(metaFile));
        }
        catch (IOException e) {
            this.frame.messanger.createError("Error trying to create file stream.", "saveInfo@Record.java");
            logger.warn("[saveInfo(File)] error creating filestream, returning false");
            return false;
        }
        try {
            transformer.transform(source, ofile);
        }
        catch (TransformerException e) {
            this.frame.messanger.createError("Error trying to transform source tofile stream.", "saveInfo@Record.java");
            logger.warn("[saveInfo(File)] error transforming source to filestream, returning false");
            return false;
        }
        logger.info("[saveInfo(File)] uploading the metafile: [" + this.getRemoteFolder() + "] [" + metaFile + "]");
        if (this.isRemote()) {
            StartFrame startFrame = this.frame;
            startFrame.getClass();
            new Thread(new StartFrame.Upload(startFrame, this, true, this.getRemoteFolder(), new File[]{metaFile})).start();
        }
        logger.info("[saveInfo(File)] Exiting true");
        return true;
    }

    public String toString() {
        if (this.isRemote()) {
            return this.getRemoteFolder();
        }
        return this.getLocalFolder().getAbsolutePath();
    }

    public boolean connect() {
        logger.info("[connect()] Entering...");
        if (this.conn != null) {
            this.conn.disconnect();
        }
        String host = this.remoteConfig.getProperty("host", "");
        int port = new Integer(this.remoteConfig.getProperty("port", "22"));
        String user = this.remoteConfig.getProperty("user", "");
        this.conn = Record.connect(this.frame.messanger, this.frame, host, user, port);
        logger.info("[connect()] ...exiting");
        return this.conn != null;
    }

    public static SshClient connect(ErrorManager em, JFrame frame, String host, String user, int port) {
        JDialog dialog;
        logger.info("[connect(ErrorManager, JFrame, String, String, int)] Entering...");
        SshClient conn = new SshClient();
        try {
            conn.connect(host, port, new myHostKeyValidator());
        }
        catch (NumberFormatException e) {
            logger.error("[connect(ErrorManager, JFrame, String, String, int)] Can not establish a connection: NumberFormatException");
            em.createError("NumberFormatException: Error trying to establish connection.[" + user + "@" + host + ":" + port + "].", "connect():Record.java");
            return null;
        }
        catch (IOException e) {
            logger.error("([connect(ErrorManager, JFrame, String, String, int)] IOException: Can not establish a connection: IOException " + e.getMessage() + "\n " + e.getStackTrace()[0].toString());
            em.createError("Error trying to establish ssh connection [" + user + "@" + host + ":" + port + "].", "connect:Project.java");
            return null;
        }
        boolean kyboardI = false;
        try {
            List options = conn.getAvailableAuthMethods(user);
            String allOptions = "";
            for (String name : options) {
                allOptions = String.valueOf(allOptions) + " [" + name + "]";
            }
            logger.info("(connect) We have the following auterization options:" + allOptions);
            kyboardI = options.contains("keyboard-interactive");
        }
        catch (IOException e2) {
            logger.error("[connect(ErrorManager, JFrame, String, String, int)] Can not establish ssh auth methods");
            em.createError("Error trying to establish ssh auth methods[" + user + "@" + host + ":" + port + "]", "connect():Project.java");
            return null;
        }
        int result = 2;
        logger.info("[connect(ErrorManager, JFrame, String, String, int)] keyboard interactive flag is: [" + kyboardI + "] result is: [" + result + "]");
        if (kyboardI) {
            KBIAuthenticationClient kbi = new KBIAuthenticationClient();
            dialog = new KBIRequestHandlerDialog(frame);
            kbi.setKBIRequestHandler((KBIRequestHandler)((Object)dialog));
            kbi.setUsername(user);
            try {
                result = conn.authenticate(kbi);
                logger.info("[connect(ErrorManager, JFrame, String, String, int)] result value is: " + result);
            }
            catch (IOException e) {
                logger.error("[connect(ErrorManager, JFrame, String, String, int)] Can not authenticate (keyboard-interative) ssh connection [" + user + "@" + host + ":" + port + "]. \n");
                em.createError("Error trying to authenticate (keyboard-interative) ssh connection [" + user + "@" + host + ":" + port + "].", "launchLogin:ProjectDialog.java");
                return null;
            }
        }
        if (result == 2) {
            PasswordAuthenticationClient pwd = new PasswordAuthenticationClient();
            dialog = new PasswordAuthenticationDialog(frame);
            pwd.setUsername(user);
            try {
                pwd.setAuthenticationPrompt((SshAuthenticationPrompt)((Object)dialog));
            }
            catch (AuthenticationProtocolException e) {
                logger.error("[connect(ErrorManager, JFrame, String, String, int)] Can not set authenticate prompt(password)[" + user + "@" + host + ":" + port + "]. \n");
                em.createError("Can not set authenticate prompt(password) [" + user + "@" + host + ":" + port + "].", "launchLogin:ProjectDialog.java");
                return null;
            }
            try {
                result = conn.authenticate(pwd);
            }
            catch (IOException e) {
                logger.error("[connect(ErrorManager, JFrame, String, String, int)] Can not authenticate (password) ssh connection [" + user + "@" + host + ":" + port + "]. \n");
                em.createError("Error trying to authenticate (password) ssh connection [" + user + "@" + host + ":" + port + "].", "launchLogin:ProjectDialog.java");
                return null;
            }
        }
        if (result == 2) {
            logger.error("[connect(ErrorManager, JFrame, String, String, int)] Error failure to establish ssh connection,  AuthenticationProtocolState: FAILED[" + user + "@" + host + ":" + port + "].");
            em.createError("Error failure to establish ssh connection[" + user + "@" + host + ":" + port + "].", "connect:Project.java");
            return null;
        }
        if (result == 3) {
            logger.error("[connect(ErrorManager, JFrame, String, String, int)]  Error failure to establish full ssh connection, AuthenticationProtocolState: PARTIAL[" + user + "@" + host + ":" + port + "].");
            em.createError("Error failure to establish full ssh connection[" + user + "@" + host + ":" + port + "].", "connect:Project.java");
            return null;
        }
        if (result == 4) {
            logger.info("[connect(ErrorManager, JFrame, String, String, int)] Auth complete!");
            return conn;
        }
        logger.error("[connect(ErrorManager, JFrame, String, String, int)] Didn't complete authorization!");
        return null;
    }

    public Record() {
        super(new DefaultMutableTreeNode());
        logger.info("[Record()] Entering...");
        this.frame = null;
        this.globalConfig = new Properties();
        this.remoteConfig = new Properties();
        this.localConfig = new Properties();
        this.globalFileNotes = new HashMap();
        this.myLock = null;
        this.conn = null;
        this.update = null;
        this.loadGlobalConfig();
        logger.info("[Record()] ...exiting");
    }

    public Record(StartFrame f) {
        this();
        logger.info("[Record(StartFrame)] Entering...");
        this.frame = f;
        DefaultMutableTreeNode temp = new DefaultMutableTreeNode("");
        this.setRoot(temp);
        this.nodeChanged(temp);
        if (f != null) {
            f.setBrowseOnly(false);
        }
        logger.info("[Record(StartFrame)] ...exiting");
    }

    public Record(StartFrame f, String localName) {
        this(f);
        logger.info("[Record(StartFrame, String)] Entering...");
        this.frame.messanger = new ErrorManager(this.frame);
        this.remoteConfig = new Properties();
        this.localConfig = new Properties();
        this.isNew = this.loadData(new File(String.valueOf(localName) + File.separator + ".metafile_gPLINK"), localName, false);
        this.myLock = new Lock(this.frame, this);
        if (!this.frame.getBrowseOnly()) {
            if (this.myLock.availableLock()) {
                this.myLock.lockFile();
            } else {
                this.frame.setBrowseOnly(!this.myLock.stealLock());
            }
        }
        logger.info("[Record(StartFrame, String)] ...exiting");
    }

    public Record(StartFrame f, String localName, String remoteFileName, String hostname, String username, String portnum, SshClient c) {
        this(f);
        logger.info("[Record(StartFrame, String, String, String, String , String, SshClient)] Entering...");
        this.conn = c;
        this.frame.messanger = new ErrorManager(this.frame);
        logger.info("[Record(StartFrame, String, String, String, String , String, SshClient)] set properties");
        if (!remoteFileName.endsWith("/")) {
            remoteFileName = String.valueOf(remoteFileName) + "/";
        }
        this.remoteConfig.setProperty("remote_folder", remoteFileName);
        this.remoteConfig.setProperty("host", hostname);
        this.remoteConfig.setProperty("user", username);
        this.remoteConfig.setProperty("port", portnum);
        try {
            this.remoteConfig.store(new FileOutputStream(new File(this.getLocalFolder(), ".remote_gPLINK")), "Remote Configuretion");
        }
        catch (FileNotFoundException e) {
            this.frame.messanger.createError("Can not store remote information. File not found.", "saveInfo@Record.java");
        }
        catch (IOException e) {
            this.frame.messanger.createError("Can not store remote information.", "saveInfo@Record.java");
        }
        this.localConfig.setProperty("local_folder", localName);
        logger.info("[Record(StartFrame, String, String, String, String , String, SshClient)] download and load metafile");
        new File(this.getLocalFolder(), ".metafile_gPLINK").delete();
        StartFrame startFrame = this.frame;
        startFrame.getClass();
        new StartFrame.Download(startFrame, this, true, this.getLocalFolder(), new String[]{String.valueOf(remoteFileName) + ".metafile_gPLINK"}).run();
        this.isNew = this.loadData(new File(String.valueOf(localName) + File.separator + ".metafile_gPLINK"), remoteFileName, true);
        logger.info("[Record(StartFrame, String, String, String, String , String, SshClient)] locking");
        this.myLock = new Lock(this.frame, this);
        if (this.myLock.availableLock()) {
            this.myLock.lockFile();
        }
        logger.info("[Record(StartFrame, String, String, String, String , String, SshClient)] calling loadRemoteConfig()");
        this.loadRemoteConfig();
        logger.info("[Record(StartFrame, String, String, String, String , String, SshClient)] ...exiting");
    }

    public void properClosing() {
        logger.info("[properClosing()] Entering...");
        this.saveConfig();
        if (this.update != null) {
            this.update.cancel();
            this.update = null;
        }
        if (this.myLock != null && this.myLock.hasLock()) {
            this.saveInfo();
            this.myLock.unlockFile();
            this.myLock = null;
        }
        if (this.conn != null) {
            this.conn.disconnect();
        }
        this.remoteConfig = null;
        this.globalConfig = null;
        this.localConfig = null;
        this.setRoot(null);
        logger.info("[properClosing()] ...exiting");
    }

    private static class myHostKeyValidator
    extends AbstractHostKeyVerification {
        public myHostKeyValidator() throws InvalidHostFileException {
            super(null);
        }

        public void onDeniedHost(String host) throws TransportProtocolException {
            new ErrorManager(null).createError("Access to '" + host + "' is denied.\n" + "Verify the access granted/denied in the allowed hosts file.", "onDenialHost(String)@myHostKeyValidator.Record.java");
        }

        public void onHostKeyMismatch(String host, String allowedHostKey, String actualHostKey) throws TransportProtocolException {
            this.allowHost(host, actualHostKey, false);
        }

        public void onUnknownHost(String host, String hostKeyFingerprint) throws TransportProtocolException {
            this.allowHost(host, hostKeyFingerprint, false);
        }
    }
}

