/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gCLINE;

import edu.harvard.mgh.purcell.gCLINE.DeleteOpDialog;
import edu.harvard.mgh.purcell.gCLINE.EditFolderDialog;
import edu.harvard.mgh.purcell.gCLINE.EditOpDialog;
import edu.harvard.mgh.purcell.gCLINE.HierarchyDialog;
import edu.harvard.mgh.purcell.gCLINE.LinkNewFileDialog;
import edu.harvard.mgh.purcell.gCLINE.StartFrame;
import edu.harvard.mgh.purcell.gCLINE.data.FileInfo;
import edu.harvard.mgh.purcell.gCLINE.data.Record;
import edu.harvard.mgh.purcell.gCLINE.data.RunCommand;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public abstract class PopUpMenu
extends JPopupMenu {
    private static Logger logger = Logger.getLogger(PopUpMenu.class);
    protected String[] localFilenames;
    protected String[] remoteFilenames;
    protected String[] fileNames;
    protected String[] opnames;
    private StartFrame frame;
    protected Record data;
    private String flagExt;
    private ActionListener download = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            logger.info("[download] find the null! frame: " + (PopUpMenu.this.frame != null) + ", data: " + (PopUpMenu.this.data != null) + ", localFolder: " + PopUpMenu.this.data.getLocalFolder() + ", first remoteFile: " + PopUpMenu.this.remoteFilenames[0]);
            StartFrame startFrame = PopUpMenu.this.frame;
            startFrame.getClass();
            new Thread(new StartFrame.Download(startFrame, PopUpMenu.this.data, false, PopUpMenu.this.data.getLocalFolder(), PopUpMenu.this.remoteFilenames)).start();
        }
    };
    private ActionListener openAlt = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            int i = 0;
            while (i < PopUpMenu.this.localFilenames.length) {
                new Thread(new RunCommand(String.valueOf(PopUpMenu.this.data.getAltEditor()) + " " + FileInfo.quote(PopUpMenu.this.localFilenames[i]), PopUpMenu.this.data, true)).start();
                ++i;
            }
        }
    };
    private ActionListener openDefault = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            int i = 0;
            while (i < PopUpMenu.this.localFilenames.length) {
                new Thread(new RunCommand(String.valueOf(Record.DEFAULT_EDITOR) + " " + FileInfo.quote(PopUpMenu.this.localFilenames[i]), PopUpMenu.this.data, true)).start();
                ++i;
            }
        }
    };
    private ActionListener showHierachyOp = new ActionListener(){

        public void actionPerformed(ActionEvent arg0) {
            new HierarchyDialog(PopUpMenu.this.opnames[0], PopUpMenu.this.frame, PopUpMenu.this.data, PopUpMenu.this.opnames[0], null);
        }
    };
    private ActionListener showHierachyFile = new ActionListener(){

        public void actionPerformed(ActionEvent arg0) {
            if (PopUpMenu.this.data.isRemote()) {
                new HierarchyDialog(FileInfo.fileName(PopUpMenu.this.remoteFilenames[0]), PopUpMenu.this.frame, PopUpMenu.this.data, null, PopUpMenu.this.remoteFilenames[0]);
            } else {
                new HierarchyDialog(FileInfo.fileName(PopUpMenu.this.localFilenames[0]), PopUpMenu.this.frame, PopUpMenu.this.data, null, PopUpMenu.this.localFilenames[0]);
            }
        }
    };
    private ActionListener editOp = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            new EditOpDialog(PopUpMenu.this.opnames[0], PopUpMenu.this.frame, PopUpMenu.this.data);
        }
    };
    private ActionListener editFile = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            new EditFolderDialog(PopUpMenu.this.frame, PopUpMenu.this.data, PopUpMenu.this.fileNames);
        }
    };
    private ActionListener deleteOp = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            new DeleteOpDialog(PopUpMenu.this.frame, PopUpMenu.this.data, PopUpMenu.this.opnames, PopUpMenu.this.flagExt);
        }
    };
    private ActionListener addFileToOp = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            new LinkNewFileDialog(PopUpMenu.this.frame, PopUpMenu.this.data, PopUpMenu.this.opnames[0]);
        }
    };
    private ActionListener removeFileFromOp = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            int choice = JOptionPane.showConfirmDialog(PopUpMenu.this.frame, "Are you sure you want to unlink " + PopUpMenu.this.fileNames[0] + " from " + PopUpMenu.this.opnames[0] + "?", "GPLINK confirmation", 0);
            if (choice != 0) {
                return;
            }
            PopUpMenu.this.data.getOp(PopUpMenu.this.opnames[0]).removeFile(PopUpMenu.this.fileNames[0]);
        }
    };

    protected abstract ActionListener createExicute();

    public PopUpMenu(StartFrame mf, Record d, String[] givenFiles, String[] givenOp, String flagExitStatus) {
        this.opnames = givenOp;
        this.frame = mf;
        this.data = d;
        this.flagExt = flagExitStatus;
        boolean openFile = false;
        if (givenFiles != null && givenFiles.length != 0) {
            if (this.data.isRemote()) {
                this.remoteFilenames = new String[givenFiles.length];
            }
            this.fileNames = new String[givenFiles.length];
            this.localFilenames = new String[givenFiles.length];
            int i = 0;
            while (i < givenFiles.length) {
                this.fileNames[i] = FileInfo.fileName(givenFiles[i]);
                this.localFilenames[i] = new File(this.data.getLocalFolder(), this.fileNames[i]).getAbsolutePath();
                if (this.data.isRemote()) {
                    this.remoteFilenames[i] = String.valueOf(this.data.getRemoteFolder()) + this.fileNames[i];
                }
                ++i;
            }
            openFile = true;
            if (openFile) {
                JMenuItem getFile = new JMenuItem("Download file");
                getFile.addActionListener(this.download);
                boolean localCopy = true;
                int i2 = 0;
                while (i2 < this.localFilenames.length) {
                    if (!new File(this.localFilenames[i2]).exists()) {
                        localCopy = false;
                    }
                    ++i2;
                }
                if (this.data.isRemote()) {
                    this.add(getFile);
                    this.add(new JPopupMenu.Separator());
                }
                if (localCopy) {
                    JMenuItem open = new JMenuItem("Open in default viewer");
                    open.addActionListener(this.openDefault);
                    this.add(open);
                    String altEdit = this.data.getAltEditor();
                    if (altEdit != null && !altEdit.matches("^\\s*$")) {
                        JMenuItem openAlter = new JMenuItem("Open in alternate viewer");
                        openAlter.addActionListener(this.openAlt);
                        this.add(openAlter);
                    }
                    this.add(new JPopupMenu.Separator());
                }
            }
            JMenuItem fileParents = this.data.isRemote() ? new JMenuItem("Show relations of " + FileInfo.fileName(this.remoteFilenames[0])) : new JMenuItem("Show relations of " + FileInfo.fileName(this.localFilenames[0]));
            fileParents.addActionListener(this.showHierachyFile);
            this.add(fileParents);
        }
        if (this.opnames != null) {
            JMenuItem opParents = new JMenuItem("Show relations of " + this.opnames[0]);
            opParents.addActionListener(this.showHierachyOp);
            this.add(opParents);
        }
        this.add(new JPopupMenu.Separator());
        if (givenOp != null) {
            if (this.fileNames != null) {
                JMenuItem unlink = new JMenuItem("Unlink " + this.fileNames[0] + " from " + this.opnames[0]);
                unlink.addActionListener(this.removeFileFromOp);
                this.add(unlink);
            }
            JMenuItem opAdd = new JMenuItem("Link a file to " + this.opnames[0]);
            opAdd.addActionListener(this.addFileToOp);
            this.add(opAdd);
            this.add(new JPopupMenu.Separator());
            JMenuItem opCreate = new JMenuItem("Create new operation");
            opCreate.addActionListener(this.createExicute());
            this.add(opCreate);
            this.add(new JPopupMenu.Separator());
        }
        if (givenFiles != null && givenOp == null) {
            JMenuItem fileEdit = new JMenuItem("Edit");
            fileEdit.addActionListener(this.editFile);
            this.add(fileEdit);
        }
        if (givenOp != null) {
            JMenuItem opEdit = new JMenuItem("Edit");
            opEdit.addActionListener(this.editOp);
            this.add(opEdit);
            JMenuItem opDelete = new JMenuItem("Delete operation");
            opDelete.addActionListener(this.deleteOp);
            this.add(opDelete);
        }
    }
}

