/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gCLINE;

import edu.harvard.mgh.purcell.gCLINE.StartFrame;
import edu.harvard.mgh.purcell.gCLINE.data.FileInfo;
import edu.harvard.mgh.purcell.gCLINE.data.OperationInfo;
import edu.harvard.mgh.purcell.gCLINE.data.Record;
import java.awt.Frame;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.log4j.Logger;

public class HierarchyDialog
extends JDialog {
    private static Logger logger = Logger.getLogger(HierarchyDialog.class);
    JTree ancesters;
    JTree decendents;
    Record data;
    String opName;
    String fileName;

    private String myArrayString(String[] info) {
        String ans = "<html> ";
        if (info.length > 0) {
            ans = String.valueOf(ans) + info[0];
        }
        int i = 1;
        while (i < info.length) {
            ans = String.valueOf(ans) + " <br> " + info[i];
            ++i;
        }
        ans = String.valueOf(ans) + " </html>";
        return ans;
    }

    private void createTree() {
        DefaultMutableTreeNode childTop = new DefaultMutableTreeNode("");
        DefaultMutableTreeNode parentTop = new DefaultMutableTreeNode("");
        if (this.opName != null) {
            childTop = new DefaultMutableTreeNode(this.opName);
            parentTop = new DefaultMutableTreeNode(this.opName);
            this.childrenOp(this.opName, childTop);
            this.parentOp(this.opName, parentTop);
        } else if (this.fileName != null) {
            childTop = new DefaultMutableTreeNode(this.fileName);
            parentTop = new DefaultMutableTreeNode(this.fileName);
            this.childrenFile(new String[]{this.fileName}, childTop);
            this.parentFile(new String[]{this.fileName}, parentTop);
        }
        this.ancesters = new JTree(parentTop);
        this.decendents = new JTree(childTop);
    }

    private String[] getOutFiles(String opName) {
        Vector<FileInfo> temp = this.data.getOp(opName).getOutputFiles();
        String[] ans = new String[temp.size()];
        int i = 0;
        while (i < ans.length) {
            ans[i] = temp.get(i).toString();
            ++i;
        }
        return ans;
    }

    private String[] getInFiles(String opName) {
        Vector<FileInfo> temp = this.data.getOp(opName).getInputFiles();
        String[] ans = new String[temp.size()];
        int i = 0;
        while (i < ans.length) {
            ans[i] = temp.get(i).toString();
            ++i;
        }
        return ans;
    }

    private void childrenOp(String op, DefaultMutableTreeNode parent) {
        String[] outfiles = this.getOutFiles(op);
        DefaultMutableTreeNode temp = new DefaultMutableTreeNode(this.myArrayString(outfiles));
        this.childrenFile(outfiles, temp);
        parent.add(temp);
    }

    private void parentOp(String op, DefaultMutableTreeNode parent) {
        String[] outfiles = this.getInFiles(op);
        DefaultMutableTreeNode temp = new DefaultMutableTreeNode(this.myArrayString(outfiles));
        this.parentFile(outfiles, temp);
        parent.add(temp);
    }

    private String[] getChildOp(String file) {
        Vector<OperationInfo> allOp = this.data.getAllOp();
        HashSet<String> ansHash = new HashSet<String>();
        block0: for (OperationInfo op : allOp) {
            Vector<FileInfo> infiles = op.getInputFiles();
            for (FileInfo temp : infiles) {
                if (!temp.toString().equals(file)) continue;
                ansHash.add(op.getName());
                continue block0;
            }
        }
        String[] ans = new String[ansHash.size()];
        int i = 0;
        Iterator iterator = ansHash.iterator();
        while (iterator.hasNext()) {
            String name;
            ans[i] = name = (String)iterator.next();
            ++i;
        }
        return ans;
    }

    private String[] getParentOp(String file) {
        Vector<OperationInfo> allOp = this.data.getAllOp();
        HashSet<String> ansHash = new HashSet<String>();
        block0: for (OperationInfo op : allOp) {
            Vector<FileInfo> outfiles = op.getOutputFiles();
            for (FileInfo temp : outfiles) {
                if (!temp.toString().equals(file)) continue;
                ansHash.add(op.getName());
                continue block0;
            }
        }
        String[] ans = new String[ansHash.size()];
        int i = 0;
        Iterator iterator = ansHash.iterator();
        while (iterator.hasNext()) {
            String name;
            ans[i] = name = (String)iterator.next();
            ++i;
        }
        return ans;
    }

    private void childrenFile(String[] files, DefaultMutableTreeNode parent) {
        HashSet<String> allOp = new HashSet<String>();
        int i = 0;
        while (i < files.length) {
            String[] childOp = this.getChildOp(files[i]);
            int j = 0;
            while (j < childOp.length) {
                allOp.add(childOp[j]);
                ++j;
            }
            ++i;
        }
        if (allOp == null || allOp.size() == 0) {
            return;
        }
        for (String opName : allOp) {
            DefaultMutableTreeNode temp = new DefaultMutableTreeNode(opName);
            this.childrenOp(opName, temp);
            parent.add(temp);
        }
    }

    private void parentFile(String[] files, DefaultMutableTreeNode parent) {
        HashSet<String> allOp = new HashSet<String>();
        int i = 0;
        while (i < files.length) {
            String[] parentOp = this.getParentOp(files[i]);
            int j = 0;
            while (j < parentOp.length) {
                allOp.add(parentOp[j]);
                ++j;
            }
            ++i;
        }
        if (allOp == null || allOp.size() == 0) {
            return;
        }
        for (String opName : allOp) {
            DefaultMutableTreeNode temp = new DefaultMutableTreeNode(opName);
            this.parentOp(opName, temp);
            parent.add(temp);
        }
    }

    public HierarchyDialog(String title, StartFrame mf, Record d, String op, String file) {
        super((Frame)mf, title);
        logger.info("[HirarchyDialog(...)] starting constructor");
        this.data = d;
        this.opName = op;
        this.fileName = FileInfo.fileName(file);
        logger.info("[HirarchyDialog(...)] starting createTree()");
        this.createTree();
        logger.info("[HirarchyDialog(...)] setting renderer");
        this.ancesters.setCellRenderer(new MyRenderer());
        this.ancesters.setRowHeight(0);
        this.decendents.setCellRenderer(new MyRenderer());
        this.decendents.setRowHeight(0);
        logger.info("[HirarchyDialog(...)] put it all together");
        JTabbedPane tabs = new JTabbedPane();
        tabs.add("Ancestors", new JScrollPane(this.ancesters));
        tabs.add("Descendents", new JScrollPane(this.decendents));
        this.getContentPane().add(tabs);
        this.pack();
        this.setVisible(true);
    }

    class MyRenderer
    extends DefaultTreeCellRenderer {
        public MyRenderer() {
            this.setBackgroundSelectionColor(this.getBackgroundNonSelectionColor());
            this.setTextSelectionColor(this.getTextNonSelectionColor());
        }
    }
}

