/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey.dsa;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPair;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.dsa.SshDssPrivateKey;
import com.sshtools.j2ssh.transport.publickey.dsa.SshDssPublicKey;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;

public class SshDssKeyPair
extends SshKeyPair {
    public SshPrivateKey decodePrivateKey(byte[] encoded) throws InvalidSshKeyException {
        return new SshDssPrivateKey(encoded);
    }

    public SshPublicKey decodePublicKey(byte[] encoded) throws InvalidSshKeyException {
        return new SshDssPublicKey(encoded);
    }

    public void generate(int bits) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DSA");
            keyGen.initialize(bits, ConfigurationLoader.getRND());
            KeyPair pair = keyGen.generateKeyPair();
            DSAPrivateKey prvKey = (DSAPrivateKey)pair.getPrivate();
            DSAPublicKey pubKey = (DSAPublicKey)pair.getPublic();
            this.setPrivateKey(new SshDssPrivateKey(prvKey));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }
}

