/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelState;
import com.sshtools.j2ssh.connection.SshMsgChannelData;
import com.sshtools.j2ssh.connection.SshMsgChannelExtendedData;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SocketChannel
extends Channel {
    private static Log log = LogFactory.getLog(SocketChannel.class);
    protected Socket socket = null;
    Thread thread;

    public void bindSocket(Socket socket) throws IOException {
        if (this.state.getValue() != 1) {
            throw new IOException("The socket can only be bound to an unitialized channel");
        }
        this.socket = socket;
    }

    protected void onChannelData(SshMsgChannelData msg) throws IOException {
        try {
            this.socket.getOutputStream().write(msg.getChannelData());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void onChannelEOF() throws IOException {
        try {
            this.socket.shutdownOutput();
        }
        catch (IOException ex) {
            log.info("Failed to shutdown Socket OutputStream in response to EOF event: " + ex.getMessage());
        }
    }

    protected void onChannelClose() throws IOException {
        try {
            this.socket.close();
        }
        catch (IOException ex) {
            log.info("Failed to close socket on channel close event: " + ex.getMessage());
        }
    }

    protected void onChannelOpen() throws IOException {
        if (this.socket == null) {
            throw new IOException("The socket must be bound to the channel before opening");
        }
        this.thread = new Thread(new SocketReader());
        this.thread.start();
    }

    protected void onChannelExtData(SshMsgChannelExtendedData msg) throws IOException {
    }

    class SocketReader
    implements Runnable {
        SocketReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] buffer = new byte[SocketChannel.this.getMaximumPacketSize()];
            ByteArrayWriter baw = new ByteArrayWriter();
            try {
                SocketChannel.this.socket.setSoTimeout(2000);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            try {
                int read = 0;
                while (read >= 0 && !SocketChannel.this.isClosed()) {
                    try {
                        read = SocketChannel.this.socket.getInputStream().read(buffer);
                    }
                    catch (InterruptedIOException ex1) {
                        read = ex1.bytesTransferred;
                    }
                    ChannelState channelState = SocketChannel.this.state;
                    synchronized (channelState) {
                        if (SocketChannel.this.isClosed() || SocketChannel.this.isLocalEOF()) {
                            break;
                        }
                        if (read > 0) {
                            baw.write(buffer, 0, read);
                            SocketChannel.this.sendChannelData(baw.toByteArray());
                            baw.reset();
                        }
                    }
                }
            }
            catch (IOException read) {
                // empty catch block
            }
            try {
                ChannelState read = SocketChannel.this.state;
                synchronized (read) {
                    if (!SocketChannel.this.isLocalEOF()) {
                        SocketChannel.this.setLocalEOF();
                    }
                    if (SocketChannel.this.isOpen()) {
                        SocketChannel.this.close();
                    }
                }
            }
            catch (Exception ex) {
                log.info("Failed to send channel EOF message: " + ex.getMessage());
            }
            SocketChannel.this.thread = null;
        }
    }
}

