/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgUserAuthRequest
extends SshMessage {
    public static final int SSH_MSG_USERAUTH_REQUEST = 50;
    private String methodName;
    private String serviceName;
    private String username;
    private byte[] requestData;

    public SshMsgUserAuthRequest() {
        super(50);
    }

    public SshMsgUserAuthRequest(String username, String serviceName, String methodName, byte[] requestData) {
        super(50);
        this.username = username;
        this.serviceName = serviceName;
        this.methodName = methodName;
        this.requestData = requestData;
    }

    public String getMessageName() {
        return "SSH_MSG_USERAUTH_REQUEST";
    }

    public String getMethodName() {
        return this.methodName;
    }

    public byte[] getRequestData() {
        return this.requestData;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getUsername() {
        return this.username;
    }

    protected void constructByteArray(ByteArrayWriter baw) throws InvalidMessageException {
        try {
            baw.writeString(this.username);
            baw.writeString(this.serviceName);
            baw.writeString(this.methodName);
            if (this.requestData != null) {
                baw.write(this.requestData);
            }
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Invalid message data");
        }
    }

    protected void constructMessage(ByteArrayReader bar) throws InvalidMessageException {
        try {
            this.username = bar.readString();
            this.serviceName = bar.readString();
            this.methodName = bar.readString();
            if (bar.available() > 0) {
                this.requestData = new byte[bar.available()];
                bar.read(this.requestData);
            }
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Invalid message data");
        }
    }
}

