/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import java.io.IOException;

public class KeyConstraints {
    public static final long NO_TIMEOUT = 0L;
    public static final long NO_LIMIT = 0xFFFFFFFFL;
    protected static final int SSH_AGENT_CONSTRAINT_TIMEOUT = 50;
    protected static final int SSH_AGENT_CONSTRAINT_USE_LIMIT = 51;
    protected static final int SSH_AGENT_CONSTRAINT_FORWARDING_STEPS = 52;
    protected static final int SSH_AGENT_CONSTRAINT_FORWARDING_PATH = 100;
    protected static final int SSH_AGENT_CONSTRAINT_SSH1_COMPAT = 150;
    protected static final int SSH_AGENT_CONSTRAINT_NEED_USER_VERIFICATION = 151;
    private UnsignedInteger32 timeout = new UnsignedInteger32(0L);
    private UnsignedInteger32 uselimit = new UnsignedInteger32(0xFFFFFFFFL);
    private UnsignedInteger32 maxsteps = new UnsignedInteger32(0xFFFFFFFFL);
    private String forwardingpath = "";
    private boolean userverify = false;
    private boolean compat = false;
    private long keyadded = System.currentTimeMillis();
    private long usedcount = 0L;

    public KeyConstraints() {
    }

    public KeyConstraints(ByteArrayReader bar) throws IOException {
        while (bar.available() > 0) {
            switch (bar.read() & 0xFF) {
                case 50: {
                    this.timeout = bar.readUINT32();
                    break;
                }
                case 51: {
                    this.uselimit = bar.readUINT32();
                    break;
                }
                case 52: {
                    this.maxsteps = bar.readUINT32();
                    break;
                }
                case 100: {
                    this.forwardingpath = bar.readString();
                    break;
                }
                case 150: {
                    this.compat = bar.read() != 0;
                    break;
                }
                case 151: {
                    boolean bl = this.userverify = bar.read() != 0;
                }
            }
        }
    }

    public void setKeyTimeout(UnsignedInteger32 timeout) {
        this.timeout = timeout;
    }

    public void setKeyUseLimit(int uselimit) {
        this.uselimit = new UnsignedInteger32(uselimit);
    }

    public void setMaximumForwardingSteps(int maxsteps) {
        this.maxsteps = new UnsignedInteger32(maxsteps);
    }

    public void setForwardingPath(String forwardingpath) {
        this.forwardingpath = forwardingpath;
    }

    public void setRequiresUserVerification(boolean userverify) {
        this.userverify = userverify;
    }

    public void setSSH1Compatible(boolean compat) {
        this.compat = compat;
    }

    public long getKeyTimeout() {
        return this.timeout.longValue();
    }

    public long getKeyUseLimit() {
        return this.uselimit.longValue();
    }

    public long getMaximumForwardingSteps() {
        return this.maxsteps.longValue();
    }

    public long getUsedCount() {
        return this.usedcount;
    }

    public boolean hasTimedOut() {
        return this.timeout.longValue() != 0L ? (System.currentTimeMillis() - this.keyadded) / 1000L > this.timeout.longValue() : false;
    }

    public boolean canUse() {
        return this.uselimit.longValue() != 0L ? this.usedcount < this.uselimit.longValue() : true;
    }

    public void use() {
        ++this.usedcount;
    }

    public String getForwardingPath() {
        return this.forwardingpath;
    }

    public boolean requiresUserVerification() {
        return this.userverify;
    }

    public boolean isSSH1Compatible() {
        return this.compat;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayWriter baw = new ByteArrayWriter();
        baw.write(50);
        baw.writeUINT32(this.timeout);
        baw.write(51);
        baw.writeUINT32(this.uselimit);
        baw.write(52);
        baw.writeUINT32(this.maxsteps);
        baw.write(100);
        baw.writeString(this.forwardingpath);
        baw.write(150);
        baw.write(this.compat ? 0 : 1);
        baw.write(151);
        baw.write(this.userverify ? 0 : 1);
        return baw.toByteArray();
    }
}

