/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;

public class ColorIcon
implements Icon {
    private Dimension size;
    private Color color;
    private Color borderColor;

    public ColorIcon() {
        this(null);
    }

    public ColorIcon(Color color) {
        this(color, null);
    }

    public ColorIcon(Color color, Color borderColor) {
        this(color, null, borderColor);
    }

    public ColorIcon(Color color, Dimension size, Color borderColor) {
        this.setColor(color);
        this.setSize(size);
        this.setBorderColor(borderColor);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(this.color == null ? Color.black : this.color);
        g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
        if (this.borderColor != null) {
            g.setColor(this.borderColor);
            g.drawRect(x, y, this.getIconWidth(), this.getIconHeight());
        }
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public int getIconWidth() {
        return this.size == null ? 16 : this.size.width;
    }

    public int getIconHeight() {
        return this.size == null ? 16 : this.size.height;
    }
}

