CREATE TABLE readings (
  id integer,
  user_name text,
  katakana text
);

CREATE USER alice NOLOGIN;
GRANT ALL ON TABLE readings TO alice;

INSERT INTO readings VALUES (1, 'nonexistent', 'ポストグレスキューエル');
INSERT INTO readings VALUES (2, 'alice', 'グルンガ');
INSERT INTO readings VALUES (3, 'alice', 'ピージールンガ');
INSERT INTO readings VALUES (4, 'alice', 'ピージーロジカル');

ALTER TABLE readings ENABLE ROW LEVEL SECURITY;
CREATE POLICY readings_myself ON readings USING (user_name = current_user);

SET enable_seqscan = on;
SET enable_indexscan = off;
SET enable_bitmapscan = off;

SET SESSION AUTHORIZATION alice;
\pset format unaligned
EXPLAIN (COSTS OFF)
SELECT katakana
  FROM readings
 WHERE katakana &^~| ARRAY['po', 'gu']
 ORDER BY id
\g |sed -r -e "s/\(CURRENT_USER\)::text/CURRENT_USER/g"
\pset format aligned

SELECT katakana
  FROM readings
 WHERE katakana &^~| ARRAY['po', 'gu']
 ORDER BY id;
RESET SESSION AUTHORIZATION;

DROP TABLE readings;

DROP USER alice;
