#  Key.pm
#    - encompass some information about GnuPG::Keys
#
#  Copyright (C) 2000 Frank J. Tobin <ftobin@uiuc.edu>
#
#  This file is part of pgpenvelope
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, visit the following URL:
#  http://www.gnu.org/copyleft/gpl.html
#
#  $Id: Key.pm,v 1.1 2001/04/30 02:15:11 ftobin Exp $
#

package PGPEnvelope::Key;

use strict;

use Class::MethodMaker
  get_set   => [ qw( short_key_type ) ];


sub new_from_key
{
    my ( $class, $key ) = @_;
    bless $key, $class;
    
    $key->pgpenvelope_init();
    
    return $key;
}


sub print
{
    my ( $self ) = @_;
    print $self->info();
}


sub info
{
    my ( $self, %args ) = @_;
    my $short_only = $args{short} || 0;
    
    my @user_id_strings;
    foreach my $user_id ( $self->user_ids() )
    {
	push @user_id_strings, $user_id->as_string();
    }
    
    my @info = ( join( ' ', ( $self->short_key_type() . ' ' ),
		       $self->short_hex_id(),
		       $self->creation_date_string(),
		       shift @user_id_strings,
		     )
		 . "\n"
	       );
    
    unless ( $short_only )
    {
	foreach my $user_id ( @user_id_strings )
	{
	    push @info, "uid                      $user_id\n";
	}
    }
    
    foreach my $subkey ( $self->subkeys() )
    {
	push @info, $subkey->info();
    }
    
    return @info;
}


1;
