#!/usr/bin/env python

"""pgnotify unit tests.

This test suite assumes the database 'pgnotify_test' exists.

Copyright (c) 2001 Ng Pheng Siong. All rights reserved."""

RCS_id='$Id: test_pgnotify.py,v 2.1 2001/06/08 17:17:41 ngps Exp ngps $'

import os, sys, thread, time
import pg
import unittest
from pgnotify import pgnotify


cb1_return = None

def cb1(arg_dict):
    global cb1_return
    if arg_dict is None:
        cb1_return = 'timed out'
    else:
        cb1_return = arg_dict


class pgnotifyTestCase(unittest.TestCase):

    def __init__(self, name='do_nothing'):
        unittest.TestCase.__init__(self, name)
        self.dbconn = pg.connect(dbname='pgnotify_test')
        self._conn = pg.connect(dbname='pgnotify_test')

    def __del__(self):
        self.dbconn.close()
        self._conn.close()

    def do_nothing(self): # Don't remove this test!
        pass

    def test_notify(self):
        global cb1_return
        # Listen for 'event_1'
        pgn = pgnotify(self._conn, 'event_1', cb1)
        thread.start_new_thread(pgn, ())
        time.sleep(1)
        # Generate notification from the other connection.
        self.dbconn.query('notify event_1')
        time.sleep(1)
        # Check that callback has been invoked.
        self.assertEquals(cb1_return['event'], 'event_1')

    def test_notify_timeout(self):
        global cb1_return
        # Listen for 'event_1'
        pgn = pgnotify(self._conn, 'event_1', cb1, {}, 1)
        thread.start_new_thread(pgn, ())
        # Sleep long enough to time out.
        time.sleep(2)
        # Verify that we've indeed timed out.
        self.assertEquals(cb1_return, 'timed out')


def suite():
    return unittest.makeSuite(pgnotifyTestCase, 'test_')
    

if __name__ == '__main__':
    unittest.TextTestRunner().run(suite())

