#include <fstream>
#include <algorithm>
#include "ordTop.h"
#include "validate.h"

using namespace ord;
using namespace std;

bool Validate::outCompareExit = false ;
bool Validate::validationTest = false ;

bool Validate::useDeleteUnref = false ;


#define LISTELTS(ord,doTest) Validate::listElts(ord,doTest,__LINE__)
#define DLISTELTS(ord,doTest) listElts(ord,doTest,__LINE__)


int Validate::simpRand()
{
    static long a = 3;
    a = (((a * 214013L + 2531011L) >> 16) & 32767);
    return (a + 1);
}


void Validate::checkCompare(int toCompare, int terms)
{
	
	
	if (terms > 15) terms = 15 ;
	const Ordinal * ordinals[toCompare] ;
	for (int i = 0 ; i < toCompare; i++) {
		
		
		int expMax = 0 ;
		int exps[terms];
		int prev = 0;
		int addInteger = simpRand()&1 ;
		for (int j = 0 ; j < terms-addInteger;j++) {
			int lexp = prev;
			while ((lexp ==0) || (lexp == prev)) lexp  = simpRand()&7;
			exps[j] = prev = lexp ;
			outStream() << "exps[" << j << "] = " << exps[j] << "\n" ;;
		}
		sort(exps,exps+terms-1);
		int nextTerm = 0 ;
		const Ordinal * result = &zero ;
		for (int j = terms-1 -addInteger ; j > -1 ; j--) {
			const Ordinal expon (exps[j]) ;
			assert(exps[j]);
			const Ordinal fac (simpRand());
			
			
			
			
			
			
			
			const Ordinal& expx = omega^expon ;
			const Ordinal& term = expx * fac ;
			
			const Ordinal& sum = *result + term ;
			result = new Ordinal(sum);
			if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();
			
		}
		if (addInteger) {
			
			
			
			
			const Ordinal offset(simpRand()&31);
			
			const Ordinal& sum = *result + offset ;
			result = new Ordinal(sum);
			if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();
		}
		
		
		
		
		ordinals[i] = new Ordinal(*result) ;
		outStream() << "ordinals[" << i << "] = " << ordinals[i]->normalForm()
			<< "\n" ;
		if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();

	}
	for (int i = 0 ; i < toCompare ; i++) {
		const Ordinal& a = *ordinals[i] ;
		outStream() << " a = " <<  a.normalForm() << "\n" ;
		for (int j = 0 ; j < toCompare ; j++) {
			const Ordinal& b = *ordinals[j] ;
			outStream() << " b = " << b.normalForm() << "\n" ;
			for (int k = 0 ; k < toCompare ; k++) {
				const Ordinal& c = *ordinals[k] ;
				outStream() << " c = " << c.normalForm() << "\n" ;
				checkThree(a,b,c);
				for (int l = 0 ; l < toCompare; l++) {
					const Ordinal& d = *ordinals[l] ;
					const Ordinal& aa = a * b ;
					const Ordinal& bb = b * c ;
					const Ordinal& cc = c * d ;
					checkThree(aa,bb,cc);
					const Ordinal& eaa = a ^ b ;
					outStream() << " eaa = " << eaa.normalForm() << "\n" ;
					const Ordinal& ebb = b ^ c ;
					outStream() << " ebb = " << ebb.normalForm() << "\n" ;
					const Ordinal& ecc = c ^ d ;
					outStream() << " ecc = " << ecc.normalForm() << "\n" ;
					checkThree(eaa,ebb,ecc);
				}
			}
		}
	}
	for (int i = 0 ; i < toCompare; i++) delete ordinals[i] ;
}




bool Validate::checkThree(const Ordinal&a, const Ordinal&b, const Ordinal&c)
{
	int aMinusB = a.compare(b);
	int bMinusC = b.compare(c);
	int aMinusC = a.compare(c);
	
	
	string error ;
	if (!aMinusB && !bMinusC && aMinusC) error += "!aMinusB && !bMinusC && aMinusC" ;
	if (aMinusB && !bMinusC && !aMinusC) error += "aMinusB && !bMinusC && !aMinusC" ;
	if (!aMinusB && bMinusC && !aMinusC) error += "!aMinusB && bMinusC && !aMinusC" ;
	if (!error.empty()) {
		outStream() << "Error: " << error << "\n" ;
		a.describel(outStream());
		b.describel(outStream());
		c.describel(outStream());
		assert(0);
	}
	const Ordinal * ordered[3] ;
	for (int i = 0 ; i < 3; i++) ordered[i]=0;
	if (aMinusB <= 0) {
		if (aMinusC <= 0) { 
			ordered[0]= &a ;
			if (bMinusC <=0) { 
				ordered[1] = &b ;
				ordered[2] = &c ;
			} else {           
				ordered[1] = &c ;
				ordered[2] = &b ;
			}
		} else { 
			assert(!(bMinusC <= 0)) ; 
			
			ordered[0] = &c ;
			ordered[1] = &a ;
			ordered[2] = &b ;
			
		}
	} else if (bMinusC <= 0) { 
			ordered[0] = &b ;
			if (aMinusC <=0) {
				ordered[1] = &a;
				ordered[2] = &c ;
			} else {
				ordered[1] = &c;
				ordered[2] = &a ;
			}
	} else {
		assert(aMinusC) ;
		ordered[0] = &c ;
		ordered[1] = &b ;
		ordered[2] = &a ;
	}
	bool allSet = true ;

	for (int i = 0 ; i < 3; i++) {
		if (!ordered[i]) allSet = false ;
		
	}
	assert(allSet);
	
	
	
	if (*ordered[0] > *ordered[1]) error += "ordered[0] > ordered[1]" ;
	if (*ordered[1] > *ordered[2]) error += "ordered[1] > ordered[2]" ;
	if (*ordered[0] > *ordered[2]) error += "ordered[0] > ordered[3]" ;
	if (!error.empty()) {
		outStream() << "Error: " << error << "\n" ;
		ordered[0]->describel(outStream());
		ordered[1]->describel(outStream());
		ordered[2]->describel(outStream());
		assert(0);
	}
	return true ;
}






static void testOffsets(const Ordinal& offA, const Ordinal& offB)
{
	
	outStream() << "limit tests with offsets: " << offA.normalForm() <<
		", " << offB.normalForm() << "\n" ;
	const Ordinal& epsa = psi(eps0+offA+1,eps0+offB+1);
	for (int i = 0 ; i < 10 ; i++) outStream() << "epsa[" << i << "] : "
		<< epsa.limitElement(i).normalForm()
		<< "\n" ;

	const Ordinal& epsb = psi(eps0+offA+1,eps0+offB);
	for (int i = 0 ; i < 10 ; i++) outStream() << "epsb[" << i << "] : "
		<< epsb.limitElement(i).normalForm()
		<< "\n" ;

	const Ordinal& epsc = psi(eps0+offA,eps0+offB+1);
	for (int i = 0 ; i < 10 ; i++) outStream() << "epsc[" << i << "] : "
		<< epsc.limitElement(i).normalForm()
		<< "\n" ;

	const Ordinal& epsd = psi(eps0+offA,eps0+offB);
	for (int i = 0 ; i < 10 ; i++) outStream() << "epsd[" << i << "] : "
		<< epsd.limitElement(i).normalForm()
		<< "\n" ;
}



static void dbgTst1(ostream & stream)
{
	static const int desLim = 10 ;
	

	const Ordinal & t1 = omega^(omega^2) ;

	stream << "t1 = " << t1.normalForm() << "\n" ;
	
	t1.descend(5,desLim) ;

	


	const Ordinal& xytst =((omega^((omega^(2))))*2);

	const Ordinal& xztst = (omega^((omega^(2)) + omega));
	bool testaa = xytst > xztst ;

	
	



	const Ordinal& a = (omega^((omega^2)))* 2 ;
	a.descend(5,desLim) ;
	
	
	stream << "a = " << a.normalForm() << "\n" ;



	const Ordinal& b = omega^(omega^2)+omega ;
	
	stream << "b = " << b.normalForm() << "\n" ;

	
	Ordinal::cmpCheck(b,a);
	
	
	stream << "a - b compare over\n";

	const Ordinal& pa = psi(a,zero);
	const Ordinal& pb = psi(b,zero);

	Ordinal::cmpCheck(pb,pa);
	stream << "pa - pb compare over\n";

	stream << "testaa = " << testaa << "\n" ;
	stream << "xytst = " << xytst.normalForm() << "\n" ;
	stream << "xztst = " << xztst.normalForm() << "\n" ;
	Ordinal::cmpCheck(xztst,xytst);

	const Ordinal& ytst = psi((omega^2), zero);
	const Ordinal& ztst = (((omega^3) + omega), zero);
	Ordinal::cmpCheck(ytst,ztst);
	const Ordinal& bgxx = psi(omega,omega);
	
	bgxx.descend(5,4);
	
}






void Validate::listElts(const Ordinal& ord, bool doTest, int line)
{
	
	ord.listElts(10,doTest);

}

void Validate::expTest(const Ordinal& ord, ostream& stream)
{
	const Ordinal& pwr = ord ^ ord ;
	pwr.describel(stream);
	
	assert(pwr.compare(ord)>0);
	
}


void Validate::baseTest()
{
	bool ftst = true ;
	int count = 10 ;
	const Ordinal& ltx = Ordinal::one ;
	outStream() << zero.hasFiniteTerm() << " zhft\n" ;
	outStream() << Ordinal(0).hasFiniteTerm() << "zhft\n" ;
	bool dbg = true ;
	OrdinalImpl::debugControl.clearAll();
	
	
	
	
	
	
	


	
	if (dbg) outStream() << "main begin\n" ;


	outStream() <<
		((omega*omega + omega*2 )*(omega*omega*3 + omega*5)).normalForm()
		<< "\n" ;
	
	outStream() << (Ordinal::five^((omega^16)+(omega^12) + omega + 9)).
		normalForm() << "\n" ;
	outStream() << (Ordinal::five^((omega^16) + 9)).normalForm() << "\n" ;

	outStream() << ((omega^16)*(omega^12) * omega * 9).normalForm() << "\n" ;


	outStream() << ((Ordinal::five^(omega*omega)) *
		(Ordinal::five^omega)).normalForm() << "\n" ;

	Ordinal test0(0) ;
	Ordinal test1(1);
	
	outStream() << OrdinalImpl::one.compare(OrdinalImpl::two) << "\n" ;
	outStream() << OrdinalImpl::two.compare(OrdinalImpl::one) << "\n" ;
	const Ordinal& osq = omega * omega ;
	const Ordinal& p1 = omega^(osq + omega) ;
	const Ordinal& p2 = osq + omega + 3 ;
	(p1*p2).DLISTELTS(count,ftst);

	const Ordinal& op1 = omega + 1 ;
	(op1^op1).DLISTELTS(count,ftst);

	const Ordinal& osqpo = (omega*omega)+omega ;
	(osqpo^osqpo).DLISTELTS(count,ftst);
	
	const Ordinal& osqpopo = (omega*omega)+omega + 1 ;
	(osqpopo^osqpopo).DLISTELTS(count,ftst);
	
	Ordinal twelve(12) ;
	(twelve^((omega^3)+((omega^2)*8) )).DLISTELTS(count,ftst);

	((omega + 4)*12).DLISTELTS(count,ftst);
	((omega + 4)*(omega)).DLISTELTS(count,ftst);
	Ordinal four(4);
	Ordinal five(5);
	(four*five*omega).DLISTELTS(count,ftst);

	(((omega^2)+(omega*3))*((omega^2)*4+(omega*7))).DLISTELTS(count,ftst);
	(((omega^2)+(omega*3))*((omega^2)*4+(omega*12))).DLISTELTS(count,ftst);

	
	outStream() << ((omega +3) ^(omega + 3)).normalForm() << "\n" ;
	outStream() << ((omega +12) ^ (omega * 4 )).texNormalForm() << "\n";
	outStream() << ((omega +12) ^ (omega * 4 )).normalForm() << "\n" ;

	outStream() << "((omega +12) ^ (omega * 4 + 12)) = " <<
	((omega +12) ^ (omega * 4 + 12)).normalForm() << "\n" ;
	
	outStream() << "((omega) ^ (omega * 4 + 12)) = " <<
	((omega + 12) ^ (omega * 4 + 12)).normalForm() << "\n" ;
	
	outStream() << "((omega +12) ^ (omega * 4 )) = " <<
	((omega +12) ^ (omega * 4 )).normalForm() << "\n" ;
	
	const Ordinal& lmt = (omega^5)*4 ;
	for (int i = 1; i<10;i++) outStream() << lmt.limitElement(i).normalForm()
		<< "\n" ;
	
	const Ordinal& int3(3);
	if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();
	
	if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();
	
	const Ordinal& opo = omega^omega ;

	osq.descend(4,50);
	if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();
	opo.descend(8,80);
	if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();

	(omega*opo).DLISTELTS(count,ftst);


	if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();
	outStream() << "after first deleteUnref\n" ;
	
	const Ordinal& wpwtw = (omega^omega) * omega ;
	outStream() << "(omega^omega) * omega = " << wpwtw.normalForm() << "\n" ;
	for (int i = 0 ; i < 10 ; i++) outStream() << i << " : "
		<< wpwtw.limitElement(i).normalForm()  << "\n" ;


	const Ordinal& wf = omega^5;


	const Ordinal& wstep1 = wf + omega;
	wstep1.DLISTELTS(count,ftst);

	const Ordinal& wstep2 = wstep1 + omega^2 ;
	wstep2.DLISTELTS(count,ftst);

	const Ordinal& wstep3 = wstep2 + wf ;
	wstep3.DLISTELTS(count,ftst);
	
	const Ordinal& wstep4 = wstep3 + omega ;
	wstep4.DLISTELTS(count,ftst);
	
	const Ordinal& wstep5 = wstep4 + omega ;
	wstep5.DLISTELTS(count,ftst);
	
	const Ordinal& wstep6 = wstep5 + omega*12;
	wstep6.DLISTELTS(count,ftst);

	
	if(Validate::useDeleteUnref) OrdinalImpl::deleteUnref();
	

		
	if (dbg) outStream() << "ck1\n" ;

	const Ordinal& elt = omega + 1 ;
	for (int i = 2; i < 50 ; i++) {
		const Ordinal& elt = omega * (58-i) ;
		if (dbg) (elt^i).DLISTELTS(count,ftst);
		if (dbg) outStream() << "To power - " << i << "\n" ;
	}
	const Ordinal& tst =
		((omega +1)*(omega +1)*(omega +1)*(omega +1)*(omega +1)*(omega +1)*
		(omega+1))*omega;
	if (dbg) tst.DLISTELTS(count,ftst);


	 Ordinal tst2 = ((((((omega*omega*omega) * 3) + ((omega*omega) * 2)) + omega) + 12) *
		(omega + 15))*omega;
	if (dbg) tst.DLISTELTS(count,ftst);


	const Ordinal& wp12 = omega + omega*12 ;
	const Ordinal& pr1 = omega * wp12 ;

	const Ordinal& omegaSq = omega * omega ;
	const Ordinal& omegaCubed = omegaSq * omega ;
	const Ordinal& omegaFour = omegaSq * omegaSq ;
	if (dbg) omegaSq.DLISTELTS(count,ftst);
	if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();
	const Ordinal& exp1 = ((omega + 12)*(omega +15))*omega ;
	if (dbg) exp1.DLISTELTS(count,ftst);

	const Ordinal& tst3 = ((omegaFour*2 + omegaCubed *3 + omega +12) *
		(omegaCubed*9 + omegaSq *3 +12))*omega ;
	if (dbg) tst3.DLISTELTS(count,ftst);

	const Ordinal& opw = one + omega ;
	if (dbg) {
		opw.DLISTELTS(count,ftst);
		outStream() << " : opw\n" ;
	}

	const Ordinal& wpo = omega + one ;
	if (dbg) {
		wpo.DLISTELTS(count,ftst);
		outStream() << " : wpo\n" ;
	}

	
	
	
	const Ordinal& pz = one + zero ;
	if (dbg) outStream() << pz.assignedName() << " :1 + 0 (pz)\n" ;

	const Ordinal& zp = zero + one ;
	if (dbg) { 
		outStream() << zp.assignedName() << " :0 + 1 (zp)\n" ;

		outStream() << "zero.isFinite = " <<zero.isFinite() << "\n" ; 
		outStream() << "one.isFinite = " << one.isFinite() << "\n" ;
		outStream() << "omega.isFinite = " << omega.isFinite() << "\n" ;

		outStream() << zero.assignedName() <<   " : zero\n";
		outStream() << zero.normalForm() << " : zero\n";

		outStream() << one.assignedName() <<  " : one\n";
		outStream() << one.normalForm() << " : one\n";

		outStream() << omega.assignedName() <<  " : omega\n";
		outStream() << omega.normalForm() << " : omega\n";
	}
	const int numOrdinals = 3 ;
	const Ordinal** ordinals = new const Ordinal *[numOrdinals] ;
	ordinals[0]=&zero ;
	ordinals[1]=&one ;
	ordinals[2]=&omega ;
 	
	checkCompare(5,5);

	for (int i = 0 ; i < numOrdinals; i++) {
		const Ordinal& a = *ordinals[i];
		for (int j = 0 ; j < numOrdinals; j++) {
			const Ordinal&b = *ordinals[j];
			outStream() << i << ", " << j << " | " << a.assignedName() << " : "
				<< b.assignedName() << " ++ " ;
			outStream() << (a  > b) << " " ;
			outStream() << (a  >= b) << " " ;
			outStream() << (a  < b) << " " ;
			outStream() << (a  <= b) << " " ;
			outStream() << (a  == b) << " " ;
			outStream() << (a  != b) << "\n" ;

		}
	}

	if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();


}



void Validate::psiTest()
{
	int count = 10;
	bool ftst = true ;
	bool useCerr = true;
	ofstream psiStreamDec("psi.tst");
	if (useCerr) OutStream::streamManager.push(cerr);
	else OutStream::streamManager.push(psiStreamDec);
	ostream& psiStream = outStream();
	outStream() << psi(0,0).normalForm() << "\n" ;
	outStream() << psi(0,1).normalForm() << "\n" ;
	outStream() << psi(1,0).normalForm() << "\n" ;
	outStream() << psi(1,1).normalForm() << "\n" ;


	outStream() << (psi(2,2)*3).compare(psi(psi(2,2)+1,0))<<" should be -1\n";
	finiteFunctional(omega,zero,Ordinal::two,zero,zero).DLISTELTS(count,true);
	const Ordinal & psi20 = psi(2,0);
	const Ordinal * psit1[] = {&psi20,&one,0};
	const Ordinal & psi20p = * new FiniteFuncOrdinal(psit1);

	psi20.listElts();
	
	psi20p.listElts();
	


	const Ordinal& xxtmp = (omega^((omega^((eps0*Ordinal::two)))));

	
	const Ordinal&  tstx = psi(xxtmp, zero);
	
	outStream() << tstx.normalForm() << " tstx\n" ;
	for (int i = 0 ; i < 10 ; i++) psiStream << i << " : "
		<< tstx.limitElement(i).normalForm()  << "\n" ;
	

	const Ordinal& epsw = psi(one,omega);
	expTest(epsw,psiStream);

	const Ordinal& psw12 = psi(omega,12);
	psw12.DLISTELTS(count,ftst);
	psw12.limitElementTest();
	psiStream << "zero.hasFiniteTerm = " << zero.hasFiniteTerm() << "\n";
	
	if (useDeleteUnref) OrdinalImpl::deleteUnref();
	dbgTst1(psiStream);
	if (useDeleteUnref) OrdinalImpl::deleteUnref();

	const Ordinal& eps0Pw = eps0 + omega ;
	bool testa = eps0Pw > eps0 ;
	psiStream << "testa = " << testa << "\n" ;


	bool test =  omega < eps0 ;
	psiStream << "test = " << test << "\n" ;

	const Ordinal& two(2);
	const Ordinal& three(3) ;
	const Ordinal& eps2 = psi(two,zero);

	const Ordinal& epsa = psi(eps0+1,eps0+1);
	for (int i = 0 ; i < 10 ; i++) psiStream << "epsa[" << i << "] : "
		<< epsa.limitElement(i).normalForm()
		<< "\n" ;

	const Ordinal& epsb = psi(eps0+1,eps0);
	for (int i = 0 ; i < 10 ; i++) psiStream << "epsb[" << i << "] : "
		<< epsb.limitElement(i).normalForm()
		<< "\n" ;

	const Ordinal& epsc = psi(eps0,eps0+one);
	for (int i = 0 ; i < 10 ; i++) psiStream << "epsc[" << i << "] : "
		<< epsc.limitElement(i).normalForm()
		<< "\n" ;

	const Ordinal& epsd = psi(eps0,eps0);
	for (int i = 0 ; i < 10 ; i++) psiStream << "epsd[" << i << "] : "
		<< epsd.limitElement(i).normalForm()
		<< "\n" ;

	testOffsets(zero,zero);
	testOffsets(omega,omega);
	testOffsets(omega^omega,omega^omega);
	
	
	const Ordinal& zz = psi(zero,zero); 
	zz.DLISTELTS(count,ftst);

	const Ordinal& zzpo = zz + omega ;
	zzpo.DLISTELTS(count,ftst);

	const Ordinal& zztw = zz^omega ;
	zztw.DLISTELTS(count,ftst);


	psiStream << (zz>zero) << (zz>one) << (zz==one) << "\n" ;
	(eps0 *eps2).DLISTELTS(count,ftst);
	
		
	
	const Ordinal& bgy = psi((eps0^eps0)*2,0);
	
	
	bgy.limitElementTest();
	if (useDeleteUnref) OrdinalImpl::deleteUnref();

	const Ordinal& zztst3 = omega^(omega^(omega*3)) ;
	for (int i = 0 ; i < 10 ; i++) psiStream << i << " : "
		<< zztst3.limitElement(i).normalForm()  << "\n" ;

	if (useDeleteUnref) OrdinalImpl::deleteUnref();
	const Ordinal& zztst = omega^(omega^(omega*2)) ;
	for (int i = 0 ; i < 10 ; i++) psiStream << i << " : "
		<< zztst.limitElement(i).normalForm()  << "\n" ;

	if (useDeleteUnref) OrdinalImpl::deleteUnref();
	const Ordinal& ztst = omega^(omega^omega) ;
	for (int i = 0 ; i < 10 ; i++) psiStream << i << " : "
		<< ztst.limitElement(i).normalForm()  << "\n" ;


	if (useDeleteUnref) OrdinalImpl::deleteUnref();
	
	const Ordinal& tstxp = omega^((omega^((eps0*Ordinal::two)))) ;
	outStream() << tstxp.normalForm() << " tstxp\n" ;
	for (int i = 0 ; i < 10 ; i++) psiStream << i << " : "
		<< tstxp.limitElement(i).normalForm()  << "\n" ;


	if (useDeleteUnref) OrdinalImpl::deleteUnref();

	const Ordinal& psiTst = psi(eps0 + omega*17, 1);
	if (useDeleteUnref) OrdinalImpl::deleteUnref();
	psiStream << psiTst.normalForm() << "\n" ;
	psiStream << psiTst.limitElement(2).normalForm() << "\n" ;
	if (useDeleteUnref) OrdinalImpl::deleteUnref();

	eps0.limitElementTest();
	if (useDeleteUnref) OrdinalImpl::deleteUnref();

	const Ordinal& bgx = psi((eps0^eps0)+1,0);
	
	bgx.limitElementTest();
	
	if (useDeleteUnref) OrdinalImpl::deleteUnref();
	
	const Ordinal& bg2 = psi((omega^omega),eps0);
	bg2.limitElementTest();
	if (useDeleteUnref) OrdinalImpl::deleteUnref();

	const Ordinal& bg3 = psi(eps0+18,bg2);
	bg3.limitElementTest();
	if (useDeleteUnref) OrdinalImpl::deleteUnref();

	const Ordinal& bg4 = psi(15,bg2);
	bg4.limitElementTest();
	if (useDeleteUnref) OrdinalImpl::deleteUnref();

	const Ordinal& bg5 = psi(bg2,zero);
	bg5.limitElementTest();
	if (useDeleteUnref) OrdinalImpl::deleteUnref();

	const Ordinal& epstw = eps0 * omega ;
	psiStream << "eps0 * omega = " << epstw.normalForm() << "\n" ;
	for (int i = 0 ; i < 10 ; i++) psiStream << i << " : "
		<< epstw.limitElement(i).normalForm()  << "\n" ;
	


	const Ordinal& bg1 = psi((omega^omega)+12,eps0+99);
	bg1.limitElementTest();
	if (useDeleteUnref) OrdinalImpl::deleteUnref();
	psiStream << "compareOut " << eps0.compare(eps0^2) << "\n";

	const Ordinal& adt1 = eps0 + (eps0^2);
	psiStream << "adt1 = " << adt1.normalForm() << "\n" ;

	const Ordinal& epswp3 = epsw^(epsw^epsw);
	psiStream << "epswp3 listElts\n" ;
	epswp3.DLISTELTS(count,ftst);
	assert(epswp3.compare(epsw)>=0);

	const Ordinal& txz = eps0 * (omega^5);
	psiStream << "txz = " << txz.normalForm() << "\n" ;
	
	const Ordinal& thr(3) ;
	(thr + omega).DLISTELTS(count,ftst);
	

	const Ordinal& pa1 = psi(one,omega);
	const Ordinal& pa2 = pa1^pa1 ;
	psiStream << "pa2 = " << pa2.normalForm() << "\n" ;
	const Ordinal& pa3 = pa1^pa2 ; 
	psiStream << "pa3 = " << pa3.normalForm() << "\n" ;


	if (useDeleteUnref) OrdinalImpl::deleteUnref();

	const Ordinal& tst1 = eps0^eps0 ;
	psiStream << "eps0^eps0 = " << "\n";
	tst1.DLISTELTS(count,ftst);

	const Ordinal& tst1b = eps0^omega ;
	psiStream << "eps0^omega = " << tst1b.normalForm() << "\n";

	const Ordinal& tst1c = eps0^((omega^4)+13) ;
	psiStream << "eps0^(omega^4+13) = " << tst1c.normalForm() << "\n";

	const Ordinal& tx0 =  omega^(eps0*2) ;
	psiStream << "tx0 = " << tx0.normalForm() << "\n" ;	

	const Ordinal& tx = eps0 + omega^(eps0*2) ;
	psiStream << "tx = " << tx.normalForm() << "\n" ;

	const Ordinal& tx1 =  omega^(eps0+2) ;
	psiStream << "tx1 = " << tx1.normalForm() << "\n" ;

	if (useDeleteUnref) OrdinalImpl::deleteUnref();
	
	const Ordinal& eps0Sq = eps0 * eps0 ;
	psiStream << "eps_0^2 = " << eps0Sq.normalForm() << "\n";

	const Ordinal& eps0Cuba =   eps0 * eps0Sq ;  ;
	psiStream << "eps_0^3 = " << eps0Cuba.normalForm() << "\n";

	psiStream << "eps0^3 listElts\n" ;
	(eps0*eps0*eps0).DLISTELTS(count,ftst);

	const Ordinal& eps0Cub = eps0Sq * eps0 ;
	psiStream << "eps_0^3 = " << eps0Cub.normalForm() << "\n";

	psiStream << "eps0^3 listElts\n" ;
	(eps0^3).DLISTELTS(count,ftst);
	if (useDeleteUnref) OrdinalImpl::deleteUnref();

	const Ordinal& epop3 = (eps0^(omega+3));
	psiStream << "eps0^(omega +3) listElts\n" ;
	epop3.DLISTELTS(count,ftst);

	const Ordinal& ecx1 = ((eps0^((omega^3)*12)) + omega*8 +24) ;
	psiStream << "eps0^((omega^3)*12) + omega *8 + 24 listElts\n" ;
	ecx1.DLISTELTS(count,ftst);



	psiStream << "psi(0.1)[2] listElts\n" ;
	eps0.limitElement(2).DLISTELTS(count,ftst);
	psiStream << "psi(0.1)[3] listElts\n" ;
	eps0.limitElement(3).DLISTELTS(count,ftst);
	psiStream << "psi(0.1)[4] listElts\n" ;
	eps0.limitElement(4).DLISTELTS(count,ftst);
	if (useDeleteUnref) OrdinalImpl::deleteUnref();

	const Ordinal& epswp1 = psi(one,omega+1);

	const Ordinal& elt2a = epswp1.limitElement(2) ;
	psiStream << "psi(omega+1,1).elts[2] listElts\n" ;
	elt2a.DLISTELTS(count,ftst);

	const Ordinal& elt3a = epswp1.limitElement(3);
	psiStream << "psi(omega+1,1).elts[3] listElts\n" ;
	elt3a.DLISTELTS(count,ftst);
	if (useDeleteUnref) OrdinalImpl::deleteUnref();
	
	const Ordinal& elt4a = epswp1.limitElement(4);
	psiStream << "psi(omega+1,1).elts[4] listElts\n" ;
	elt4a.DLISTELTS(count,ftst);

	
	
	for (int i = 0 ; i < 8; i++) eps0.limitElement(i).DLISTELTS(count,ftst);
	if (useDeleteUnref) OrdinalImpl::deleteUnref();

	const Ordinal& eps1 = psi(one,one);

	for (int i = 0 ; i < 8; i++) eps1.limitElement(i).DLISTELTS(count,ftst);
	if (useDeleteUnref) OrdinalImpl::deleteUnref();


	for (int i = 0 ; i < 8; i++) epswp1.limitElement(i).DLISTELTS(count,ftst);

	if (useDeleteUnref) OrdinalImpl::deleteUnref();
	
	
	if (useDeleteUnref) OrdinalImpl::deleteUnref();
	

	(omega + omega *2).DLISTELTS(count,ftst);
	if (useDeleteUnref) OrdinalImpl::deleteUnref();

	
	for (int i = 0 ; i < 5; i++) (omega * 12).limitElement(i).DLISTELTS(count,ftst);
	for (int i = 0 ; i < 5; i++) (omega *3 ).limitElement(i).DLISTELTS(count,ftst);
	const Ordinal& twoOmega = omega * 2 ;
	twoOmega.limitElement(1).DLISTELTS(count,ftst);
	twoOmega.limitElement(2).DLISTELTS(count,ftst);
	twoOmega.limitElement(3).DLISTELTS(count,ftst);

	for ( int i = 0 ; i < 30 ; i++) omega.limitElement(i).DLISTELTS(count,ftst);
	if (useDeleteUnref) OrdinalImpl::deleteUnref();

	const Ordinal& osq = omega * omega ;
	for ( int i = 0 ; i < 30 ; i++) {
		psiStream << i << " listElts\n" ;
		osq.limitElement(i).DLISTELTS(count,ftst);
	}

	const Ordinal& omom = omega ^ omega ;
	for ( int i = 0 ; i < 30 ; i++) {
		psiStream << i << " listElts\n" ;
		omom.limitElement(i).DLISTELTS(count,ftst);
	}
	if (useDeleteUnref) OrdinalImpl::deleteUnref();

	for (int i = 0 ; i < 5; i++) (omega *3).limitElement(i).DLISTELTS(count,ftst);
	const Ordinal &ptst1 = ((omega^2)*3 + omega*5 )^15;
	
	const Ordinal &ptst2 = ((omega^2)*3 + omega*5 + 12)^(omega + 15);
	const Ordinal &ptst3 = ptst1 ^ ptst2 ;

	for ( int i = 0 ; i < 30 ; i++) ptst1.limitElement(i).DLISTELTS(count,ftst);
	if (useDeleteUnref) OrdinalImpl::deleteUnref();

	const Ordinal& ps1 = psi(omega,omega) ;
	const Ordinal& xps1 = psi(ps1,omega) ;

	ps1.DLISTELTS(count,ftst);
	xps1.DLISTELTS(count,ftst);
	psiStream << "xps1 + ps1:\n" ;
	(xps1 + ps1).DLISTELTS(count,ftst);
	psiStream << "ps1 + xps1:\n" ;
	(ps1 + xps1).DLISTELTS(count,ftst);
	psiStream << "xps1 * ps1:\n" ;
	(xps1 * ps1).DLISTELTS(count,ftst);
	psiStream << "ps1 * xps1:\n" ;
	(ps1 * xps1).DLISTELTS(count,ftst);
	psiStream << "END+*\n";

	psiStream << "xps1 ^ ps1:\n" ;
	(xps1 ^ ps1).DLISTELTS(count,ftst);
	psiStream << "ps1 ^ xps1:\n" ;
	(ps1 ^ xps1).DLISTELTS(count,ftst);
	psiStream << "END^\n";
	if (useDeleteUnref) OrdinalImpl::deleteUnref();

	psiStream << (ps1 > omega) << " : " << (one < ps1) <<  " : " <<
		(ps1 == ps1) << "\n" ;

	

	( ps1 + omega + 6 + ps1 + omega + omega + 12).DLISTELTS(count,ftst);
	if (useDeleteUnref) OrdinalImpl::deleteUnref();
	
	const Ordinal& step1 = ps1 + omega;
	step1.DLISTELTS(count,ftst);

	(step1 * ps1).describe(psiStream);

	const Ordinal& step2 = step1 + omega*6 ;
	step2.DLISTELTS(count,ftst);

	const Ordinal& step3 = step2 + ps1 ;
	step3.DLISTELTS(count,ftst);
	
	const Ordinal& step4 = step3 + omega ;
	step4.DLISTELTS(count,ftst);
	if(useDeleteUnref) OrdinalImpl::deleteUnref();
	
	const Ordinal& step5 = step4 + omega ;
	step5.DLISTELTS(count,ftst);
	
	const Ordinal& step6 = step5 + omega*12;
	step6.DLISTELTS(count,ftst);

	(ps1 + ps1).DLISTELTS(count,ftst);


	const Ordinal& ps2 = psi(ptst3,ptst2);
	const Ordinal& ps3 = psi(ptst1,ptst3);
	ps2.DLISTELTS(count,ftst);
	ps3.DLISTELTS(count,ftst);

	(ps2 + ps3).DLISTELTS(count,ftst);

	psiStream << (ps2 < ps3) << " : " <<  (ps1 == ps2) << " : " << 
			(ps3 > ps2) << "\n" ;


	(omega*eps0).DLISTELTS(count,ftst);
	(eps0*omega).DLISTELTS(count,ftst);
	(eps0^(omega^(eps0+1))).DLISTELTS(count,ftst);
	
	(eps0^(omega^(eps0+1))).DLISTELTS(count,ftst);
	
	(eps0^eps0).DLISTELTS(count,ftst);
	(eps0^(omega*eps0)).DLISTELTS(count,ftst);
	(eps0^(eps0*omega)).DLISTELTS(count,ftst);
	(omega^(eps0+Ordinal::one)).DLISTELTS(count,ftst);
	(omega^((eps0*2))).DLISTELTS(count,ftst);
	(omega^(omega^((eps0*2)))).DLISTELTS(count,ftst);
	(eps0^omega).DLISTELTS(count,ftst);
	(omega^((omega^((eps0*2))))).DLISTELTS(count,ftst);
	(eps0^(omega^((omega^((eps0*2)))))).DLISTELTS(count,ftst);
	(eps0^eps0).DLISTELTS(count,ftst);
	(eps0^(eps0^eps0)).DLISTELTS(count,ftst);


	OutStream::streamManager.pop();


}




void Validate::iterTest()
{
	bool fullCk = true ;
	int count = 10 ;
	bool useCerr = true ;
	ofstream iterStreamDec("iter.tst");
	if (useCerr) OutStream::streamManager.push(cerr);
	else OutStream::streamManager.push(iterStreamDec);
	ostream& iterStream = outStream();
    const Ordinal& psiwp1 = iterativeFunctional(omega)+one ;
    iterativeFunctional(one,psiwp1).DLISTELTS(count,fullCk);
	iterativeFunctional(one).DLISTELTS(count,fullCk);
	iterativeFunctional(omega,createParameters(&one)).DLISTELTS(count,fullCk),
	iterativeFunctional(one,createParameters(&Ordinal::two)).
		DLISTELTS(count,fullCk);
	
	const Ordinal& xtmp = psi(iterativeFunctional
		(one,createParameters(&Ordinal::three))+one,0);
	
	const Ordinal& xprev = iterativeFunctional(one,
		
		createParameters(&Ordinal::three)) ;
	outStream() << "CMP " << xtmp.compare(xprev) << " :: " <<
			xprev.compare(xtmp) << "\n";
	
	
	const Ordinal& ytmp = iterativeFunctional
		(one,createParameters(&Ordinal::three))+one;
	const Ordinal& xxtmp=iterativeFunctional(one,createParameters(&ytmp,&zero));
	
	const Ordinal& xxprev = iterativeFunctional(one,
		createParameters(&Ordinal::three))*2 ;
	outStream() << "CMP " << xxtmp.compare(xxprev) << " :: " <<
			xxprev.compare(xxtmp) << "\n" ;

	IterFuncOrdinal(Ordinal::two,IterFuncOrdinal(Ordinal::two)*3).
		DLISTELTS(10,fullCk);
	IterFuncOrdinal(one).DLISTELTS(count,fullCk);
	(iterativeFunctional(one,*new Ordinal(4))).DLISTELTS(10,fullCk);
	(iterativeFunctional(one,*new Ordinal(4)*12)).DLISTELTS(10,fullCk);
	psi(one,zero).DLISTELTS(10,fullCk);
	
	(iterativeFunctional(Ordinal::three,one,zero,zero)*Ordinal::two).
		DLISTELTS(10,fullCk);
	
	(omega^(iterativeFunctional(omega)*10)).DLISTELTS(10,fullCk);
	(iterativeFunctional(Ordinal::three,one,zero,zero)*98756).
		DLISTELTS(10,fullCk);

	(iterativeFunctional(one,zero)*Ordinal::three).DLISTELTS(10,fullCk);
	(iterativeFunctional(one,zero)*Ordinal::three*50).DLISTELTS(10,fullCk);
	const Ordinal & aba = iterativeFunctional(one,zero);
	aba.out("aba");
	aba.DLISTELTS(10,fullCk);
	const Ordinal&  abb = omega^(aba+one);
	abb.DLISTELTS(10,fullCk);

	const Ordinal & abwp = iterativeFunctional(Ordinal::omega,one);
	abwp.out("abwp");
	abwp.DLISTELTS(10,fullCk);

	const Ordinal & abw = iterativeFunctional(Ordinal::omega,zero);
	abw.out("abw");
	abw.DLISTELTS(10,fullCk);

	const Ordinal & abt = iterativeFunctional(Ordinal::two,zero);
	abt.out("abt");
	abt.DLISTELTS(10,fullCk);

	

	iterativeFunctional(one,one).DLISTELTS(10,fullCk);
	const Ordinal& tstx1 = (omega^(psi(1,1)+one)) ;
	tstx1.out("tstx1");
	tstx1.limitElement(2).out("tstx1.le(2)");
	tstx1.compare(tstx1+one);
	

	iterativeFunctional(one,one,zero).DLISTELTS(10,fullCk);
	iterativeFunctional(one,one).DLISTELTS(10,fullCk);
	iterativeFunctional(one).DLISTELTS(10,fullCk);
	iterativeFunctional(Ordinal::two).DLISTELTS(10,fullCk);
	iterativeFunctional(eps0+one).DLISTELTS(10,fullCk);
	iterativeFunctional(omega).DLISTELTS(10,fullCk);
	iterativeFunctional(eps0).DLISTELTS(10,fullCk);
	


	IterFuncOrdinal t1(omega,omega);
	iterStream << t1.normalForm() << " t1\n" ;
	iterStream << t1.texNormalForm() << " t1 TeX\n" ;
	LISTELTS(t1,fullCk);

	IterFuncOrdinal(one,one).describel(outStream());
	LISTELTS(IterFuncOrdinal(one,one),fullCk);
	LISTELTS(IterFuncOrdinal(one,NULL),fullCk);
	LISTELTS(IterFuncOrdinal(Ordinal::two,NULL),fullCk);

	IterFuncOrdinal t2(omega,NULL);
	iterStream << t2.normalForm() << " t2\n" ;


	
	iterStream << t1.compare(t1) << " t1.compare(t1)\n" ;
	
	
	iterStream << (t1*t1).normalForm() << " t1^2\n";
	iterStream << (t1^t1).normalForm() << " t1^t1\n";

	expTest(t1,iterStream);
	expTest(t1*t1,iterStream);
	Ordinal::multCheck(t1^t1,t1*t1,t1);
	Ordinal::multCheck(t2^t2,t2*t2,t2);
	LISTELTS(IterFuncOrdinal(one,one,zero),fullCk);
	
	LISTELTS(IterFuncOrdinal(Ordinal::two,Ordinal::omega,zero,zero),fullCk);
	LISTELTS(IterFuncOrdinal(Ordinal::two,Ordinal::two,zero,zero),fullCk);
	
	LISTELTS(FiniteFuncOrdinal(Ordinal::two,zero,zero),fullCk);
	
	LISTELTS(FiniteFuncOrdinal(Ordinal::one,zero,zero),fullCk);
	LISTELTS(FiniteFuncOrdinal(Ordinal::two,zero),fullCk);
	LISTELTS(FiniteFuncOrdinal(Ordinal::one,zero,zero,zero),fullCk);
	LISTELTS(FiniteFuncOrdinal(Ordinal::one,zero,zero,one),fullCk);
	LISTELTS(FiniteFuncOrdinal(Ordinal::omega,zero,one,zero),fullCk);
	
	LISTELTS(FiniteFuncOrdinal(Ordinal::omega,zero,zero,one),fullCk);
	
	LISTELTS(FiniteFuncOrdinal(Ordinal::omega,zero,zero,one),fullCk);
	
	
	LISTELTS(IterFuncOrdinal(omega,Ordinal::one,zero,one),fullCk);
	LISTELTS(IterFuncOrdinal(omega,Ordinal::three,zero,one),fullCk);
	
	
	
	//
	outStream() << "Fixed Point tests:\n" ;
	const Ordinal ifa = iterativeFunctional(omega,100,zero);
	outStream() << iterativeFunctional(1000,ifa,zero.zero).normalForm()<<"\n";	
	outStream() << iterativeFunctional(omega,99,ifa).normalForm()<<"\n";	
	outStream() << iterativeFunctional(omega,99,ifa).normalForm()<<"\n";	
	outStream() << iterativeFunctional(omega,100,ifa).normalForm()<<"\n";	
	outStream() << iterativeFunctional(omega,101,ifa).normalForm()<<"\n";	

	const Ordinal ifb = iterativeFunctional(omega,100,zero,zero);
	outStream() << iterativeFunctional(omega,99,ifb,zero).normalForm()<<"\n";	
	outStream() << iterativeFunctional(omega,99,ifb,one).normalForm()<<"\n";	

	const Ordinal ffa = finiteFunctional(omega,zero,zero,zero);
	const Ordinal ffb = finiteFunctional(omega,zero,zero,one);

	outStream() << finiteFunctional(omega,zero,ffb,zero).normalForm() << "\n" ;
	outStream() << finiteFunctional(1000,zero,ffa,zero).normalForm() << "\n" ;
	outStream() << finiteFunctional(1000,zero,ffa,one).normalForm() << "\n" ;
	outStream() << finiteFunctional(1000,zero,ffb,zero).normalForm() << "\n" ;
	outStream() << finiteFunctional(1000,zero,ffb,one).normalForm() << "\n" ;
	outStream() << "End fixed Point tests:\n" ;
	
	bool flLimTst = fullCk ;
	outStream() << "Test for limitElement exit C:\n" ;
	iterativeFunctional(Ordinal::one).DLISTELTS(10,flLimTst);

	outStream() << "Tests for limitElement exit D:\n" ;
	iterativeFunctional(Ordinal::three).DLISTELTS(10,flLimTst);
	iterativeFunctional(eps0+2).DLISTELTS(10,flLimTst);
	iterativeFunctional(eps0+1).DLISTELTS(10,flLimTst);
	outStream() << "Tests EXIT for limitElement exit D:\n" ;

	outStream() << "Tests for limitElement exit E:\n" ;
	iterativeFunctional(omega,4).DLISTELTS(10,flLimTst);
	iterativeFunctional(Ordinal::omega).DLISTELTS(10,flLimTst);
	outStream() << "Tests END for limitElement exit E:\n" ;

	outStream() << "Tests for limitElement exit F:\n" ;
	iterativeFunctional(omega,Ordinal::omega).DLISTELTS(10,flLimTst);
	iterativeFunctional(omega,Ordinal::omega,eps0).DLISTELTS(10,flLimTst);
	outStream() << "Tests END for limitElement exit F:\n" ;

	outStream() << "Test for limitElement exit G:\n" ;
	iterativeFunctional(5,1).DLISTELTS(10,flLimTst);

	outStream() << "Test for limitElement exit H:\n" ;
	iterativeFunctional(5,4).DLISTELTS(10,flLimTst);

	outStream() << "Test for limitElement exit I:\n" ;
	iterativeFunctional(5,one,zero,zero).DLISTELTS(10,flLimTst);

	outStream() << "Test for limitElement exit J:\n" ;
	iterativeFunctional(5,Ordinal::two,zero,zero).DLISTELTS(10,flLimTst);

	outStream() << "Test for limitElement exit K:\n" ;
	iterativeFunctional(5,Ordinal::two,zero,3,zero).DLISTELTS(10,flLimTst);

	outStream() << "Tests for limitElement exit L:\n" ;
	iterativeFunctional(5,Ordinal::two,omega,zero,omega+1).DLISTELTS(9,flLimTst);
	iterativeFunctional(5,Ordinal::two,eps0,zero,omega+1).DLISTELTS(10,flLimTst);
	outStream() << "Tests END for limitElement exit L:\n" ;

	outStream() << "Tests for limitElement exit M:\n" ;
	iterativeFunctional(5,Ordinal::one,zero,3).DLISTELTS(10,flLimTst);
	iterativeFunctional(5,Ordinal::two,one,one).DLISTELTS(10,flLimTst);
	outStream() << "Tests END for limitElement exit M:\n" ;

	outStream() << "Tests for limitElement exit N:\n" ;
	iterativeFunctional(5,Ordinal::two,zero,3).DLISTELTS(10,flLimTst);
	iterativeFunctional(5,omega,Ordinal::two,one).DLISTELTS(10,flLimTst);
	outStream() << "Tests END for limitElement exit N:\n" ;

	iterativeFunctional(12).DLISTELTS(10,true);
	iterativeFunctional(Ordinal::one,Ordinal::one).DLISTELTS(10,true);
	iterativeFunctional(Ordinal::one,Ordinal::one,Ordinal::one).
		DLISTELTS(10,true);
	const Ordinal & fp = finiteFunctional(one,zero,4,zero);
	fp.DLISTELTS(10,true);
	finiteFunctional(one,fp+1,zero,zero).DLISTELTS(10,fullCk);
	finiteFunctional(one,fp+1,zero,zero).DLISTELTS(10,true);
	finiteFunctional(Ordinal::two,zero,Ordinal::two,zero,12).DLISTELTS(10,true);
	finiteFunctional(Ordinal::two,zero,one,zero,12).DLISTELTS(10,true);
	finiteFunctional(one,zero,zero,one).DLISTELTS(10,true);
	finiteFunctional(one,zero,one).DLISTELTS(10,true);
	psi(1,2).DLISTELTS(10,true);
	psi(1,3).DLISTELTS(10,true);
	psi(1,1).DLISTELTS(10,true);
	psi(1,psi(2,0)).DLISTELTS(10,true);
	
	finiteFunctional(Ordinal::two,zero,zero,zero).DLISTELTS(10,true);
	finiteFunctional(one,zero,zero,zero,zero).DLISTELTS(10,true);
	finiteFunctional(one,zero,zero,zero).DLISTELTS(10,true);
	finiteFunctional(one,zero,zero).DLISTELTS(10,true);
	eps0.DLISTELTS(10,true);

	psi(one,one).DLISTELTS(10,true);

	const Ordinal&a4 = finiteFunctional(omega,omega^omega,one);
	a4.DLISTELTS(10,true);
	

	const Ordinal&a1 = finiteFunctional(omega,omega,one);
	a1.DLISTELTS(10,true);

	const Ordinal&a2 = finiteFunctional(omega,omega,one,zero);
	a2.DLISTELTS(10,true);

	const Ordinal& if1 = iterativeFunctional(one,NULL);

	const Ordinal& ff1 = psi(zero,if1);
	const Ordinal& ff2 = psi(zero,one);

	
	outStream() << if1.normalForm() << " if1\n" ;
	outStream() << ff1.normalForm() << ", cl = " <<
		ff1.getImpl().getFirstTerm()->codeLevel << " ff1\n" ;

	outStream() << ff2.normalForm() << ", cl = " <<
		ff2.getImpl().getFirstTerm()->codeLevel << " ff2\n" ;

	outStream() << ff1.compare(if1) << " ff1.comp(if1)\n" ;

	LISTELTS(ff1,fullCk);
	LISTELTS(ff2,fullCk);

	IterFuncOrdinal si(omega+3,NULL);
	LISTELTS(si,true);

	

	bool ftst = fullCk;

	IterFuncOrdinal x1(omega,NULL);
	LISTELTS(x1*x1,ftst);

	LISTELTS(IterFuncOrdinal(Ordinal::three,NULL),ftst);

	LISTELTS(IterFuncOrdinal(Ordinal::three,Ordinal::one),ftst);
	LISTELTS(IterFuncOrdinal(Ordinal::three,Ordinal::one,zero),ftst);
	LISTELTS(IterFuncOrdinal(Ordinal::three,Ordinal::one,zero,zero),ftst);
	LISTELTS(IterFuncOrdinal(Ordinal::three,Ordinal::one,zero,zero)*omega,ftst);

	(IterFuncOrdinal(Ordinal::three,Ordinal::one,zero,zero)).descend(3, 10);
	//


}


void Validate::tryExamp()
{
    
	
    //
    
    const Ordinal & xta = admisLevelFunctional(Ordinal::three,Ordinal::zero);
    outStream() << xta.normalForm() << "\n" ;

    const Ordinal &w = omega;
#define EMB(a) { outStream() << (a).normalForm() << ", maxEmbed = " << \
    a.getMaxEmbedIndex().normalForm() << "\n" ;}

    const Ordinal e2 =
        admisLevelFunctional(Ordinal::three,zero,NULL,zero, Ordinal::three);
    EMB(omega1CK);
    EMB(omega);
    EMB(e2);


#define TS(a)  { outStream() << (a).normalForm() << " " << \
    (a).isOmegaSuccessor() << "\n" ; if ((a).isOmegaSuccessor()) \
    outStream() << (a).getImpl().subtractOmega().normalForm() << " SUB\n" ;}

    TS(w);
    TS(w+1);
    TS(Ordinal::three);
    TS(eps0);
    TS(eps0+Ordinal::five);
    TS(eps0+(w^w));
    TS(eps0+(w^w)+w*12);
    
    const Ordinal& dd = Ordinal::two ;
    const Ordinal& d1 = admisLevelFunctional(Ordinal::omega,zero,NULL,zero,dd);
    outStream() << d1.normalForm() << "\n" ;
    //
    //
    //
	FiniteFuncOrdinal ffo(3,0,0);
	outStream() << ffo.normalForm() << " ffo\n" ;
	outStream() << ffo.texNormalForm() << " ffoTeX\n" ;
	outStream() << ffo.limitElement(2).normalForm() << " ffo\n" ;
	outStream() << ffo.limitElement(2).texNormalForm() << " ffoTeX\n" ;
	const Ordinal * p1[] = {&Ordinal::three,&omega,&Ordinal::two,NULL};
	FiniteFuncOrdinal ff1(p1);
	outStream() << ff1.normalForm() << " ff1\n" ;
	outStream() << ff1.texNormalForm() << " ff1 TeX\n" ;
	
	LISTELTS(ff1,true);
 	

	(ff1*Ordinal::three).describel(outStream());
	(ff1*Ordinal::omega).describel(outStream());
	(ff1*ff1).describel(outStream());
	(ff1^omega).describel(outStream());
	(ff1^ff1).describel(outStream());
	LISTELTS(eps0,true);

	const Ordinal& psi3 = psi(Ordinal::three,zero);
	
	
	
	
	const Ordinal& psi4 = psi(omega,zero);
	LISTELTS(psi4,true);
	
	const Ordinal * p5[] = {&one,&zero,&zero,&zero,NULL};
	FiniteFuncOrdinal ff5(p5);
	outStream() << ff5.normalForm() << " ff5\n" ;
	
	LISTELTS(ff5,true);
 	
	
	const Ordinal * p6[] = {&one,&zero,&zero,&zero,&zero,&zero,NULL};
	FiniteFuncOrdinal ff6(p6);
	outStream() << ff6.normalForm() << " ff6\n" ;
	LISTELTS(ff6,true);

	const Ordinal * p7[] = {&Ordinal::three,&zero,&zero,&zero,NULL};
	FiniteFuncOrdinal ff7(p7);
	outStream() << ff7.normalForm() << " ff7\n" ;
	LISTELTS(ff7,true);
	
	const Ordinal * p8[] = {&Ordinal::two,&zero,&zero,&zero,&zero,&zero,NULL};
	FiniteFuncOrdinal ff8(p8);
	outStream() << ff8.normalForm() << " ff8\n" ;
	LISTELTS(ff8,true);
	
	const Ordinal * p9[] = {&one,&Ordinal::two,&Ordinal::three,&zero,
		&omega,&zero,NULL};
	FiniteFuncOrdinal ff9(p9);
	outStream() << ff9.normalForm() << " ff9\n" ;
	LISTELTS(ff9,true);

	const Ordinal * pA[] = {&one,&Ordinal::two,&Ordinal::three,&zero,
		&omega,&one,&zero,NULL};
	FiniteFuncOrdinal ffA(pA);
	outStream() << ffA.normalForm() << " ffA\n" ;
	LISTELTS(ffA,true);

	const Ordinal * pB[] = {&one,&Ordinal::two,&Ordinal::three,&zero,
		&one,&one,&zero,NULL};
	FiniteFuncOrdinal ffB(pB);
	outStream() << ffB.normalForm() << " ffB\n" ;
	
	LISTELTS(ffB,true);
 	

	const Ordinal * pC[] = {&one,&Ordinal::two,&Ordinal::one,&zero,
		&zero,&one,NULL};
	FiniteFuncOrdinal ffC(pC);
	outStream() << ffC.normalForm() << " ffC\n" ;
	LISTELTS(ffC,true);

	const Ordinal * pD[] = {&one,&Ordinal::two,&Ordinal::three,&zero,
		&zero,&one,NULL};
	FiniteFuncOrdinal ffD(pD);
	outStream() << ffD.normalForm() << " ffD\n" ;
	LISTELTS(ffD,true);



	psi(gamma0,omega).describel(outStream());
	psi(gamma0+one,omega).describel(outStream());
	psi(gamma0*Ordinal::two,omega).describel(outStream());
	 psi(15, psi((omega^(omega)), eps0)).describel(outStream());

	const Ordinal&a3 = finiteFunctional(omega,zero,zero);
	a3.DLISTELTS(10,true);

	const Ordinal&a = finiteFunctional(omega,omega,omega);
	a.DLISTELTS(10,true);

	const Ordinal&b = finiteFunctional(one,one,a+one);
	b.DLISTELTS(10,true);
	

	psi(1,psi(1,psi(1,0))).DLISTELTS(10,true);
	psi(3,5).DLISTELTS(10,true);
	psi(3,1).DLISTELTS(10,true);
	psi(1,1).DLISTELTS(10,true);
	finiteFunctional(Ordinal::three,Ordinal::one,Ordinal::one).DLISTELTS(10,true);
	iterativeFunctional(Ordinal::three,Ordinal::one, Ordinal::one).DLISTELTS(10,true);

	iterativeFunctional(Ordinal::three,eps0,omega+13).DLISTELTS(10,true);

	finiteFunctional(Ordinal::omega,Ordinal::one,omega+15).DLISTELTS(10,true);

	finiteFunctional(Ordinal::omega,Ordinal::one,zero,omega+15).DLISTELTS(10,
		true);

	
	finiteFunctional(Ordinal::omega,Ordinal::one,zero,omega+15).DLISTELTS(10,true);
	
	const Ordinal ft1 = finiteFunctional(omega, 0,
			finiteFunctional(omega, 1, 0, omega + 14) + 1, omega + 14);
	ft1.DLISTELTS(10,true);

	outStream() << ft1.limitElement(2).normalForm() << "\n" ;

	psi(3,9).DLISTELTS(10,true) ;
	psi(3,1).DLISTELTS(10,true) ;
	psi(omega+1,1).DLISTELTS(10,true) ;

	psi(2,psi(2,0)+1).DLISTELTS(10,true);

	outStream() << psi(1,psi(2,0)).normalForm() << "\n" ;
	
	outStream() << finiteFunctional(omega, 0, finiteFunctional(omega, 1, 0,
		omega + 14) + 1, omega + 14).limitElement(2).normalForm() << "\n" ;
	

}







