#include <fstream>


#include "admisOrd.h"

using namespace std;
using namespace ord;


#define DBGO if (dbg) outStream() <<


IterFuncNormalElement::IterFuncParameters::IterFuncParameters(
	const Ordinal& iter, const Ordinal * const * const params,
    const Embeddings& embed, int level):functionLevel(iter),
        FiniteFuncParameters(params,embed,level)
{
	if (codeLevel <= iterFuncCodeLevel) 
		if (iter.isZero()) if (size < 2)
			if (codeLevel == iterFuncCodeLevel) codeLevel = cantorCodeLevel ;
	else codeLevel = finiteFuncCodeLevel;
	assert(maxParameter);
	maxParameter = (iter.getImpl().compare(embeddings,embeddings,
        maxParameter->getImpl())>0)?
		 &iter : maxParameter;

    const Ordinal& iterMaxEmbed = iter.getMaxEmbedIndex();
    if (maxEmbedIndex->compare(iterMaxEmbed) <0) maxEmbedIndex = &iterMaxEmbed;
	
}

void IterFuncNormalElement::iterFuncDebug(const char * where) const
{

}

IterFuncNormalElement::IterFuncNormalElement(const Ordinal& iter,
	const Ordinal* const * const params, Int fac, int level):
	FiniteFuncNormalElement(new IterFuncParameters(iter,params,
    Embeddings::embedNone,level),fac),
	functionLevel(iter.getImpl()),
	functionLevelO(iter)
{
    iterFuncDebug("A");
}

IterFuncNormalElement::IterFuncNormalElement(const IterFuncParameters* prma,
	Int fac):FiniteFuncNormalElement(prma,fac),
	functionLevel(prma->functionLevel.getImpl()),
	functionLevelO(prma->functionLevel)
{
    iterFuncDebug("B");
}

void IterFuncNormalElement::normalFormName(string& base) const 
{
	if (codeLevel < iterFuncCodeLevel) return
		FiniteFuncNormalElement::normalFormName(base);
	bool useFactor = factor > 1 ;
	if (useFactor) base += "(" ;
	base += IterFuncOrdinalImpl::makeName(functionLevel, funcParameters);
	if (useFactor) {
		base += "*" ;
		base += OrdinalImpl::itoa(factor) ;
		base += ")" ;
	}


}


void IterFuncNormalElement::psiNormalFormKernel(string& str) const
{
    const Ordinal& virtualLimit = classLimit();
    if (!virtualLimit.isZero()) if (functionLevel.compare(virtualLimit)>=0)
    {
        str = notBasic();
        return ;
    }
    bool expSum = size > 1 ;
    if (!functionLevel.isZero()) {
        if (expSum) str += "(\\Omega^{" ;
        else str += "\\Omega^{" ;
        const Ordinal & ord = Ordinal::omega*functionLevelO ;
        str += ord.psiNormalForm();
        str += "}" ;
    } 
    if (size>0) {
        const Ordinal ** params = new const Ordinal * [size+2] ;
        params[size+1]=NULL ;
        params[0]=&Ordinal::one;
        for (int i =1; i < size+1; i++) params[i] = &Ordinal::zero;
        if (createVirtualOrdImpl(params).compare(*(funcParameters[0]))>0) {
            params[size] = NULL ;
            bool badFlag = false ;
            for (int i = 0 ; i < size -1 ;i++) {
                if (!funcParameters[i+1]->isFinite()) {
                    params[i]=new Ordinal(*(funcParameters[i])+Ordinal::one) ;
                    if (finiteFunctional(params).compare(*(funcParameters[i+1]))
                        <=0) {
                          badFlag = true ;
                          break ;
                    }
                }
                params[i]=funcParameters[i] ;
            }
            if (badFlag) {
                str = notBasic();
                return ;
            } else {
                for (int i = 0 ; i < size; i++) { 
                    const Ordinal &f = *(funcParameters[i]) ;
                    int exp = size - i - 1  ;
                    bool fz = f.isZero() ;
                    if (!fz) {
                        if ((i == 0) && expSum) str += " (" ;
                        if (i > 0) str += " + " ;
                        if (exp > 0) str += "\\Omega" ;
                        if (exp > 1) {
                            str += "^" ;
                            str += OrdinalImpl::itoa(exp) ;
                        }
                        str+= " " ;
                        if (!f.isOne() || (exp==0))
                             str += f.psiNormalForm();
                    }
                }
                if (expSum) {
                    str += ")" ;
                    if (!functionLevel.isZero()) str += ")" ;
                }

            }
            delete params ;
            params = NULL ;
                
        } else {
            str = notBasic();
            return ;
        }

    }
    
}

void IterFuncNormalElement::psiNormalForm(string& str) const
{
	bool useFactor = factor > 1 ;
	if (useFactor) str += "(" ;
    str += "\\Psi(\\Omega^{" ;
    psiNormalFormKernel(str);
    if (isNotBasic(str)) return ;
    str += "})" ;
    if (useFactor) {
		str += " " ;
		str += OrdinalImpl::itoa(factor) ;
		str += ")" ;
	}


}

void IterFuncNormalElement::texNormalForm(string& str) const 
{
	if (codeLevel < iterFuncCodeLevel) {
		FiniteFuncNormalElement::texNormalForm(str);
		return ;
	}
	bool useFactor = factor > 1 ;
	if (useFactor) str += "(" ;
	str += IterFuncOrdinalImpl::makeTexName(functionLevel,funcParameters);
	if (useFactor) {
		str += " " ;
		str += OrdinalImpl::itoa(factor) ;
		str += ")" ;
	}

}



const CantorNormalElement& IterFuncNormalElement::getCopy(const Int fac) const
{
	if (codeLevel < iterFuncCodeLevel)
		return FiniteFuncNormalElement::getCopy(fac);
	assert(codeLevel == iterFuncCodeLevel);
	return *new IterFuncNormalElement(functionLevelO,funcParameters,fac);

}


const OrdinalImpl* IterFuncNormalElement::limitOrdCom(
    const OrdinalImpl & ord) const 
{
	bool dbg = OrdinalImpl::debugControl.check(
        DebugControlParam::limit,0) ;
	
	if (dbg) outStream() << "IterFunc entering for " <<
		normalForm() << ".limitOrd(" << ord.normalForm() << ")\n" ;

	const OrdinalImpl * comRet =
        FiniteFuncNormalElement::limitOrdCom(ord);
	if (comRet) return comRet;
	if (functionLevel.isZero()) return NULL ;
	assert(functionLevel.limitType().
        compare(ord.maxLimitType())>0);
	return &(createVirtualOrdImpl(* new Ordinal(
		functionLevel.limitOrd(ord)),
		funcParameters));
}

const OrdinalImpl& IterFuncNormalElement::limitOrd(
    const OrdinalImpl & ord) const 
{
	bool dbg = OrdinalImpl::debugControl.
        check(DebugControlParam::limit,0) ;
	const OrdinalImpl * comRet = limitOrdCom(ord);
	assert(comRet);
	return *comRet ;
}




static const OrdinalImpl& returning1(bool dbg, const char *id,
	const OrdinalImpl& r,
	const Int& n, const IterFuncNormalElement& elt)
{
	const OrdinalImpl * ret = &r ;
	
	if (!dbg) {
		
		return *ret ;
	}
	outDbgStream() << "IterFunc -le limit returning at "
        << id << ", val = " << ret->normalForm() << ", " << n
        << " limit of " << elt.normalForm() << "\n" ;
	return *ret ;
}


#define RETURN1(id,x) return returning1(dbg, id, addFactorPart(x), n, *this)
#define RETURN1X(id,x) return returning1(dbg, id, x, n, *this)




const OrdinalImpl& IterFuncNormalElement::limitElement(Int n) const
{
	assert(n>0);
	assert(!functionLevel.isZero()) ;
	bool dbg = OrdinalImpl::debugControl.
        check(DebugControlParam::limit,0) ;
	
	if (dbg) outStream() << "Entering IterFunc " <<
		normalForm() << ".limitElement(" << n << ") if\n" ;

	if (codeLevel < iterFuncCodeLevel) return
		FiniteFuncNormalElement::limitElement(n);
	assert(codeLevel == iterFuncCodeLevel);
	return limitElementCom(n);
}

const OrdinalImpl& IterFuncNormalElement::limitElementCom(Int n)
    const 
{
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::limit,0) ;
	
	
	assert(n>0);
	assert(funcParameters || !size);
	int leastNz = size-1;
	if (funcParameters) while ((leastNz >= 0) &&
		funcParameters[leastNz]->isZero()) leastNz--;

	if (leastNz < 0) { 
		assert(!functionLevel.isZero());
		
		if (functionLevel.isLimit()) RETURN1("E", createVirtualOrdImpl(
			* new Ordinal(functionLevel.limitElement(n).limPlus_1())));
		
		const Ordinal & funcLevMo =
		* new Ordinal(functionLevel.subtract(1));
		const Ordinal * base = NULL ;
		
		base = &(createVirtualOrd(funcLevMo).limPlus_1());
		int nint ;
		const Ordinal** params = createParamArray(n,nint);
		params[0] = base ;
		
		RETURN1("F",createVirtualOrdImpl(funcLevMo,params));



	}
	assert(size > 0); 
	const Ordinal& leastNzOrd = *(funcParameters[leastNz]) ;
	if (leastNzOrd.isLimit()) RETURN1("G",
		replace1(leastNz, * new Ordinal(
		leastNzOrd.limitElement(n).limPlus_1())));
	if (size < 2) { 
		Ordinal& leastNzMo = * new Ordinal(leastNzOrd.getImpl().subtract(1));
		if (functionLevel.isLimit()) {
            
            
            
            const Ordinal& tmp = 
                *new Ordinal(createVirtualOrdImpl(functionLevelO,
                createParameters(&leastNzMo)).limPlus_1());
                
            DBGO "tmp = " << tmp.normalForm() << "\n" ;
            const OrdinalImpl& fl = functionLevel.limitElement(n).limPlus_1();
            DBGO "fl = " << fl.normalForm() << "\n" ;
            const Ordinal& ofl = * new Ordinal(fl);
            const OrdinalImpl& ret = createVirtualOrdImpl(ofl,
                createParameters(&tmp));
            RETURN1("H",ret);
        

			
		}
		const OrdinalImpl * base = &(replace1(leastNz,leastNzMo).limPlus_1()) ;
        int nint ;
        if (dbg) outStream() << "createParamArray(" << n << "...)\n" ;
		const Ordinal** params = createParamArray(n,nint);
		params[0] = new Ordinal(*base) ;

		const Ordinal& funcLevMo = * new Ordinal(functionLevel.subtract(1));
		if (dbg) outStream() << funcLevMo.normalForm() << " funcLevMo\n" ;
		RETURN1("I",createVirtualOrdImpl(funcLevMo,params));
	}
	RETURN1X("J", FiniteFuncNormalElement::limitElementCom(n)) ;
}


const OrdinalImpl & IterFuncNormalElement::createVirtualOrdImpl(
	const Ordinal & lev, const Ordinal * const * const params) const 
{
	return iterativeFunctional(lev,params).getImpl();
}


const Ordinal & IterFuncNormalElement::createVirtualOrd(const Ordinal & lev,
			const Ordinal * const * const params) const 
{
	return iterativeFunctional(lev,params);
}

const OrdinalImpl & IterFuncNormalElement::createVirtualOrdImpl(
			const Ordinal * const * const params) const 
{
	return iterativeFunctional(functionLevelO,params).getImpl();
}


const Ordinal & IterFuncNormalElement::createVirtualOrd(
			const Ordinal * const * const params) const 
{
	return iterativeFunctional(functionLevelO,params);
}




const CantorNormalElement & IterFuncNormalElement::addFactors(
	const CantorNormalElement& toAdd) const 
{
	if (codeLevel < iterFuncCodeLevel) return
		FiniteFuncNormalElement::addFactors(toAdd);
	return * new IterFuncNormalElement(functionLevelO,
		funcParameters,factor+toAdd.factor);
}

const CantorNormalElement& IterFuncNormalElement::limitMaxEmbed(
    const OrdinalImpl&lim) const
{
    if (getMaxEmbedIndex().compare(lim)<0) return *this ;
    const Ordinal *const * newParams = getLimitMaxEmbedParamAry(lim);
    const Ordinal& iter = functionLevelO.limitMaxEmbed(lim);
    return * new IterFuncNormalElement(iter,newParams,factor);
}

static int returning(bool dbg, const char *id, int r, 
	const IterFuncNormalElement& op1, const CantorNormalElement &op2,
	bool ignoreFactor) 

{
	if (!dbg) return r ;
	outDbgStream() << "IterFunc elt compare returning at " << id <<
		", val = "  << r <<
		", cmp(" << op1.normalForm() << " ::\n" << op2.normalForm() <<
		"), ignf = " << ignoreFactor <<  "\n" ;
	return r;
}

#define RETURN2(id,x) return returning(dbg, id, x, *this, trm,  ignoreFactor)




int IterFuncNormalElement::compare(const CantorNormalElement& trm,
	bool ignoreFactor ) const 
{
   return compare(Embeddings::embedNone,Embeddings::embedNone,trm,ignoreFactor);
}



int IterFuncNormalElement::compare(const Embeddings& context,
    const Embeddings& paramContext, const CantorNormalElement& trm,
	bool ignoreFactor ) const
{
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::compare,0) ;
	
	if (dbg) {
		outDbgStream() << "IterFunc elt compare(" <<  normalForm() << ", " 
			<< trm.normalForm() << ")\n" ;
	}
	if (codeLevel < iterFuncCodeLevel)
		RETURN2("A",FiniteFuncNormalElement::compare(context,paramContext,
            trm, ignoreFactor));
	if (trm.codeLevel > iterFuncCodeLevel) RETURN2("A1", -trm.compare(
        paramContext,context,*this));

	assert(codeLevel == iterFuncCodeLevel) ;
	assert(trm.codeLevel <= iterFuncCodeLevel) ;

	if (trm.codeLevel < iterFuncCodeLevel) { 
		if (dbg) outStream() << trm.getMaxParameter().normalForm() <<
			"  " << trm.normalForm() <<  "  " << normalForm() <<
			" mxc from trm this\n";
		const OrdinalImpl&  trmMaxComp = trm.getMaxParameter();
		
		if (!trmMaxComp.isZero()) {
			const CantorNormalElement * firstTerm = trmMaxComp.getFirstTerm();
			if (firstTerm) if (compare(context,paramContext,*firstTerm,true) <=0)
                RETURN2("A3", -1) ;
		}
		RETURN2("A4",1); 
	}
	assert(trm.codeLevel == iterFuncCodeLevel);
    int diff = parameterCompare(context,paramContext,trm);
    if (diff) RETURN2("A5",diff);
	const IterFuncNormalElement& ftrm = (const IterFuncNormalElement&) trm;
   	diff = functionLevel.compare(context,paramContext,ftrm.functionLevel) ;
	if (diff) RETURN2("A6",diff);

	diff = compareFiniteParams(context,paramContext,ftrm);
	if (diff) RETURN2("R",diff);
	int factDiff = 0 ;
	if (!ignoreFactor) factDiff = cmp(factor,ftrm.factor) ;
	RETURN2("S", factDiff) ;

}

static int returning3(bool dbg, const char * id, int v,
	const IterFuncNormalElement &th, const OrdinalImpl& ord)
{
	if (!dbg) return v ;
	outDbgStream() << "IterFuncn -b compareOrd at " << id << ", returning " << v <<
		", cmp(" << th.normalForm() << "::\n" << ord.normalForm() << ")\n";
	return v ;
}

#define RETURN3(id,x) return returning3(dbg,id,x,*this,ord)






const OrdinalImpl& IterFuncNormalElement::limitInfo(
	CantorNormalElement::LimitTypeInfo& typeInfo) const 
{
	assert(!theLimitType) ;
	typeInfo = unknownLimit;
	const OrdinalImpl * type = NULL ;
	assert(size || !functionLevel.isZero()) ;
	if (size) {
		type = &(FiniteFuncNormalElement::limitInfo(typeInfo)) ;
		assert(typeInfo != unknownLimit);
	} else if (functionLevel.isLimit()) {
		type = &(functionLevel.limitType());
		typeInfo = paramLimit ;
	} else {
		type = &integerLimitType ;
		typeInfo = paramSucc ;
	}
	IterFuncNormalElement * setThis = (IterFuncNormalElement *)this;
	setThis->theLimitType = type ;
	setThis->theLimitTypeInfo = typeInfo ;
	return *theLimitType ;
	

}

const OrdinalImpl& IterFuncNormalElement::limitType() const
{
	if (theLimitType) return * theLimitType ;
	LimitTypeInfo typeInfo = unknownLimit;
	return limitInfo(typeInfo) ;
	
}

const OrdinalImpl& IterFuncNormalElement::maxLimitType() const
{
    return maxLimitType(Ordinal::zero);
}

const OrdinalImpl& IterFuncNormalElement::maxLimitType(const Ordinal& embIx)
    const
{
    
    if (embIx.isZero()) if (theMaxLimitType) return *theMaxLimitType ;
    const OrdinalImpl * type = NULL ;
    if (size) type = &(FiniteFuncNormalElement::maxLimitType(embIx));
    if (!functionLevel.isZero()) {
        const OrdinalImpl& flt = functionLevel.maxLimitType(embIx);
        if (!type || (flt.compare(*type)>0)) type = &flt;
    }
    if (embIx.isZero()) {
        ((IterFuncNormalElement *)this)->theMaxLimitType = type ;
        return *theMaxLimitType ;
    }
    type = &(AdmisNormalElement::boundedLimitType( embIx,*type));
    return *type ;
}


const NormalFormTerm& IterFuncOrdinalImpl::createTerms(const Ordinal& iter,
			const Ordinal* const * const params)  
{
	const IterFuncNormalElement& elt = * new IterFuncNormalElement(iter,
		params) ;
	return * new NormalFormTerm(elt) ;

}

string IterFuncOrdinalImpl::makeName(const Ordinal& iter,
			const Ordinal* const * const params)  
{
	if (iter.isZero()) return FiniteFuncOrdinalImpl::makeName(params);
	int count = 0 ;
	if (params) for (;params[count];count++) ;

	string base = "psi_{ " ;
	base += iter.normalForm() ;
	base += "}" ;
	if (count) {
		base += "(" ;
		for (int i = 0 ; i < count; i++) {
			if (i) base += ", " ;
			base += params[i]->normalForm() ;
		}
		base += ")" ;
	}
	return base ;

}

string IterFuncOrdinalImpl::makeTexName(const Ordinal& iter,
			const Ordinal* const * const params)  
{
	if (iter.isZero()) return FiniteFuncOrdinalImpl::makeTexName(params);
	int count = 0 ;
	if (params) for (;params[count];count++) ;

	string base = "\\varphi_{" ;
	base += iter.texNormalForm() ;
	base += "}" ;
	if (count) {
		base += "(" ;
		for (int i = 0 ; i < count; i++) {
			if (i) base += ", " ;
			base += params[i]->texNormalForm() ;
		}
		base += ")" ;
	}
	return base ;

	
}

bool IterFuncOrdinal::fixedPoint(const Ordinal& iter, int ix,
			const Ordinal* const * const params)
{
	
	if (iter.isZero()) {
		if ((ix == iterMaxParam) || !params) return false ;
		return FiniteFuncOrdinal::fixedPoint(ix,params);
	}
	if (ix==iterMaxParam ) return iter.psuedoCodeLevel() >
		IterFuncNormalElement::iterFuncCodeLevel ;
	int paramsPcl = params[ix]->getImpl().psuedoCodeLevel() ;
	if (paramsPcl != IterFuncNormalElement::iterFuncCodeLevel)
		return paramsPcl > IterFuncNormalElement::iterFuncCodeLevel ;

	if (ix == 0) return IterFuncOrdinal(iter).compare(*params[0]) < 0;
	int size = 0 ;
	for (;params[size];size++);
	const Ordinal** nParams = new const Ordinal *[size+1] ;
	nParams[size]=0;
	assert(ix<size);
	for (int i = 0 ; i < ix;i++) nParams[i] = params[i] ;
	for (int i = ix ; i < size ; i++) nParams[i] = &zero ;
	return  IterFuncOrdinal(iter,nParams).compare(*(params[ix])) < 0;


}

static void iterFuncExamp()
{
	string tname = "tabiterfuncCppExamp" ;
	string fname = tname;
	fname += ".tex" ;
	ofstream outStream(fname.c_str());
	OutStream::streamManager.push(outStream);

#define CPP_EXAMP(str) outStream << "{\\tt " << "\\verb#" << #str <<"#" \
	<< "}&$" << (str).texNormalForm()  << "$\\\\  \n"

#define cp createParameters	

	outStream << "\\begin{table}\\centering\n" ;
	outStream << "\\begin{tabular}{|l|l|}\\hline\n" ;

	outStream << "\\multicolumn{2}{|c|}{\\bf `{\\tt cp}' stands for function" <<
		" {\\tt createParameters}}\\\\ \\hline \n" ;
	outStream << "{\\bf \\Cpp{} code} &{\\bf Ordinal}\\\\ \\hline \n" ;
	CPP_EXAMP(iterativeFunctional(zero,cp(&one)));
	CPP_EXAMP(iterativeFunctional(zero,cp(&one,&zero)));
	CPP_EXAMP(iterativeFunctional(zero,cp(&one,&one,&zero)));
	CPP_EXAMP(iterativeFunctional(one));
	CPP_EXAMP(iterativeFunctional(one,cp(&one)));
	CPP_EXAMP(iterativeFunctional(one,cp(&one,&omega)));
	CPP_EXAMP(iterativeFunctional(one,cp(&one,&omega,&zero,&zero)));
	CPP_EXAMP(iterativeFunctional(omega,cp(&one,&omega,&zero,&zero)));
	CPP_EXAMP(iterativeFunctional(omega));
	CPP_EXAMP(iterativeFunctional(one,cp(&iterativeFunctional(omega))));

	outStream << "\\hline\n" ;
	outStream << "\\end{tabular}\n" ;
	outStream<<"\\caption{{\\tt iterativeFunctional} \\Cpp{} code examples}\n";
    outStream << "\\mindex{{\\tt iterativeFunctional} C{\\tt ++} examples}\n" ;
    outStream <<
        "\\mindex{examples {\\tt iterativeFunctional} C{\\tt ++} code}\n" ;

	outStream << "\\label{TabIterFuncOrdinalCppExamp}\n" ;
	outStream << "\\end{table}\n\n" ;

	OutStream::streamManager.pop();
#undef cp
#undef CPP_EXAMP
}


static void iterArithExamp()
{
	const char * cName = "IterFuncOrdinal" ;
        const Ordinal &iter1  = iterativeFunctional(one);
        const Ordinal &iter2  = iterativeFunctional(Ordinal::three) ;
        const Ordinal &iter3  =
            iterativeFunctional(Ordinal::three,createParameters(&one,&zero,&zero));
        const Ordinal &iter4  = iterativeFunctional(one,createParameters(&omega,&one)) ;
        const Ordinal &iter5  =
            iterativeFunctional(one,createParameters(&omega,&one,&zero)) + iter1 ;
        const Ordinal &iter6  = iterativeFunctional(eps0) + iter5 ;
	const Ordinal * const am[] = {
		&iter1,
		&iter2,
		&iter3,
		&iter4,
		&iter5,
		&iter6,


		NULL
	};

	Ordinal::arithExamp(am,cName,Ordinal::multType);

	const Ordinal * const * bm = am ;

	Ordinal::arithExamp(bm,cName,Ordinal::powerType);

}



void IterFuncOrdinal::texDocument()
{

	iterFuncExamp();

	iterArithExamp();

	
	const Int indicies[] = {1,2,3,-1};
	
	const Ordinal expI=(iterativeFunctional(one)^(iterativeFunctional(one)+1));

	const Ordinal* ordAry [] = {
		
		&iterativeFunctional(one),
		&iterativeFunctional(Ordinal::three),
		
		&iterativeFunctional(one,createParameters(&one)),
		&iterativeFunctional(omega,NULL),
		&iterativeFunctional(omega,createParameters(&one)),
		&iterativeFunctional(one,createParameters(&Ordinal::two)),
		&iterativeFunctional(one,createParameters(&eps0)),
		&iterativeFunctional(one,createParameters(&one,&zero,&zero)),
		&iterativeFunctional(Ordinal::three,createParameters(&one,&zero,&zero)),
		&iterativeFunctional(one,createParameters(&omega,&one)),
		&iterativeFunctional(one,createParameters(&omega,&one,&zero)),
		&iterativeFunctional(Ordinal::two),
		&iterativeFunctional(eps0),
		&iterativeFunctional(finiteFunctional(one,zero,zero)),
		&iterativeFunctional(finiteFunctional(one,zero,zero),
			createParameters(&one)),
		&iterativeFunctional(finiteFunctional(one,zero,zero),
			createParameters(&one,&zero)),
		&iterativeFunctional(finiteFunctional(one,zero,zero),
			createParameters(&eps0)),
		&iterativeFunctional(finiteFunctional(one,zero,zero),
			createParameters(&eps0,&zero)),
		&iterativeFunctional(finiteFunctional(one,zero,zero),
			createParameters(&eps0,&one)),
		&iterativeFunctional(finiteFunctional(one,zero,zero),
			createParameters(&eps0,&one,&one)),
		&iterativeFunctional(finiteFunctional(one,zero,zero),
			createParameters(&eps0,&one,&one,&Ordinal::two)),
		
		0
	};

	limitElementTable(ordAry,indicies,"IterFuncOrdinal");


}
