#include <fstream>

#include "admisOrd.h"
#include "validate.h"

using namespace std;
using namespace ord;

#define DBGO if (dbg) outStream() << __LINE__ << " : " <<


static const Ordinal * const * const ckDd(const Ordinal * const * const dd)
{
    if ((dd !=  NULL) && (*dd != NULL) && !dd[0]->isZero()) return dd;
    return NULL;
}

void breakPointEmbed()
{
}


AdmisNormalElement::AdmisLevParameters::AdmisLevParameters(
    const Ordinal& ixCK, const Ordinal& iter,
    const Ordinal * const * const params, const Ordinal& dd,
    const Embeddings& embed, int level):indexCK(ixCK),drillDown(dd),
    embeddings(embed),
    IterFuncParameters(iter,params,embed,level),leastSigParam(NULL)
{
    breakPointEmbed();
    if (maxEmbedIndex->compare(ixCK.getMaxEmbedIndex())<0)
        maxEmbedIndex = &(ixCK.getMaxEmbedIndex());
    if (embed.type == Embeddings::paramRestrict) {
        const Ordinal& ix = embed.embedIndex ;
        assert(!ix.isZero()) ;
        assert(ix.compare(*maxEmbedIndex)>=0);
        maxEmbedIndex = &ix ;
        
        
    }
    if (parameters) for (int sz = size -1; sz > -1; sz--) {
        if (!parameters[sz]->isZero()) {
            leastSigParam = &(parameters[sz]->getImpl()) ;
            break ;
        }
    }
    if (!leastSigParam) if (!functionLevel.isZero()) leastSigParam =
        &(functionLevel.getImpl()) ;
    if (!leastSigParam) leastSigParam = &(indexCK.getImpl()) ;
    if (maxParameter->getImpl().compare(embed,embed,indexCK.getImpl())<0)
        maxParameter  = &indexCK;
    
    if (codeLevel > admisCodeLevel)  return ;
    assert(!indexCK.isZero());

}




const AdmisNormalElement& AdmisNormalElement::createAdmissibleBase() const
{
    if (!size && functionLevel.isZero() && drillDown.isZero()) return *this ;
    ((AdmisNormalElement *)this)->admissibleBase =
        new AdmisLevOrdinal(indexCKo,Ordinal::zero) ;
    const CantorNormalElement * firstTerm =
        admissibleBase->getImpl().getFirstTerm();
    assert(firstTerm);
    assert(firstTerm->codeLevel == admisCodeLevel);
    return *(const AdmisNormalElement *) firstTerm ;
}

const AdmisLevOrdinalImpl& AdmisNormalElement::getAdmissibleBaseImpl() const 
{
    return (AdmisLevOrdinalImpl&) getAdmissibleBase().getImpl();
}

const AdmisLevOrdinal& AdmisNormalElement::getAdmissibleBase() const 
{
    
    if (!admissibleBase) ((AdmisNormalElement *)this)->admissibleBase =
         (AdmisLevOrdinal*) new Ordinal(*new OrdinalImpl (admissibleBaseElement));
    return *  admissibleBase ;
}

AdmisNormalElement::AdmisNormalElement(const Ordinal& ixCK,
    const Ordinal& iter,
	const Ordinal* const * const params, 
	const Ordinal& dd, const Embeddings& embed, Int fac):
    indexCK(ixCK.getImpl()),
    indexCKmo(ixCK.isSuccessor()?ixCK.getImpl().subtract(1):ixCK.getImpl()),
    indexCKo(ixCK),
    drillDown(dd),
    entryCount(0),
    embeddings(embed),
    ixMone(indexCK.isSuccessor()?indexCK.subtract(1):indexCK),
    IterFuncNormalElement(new AdmisLevParameters(ixCK,iter,params,
        dd,embed,admisCodeLevel), fac),
        leastSigParam(*(((AdmisLevParameters*)parameters)->leastSigParam)),
         admissibleBase(NULL),
         admissibleBaseElement(createAdmissibleBase())
         
            
    
{
    iterFuncDebug("C");
    assert(validAdmisNormalElementInt());
}


AdmisNormalElement::AdmisNormalElement(const AdmisLevParameters* params,
    Int fac): indexCK(params->indexCK.getImpl()),
    indexCKo(params->indexCK),
    indexCKmo(params->indexCK.isSuccessor()?
        params->indexCK.getImpl().subtract(1):params->indexCK.getImpl()),
    drillDown(params->drillDown),
    IterFuncNormalElement(params),
    leastSigParam(*(params->leastSigParam)),
    embeddings(params->embeddings),
    ixMone(indexCK.isSuccessor()?indexCK.subtract(1):indexCK),
    admissibleBase(NULL),
    entryCount(0),
    admissibleBaseElement(createAdmissibleBase())
   
{
    iterFuncDebug("D");
    assert(validAdmisNormalElementInt());
}



bool AdmisNormalElement::validAdmisNormalElementInt() const
{
    return validAdmisNormalElement(indexCKo,functionLevelO,
        funcParameters,drillDown,embeddings);
}

static void errorBreak()
{

}


bool AdmisNormalElement::validAdmisNormalElement(const Ordinal& inx,
    const Ordinal& iter, const Ordinal * const * const params,
    const Ordinal& dd, const Embeddings& embed)
{
    const OrdinalImpl& embedIx = embed.embedIndex.getImpl() ;
    bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::ctrOrd) ;
    struct Errs {int flag; const char *err;} errors[] = {
        {1,"[[Index]] must be <= indexCK"},
        {2,"indexCK must be a successor with []"},
        {4,"functionalLevel must be 0 with []"},
        {8,"no parameters allowed with []"},
        {0x10,"internal error: empty []"},
        {0x20,"internal error: indexCK is zero"},
        {0x40,"[parameter.maxLimitType] < limitType"},
        {0x80,"embedIndex must be >= all internal instances of embedIndex"},
        {0x100,"With [[index]] indexCK must be > 0"},
        {0x200,"[[Index]] must be <= affected internal indeCK's"}, 
       
    
        
        {0,0}
    };
    int sz=0;
    if (params) for (;params[sz];sz++) ;
    bool checkEmbed = true ;;

    const Ordinal * maxEmbedIx = &Ordinal::zero ;
    if (embedIx.isZero()) {
        assert(embed.type != Embeddings::paramRestrict);
        checkEmbed = false ;
    }
    int err = 0 ;
    if (checkEmbed) {
        
        for (int i =0;i<sz;i++) {
            const Ordinal& ord = params[i]->getMaxEmbedIndex();
            if (ord.compare(*maxEmbedIx)>0) maxEmbedIx = &ord ;
        }
        const Ordinal &iord = iter.getMaxEmbedIndex();
        if (iord.compare(*maxEmbedIx)>0) maxEmbedIx = &iord ;
        const Ordinal &xord = inx.getMaxEmbedIndex();
        if (xord.compare(*maxEmbedIx)>0) maxEmbedIx = &xord ;
        if (inx.compare(embedIx)<0) err|= 0x1 ;
        if (embedIx.compare(*maxEmbedIx)<0) err |= 0x80 ;
        if (inx.isZero()) err|=0x100 ;
       
    }
        
    if (dbg) outStream() << inx.normalForm() << " = inx, " <<
         dd.normalForm() << " = dd, " << sz <<
        " = sz, " << iter.normalForm() << " = iter, " <<
        embedIx.normalForm() << " = embIx\n" ;
    if (inx.isZero()) err |= 0x20;
    if (!dd.isZero()) {
        if (!iter.isZero()) err|=0x4 ;
        if (sz) err|= 8 ;
        if (inx.isLimit()) err|=0x2 ;
        const CantorNormalElement *ddft = dd.getImpl().getFirstTerm();
        int compare = -1;
        if (ddft) compare = ddft->maxLimitType().compare(
               inx.getImpl().indexCKlimitType());
        if (embedIx.isZero()) {
              if (ddft) {
                if (compare >= 0) err|=0x40 ;
                    

                if (dbg) outStream() << "maxCK: " << 
                    ddft->maxLimitType().normalForm() << " mx::ixLim " <<
                    inx.getImpl().indexCKlimitType().normalForm() << "\n" ;
            }
        if (ddft) {
            int ddftcl = ddft->codeLevel;
            if (ddftcl > AdmisNormalElement::admisCodeLevel) err |= 0x40 ;
            if (ddftcl == AdmisNormalElement::admisCodeLevel) {
                const AdmisNormalElement& dda = (const AdmisNormalElement&)
                    *ddft ;
                
                if ((compare==0) && (dda.drillDown !=NULL) &&
                    ((!embedIx.isZero()) ||
                    (!dda.embeddings.embedIndex.isZero()))) err|=0x100 ;
                if (compare > 0) err|=0x40 ;
            }
        }
        }
    }
    if (err) {
        outStream() << "ERROR: in defining 'omega_{indexCK}(" << sz <<
            " parameter" << ((sz==1) ? ")" : "s)") ;
        if (!dd.isZero()) outStream() << "[" << dd.normalForm() << "]" ;
        outStream() << "':" ;
        bool out = false ;
        for (Errs * er = errors; er->flag;er++) {
            if (er->flag & err) {
                if (out) outStream() << "\nand " ;
                else outStream() << "\n" ;
                outStream() << er->err ;
                out = true ;
            }
        }
         outStream() << ".\n" ;
         outStream().flush();
        errorBreak();
        return false ;
    }
    return true ;
}




const OrdinalImpl& AdmisNormalElement::typeIndexCK() const
{
    if (indexCK.isZero()) return nullLimitType ;
    const OrdinalImpl * ret = &indexCK ;
    if (ret->isFinite()) ret = &(ret->addLoc(integerLimitType));
    return *ret ;
}

static const Ordinal *const * const copyParameters(
    const Ordinal * const * const in)
{
    if (!in) return NULL ;
    int sz = 0 ;
    while(in[sz++]);
    const Ordinal ** out = new const Ordinal *[sz+1] ;
    for (int i = 0 ; i < sz+1;i++) out[i]=in[i] ;
    return out;
}

const AdmisNormalElement& AdmisNormalElement::addEmbeddings(
    const Embeddings& emb) const 
{
    assert(embeddings.type == Embeddings::none);
    return * new AdmisNormalElement(indexCKo,functionLevelO,
        copyParameters(funcParameters),drillDown,emb) ;
}



const OrdinalImpl& AdmisNormalElement::boundedLimitType(
    const Ordinal& bound, const OrdinalImpl&type, const Ordinal& dd)
{
    if (bound.isZero()) return type ;
    const OrdinalImpl * ret = &type ;
    const OrdinalImpl * cmpBound = &(bound.getImpl()) ;
    if (bound.isFinite()) cmpBound = &(bound.getImpl().addLoc(1));
    if (!dd.isZero()) {
        assert(!cmpBound->isLimit()) ;
        cmpBound = &(cmpBound->subtract(1)) ;
    }
    if (cmpBound->compare(type)<0) ret = cmpBound ;
    return *ret ;
}

const OrdinalImpl& AdmisNormalElement::maxLimitType() const
{
    return maxLimitType(Ordinal::zero);
}


const OrdinalImpl& AdmisNormalElement::maxLimitType(const Ordinal& emIx) const
{
    const Ordinal *embedIx = &emIx ;
    const Ordinal& delta = embeddings.type==Embeddings::paramRestrict?
        embeddings.embedIndex : Ordinal::zero ;

    if (emIx.isZero()) {
        if (theMaxLimitType) return *theMaxLimitType ;
        if (!delta.isZero()) embedIx = &delta ;
    } else if (!delta.isZero()) {
        assert(delta.compare(emIx)<=0);
        embedIx = &delta ;
    }


    const OrdinalImpl * type = NULL ;
    if (size || !functionLevel.isZero()) type =
        &(IterFuncNormalElement::maxLimitType(*embedIx));

    assert(!indexCK.isZero());
    const OrdinalImpl * ixType = &(typeIndexCK());
    if (!embedIx->isZero())
        if (ixType->compare(*embedIx)>0) ixType = &(embedIx->getImpl()) ;
    bool fromKappa = true ;
    if (!type) type = ixType,fromKappa=true ; else
           if (type->compare(*ixType) < 0) type = ixType,fromKappa=true ;
    assert(type) ;
    if (!embeddings.embedIndex.isZero()) {
        if (embeddings.embedIndex.isFinite()) {
            if (type->compare(embeddings.embedIndex)<=0) type =
                &(embeddings.embedIndex.getImpl().addLoc(1));
        } else if (type->compare(embeddings.embedIndex)<0)
            type = &(embeddings.embedIndex.getImpl()) ;
    }
    if ((!drillDown.isZero()&&fromKappa) || ((embedIx != NULL) && !embedIx->isZero() 
        &&type->isSuccessor())) {
        type = &(type->subtract(1));
    }
    if (emIx.isZero()) {
        ((AdmisNormalElement *)this)->theMaxLimitType = type ;
        return *theMaxLimitType ;
    }
    return * type ;
}


const CantorNormalElement& AdmisNormalElement::limitMaxEmbed(
    const OrdinalImpl&lim) const
{
    if (getMaxEmbedIndex().compare(lim)<0) return *this ;
    const Ordinal *const * newParams = getLimitMaxEmbedParamAry(lim);
    const Ordinal& iter = functionLevelO.limitMaxEmbed(lim);
    const Ordinal& kappa = indexCKo.limitMaxEmbed(lim) ;
    const Embeddings * retEmbed = &embeddings ;
    const Ordinal &dd = drillDown.limitMaxEmbed(lim);
    if (embeddings.type == Embeddings::paramRestrict)
        if (embeddings.embedIndex.compare(lim)>=0)
            retEmbed = &Embeddings::embedNone ;
    return * new AdmisNormalElement(kappa,iter,newParams,dd,
        *retEmbed,factor);
}






const OrdinalImpl& AdmisNormalElement::getCompareIndexCK(
    const Embeddings *emb) const
{
    bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::compare,0) ;
    if (dbg) outStream() << normalForm() << " emb.embedIndex = " <<
           embeddings.embedIndex.normalForm() << "\n" ;     


    const OrdinalImpl * embIx = &OrdinalImpl::zero ;
    if (emb) embIx = &(emb->embedIndex.getImpl());
    bool embZero =  embIx->isZero();
    bool embedZero = embeddings.embedIndex.isZero();
    if (!embZero && !embedZero)
        assert(embIx->compare(embeddings.embedIndex)>=0);
    if (embZero) if (embedZero) return indexCK;
                 else if (embeddings.embedIndex.compare(indexCK)<0)
                        return embeddings.embedIndex.getImpl() ;
                      else return indexCK ;
    const OrdinalImpl * min = embIx ;
    if (min->compare(embeddings.embedIndex.getImpl())>0) 
        min = &(embeddings.embedIndex.getImpl());

    if (min->compare(indexCK)>0) min = &indexCK ;
    return * min ;
}

const OrdinalImpl& AdmisNormalElement::indexCKtoLimitType(const OrdinalImpl&ix,
    const Ordinal&dd)
{
    if (ix.isLimit()) return ix ;
    const OrdinalImpl * ret = &ix ;
    int sub = dd.isZero() ? 0:1 ; 
    if (ix.isFinite()) sub--;
    if (sub>0) ret = &(ix.subtract(sub));
    else if (sub < 0) ret = &(ix.addLoc(-sub));
    return *ret ;
    
}

const OrdinalImpl& AdmisNormalElement::limitInfo(
    CantorNormalElement::LimitTypeInfo& typeInfo) const 
{
    bool dbg = false  ;
    assert(!theLimitType) ;
    typeInfo = unknownLimit;
    const OrdinalImpl * type = NULL ;
    const Ordinal& embIx = embeddings.type==Embeddings::paramRestrict?
        embeddings.embedIndex : Ordinal::zero ;

    if (!drillDown.isZero()) {
        if (drillDown.isLimit()) {
            type = &(drillDown.limitType());
            typeInfo = drillDownLimit;
        } else {
            assert(drillDown.isSuccessor());
            type = &integerLimitType ;
            typeInfo = drillDownSucc;
        }
    }
    if (type == NULL) {
        const Ordinal * leastIx = NULL ;
        const Ordinal * nxtLeastIx = NULL ;

        if (!functionLevel.isZero() || size) {
            for (int i = size -1; i > -1 ;i--) {
                if (!(funcParameters[i]->isZero()))
                if (!leastIx) leastIx = funcParameters[i] ;
                else {
                    assert(!nxtLeastIx);
                    nxtLeastIx = funcParameters[i] ;
                    break ;
                }
            }
            if (leastIx) {
                    if (leastIx->isLimit()) {
                    type = &(leastIx->limitType());
                    typeInfo = (leastIx==&functionLevelO) ?
                        iterLimit:paramLimit ;
                } else if (size>1) {
                    if (nxtLeastIx && nxtLeastIx->isLimit()) {
                        type = &(nxtLeastIx->limitType());
                        typeInfo = paramNxtLimit ;
                    } else {
                        type = &integerLimitType ;
                        typeInfo = paramSucc;
                    }
                } else if (!functionLevel.isZero()) {
                    if (functionLevel.isLimit()) {
                        type = &(functionLevel.limitType());
                        typeInfo = iterNxtLimit ;
                    } else {
                        type = &integerLimitType ;
                        typeInfo = iterSucc;
                    }
                }
            } else if (!functionLevel.isZero()){
                if (functionLevel.isLimit()) {
                    type = &(functionLevel.limitType());
                    typeInfo = iterLimit ;
                } else {
                    type = &integerLimitType ;
                    typeInfo = iterSucc ;
                }
            }
            if (!type) {
                assert(functionLevel.isZero());
                assert(size==1);
                assert (leastIx->isSuccessor()) ;
                if (indexCK.isSuccessor()) {
                    type = &integerLimitType ;
                    typeInfo = indexCKsuccParam;
                } else {
                    assert(indexCK.isLimit());
                    type = &integerLimitType ;
                    typeInfo = indexCKlimitParam;
                }
            }
        }
        if (!type) {
            assert(!leastIx);
            if (indexCK.isLimit()) {
               type = &( indexCK.limitType());
               typeInfo = indexCKlimit ;
           } else {
               assert(!indexCK.isZero());
               const OrdinalImpl * ix = &indexCK ;
               if (!embIx.isZero()) ix = &(embIx.getImpl()) ;
              
               type = &(indexCKtoLimitType(*ix,drillDown));
               typeInfo = indexCKsucc;
           }
       }
    }
    if (!embIx.isZero()) {
        const OrdinalImpl& effEmb = indexCKtoLimitType(embIx.getImpl(),
            Ordinal::one); 
        if (effEmb.compare(*type) < 0) type = &effEmb ;
    }
    assert(type);
    AdmisNormalElement * setThis = (AdmisNormalElement *)this;
    setThis->theLimitType = type ;
    setThis->theLimitTypeInfo = typeInfo ;
    return *theLimitType ;

}





const OrdinalImpl& AdmisNormalElement::limitType(const Ordinal& context) const
{
    const OrdinalImpl& lmt = limitType();
    if (context.isZero()) return lmt ;
    const OrdinalImpl& clmt = indexCKtoLimitType(context.getImpl(),drillDown);
    if (lmt.compare(clmt)>0) return clmt ; else return lmt ;
}




const OrdinalImpl& AdmisNormalElement::limitType() const
{
    if (theLimitType) return * theLimitType;
    LimitTypeInfo typeInfo;
    return limitInfo(typeInfo) ;
}

void AdmisNormalElement::normalFormName(string& base) const 
{
    if (codeLevel < admisCodeLevel) return
        IterFuncNormalElement::normalFormName(base);
    bool useFactor = factor > 1 ;
    if (useFactor) base += "(" ;
    base += AdmisLevOrdinalImpl::makeName(indexCKo,functionLevelO,
        funcParameters,drillDown,embeddings);
    if (useFactor) {
        base += "*" ;
        base += OrdinalImpl::itoa(factor) ;
        base += ")" ;
    }


}



void AdmisNormalElement::psiNormalForm(string& str) const
{
    static const Ordinal * kappaLimit = NULL ;
    if (kappaLimit == NULL) kappaLimit = &Ordinal::omega ;
        
    bool useFactor = factor > 1 ;
    if (useFactor) str += "(" ;

    str += "\\Psi(" ;
    if (embeddings.isParamRestrict()) {
        if (!embeddings.embedIndex.isOne()) goto notDecodable ;
        else  {
            int ckCmp = indexCK.compare(*kappaLimit) ;
            if ((ckCmp==0) && (size==0) && functionLevel.isZero()) {
                str += "\\varepsilon_{\\Omega+1})" ;
                return ;
            }
            if (ckCmp>=0) goto notDecodable;
                        bool useKernel = (size > 0) || !functionLevel.isZero();
            Int depth = indexCK.getFirstTerm()->factor ;
            if (depth > 15) goto notDecodable ;
            Int limit = depth + 3 - (useKernel?1:0);
            for (int i = 0 ; i < limit ; i++)
                str += "\\Omega^{" ;
            
            if (useKernel) str += "(\\Omega" ;
            if (useKernel) psiNormalFormKernel(str);
            if (useKernel) str += ")" ;
            for (int i = 0 ; i < limit ; i++) str += "}" ;

        }
    } else if (!drillDown.isZero()) {
        assert(size ==0);
        assert(functionLevel.isZero());
        if (!indexCK.isOne() ||
            (compare(drillDownLimitValue.getImpl())>=0)) goto notDecodable ;
        
        bool mt = drillDown.getImpl().multipleTerms();
        str += "\\Omega^{\\Omega^{\\Omega " ;
        if (mt) str +="(" ;
        if (mt || !drillDown.isOne()) str += drillDown.psiNormalForm();
        if (mt) str +=")" ;
        str += "}}" ;

    } else goto notDecodable ;
    str += ")" ;
    if (useFactor) {
        str += " " ;
        str += OrdinalImpl::itoa(factor) ;
        str += ")" ;
    }
    return ;
notDecodable:
    str = notBasic();
    return ;
}


void AdmisNormalElement::texNormalForm(string& str) const 
{
    if (codeLevel < admisCodeLevel) {
        IterFuncNormalElement::texNormalForm(str);
        return ;
    }
    bool useFactor = factor > 1 ;
    if (useFactor) str += "(" ;
    str += AdmisLevOrdinalImpl::makeTexName(indexCKo,functionLevelO,
        funcParameters,drillDown,embeddings);
    if (useFactor) {
        str += " " ;
        str += OrdinalImpl::itoa(factor) ;
        str += ")" ;
    }

}
const AdmisNormalElement& AdmisNormalElement::addParam(const Ordinal& param)
    const
{
    assert(drillDown.isZero());
    AdmisNormalElement& ret =
        * new AdmisNormalElement(indexCKo,functionLevelO,funcParameters,
            param,embeddings);
    return ret ;
}


const CantorNormalElement& AdmisNormalElement::getCopy(const Int fac) const
{
    if (codeLevel < admisCodeLevel)
        return IterFuncNormalElement::getCopy(fac);
    assert(codeLevel == admisCodeLevel);
    return *new AdmisNormalElement(indexCKo,functionLevelO,funcParameters,
        drillDown,embeddings,fac);

}

static int countParams(const Ordinal * const * params)
{
    if (!params) return 0 ;
    int ret = 0 ;
    while (*params != NULL) params++,ret++;
    return ret ;
}

#define INTERACTIVE(ret,indexCKo,lev,dd,embed) if (ord::interactiveMode) {\
        bool valid = AdmisNormalElement::validAdmisNormalElement(indexCKo, \
        lev,params,dd,embed) ;\
        if (!valid) { \
            outStream() << "Value set to 0.\n" ; \
            return ret ; \
        }\
    }


const OrdinalImpl & AdmisNormalElement::createVirtualOrdImpl
    (const Ordinal & lev, const Ordinal * const * const params) const 
{
    INTERACTIVE(OrdinalImpl::zero,indexCKo,lev,drillDown,embeddings) ;
    return admisLevelFunctional(indexCKo,lev,params,
        drillDown,embeddings).getImpl();
}


const Ordinal &AdmisNormalElement::createVirtualOrd(const Ordinal & lev,
            const Ordinal * const * const params) const 
{
    INTERACTIVE(Ordinal::zero,indexCKo,lev,drillDown,embeddings) ;
    return admisLevelFunctional(indexCKo,lev,params,drillDown,embeddings);
}

const OrdinalImpl & AdmisNormalElement::createVirtualOrdImpl(
    const Ordinal & ix, const Ordinal & lev,
    const Ordinal * const * const params,
    const Ordinal& drillDownParams, const Embeddings& embed) const 
{
    INTERACTIVE(OrdinalImpl::zero,ix,lev,drillDownParams,embed) ;
    return admisLevelFunctional(ix,lev,params,
        drillDownParams,embeddings).getImpl();
}


const Ordinal &AdmisNormalElement::createVirtualOrd(const Ordinal& ix,
    const Ordinal & lev, const Ordinal * const * const params,
    const Ordinal& drillDownParams, const Embeddings& embed) const 
{
    INTERACTIVE(Ordinal::zero,ix,lev,drillDownParams,embed) ;
    return admisLevelFunctional(ix,lev,params,drillDownParams,embed);
}


const OrdinalImpl & AdmisNormalElement::createVirtualOrdImpl(
    const Ordinal * const * const params) const 
{
    INTERACTIVE(OrdinalImpl::zero,indexCKo,functionLevelO,
        drillDown,embeddings) ;
    return admisLevelFunctional(indexCKo,functionLevelO,params,
        drillDown,embeddings).getImpl();

}


const Ordinal & AdmisNormalElement::createVirtualOrd(
    const Ordinal * const * const params) const 
{
    INTERACTIVE(Ordinal::zero,indexCKo,functionLevelO,
        drillDown,embeddings);
    return admisLevelFunctional(indexCKo,functionLevelO,params,
        drillDown,embeddings);

}


static const OrdinalImpl* returningOrd(bool dbg, const char *id,
    const OrdinalImpl& r, const OrdinalImpl& ord,
    const AdmisNormalElement& elt)
{
    if (dbg) outDbgStream() << "Admis limitOrd returning at " << id <<
        ", val = " << r.normalForm() << ", " << ord.normalForm() <<
        " limit of " << elt.normalForm() << "\n" ;
    else if(Validate::validationTest) outDbgStream()
        << "Admis lo ex " << id << "\n";
    return &r;
}

#define RETURNO(id,x) return returningOrd(dbg, id, addFactorPart(*x), ord, *this)


const OrdinalImpl* AdmisNormalElement::limitOrdCom(const OrdinalImpl & ord)
    const 
{
    bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::limit,0) ;

    if (dbg) outStream() << "Admis entering for " <<
        normalForm() << ".limitOrd(" << ord.normalForm() << ")\n" ;
    if (limitType().compare(ord.maxLimitType())<=0) {
        assert(0);
    }
    assert(ord.compare(omega)>=0) ;
    
    switch (getInfo()) {
case unknownLimit:
case finiteLimit:
        assert(0);
case drillDownLimit:
        assert(!drillDown.isZero());
        RETURNO("LOD", &(createVirtualOrdImpl(indexCKo,functionLevelO,
            funcParameters,*new Ordinal(drillDown.limitOrd(ord)),embeddings)));
case paramLimit:
        assert(funcParameters);
        {
            int i = size - 1 ;
            for (; i > -1; i--)
                if (!funcParameters[i]->isZero()) break ;
            assert(funcParameters[i]&& !funcParameters[i]->isZero());
            assert(funcParameters[i]->isLimit());
            const Ordinal& ordd = *(funcParameters[i]);
            assert(ordd.limitType().compare(ord.maxLimitType())>0);

            const Ordinal& toRep = * new Ordinal(ordd.limitOrd(ord));
            RETURNO("LOE",&replace1(i,toRep));
        }
case paramNxtLimit:
        {
            int i = size - 1;
            for (; i > -1 ; i--)  if (!funcParameters[i]->isZero()) break ;
            assert((i>-1) && funcParameters[i]);

            const Ordinal& leastOrd = *(funcParameters[i]);
            DBGO "leastOrd = " << leastOrd.normalForm() << "\n";
            assert(leastOrd.isSuccessor());
            int least = i ;
        
            int j = i - 1;
            for (;j>-1; j--) if (!funcParameters[j]->isZero()) break ;
            assert((j>-1) && funcParameters[j]);

            const Ordinal& nxtOrd = *(funcParameters[j]);
            DBGO "nxtOrd = " << nxtOrd.normalForm() << "\n";
            assert(nxtOrd.limitType().compare(ord.maxLimitType())>0);
            int nxt = j ;

            const Ordinal& nxtOrdLimit = * new Ordinal(nxtOrd.limitOrd(ord));
            DBGO "nxtOrdLimit = " << nxtOrdLimit.normalForm() << "\n" ;
            const Ordinal& leastSubOne =
                *new Ordinal(leastOrd.getImpl().subtract(1));
            DBGO "leastSubOne = " << leastSubOne.normalForm() << "\n" ;

            const Ordinal& tmp = * new Ordinal(
                replace1(least,leastSubOne).limPlus_1());
            DBGO "tmp = " << tmp.normalForm() << "\n" ;

            RETURNO("LOF",&(replace2(nxt,nxtOrdLimit.limPlus_1(),
                nxt+1,tmp)));

        }
        assert(0);
case iterNxtLimit:
        assert(functionLevel.isLimit());
        assert(functionLevel.limitType().compare(ord.maxLimitType())>0);
        {
            assert(size==1 && (funcParameters[0] != NULL) ) ;
            assert(funcParameters[0]->isSuccessor());
           	Ordinal& leastNzMo =
                * new Ordinal(funcParameters[0]->getImpl().subtract(1));

            const Ordinal& tmp = *new Ordinal(createVirtualOrdImpl(
                createParameters(&leastNzMo)).limPlus_1());
            const Ordinal& ofl = * new Ordinal(
                functionLevel.limitOrd(ord).limPlus_1());
            RETURNO("LOED",&(createVirtualOrdImpl(indexCKo,ofl,
                createParameters(&tmp),drillDown,embeddings)));
        }


case iterLimit:
        assert(functionLevel.isLimit());
        assert(functionLevel.limitType().compare(ord.maxLimitType())>0);

        RETURNO("LOEE",&(createVirtualOrdImpl(
           * new Ordinal(functionLevel.limitOrd(ord)), funcParameters)));
case indexCKlimit:
        assert(indexCK.isLimit());
        assert(indexCK.limitType().compare(ord.maxLimitType())>0);
        if (!embeddings.isParamRestrict())
            RETURNO("LOEF",&(createVirtualOrdImpl(* new Ordinal(
            indexCK.limitOrd(ord)), functionLevelO,funcParameters,
            drillDown,embeddings)));
        if (embeddings.embedIndex.compare(indexCK)==0) { 
            const Ordinal & limElt = * new Ordinal (indexCK.limitOrd(ord)) ;
            RETURNO("LOEG",&(admisLevelFunctional(limElt,functionLevelO,
                funcParameters, drillDown,limElt).getImpl()));
        }
        RETURNO("LOEH",&(admisLevelFunctional(loUse(ord), functionLevelO,
            funcParameters, drillDown,embeddings).getImpl()));
case paramSucc:
        assert(0);
case indexCKsucc:
        assert(functionLevel.isZero() && drillDown.isZero() &&
            (funcParameters == NULL));
        RETURNO("LOI",&(createVirtualOrdImpl(indexCKo,
            functionLevelO,funcParameters,* new Ordinal(ord),embeddings)));
            
default:
    assert(0);
    }

    assert(0);
}

const OrdinalImpl& AdmisNormalElement::limitOrd(const OrdinalImpl & ord) const 
{
    
    const OrdinalImpl * comRet = limitOrdCom(ord);
    assert(comRet);
    bool check = true ;
    if (check) {
        bool abortError = false ;
        if(compare(*comRet)<=0) abortError = true ;
        if (!ord.isFinite()) {
            static const int bg = 99;
            const OrdinalImpl & le = limitElement(bg);
            bool abort1= false ;
            if (le.normalForm().length() > normalForm().length()*20) {
                outStream() << "Questionable length\n" ;
                OrdinalImpl::debugControl.setLimit();
                const OrdinalImpl& le = limitElement(bg);
                abort1=true ;
            }
            int cmp = comRet->compare(le) ;
            if (Validate::validationTest || abort1 || (cmp <=0)) {
                outStream() << (cmp <= 0? "ERR ":"Bg ") << normalForm() <<
                    ".le( " << bg << ") = " << le.normalForm() << "\n" ;
                if (abort1 || (cmp <=0)) assert(false) ;
            }
        }
        if (abortError) {
            OrdinalImpl::debugControl.setCompare();
            int cmp = compare(*comRet);
            outStream() << normalForm() << ".lo( " << ord.normalForm() << ") = "
                << comRet->normalForm() << " COMPARISON: " << cmp << "\n" ;
            assert(false);
        }
    }
    return *comRet ;
}





static const OrdinalImpl& returning1(bool dbg, const char *id,
    const OrdinalImpl& r,
    const Int& n, const AdmisNormalElement& elt)
{
    if (!dbg) {
        if (Validate::validationTest) outDbgStream() << "Admis le ex " << id << "\n";
        
        return r ;
    } 

    outDbgStream() << "Admis -le limit returning at " << id << ", val = "
        << r.normalForm() << ", " << n << " limit of " << elt.normalForm()
            << "\n" ;
    return r;
}



const OrdinalImpl& AdmisNormalElement::dRep1( 
    const Ordinal& nval) const 
{
    return createVirtualOrdImpl(indexCKo,functionLevelO,
        funcParameters,nval,embeddings);
    

}


#define RETURN1(id,x) return returning1(dbg, id, addFactorPart(x), n, *this)
#define RETURN1X(id,x) return returning1(dbg, id, x, n, *this)


const Ordinal & AdmisNormalElement::leUse(const Int n) const
{
    return loUseLe(indexCK.limitElement(n));
}

const Ordinal & AdmisNormalElement::loUse(const OrdinalImpl& ord) const
{
    return loUseLe(indexCK.limitOrd(ord));
    
}

const Ordinal & AdmisNormalElement::loUseLe(const OrdinalImpl& leIn) const
{
    bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::limit,0) ;

    int cmp = 0 ;
    int ix = 1 ;
    const OrdinalImpl& embedIx = embeddings.embedIndex.getImpl() ;
    const CantorNormalElement * ixLastTerm = indexCK.getLastTerm();
    
    if (dbg) outStream() << "loUse:leIn: (" << indexCK.normalForm() << ").lo = "
        << leIn.normalForm() << "\n" ;
    const CantorNormalElement * leFirstTerm = leIn.getFirstTerm();
    assert(leFirstTerm);


    const NormalFormTerm * embedTail = embedIx.terms ;
    const NormalFormTerm * leTailCheck = leIn.terms ;
    while (embedTail && leTailCheck && leTailCheck->next) {
        int cmp = embedTail->term.compare(leTailCheck->term) ;
        if (cmp > 0) break ;
        if (cmp == 0) leTailCheck = leTailCheck->next ;
        if (dbg) outStream() << "skipping embed " <<
            embedTail->term.normalForm() << "\n" ;
        embedTail= embedTail->next ;
    }
    NormalFormTerm * tail = NULL ;
    const NormalFormTerm * leTail = leIn.terms ;
    

    while (true) {
        const CantorNormalElement * newTerm = NULL ;
        if (embedTail && leTail) {
            int cmp = embedTail->term.compare(leTail->term,true);
            if (!cmp) {
                Int useFactor = 0 ;
                if (leTail->next==NULL) useFactor =
                    embedTail->term.factor + leTail->term.factor;
                else useFactor = (embedTail->term.factor > leTail->term.factor) ?
                    (embedTail->term.factor) : (leTail->term.factor) ;
                newTerm = new CantorNormalElement(
                    embedTail->term.exponent,useFactor);
                embedTail = embedTail->next ;
                leTail = leTail->next ;
            } else if (cmp < 0) {
                newTerm = &(leTail->term);
                leTail = leTail->next ;
            } else { 
                newTerm = &(embedTail->term);
                embedTail = embedTail->next ;
            }
        } else if (embedTail) {
            newTerm =  &(embedTail->term);
            embedTail = embedTail->next ;
        } else if (leTail) {
            newTerm = &(leTail->term);
            leTail = leTail->next ;
        } else break ;
        if (!newTerm) break ;
        if (dbg) outStream() << "Adding cmp = " << cmp << ", added trm = " <<
            newTerm->normalForm() << "\n" ;
        if (!tail) tail = new NormalFormTerm(*newTerm);
        else tail->append(*newTerm);
    } 
    assert(tail);
    const OrdinalImpl *ret = new OrdinalImpl("loUse",*tail);
    if (dbg) outStream() << "loUsele(" << leIn.normalForm() << ") = "
        << ret->normalForm() << ", indexCK = " << indexCK.normalForm()
        << ", embedIx = " << embeddings.embedIndex.normalForm() << "\n" ;
    return * new Ordinal(*ret);
}

const OrdinalImpl& AdmisNormalElement::drillDownLimitElement(Int n) const 
{
    bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::limit,0);

    assert(!size && functionLevel.isZero() && !drillDown.isZero());
    
    
    const Ordinal &dd = drillDown ;
    if (dd.isLimit()) {
        assert(getLimitInfo()==drillDownLimit);
        const Ordinal * ddlm = new Ordinal(drillDown.limitElement(n));
        RETURN1("DDL", admisLevelFunctional(indexCKo,Ordinal::zero, NULL,
            *ddlm, embeddings).getImpl());
    }
    assert(dd.isSuccessor());
    assert(getLimitInfo()==drillDownSucc);

    if (dd.isOne()) {
        
        const Ordinal & ixMo = *new Ordinal(indexCK.subtract(1));
        if (ixMo.isZero()) {
            const Ordinal * base = &Ordinal::omega ;
            for (int i = 1 ; i < n ; i++)
                base = &(iterativeFunctional(base->limPlus_1(),NULL));
            RETURN1("DDKO",base->getImpl());
        }
        const Ordinal* base = &(admisLevelFunctional(ixMo,Ordinal::zero,
            NULL,Ordinal::zero, embeddings));
        
        for (int i = 1 ; i < n ; i++)base=&(admisLevelFunctional(ixMo,
            base->limPlus_1(),NULL,Ordinal::zero,embeddings));
        RETURN1("DDO",base->getImpl());
    }
    const Ordinal& ddMo = * new Ordinal((dd.getImpl().subtract(1)));
    const Ordinal * base = new Ordinal(dRep1(ddMo));
    if (indexCK.isOne()) {
        for (int i = 1 ; i < n ; i++) base =
            &(iterativeFunctional(base->limPlus_1(),NULL));
        RETURN1("DDGA",base->getImpl());
    }
    const Ordinal & ixMo = *new Ordinal(indexCK.subtract(1));
    for (int i = 1 ; i < n ; i++) base = &(admisLevelFunctional(ixMo,
        base->limPlus_1(),NULL,Ordinal::zero,embeddings));
    RETURN1("DDGB",base->getImpl());
}


const OrdinalImpl& AdmisNormalElement::embedLimitElement(Int n) const 
{
    bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::limit,0) ;
    assert(embeddings.type == Embeddings::paramRestrict) ;
    assert((size==0) && functionLevel.isZero() );
    assert(drillDown.isZero());
   if (embeddings.embedIndex.isLimit()) {
        if (indexCK.isLimit()) {
            Embeddings& toEmbed = *new Embeddings(
                embeddings.embedIndex.limitElement(n),
                Embeddings::paramRestrict);
            if (indexCK.compare(embeddings.embedIndex)==0) {
                RETURN1("EDEQ",admisLevelFunctional(
                    indexCKo.limitElement(n),
                    Ordinal::zero,NULL,Ordinal::zero,toEmbed).getImpl());
            } else { 
                const Ordinal& le = indexCKo.limitElement(n);
                const Ordinal * newIxCK = &(leUse(n));
                RETURN1("EDAB",admisLevelFunctional(newIxCK->limPlus_1(),
                    Ordinal::zero,NULL,Ordinal::zero,embeddings).getImpl());
            }
        } else {
            assert(indexCK.isSuccessor());
            RETURN1("EDAC",admisLevelFunctional(indexCKo,zero,NULL,
                * new Ordinal(n),embeddings).getImpl());
        }
        assert(0);
    }
    assert(embeddings.embedIndex.isSuccessor());
    if (indexCK.isLimit()) {
        const Ordinal& ixCkLe = leUse(n) ;
        if (dbg) {
            outStream() << "ixCk.le( leUse(" << n << ")) = " <<
                ixCkLe.normalForm() << "\n" ;
        }
        RETURN1("EDAD",admisLevelFunctional(
            ixCkLe.limPlus_1(), Ordinal::zero,
            NULL,Ordinal::zero, embeddings).getImpl());

    }
    assert(embeddings.embedIndex.isSuccessor());
    const Ordinal * base = NULL ;
    if (embeddings.embedIndex.compare(indexCK)==0) {
        if (indexCK.isOne()) {
            base = &(admisLevelFunctional(indexCKo,Ordinal::zero,NULL,
                Ordinal::omega,Ordinal::zero));
            for (int i = 1 ; i < n ; i++) base = 
                &(admisLevelFunctional(indexCKo,Ordinal::zero,NULL,*base,
                    Ordinal::zero));
            RETURN1("EDEO",base->getImpl());
        }
        RETURN1("EDEE",createVirtualOrdImpl(indexCKo,zero,NULL,
            * new Ordinal(n),embeddings));

    }
    assert(embeddings.embedIndex.compare(indexCK)<0);
    assert(indexCK.isSuccessor());
    const Ordinal& embIxMo = * new Ordinal(
        embeddings.embedIndex.getImpl().subtract(1));
    const Ordinal& ixCKmo = *new Ordinal(indexCK.subtract(1));
    if (embIxMo.isZero()) {
            assert(!ixCKmo.isZero());
            base = &(admisLevelFunctional(ixCKmo,
                Ordinal::zero,NULL,Ordinal::zero,Ordinal::one));
        for (int i = 1 ; i < n ; i++) base = &(admisLevelFunctional(ixCKmo,
            base->limPlus_1(),NULL,Ordinal::zero,Ordinal::one));
        RETURN1("EDEF",base->getImpl());

    }
    RETURN1("EDEG",admisLevelFunctional(indexCKo,zero,NULL,
                * new Ordinal(n),embeddings).getImpl());
    assert(0);
}



const OrdinalImpl& AdmisNormalElement::limitElement(Int n) const 
{
    bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::limit,0) ;
    
    if (dbg) outStream() << "Entering Admis " <<
        normalForm() << ".limitElement(" << n << ")\n" ;

    int leastNz = size -1 ;
    if (!drillDown.isZero()) RETURN1X("DDA",drillDownLimitElement(n));
    
    if (funcParameters) while ((leastNz >= 0) &&
            funcParameters[leastNz]->isZero()) leastNz--;
    if (leastNz >= 0) {
        if (funcParameters[leastNz]->isLimit())  {
            assert(drillDown.isZero());
            assert(getLimitInfo()==paramLimit);
            RETURN1("LA",replace1(leastNz, funcParameters[leastNz]->
                limitElement(n).limPlus_1()));
        }
    } else if (functionLevel.isLimit()) {
        assert(drillDown.isZero());
        assert(getLimitInfo()==iterLimit);
        RETURN1("LB",admisLevelFunctional(indexCKo,
            functionLevelO.limitElement(n).limPlus_1(),NULL,Ordinal::zero,
            embeddings).getImpl());
    } else if (functionLevel.isZero() && indexCK.isLimit()) {
        
        if (embeddings.type == Embeddings::paramRestrict) 
            RETURN1X("EDDC",embedLimitElement(n));
        assert(getLimitInfo()==indexCKlimit);
        RETURN1("LC",admisLevelFunctional(
            indexCKo.limitElement(n).limPlus_1(),Ordinal::zero,NULL,
            Ordinal::zero, embeddings).getImpl());
    }

    assert(n>0);
    assert(codeLevel == admisCodeLevel) ;
    if (functionLevel.isZero() && size ==1) {
        const Ordinal& leastNzOrd = *(funcParameters[leastNz]) ;
        assert(leastNzOrd.isSuccessor());
        Ordinal& leastNzMo =
            * new Ordinal(leastNzOrd.getImpl().subtract(1));
        if (indexCK.isLimit()) {
            assert(getLimitInfo()==indexCKlimitParam);
            const Ordinal** params = NULL ;
            if (!leastNzMo.isZero()) {
               int nint ;
               params = createParamArray(1,nint);
            }
            const Ordinal *ixckle = new Ordinal(indexCK.limitElement(n));
            if (indexCK.compare(embeddings.embedIndex.getImpl())==0) {
               if (params) params[0] =
                    &(leastNzMo.limitMaxEmbed(ixckle->getImpl()));
                const Embeddings& newEmbed = * new Embeddings(*ixckle,
                    Embeddings::paramRestrict);
                const Ordinal &fl = admisLevelFunctional(indexCKo,Ordinal::zero,
                    params,Ordinal::zero);
                const OrdinalImpl &ret = admisLevelFunctional(*ixckle,
                   fl.limPlus_1(), NULL,Ordinal::zero,newEmbed).getImpl();
                RETURN1("CLLM",ret);

            }
            if (dbg) outStream() << "ixckle = " << ixckle->normalForm() <<
                ", embIx = " << embeddings.embedIndex.normalForm() << "\n" ;
            
            ixckle = &(leUse(n));
            if (params) params[0] = &leastNzMo;
            if (dbg) outStream() << "ixckle = " << ixckle->normalForm()<<"\n";
            const Ordinal &fl = admisLevelFunctional(indexCKo,Ordinal::zero,
                params,Ordinal::zero,embeddings);
            const OrdinalImpl &ret = admisLevelFunctional(*ixckle,
                fl.limPlus_1(), NULL,Ordinal::zero,embeddings).getImpl();
             RETURN1("CKLM",ret);
        } else {
            assert(indexCK.isSuccessor());
            assert(getLimitInfo()==indexCKsuccParam);
            Ordinal& ixckMo = * new Ordinal(indexCK.subtract(1));
            const OrdinalImpl * base =
                &(replace1(leastNz,leastNzMo).limPlus_1());
            if (!ixckMo.isZero()) base=
                &(base->limitMaxEmbed(ixckMo.getImpl()).getImpl()) ;
            const AdmisNormalElement *baseElt = (const AdmisNormalElement *)
                base->getFirstTerm();
            const Embeddings * embed = &embeddings;
            if (embeddings.type == Embeddings::paramRestrict
                && indexCK.compare(embeddings.embedIndex)==0) {
                    embed = new Embeddings(ixckMo,Embeddings::paramRestrict);
            }

            const Ordinal * const * params = baseElt->funcParameters;
            for (int i = 0 ; i < n ; i++) {
                base = &(admisLevelFunctional(ixckMo,
                    (* new Ordinal(*base)).limPlus_1(),params,Ordinal::zero,
                    *embed).getImpl());
            }
             RETURN1("CKSC", *base);
        }
     }
    if (leastNz >= 0 || functionLevel.isSuccessor()) {
        assert((size>1)|| !functionLevel.isZero());
        const OrdinalImpl& ret = IterFuncNormalElement::limitElementCom(n);
        RETURN1("KA", ret);
    }
    
    assert(functionLevel.isZero()) ;
    assert(indexCK.isSuccessor());
    assert(getLimitInfo()==indexCKsucc);
    if (embeddings.type == Embeddings::paramRestrict) RETURN1X
          ("KEA",embedLimitElement(n));
     RETURN1("KE",createOrdinal(addParam(* new Ordinal(n))));
}

const CantorNormalElement & AdmisNormalElement::addFactors(
    const CantorNormalElement& toAdd) const 
{
    if (codeLevel < admisCodeLevel) return
        IterFuncNormalElement::addFactors(toAdd);
    return * new AdmisNormalElement(indexCKo,functionLevelO,
        funcParameters,drillDown,embeddings,factor+toAdd.factor);
}

static int returning(bool dbg, const char *id, int r, 
    const AdmisNormalElement& op1, const CantorNormalElement &op2,
    bool ignoreFactor, const Embeddings& embed, const Embeddings& termEmbed) 

{
    op1.entryDec();
    if (dbg) {
        outDbgStream() << "Admis elt compare returning at " << id <<
            ", val = "
            << r << ", cmp(" << op1.normalForm() << " ::\n" << op2.normalForm()
            << "), ignf = " << ignoreFactor << "\nemb = " <<
            embed.embedIndex.normalForm() << ":" <<
            embed.type << ", trm.emb = " << termEmbed.embedIndex.normalForm()
            << ":" << termEmbed.type << "\n" ;
    } else if (Validate::outCmpExit() && (op1.entryCount <2))
        outDbgStream() << "Admis cmp ex " << id << ", " <<op1.entryCount<<"\n";
    assert(op1.entryCount > -1);
    

    return r;
}

#define RETURN2(id,x) return returning(dbg, id, x, *this, trm, ignoreFactor,\
    embed,termEmbed)


int AdmisNormalElement::compare(const CantorNormalElement& trm,
    bool ignoreFactor ) const
{
    bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::compare,0) ;
    if (dbg) {
        outDbgStream() << "Admis elt compare entry(" <<
            normalForm() << " : " << trm.normalForm() << ", " <<
                ignoreFactor << ")\n"  ;
    }

    assert(codeLevel==admisCodeLevel) ;
    const Embeddings * trmEmbed = &(Embeddings::embedNone);
    if (trm.codeLevel >= admisCodeLevel) {
        const AdmisNormalElement & elt = (const AdmisNormalElement &) trm ;
       trmEmbed = &(elt.embeddings);
    }
    return compare(embeddings, *trmEmbed,trm,
        ignoreFactor);
}


const Embeddings & AdmisNormalElement::effectiveEmbedding(
    const Embeddings& termEmbed) const
{
    if (embeddings.type == Embeddings::paramRestrict) {
        assert(!embeddings.embedIndex.isZero());
        if (!termEmbed.type == Embeddings::paramRestrict) return embeddings;
        assert(!termEmbed.embedIndex.isZero()) ;
        if (embeddings.embedIndex.compare(termEmbed.embedIndex) < 0)
              return embeddings ; else return termEmbed ;
    }
    if (termEmbed.type == Embeddings::paramRestrict) return termEmbed ;
    return Embeddings::embedNone ;
}

const OrdinalImpl& AdmisNormalElement::effectiveIndexCK(
    const Embeddings& embed) const
{
    bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::compare,0) ;
    DBGO "emb.isPaRe = " << embed.isParamRestrict() <<
            ", ddz = " << drillDown.isZero() << "\nixCK = " <<
            indexCK.normalForm() <<
            ", ixCKmo  = " << indexCKmo.normalForm() << ", eIx = " << 
             embed.embedIndexMo.getImpl().normalForm() << "\n" ;
    if (!embed.isParamRestrict()) {
        if (drillDown.isZero()) return indexCK ; else return indexCKmo ;
    }
    if (indexCK.compare(embed.embedIndex)<0) return indexCK ;
    return embed.embedIndexMo.getImpl();
}


const OrdinalImpl&AdmisNormalElement::kappaLim(const OrdinalImpl& effEmbIx)const
{
    if (indexCK.compare(effEmbIx)<0) return indexCK; else return effEmbIx;
}


int AdmisNormalElement::compare(const Embeddings& embed,
    const Embeddings& termEmbed, const CantorNormalElement& trm,
    bool ignoreFactor) const 
{
    entryInc();
    bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::compare,0) ;
    
    DBGO "Admis elt compare(" <<  normalForm() << ", " 
            << trm.normalForm() << ")\n" ;
    DBGO "emb = " << embed.embedIndex.normalForm() << ":" <<
            embed.type << ", trm.emb = " << termEmbed.embedIndex.normalForm()
            << ":" << termEmbed.type << "\n" ;
    assert(codeLevel == admisCodeLevel);
    const Embeddings& effEmbed = effectiveEmbedding(embed);
    if (trm.codeLevel < admisCodeLevel) {
        DBGO trm.getMaxParameter().normalForm() <<
            "  " << trm.normalForm() <<  "  " << normalForm() <<
            " mxc from trm this\n";
        const OrdinalImpl&  trmMaxParam = trm.getMaxParameter();
        if (trmMaxParam.isZero()) RETURN2("A2",1);
        const CantorNormalElement * maxParamFirstTerm =
            trmMaxParam.getFirstTerm();
        if (maxParamFirstTerm) {
            DBGO "A3 exit compares " << normalForm()
                << " :: " << maxParamFirstTerm->normalForm() << "\n" ;
            if (compare(effEmbed,termEmbed, *maxParamFirstTerm,true) <=0)
                RETURN2("A3", -1) ;
        }
        RETURN2("A4",1); 
    } 

    assert(trm.codeLevel == admisCodeLevel);
    const AdmisNormalElement& ftrm = (const AdmisNormalElement&) trm;
    const Embeddings& termEffEmbed= ftrm.effectiveEmbedding(termEmbed);

    int diff = parameterCompare(effEmbed,termEffEmbed,trm);
    if (diff) DBGO "maxParam = " << getMaxParameter().normalForm() << 
        ",\n term.maxParam = " << trm.getMaxParameter().normalForm() << "\n" ;
    if (diff) RETURN2("A5",diff);

    if (trm.codeLevel > admisCodeLevel)
        RETURN2("A1", -ftrm.compare(termEffEmbed,effEmbed,*this));

    if (effEmbed.isParamRestrict()  && (termEffEmbed.isParamRestrict())) {
        if ((effEmbed.embedIndex.compare(indexCK)<=0) &&
        (termEffEmbed.embedIndex.compare(ftrm.indexCK)<=0))
        diff = effEmbed.embedIndex.getImpl().compare(
            termEffEmbed.embedIndex.getImpl()) ;
        if (diff) RETURN2("B",diff);
    }

    const OrdinalImpl& effIndexCk = effectiveIndexCK(effEmbed);
    const OrdinalImpl& termEffIndexCK =
        ftrm.effectiveIndexCK(termEffEmbed);

    DBGO "effIxCK = " << effIndexCk.normalForm() <<
        "\nterm effIxCK = " << termEffIndexCK.normalForm() << "\n" ;

    diff = effIndexCk.compare(termEffIndexCK) ;
    if (diff) RETURN2("B1",diff);
    diff = indexCK.compare(effEmbed,termEffEmbed,ftrm.indexCK);
    if (diff) DBGO "ixCk = " << indexCK.normalForm() << ", trmIxCk = "
        << ftrm.indexCK.normalForm() << ", effEmb "
        << effEmbed.normalForm() << ", termeffEmb " <<
        termEffEmbed.normalForm() << "\n" ;
        
    if (diff) RETURN2("B1A",diff);
    if (!drillDown.isZero()) {
        if (!ftrm.drillDown.isZero()) {
            int diff = drillDown.compare(ftrm.drillDown.getImpl());
            if (diff) RETURN2("B2", diff) ;
        } else RETURN2("B3", -1) ; 
    } else if (!ftrm.drillDown.isZero())  RETURN2("B4",1); 

    diff = functionLevel.compare(embed,termEmbed,
        ftrm.functionLevel) ;
     if (diff) RETURN2("A6",diff);

    diff = compareFiniteParams(embed,termEmbed,ftrm);
    if (diff) RETURN2("R",diff);
    if (!ignoreFactor) diff = cmp(factor,ftrm.factor) ;
    RETURN2("S", diff) ;

}

static void fixReturn(const char * id, bool ret)
{
    outStream() << "fpr ret " << ret << " at " << id << "\n" ;
}

#define FRETURN(id,ret) {if (dbg) fixReturn(id,ret); return ret;}

bool AdmisLevOrdinal::fixedPoint(const OrdinalImpl& ixCK, const Ordinal& iter,
    int ix, const Ordinal* const * const params, const Embeddings& emb)
{
    bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::ctrOrd) ;
    if (ixCK.isZero()) FRETURN("FA",
        IterFuncOrdinal::fixedPoint(iter,ix,params));
    if (ix == indexCKmaxParam) FRETURN("FB", false);
    if (ix == iterMaxParam)  {
        if (iter.getImpl().psuedoCodeLevel() < 
            AdmisNormalElement::admisCodeLevel) FRETURN("FC",false) ;
        FRETURN("FC", AdmisLevOrdinalImpl (*new Ordinal(ixCK),
            Ordinal::zero).compare(emb,emb,iter.getImpl()) < 0);
    }
    if (params[ix]->getImpl().psuedoCodeLevel() <
        AdmisNormalElement::admisCodeLevel) FRETURN("FE", false) ;
    if (ix == 0) FRETURN("FF",
        AdmisLevOrdinalImpl(ixCK,iter,NULL).compare(emb,emb,
        params[0]->getImpl()) < 0);
    int size = 0 ;
    for (;params[size];size++);
    const Ordinal** nParams = new const Ordinal *[size+1] ;
    nParams[size]=0;
    assert(ix<size);
    for (int i = 0 ; i < ix;i++) nParams[i] = params[i] ;
    for (int i = ix ; i < size ; i++) nParams[i] = &(Ordinal::zero) ;
    FRETURN("FG", AdmisLevOrdinalImpl(ixCK,iter,nParams).compare(emb,emb,
        (params[ix]->getImpl())) < 0);
}



const NormalFormTerm& AdmisLevOrdinalImpl::createTerms(
    const Ordinal& indexCK, const Ordinal& iter,
    const Ordinal* const * const params,const Ordinal& dd,
    const Embeddings& embed)
{
    const AdmisNormalElement& elt = * new AdmisNormalElement(indexCK, iter,
        params,dd,embed) ;
    return * new NormalFormTerm(elt) ;

}

const OrdinalImpl & AdmisLevOrdinalImpl::addEmbeddings(
    const Embeddings& emb) const
{
    assert(terms) ;
    const CantorNormalElement& firstTerm = terms->term ;
    assert (firstTerm.codeLevel == AdmisNormalElement::admisCodeLevel); 
    const AdmisNormalElement &adm = (const AdmisNormalElement&) firstTerm ;
    const AdmisNormalElement &admOut = adm.addEmbeddings(emb);
    const NormalFormTerm * out = new NormalFormTerm(admOut);
    const NormalFormTerm * next = terms->next ;
    while (next) {
        out->append((next)->term) ;
        next = next->next ;
    }
    return * new AdmisLevOrdinalImpl(normalForm(),*out);
}



const AdmisLevOrdinal* AdmisLevOrdinalImpl::getAdmissibleBase() const
{
    const CantorNormalElement * frst = getFirstTerm();
    if (!frst) return NULL;
    if (frst->codeLevel < AdmisNormalElement::admisCodeLevel) return NULL ;
    const AdmisNormalElement & elt = (AdmisNormalElement&)*frst ;
    return &(elt.getAdmissibleBase());
}


string AdmisLevOrdinalImpl::makeName(const Ordinal& ixCK,
    const Ordinal& iter, const Ordinal* const * const params,
    const Ordinal &drillDown, const Embeddings& embed)
{
    if (ixCK.isZero()) return IterFuncOrdinalImpl::makeName(iter,params);
    int count = 0 ;
    if (params) for (;params[count];count++) ;
    string base = "" ;
    if (embed.type == Embeddings::paramRestrict) {
        base += "[[" ;
        assert(!embed.embedIndex.isZero());
        base += embed.embedIndex.normalForm();
        base += "]]" ;
    }
    base += "omega_{ " ;
    base += ixCK.normalForm();
    if (!iter.isZero()) {
        base += ", " ;
        base += iter.normalForm() ;
    }
    base += "}" ;
    if (count) {
        base += "(" ;
        for (int i = 0 ; i < count; i++) {
            if (i) base += ", " ;
            base += params[i]->normalForm() ;
        }
        base += ")" ;
    }
    if (!drillDown.isZero()) {
        base += "[ " ;
        base += drillDown.normalForm() ;
        base += "]" ;
    }
    return base ;
}

string AdmisLevOrdinalImpl::makeTexName(const Ordinal& ixCK,
    const Ordinal& iter, const Ordinal* const * const params,
    const Ordinal &drillDown, const Embeddings& embed)
{
    if (ixCK.isZero()) return IterFuncOrdinalImpl::makeTexName(iter,params);
    int count = 0 ;
    if (params) for (;params[count];count++) ;
    string base = "" ;
    if (embed.type == Embeddings::paramRestrict) {
        base += "[[" ;
        assert(!embed.embedIndex.isZero());
        base += embed.embedIndex.texNormalForm();
        base += "]]" ;
    }
    base += "{\\omega_{" ;
    base += ixCK.texNormalForm();
    if (!iter.isZero()) {
        base += ", ";
        base += iter.texNormalForm() ;
    }
    base += "}}" ;
    if (count) {
        base += "(" ;
        for (int i = 0 ; i < count; i++) {
            if (i) base += ", " ;
            base += params[i]->texNormalForm() ;
        }
        base += ")" ;
    }
    if (!drillDown.isZero()) {
        base += "[" ;
        base += drillDown.texNormalForm() ;
        base += "]" ;
    }

    return base ;
}

const AdmisNormalElement * AdmisLevOrdinalImpl::getFirstAdmis() const
{
    const CantorNormalElement * frst = getFirstTerm();
    if (frst == NULL) return NULL ;
    if (frst->codeLevel < AdmisNormalElement::admisCodeLevel)
        return NULL ;
    return (AdmisNormalElement*) frst ;

}

const OrdinalImpl& AdmisLevOrdinalImpl::getIndexCK() const
{
    const AdmisNormalElement *elt = getFirstAdmis();
    assert(elt);
    return elt->getIndexCK();
}









static void admisExamp()
{
    string tname = "tabAdmisCppExamp" ;
    string fname = tname;
    fname += ".tex" ;
    ofstream outStream(fname.c_str());
    OutStream::streamManager.push(outStream);

#define CPP_EXAMP(str) outStream << "{\\tt " << "\\verb#" << #str <<"#" \
    << "}&$" << (str).texNormalForm()  << "$\\\\  \n"

#define cp createParameters    
#define af admisLevelFunctional

    outStream << "\\begin{table}\\centering\n" ;
    outStream << "\\begin{tabular}{|l|l|}\\hline\n" ;

    outStream << "\\multicolumn{2}{|c|}{`{\\tt cp}' stands for " <<
        " {\\tt createParameters} and `{\\tt af}' stands for " <<
        "{\\tt admisLevelFunctional}}\\\\ \\hline \\hline \n" ;
    outStream <<
        "{\\bf \\Cpp{} code examples} & {\\bf Ordinal}\\\\ \\hline \\hline\n" ;
    CPP_EXAMP(af(zero,zero,cp(&one)));
    CPP_EXAMP(af(zero,one,cp(&one,&zero)));
    CPP_EXAMP(af(one,zero,cp(&one,&one,&zero)));
    CPP_EXAMP(af(one,zero));
    CPP_EXAMP(af(one,zero,NULL,eps0));
    CPP_EXAMP(af(one,zero,NULL,Ordinal::five));
    CPP_EXAMP(af(one,omega1CK,cp(&one)));
    CPP_EXAMP(af(one,one,cp(&one,&omega1CK)));
    CPP_EXAMP(af(one,Ordinal::two,
        cp(&one,&omega,&zero)));
    CPP_EXAMP(af(omega,omega,cp(&one,&omega1CK,&zero,&zero)));
    CPP_EXAMP(af(omega1CK,omega));
    CPP_EXAMP(af(one,omega,cp(&iterativeFunctional(omega))));
    CPP_EXAMP(af(af(one,zero)+1,zero,NULL,omega));
    CPP_EXAMP(af(Ordinal::two,zero,NULL,zero,Ordinal::two));
    CPP_EXAMP(af(Ordinal::omega,zero,NULL,zero,Ordinal::three));
    CPP_EXAMP(af(omega,zero,NULL,zero,omega));
    CPP_EXAMP(af(Ordinal::two,omega1CK,cp(&one),zero,Ordinal::two));
    CPP_EXAMP(af(omega,omega,cp(&one,&omega1CK,&zero),zero,one));
    

    outStream << "\\hline\n" ;
    outStream << "\\end{tabular}\n" ;
    outStream<<"\\caption{{\\tt admisLevelFunctional} \\Cpp{} code examples}\n";
    outStream << "\\mindex{{\\tt admisLevelFunctional} C{\\tt ++} examples}\n" ;
    outStream <<
        "\\mindex{examples {\\tt admisLevelFunctional} C{\\tt ++} code}\n" ;
    outStream << "\\label{TabAdmisLevOrdinalCppExamp}\n" ;
    outStream << "\\end{table}\n\n" ;

    OutStream::streamManager.pop();
#undef af
#undef cp
#undef CPP_EXAMP
}

static void admisLimitEle()
{
    const Int indicies[] = {1,2,3,-1};
    
    const Ordinal expI=(admisLevelFunctional(one,one)^(admisLevelFunctional(one,one)+1));

    const Ordinal & omega1CKp1 = omega1CK+1 ;
    const Ordinal & o1ckt4 = omega1CK*4 ;
    const Ordinal & o1cksq = omega1CK*omega1CK ;
    const Ordinal & bg1 = admisLevelFunctional(eps0,omega);
    const Ordinal & off1 = omega1CK*omega ;
    const Ordinal & sum1 = bg1 + off1 ;
    const Ordinal & w1xw = omega1CK*omega ;
    const Ordinal & w1x2 = omega1CK*Ordinal::two ;
    const Ordinal & w2dd = admisLevelFunctional(Ordinal::two,zero,NULL,
        omega1CK);
    const Ordinal & wxx = admisLevelFunctional(Ordinal::two,zero,NULL,
        w2dd);
    const Ordinal* ordAry [] = {
        
        
        &admisLevelFunctional(omega,zero),
        &omega1CK,
        &finiteFunctional(omega1CK,one,zero,zero),
        &finiteFunctional(createParameters(&omega1CKp1,&one)),
        &admisLevelFunctional(one,zero,NULL,Ordinal::one),
        &admisLevelFunctional(one,zero,NULL,Ordinal::two),
        &admisLevelFunctional(one,zero,NULL,Ordinal::omega),
        &admisLevelFunctional(Ordinal::two,zero,NULL,omega1CK),
        & w2dd,
        & wxx ,
        &o1ckt4,
        &o1cksq,
        &admisLevelFunctional(one,zero,createParameters(&one)),
        
        
        &admisLevelFunctional(one,zero,createParameters(&one,&one)),
        
        &admisLevelFunctional(one,zero,createParameters(&one,&zero,&one)),
        
        &admisLevelFunctional(one,zero,createParameters(&one,&one,&zero)),
        
         &admisLevelFunctional(one,zero,createParameters(&eps0, &zero)),
         
         
         
         &admisLevelFunctional(one,zero,createParameters(&eps0, &one, &zero)),
         
         
         &admisLevelFunctional(one,zero,createParameters(&eps0, &one)),
         
         
         
        
         
         
         
         
        
         
        0
    };

    Ordinal::limitElementTable(ordAry,indicies,"AdmisLevOrdinal",
        1,"\\small");
    Ordinal::limitTypeTable(ordAry,"AdmisLevOrdinal", 1,NULL);

}

static void admisLimitEle2()
{
    const Int indicies[] = {1,2,3,-1};
    

    const Ordinal* ordAry [] = {
        
        &admisLevelFunctional(one,one,createParameters(&one)),
        &admisLevelFunctional(Ordinal::two,one,createParameters(&one)),
        
        &admisLevelFunctional(one,Ordinal::three,createParameters(&one)),
        
        &admisLevelFunctional(one,Ordinal::three,
            createParameters(&Ordinal::five)),
        
        &admisLevelFunctional(one,one,createParameters(&one,&zero)),
        
        &admisLevelFunctional(one,Ordinal::three,createParameters(&one,&zero)),
        
        &admisLevelFunctional(one,Ordinal::three,
            createParameters(&Ordinal::five,&zero)),
        
        &admisLevelFunctional(one,one,createParameters(&one,&zero,&zero)),
        
        &admisLevelFunctional(one,Ordinal::three,
            createParameters(&one,&zero,&zero)),
        
        &admisLevelFunctional(one,Ordinal::three,
            createParameters(&Ordinal::two,&zero,&zero)),
        
        &admisLevelFunctional(one,eps0,createParameters(&one)),
        
        &admisLevelFunctional(one,eps0+one,createParameters(&one)),
        
        &admisLevelFunctional(one,eps0+omega,createParameters(&Ordinal::three)),
        
        &admisLevelFunctional(one,one,createParameters(&one)),
        
        &admisLevelFunctional(one,eps0,createParameters(&one)),
        &admisLevelFunctional(one,eps0+omega,createParameters(&one)),
        
        &admisLevelFunctional(one,eps0,createParameters(&Ordinal::five)),
        
        &admisLevelFunctional(one,eps0+Ordinal::one,
            createParameters(&Ordinal::five)),
        
        &admisLevelFunctional(one,eps0,createParameters(&Ordinal::five)),
        
        &admisLevelFunctional(one,zero,createParameters(&one,&one)),
        
        &admisLevelFunctional(one,zero,createParameters(&Ordinal::two)),
        
        &admisLevelFunctional(one,one),
        &admisLevelFunctional(one,one,createParameters(&one)),
        &admisLevelFunctional(one,Ordinal::three),
        &admisLevelFunctional(one,one,createParameters(&omega,&one)),
        
        &admisLevelFunctional(one,omega,createParameters(&one)),
        

        0
    };

    Ordinal::limitElementTable(ordAry,indicies,"AdmisLevOrdinal",
        2,"\\footnotesize");
    

}



static void admisLimitEle3()
{
    const Int indicies[] = {1,2,3,-1};
        const Ordinal & omega1CKp1 = omega1CK+1 ;
    const Ordinal & o1ckt4 = omega1CK*4 ;
    const Ordinal & o1cksq = omega1CK*omega1CK ;
    const Ordinal & bg1 = admisLevelFunctional(eps0,omega);
    const Ordinal & off1 = omega1CK*omega ;
    const Ordinal & sum1 = bg1 + off1 ;
    const Ordinal & w1xw = omega1CK*omega ;
    const Ordinal & w1x2 = omega1CK*Ordinal::two ;
    const Ordinal* ordAry [] = {
        &w1xw,
        &w1x2,
        &admisLevelFunctional(eps0,zero,createParameters(&one)),
        &admisLevelFunctional(eps0,zero,createParameters(&Ordinal::two)),
        
        &admisLevelFunctional(eps0,zero,createParameters(&Ordinal::omega)),
        
        &admisLevelFunctional(eps0+one,zero,createParameters(&one)),
        &sum1,
        &admisLevelFunctional(one,omega,createParameters(&one)),
        &admisLevelFunctional(one,omega,createParameters(&Ordinal::omega)),
        
        &admisLevelFunctional(one,Ordinal::two,createParameters(&eps0)),
        
        &admisLevelFunctional(one,one,createParameters(&Ordinal::two)),
        &admisLevelFunctional(one,one,createParameters(&eps0)),
        &admisLevelFunctional(one,one,createParameters(&one,&zero,&zero)),
        &admisLevelFunctional(one,Ordinal::three,createParameters(&one,&zero,&zero)),
        &admisLevelFunctional(one,one,createParameters(&omega,&one)),
        &admisLevelFunctional(one,one,createParameters(&omega,&one,&zero)),
        &admisLevelFunctional(one,eps0),
        
        

        &admisLevelFunctional(one,finiteFunctional(one,zero,zero),
            createParameters(&one,&zero)),
        &admisLevelFunctional(one,finiteFunctional(one,zero,zero),
            createParameters(&eps0)),
        &admisLevelFunctional(one,finiteFunctional(one,zero,zero),
            createParameters(&eps0,&zero)),
        &admisLevelFunctional(one,finiteFunctional(one,zero,zero),
            createParameters(&eps0,&one)),
         &admisLevelFunctional(one,finiteFunctional(one,zero,zero),
            createParameters(&eps0,&one,&one)),
        &admisLevelFunctional(one,one),
        
        
        &admisLevelFunctional(one,Ordinal::three),
        
        &admisLevelFunctional(one,Ordinal::four,NULL),
        

        



        0
    };

    Ordinal::limitElementTable(ordAry,indicies,"AdmisLevOrdinal",3,
        "\\small");
    Ordinal::limitTypeTable(ordAry,"AdmisLevOrdinal",2, NULL);

}

static void admisLimitOrd()
{
    const Ordinal * const indicies[] = {
        &omega,&eps0,&omega1CK,
        
        NULL};
    
    const Ordinal expI=(admisLevelFunctional(one,one)^(admisLevelFunctional(one,one)+1));

    const Ordinal & bga = admisLevelFunctional(omega1CK+Ordinal::one,zero) ;
    const Ordinal & bge = admisLevelFunctional(omega^omega,bga) ;
    const Ordinal & bgw = admisLevelFunctional(100,zero);
    const Ordinal & o1ckt4 = omega1CK*4 ;
    const Ordinal & o1cksq = omega1CK*omega1CK ;
    const Ordinal & bg1 = admisLevelFunctional(eps0,omega);
    const Ordinal & off1 = omega1CK*omega ;
    const Ordinal & sum1 = bg1 + off1 ;
    const Ordinal & omega4 = omega*4 ;
    const Ordinal* ordAry [] = {
        &omega1CK,
        &admisLevelFunctional(Ordinal::two,zero),
        &o1ckt4,
        &o1cksq,
        &admisLevelFunctional(bge,zero,createParameters(&bge)),
        &admisLevelFunctional(omega1CK,zero,createParameters(&Ordinal::two,
            &bga)),
        &admisLevelFunctional(one,omega1CK),
        &admisLevelFunctional(one,bgw),
        &admisLevelFunctional(one,one,createParameters(&omega1CK)),
        &admisLevelFunctional(one,Ordinal::three,createParameters(&omega1CK)),
        &admisLevelFunctional(eps0,zero,createParameters(&omega1CK)),
        &admisLevelFunctional(eps0+one,zero,createParameters(&one)),
        &sum1,
        
        0
    };

    Ordinal::limitOrdTable(ordAry,indicies,"AdmisLevOrdinal");

}



static void admisArithExamp()
{
    const Ordinal&a1 = admisLevelFunctional(one,zero);
    const Ordinal&a3 = a1 + admisLevelFunctional(Ordinal::three,one,
        createParameters(&one,&zero,&one),zero,one);
    const char * cName = "AdmisLevOrdinal" ;
    const Ordinal * const am[] = {
        &a1,
        &admisLevelFunctional(zero,Ordinal::three),
        &a3,
        &admisLevelFunctional(one,omega,createParameters(&omega,&one)),
        &admisLevelFunctional(one,eps0,createParameters(&omega,&one,&zero)),
        &admisLevelFunctional(eps0,zero),


        NULL
    };

    Ordinal::arithExamp(am,cName,Ordinal::multType);

    const Ordinal * const * bm = am ;

    Ordinal::arithExamp(bm,cName,Ordinal::powerType);

}

const static int ddCol = 2 ;
const static int ddOff = 2 ;

static void admisDrillDownLine(const Ordinal& ord, ostream&out)
{
    out << "$" << ord.texNormalForm() << "$\n" ;
    for (int i = 0; i < ddCol ; i++) out << "&$" <<
        ord.limitElement(i+ddOff).texNormalForm() << "$\n" ;
    out << "\\\\ \\hline\n" ;

}

static void admisNestedCollapsingExamp()
{
    string tname = "tabAdmisNestedCollapsingDef" ;
    string fname = tname;
    fname += ".tex" ;
    ofstream outStream(fname.c_str());
    OutStream::streamManager.push(outStream);


    outStream << "\\begin{table}\\centering\\small\n" ;
    outStream << "\\begin{tabular}{|c|";
    for (int i = 0; i < ddCol ; i++) outStream << "c|" ;
    outStream << "}\\hline\n" ;

    outStream << "{\\bf Ordinal }&\\multicolumn{" << ddCol <<
        "}{|c|}{\\bf Limit elements}\\\\ \\hline\n" ;
    for (int i = 0; i < ddCol ; i++) outStream << "& " << (i+ddOff) ;
    outStream << "\\\\ \\hline\n" ;

    const Ordinal& w2CK = admisLevelFunctional(Ordinal::two,zero);
    const Ordinal & tst2 = admisLevelFunctional(Ordinal::two,zero) ;
    const Ordinal& n2 = admisLevelFunctional(Ordinal::three,zero,NULL,w2CK);
    admisDrillDownLine( n2,outStream);
    const Ordinal n1_n2 = admisLevelFunctional(Ordinal::three,zero,NULL,n2);
    admisDrillDownLine(n1_n2,outStream);
    const Ordinal n1_n2_l3=n1_n2.limitElement(3);
    admisDrillDownLine(n1_n2_l3,outStream);
    admisDrillDownLine(n1_n2_l3.limitElement(2),outStream);

    const Ordinal * plist[] = {
        &eps0,
        
        &Ordinal::two,
        NULL
    };

    const Ordinal & cxl2 = admisLevelFunctional(Ordinal::two,eps0,plist,NULL);
    const Ordinal & l2cxl2 = admisLevelFunctional(Ordinal::three,zero,NULL,cxl2);

    admisDrillDownLine(l2cxl2,outStream);

    const Ordinal & l1xx = admisLevelFunctional(Ordinal::three,zero,NULL,
        l2cxl2);

    admisDrillDownLine(l1xx,outStream);

    Ordinal twelve(12);

    const Ordinal& w5CK = admisLevelFunctional(Ordinal::four,zero);
    const Ordinal& w5CKc =admisLevelFunctional(Ordinal::five,zero,NULL,w5CK);
    const Ordinal& w4CKc =admisLevelFunctional(Ordinal::six,zero,NULL,w5CKc);
    const Ordinal& w3CKc =admisLevelFunctional(Ordinal::six,zero,NULL,w4CKc);
    const Ordinal& w2CKc =admisLevelFunctional(Ordinal::six,zero,NULL,w3CKc);
    const Ordinal& w1CKc =admisLevelFunctional(twelve,zero,NULL,w2CKc);

    const Ordinal & bga = admisLevelFunctional(omega1CK,zero);
    const Ordinal &btrm = w2CK+psi(one,omega)+Ordinal::four;
    const Ordinal & bgb = admisLevelFunctional(btrm,zero)+Ordinal::five;

    admisDrillDownLine(w4CKc,outStream);
    admisDrillDownLine(w1CKc,outStream);
    admisDrillDownLine(w1CKc.limitElement(2),outStream);
    admisDrillDownLine(w3CKc.limitOrd(omega),outStream);
   admisDrillDownLine(admisLevelFunctional(bgb,zero,NULL,btrm),outStream);

    const Ordinal * orda, *ordb ;
    const Ordinal & op1 = omega+one ;
    const Ordinal & ep1 = eps0+one ;
    const Ordinal * bases[] = {
        &(admisLevelFunctional(Ordinal::two,zero,NULL,omega1CK)),
        &(admisLevelFunctional(Ordinal::three,zero,NULL,w2CK)),
        &(admisLevelFunctional(omega1CK+one,zero,NULL,op1)),
        &(admisLevelFunctional(omega1CK+one,zero,NULL,ep1)),
        
        
        new Ordinal(orda->limitOrd(omega)),
        new Ordinal(ordb->limitOrd(omega)),
        NULL
    };

    const Ordinal * ordc = NULL ;
    for (const Ordinal * const * b = bases; *b ; b++) {
        const Ordinal & ba = ** b ;
        admisDrillDownLine(ba,outStream);
        admisDrillDownLine(*(ordc=new Ordinal(ba.limitElement(3))),outStream);
        admisDrillDownLine(*new Ordinal(ordc->limitElement(2)),outStream);

    }
    
    outStream << "\\end{tabular}\n" ;
    outStream<<"\\caption{{\\tt AdmisLevOrdinal} nested collapsing examples }\n";
    outStream<<"\\mindex{{\\tt AdmisLevOrdinal} nested collapsing examples }\n";
    outStream<<"\\mindex{nested collapsing examples}\n";
    outStream<<"\\mindex{collapsing examples, nested}\n";
    outStream<<"\\mindex{examples {\\tt AdmisLevOrdinal} nested collapsing}\n";
    outStream << "\\label{TabAdmisLevNestedCollapsingDef}\n" ;
    outStream << "\\end{table}\n\n" ;

    OutStream::streamManager.pop();



}

static void admisDrillDownDefExamp()
{
    string tname = "tabAdmisDrillDownDef" ;
    string fname = tname;
    fname += ".tex" ;
    ofstream outStream(fname.c_str());
    OutStream::streamManager.push(outStream);


    outStream << "\\begin{table}\\centering\\small\n" ;
    outStream << "\\begin{tabular}{|c|";
    for (int i = 0; i < ddCol ; i++) outStream << "c|" ;
    outStream << "}\\hline\n" ;

    outStream << "{\\bf Ordinal }&\\multicolumn{" << ddCol <<
        "}{|c|}{\\bf Limit elements}\\\\ \\hline\n" ;
    for (int i = 0; i < ddCol ; i++) outStream << "& " << (i+ddOff) ;
    outStream << "\\\\ \\hline\n" ;

    const Ordinal &a1 = omega1CK.limitElement(1);
    const Ordinal &a2 = omega1CK.limitElement(2);
    admisDrillDownLine( a1,outStream);
    admisDrillDownLine( a2,outStream);
    const Ordinal & tst2 = admisLevelFunctional(Ordinal::two,zero) ;
    admisDrillDownLine( tst2.limitElement(2),outStream);
    admisDrillDownLine( tst2.limitElement(3),outStream);
    const Ordinal & bga = admisLevelFunctional(omega1CK,zero);
    const Ordinal& w2CK = admisLevelFunctional(Ordinal::two,zero);
    
    const Ordinal &btrm = w2CK+psi(one,omega);
    const Ordinal & bgb = admisLevelFunctional(btrm,zero);
    const Ordinal * bases[] = {
        &(admisLevelFunctional(Ordinal::two,zero,NULL,omega1CK)),
        &(admisLevelFunctional(Ordinal::three,zero,NULL,w2CK)),
        &bgb,
        &btrm,
        
        NULL
    };

    for (const Ordinal * const * b = bases; *b ; b++) {
        const Ordinal & ba = ** b ;
        admisDrillDownLine(ba,outStream);
        admisDrillDownLine(ba.limitElement(2),outStream);
        if (b != bases+2) admisDrillDownLine(ba.limitElement(3),outStream);

    }



      
    outStream << "\\end{tabular}\n" ;
    outStream<<"\\caption{{\\tt AdmisLevOrdinal} collapsing examples }\n";
    outStream<<"\\mindex{{\\tt AdmisLevOrdinal} collapsing examples }\n";
    outStream<<"\\mindex{examples {\\tt AdmisLevOrdinal} collapsing}\n";
    outStream << "\\label{TabAdmisLevDrillDownDef}\n" ;
    outStream << "\\end{table}\n\n" ;

    OutStream::streamManager.pop();
}

static void limitExampLine(const Ordinal &ord, int rule, ostream &out)
{
    out << "$" << ord.texNormalForm() << "$&$"
        << ord.limitType().texNormalForm() << "$&" << rule << "\\\\ \\hline\n" ;
}


static void admisLimitTypeExamp()
{
    const Ordinal & w4 = * new AdmisLevOrdinal(Ordinal::four,zero);
    string tname = "tabAdmisLimitType" ;
    string fname = tname;
    fname += ".tex" ;
    ofstream outStream(fname.c_str());
    OutStream::streamManager.push(outStream);

    outStream << "\\begin{tabular}{|l|r|r|}\\hline\n" ;
    outStream << "\\multicolumn{3}{|c|}{\\bf Examples} \\\\ \\hline\\hline\n";
    outStream <<
    "$\\alpha$ & $\\alpha{\\tt .limitType()}$& Rule \\\\ \\hline\\hline\n";

    const Ordinal& e1 = ord::omega1CK ;
    limitExampLine(e1,1,outStream);

    const Ordinal& e2 = * new AdmisLevOrdinal(Ordinal::two,zero,NULL);
    limitExampLine(e2,1,outStream);

    const Ordinal& e2a = * new AdmisLevOrdinal(Ordinal::two,omega^omega,NULL);
    limitExampLine(e2a,2,outStream);

    const Ordinal& e2b = * new AdmisLevOrdinal(Ordinal::omega,zero,NULL);
    limitExampLine(e2b,2,outStream);

    const Ordinal& tx = * new AdmisLevOrdinal(omega^omega,Ordinal::four,NULL);
    const Ordinal& e2ba = * new AdmisLevOrdinal(tx,zero,NULL);
    limitExampLine(e2ba,2,outStream);

    const Ordinal &r4 = admisLevelFunctional(omega,Ordinal::five,
        createParameters(&Ordinal::three));
    limitExampLine(r4,4,outStream);

    const Ordinal& r5 = admisLevelFunctional(omega,omega1CK,createParameters(
        &Ordinal::four));
    limitExampLine(r5,5,outStream);


    const Ordinal& tx2 = * new AdmisLevOrdinal((omega^omega)+1,Ordinal::five);
    const Ordinal& e2ba2 = * new AdmisLevOrdinal(tx2,Ordinal::five,NULL);
    limitExampLine(e2ba2,3,outStream);

    const Ordinal& e2ba3 = * new AdmisLevOrdinal(w4,zero,createParameters(
        &Ordinal::three));
    limitExampLine(e2ba3,5,outStream);



    const Ordinal &s = omega+Ordinal::five ;
    const Ordinal& e2c = * new AdmisLevOrdinal(s,zero,NULL);
    limitExampLine(e2c,1,outStream);

    const Ordinal& e2d = * new AdmisLevOrdinal(omega,e2c,NULL);
    limitExampLine(e2d,2,outStream);

    const Ordinal &t = * new AdmisLevOrdinal((e1^e1)+Ordinal::six,zero,NULL) ;
    const Ordinal &e3 = * new AdmisLevOrdinal(t,zero,createParameters(
        &Ordinal::three, &Ordinal::five, &t));
    limitExampLine(e3,2,outStream);

    const Ordinal& ckIx = admisLevelFunctional(Ordinal::five,zero);
    const Ordinal& rule3 = admisLevelFunctional(ckIx,Ordinal::three);
    limitExampLine(rule3,3,outStream);

    const Ordinal &e4 = * new AdmisLevOrdinal(t,zero,NULL);
    limitExampLine(e4,2,outStream);

    const Ordinal &e5 = * new AdmisLevOrdinal(omega,e4,NULL);
    limitExampLine(e5,2,outStream);

    const Ordinal &t1 = e1+Ordinal::six ;
    const Ordinal &e6 = * new AdmisLevOrdinal(omega,t1,NULL);
    limitExampLine(e6,5,outStream);


    outStream << "\\end{tabular}\n" ;
    
    outStream<<"\\caption{{\\tt AdmisNormalElement::limitType}s}\n";
    outStream<<"\\index{{\\tt AdmisNormalElement::limitType}s}\n";
    outStream << "\\label{TabAdmisLimitType}\n" ;

    OutStream::streamManager.pop();
}


static void admisNeExLine(const Ordinal&ord , int n, ostream& str)
{
    str << "$" << ord.texNormalForm() ;
    for (int i = 0 ; i < n ; i++) str << " $&$ " <<
        ord.limitElement(i+1).texNormalForm()  ;
    str << "$\\\\\\hline\n" ;
}

static void admisNestedExamp()
{
    const Ordinal& zero = Ordinal::zero ;
    string tname = "tabAdmisNestedExamp" ;
    string fname = tname;
    fname += ".tex" ;
    ofstream outStream(fname.c_str());
    OutStream::streamManager.push(outStream);

    int n = 3 ;

    outStream << "\\begin{table}\\centering\n" ;
    outStream << "\\begin{tabular}{|l|" ;
    for (int i = 0 ; i < n ; i++) outStream << "l|" ;
    outStream << "}\\hline\n" ;
    outStream << "{\\bf Ordinal} & \\multicolumn{" << n <<
        "}{|c|}{\\bf LimitElements}\\\\\\hline\n" ;
    for (int i = 0 ; i < n ; i++) outStream << "&" <<  (i+1)  ;
    outStream << "\\\\\\hline\n" ;

    const Ordinal & aa = admisLevelFunctional(Ordinal::one,zero,NULL,zero,
        Ordinal::one);
    admisNeExLine(aa,n,outStream);

    const Ordinal & bba = admisLevelFunctional(Ordinal::two,zero,NULL,zero,
        Ordinal::one);
    admisNeExLine(bba,n,outStream);     

    const Ordinal & bbc = admisLevelFunctional(Ordinal::three,zero,NULL,zero,
        Ordinal::one);
    admisNeExLine(bbc,n,outStream);     

    const Ordinal & bb = admisLevelFunctional(Ordinal::two,zero,NULL,zero,
        Ordinal::two);
    admisNeExLine(bb,n,outStream);     

    const Ordinal & bbb = admisLevelFunctional(Ordinal::three,zero,NULL,zero,
        Ordinal::two);
    admisNeExLine(bbb,n,outStream);     

    const Ordinal & cc = admisLevelFunctional(Ordinal::omega,zero,NULL,zero,
        Ordinal::one);
    admisNeExLine(cc,n,outStream);     

    const Ordinal & cca = admisLevelFunctional(Ordinal::omega,zero,NULL,zero,
        Ordinal::two);
    admisNeExLine(cca,n,outStream);     

    const Ordinal & dd = admisLevelFunctional(Ordinal::omega,zero,NULL,zero,
        Ordinal::omega);
    admisNeExLine(dd,n,outStream);     

    const Ordinal& wtw = Ordinal::omega^Ordinal::omega ;
    const Ordinal & dda = admisLevelFunctional(wtw,zero,NULL,zero,
        wtw);
    admisNeExLine(dda,n,outStream);     

      


    outStream << "\\end{tabular}\n" ;
    
    outStream<<"\\caption{$\\delta$ parameter examples}\n";
    outStream<<"\\index{embedded index examples}\n";
    outStream << "\\label{TabAdmisNestedExamp}\n" ;
    outStream << "\\end{table}\n" ;

    OutStream::streamManager.pop();
}

static void admisEmbedLimit()
{

    string tname = "tabEmbedLimitDef" ;
    string fname = tname;
    fname += ".tex" ;
    ofstream outStream(fname.c_str());
    OutStream::streamManager.push(outStream);
    int n = 3 ; 

    outStream << "\\begin{table}\n\\begin{tabular}{|c|c|c|" ;
    for (int i = 0 ; i < n ; i++) outStream << "r|" ;
    outStream << "r|}\\hline\n" ;
    outStream << "\\multicolumn{" << n+3 << "}{|l|}{Types: S=successor, L=limit}"
        << "\\hline\n" ;
    outStream << "\\multicolumn{" << n+3 << "}{|l|}{Parameters: I=indexCK,"
        << "E=embedIndex D=drillDown}\\hline\n" ;

    outStream << "E&I&D&" ;
    for (int i = 0 ; i < n ; i++) outStream << (i+1) << "&" ;
    outStream << "\\\\\\hline\n" ;
    outStream << "S&S&" ;

    

    outStream << "\\end{tabular}\n" ;
    
    outStream<<"\\caption{Defining nested examples}\n";
    outStream<<"\\index{nested examples}\n";
    outStream << "\\label{TabAdmisNestedDef}\n" ;
    outStream << "\\end{table}\n" ;

    OutStream::streamManager.pop();

    
}



static void admisDescribeNestedCollapse()
{
    string tname = "descrNestedCollapse" ;
    string fname = tname;
    fname += ".tex" ;
    ofstream outStream(fname.c_str());
    OutStream::streamManager.push(outStream);

    const Ordinal& d1Base = admisLevelFunctional(Ordinal::one,zero,NULL,zero,
        Ordinal::one);
   static const int lim = 5 ;
   const Ordinal * ords[lim-1] ;
   static const int innerLim = 5 ;
   static const Ordinal * ords2[innerLim-1][lim-1];
    
    outStream << "\\begin{table}\n\\centering\n\\begin{tabular}{|l|" ;
    for (int i = 1 ; i < lim ; i++) outStream << "l|" ;
    outStream << "}\\hline\\hline\n" ;
    outStream <<"$\\alpha$ & \\multicolumn{" << (lim-1) <<
        "}{|c|}{$\\alpha{\\tt .limitElement(}n{\\tt )}$}\\\\\\hline\n" ;
    outStream << "$n$ " ;
    for (int i = 1 ; i < lim ; i++) outStream << "& {\\bf " << i
        << "}" ;
    outStream << "\\\\\\hline\\hline\n";

    outStream << "$" << d1Base.texNormalForm() << "$\n"  ;
    for (int i = 1 ; i < lim; i++) outStream << "&$" <<
       (ords[i-1] = &(d1Base.limitElement(i)))->texNormalForm() << "$\n" ;
    outStream << "\\\\\\hline\n" ;

    for ( int i = 1 ; i < innerLim;i++)  {
        outStream << "$" << ords[i-1]->texNormalForm() << "$&" ;
        for (int j = 1 ; j < lim ; j++) {
            if ( j > 1) outStream << "&" ;
            outStream << "$" <<
                (ords2[i-1][j-1] = &(ords[i-1]->limitElement(j)))
                ->texNormalForm() << "$" ;
        }
        outStream << "\\\\\\hline\n" ;
    }
    for ( int i = 1 ; i < innerLim;i++)  {
        for (int j = 1 ; j < lim ; j++) {
            const Ordinal &ord = *(ords2[i-1][j-1]) ;
            outStream << "$" << ord.texNormalForm() << "$&" ;
            for (int j = 1 ; j < lim ; j++) {
                if ( j > 1) outStream << "&" ;
                outStream << "$" << ord.limitElement(j).texNormalForm()
                    << "$" ;
            }
            outStream << "\\\\\\hline\n" ;
        }
    }


    outStream << "\\end{tabular}\n" ;
    outStream <<"\\caption{Structure of $[[1]]\\omega_{1}$ }\n";
    outStream <<"\\index{nested examples}\n";
    outStream << "\\label{TabAdmisNestedDef}\n" ;
    outStream << "\\end{table}\n" ;



    OutStream::streamManager.pop();
}

static const int numLimElts = 3 ;
static void outCollLine(ostream& outStream, const Ordinal &ord, int num = numLimElts)
{
    const Ordinal * ordAry [num] ;
    if (!ord.isZero()) {
        outStream  << "$" << ord.texNormalForm() << "$" ;
        for (int i = 1 ; i < num +1 ; i++) outStream << "&$" <<
            (ordAry[i] = &ord.limitElement(i))->texNormalForm() << "$" ;
    } else {
        const Ordinal * base = &one ;
        for (int i = 1 ; i < num + 1 ; i++) {
            base = &(admisLevelFunctional(*base,zero));
            const Ordinal & disp =
                admisLevelFunctional(*base,zero,NULL,zero, one);
            outStream  << "&$" << disp.texNormalForm() << "$";
        }
    }
    outStream << "\\\\\\hline\n" ;
    

}

static const int psiNumLimElts = 2;
static void outPsiLine(ostream& outStream, const Ordinal &ord,
    int psiNum=psiNumLimElts)
{
    const Ordinal * ordAry [psiNum] ;
    outStream  << "$" << ord.texNormalForm() << "$&\n$" <<
        ord.psiNormalForm() << "\n" ;
    for (int i = 1 ; i < psiNum +1 ; i++) outStream << "$&\n$" <<
        (ordAry[i] = &ord.limitElement(i))->texNormalForm() ;
    outStream << "$\n\\\\\\hline\n" ;
}

static void outPsiRvLine(ostream& outStream, const Ordinal &ord,
    int psiNum=psiNumLimElts)
{
    const Ordinal * ordAry [psiNum] ;
    outStream  << "$" << ord.psiNormalForm() << "$&\n$" <<
        ord.texNormalForm() << "\n" ;
    for (int i = 1 ; i < psiNum +1 ; i++) outStream << "$&\n$" <<
        (ordAry[i] = &ord.limitElement(i))->texNormalForm() ;
    outStream << "$\n\\\\\\hline\n" ;
}





static void admisCollapseConnect()
{
    string tname = "collapseConnect" ;
    string fname = tname;
    fname += ".tex" ;
    ofstream outStream(fname.c_str());
    OutStream::streamManager.push(outStream);
    outStream << "\\begin{table}\\centering\n\\begin{tabular}{|l|l|" ;
    for (int i = 1 ; i < numLimElts + 1 ; i++) outStream << "l|" ;
    outStream << "}\\hline\n" ;
    outStream << "\\multicolumn{2}{|c|}{\\bf Notation}&\n\\multicolumn{"
        << numLimElts << "}{|c|}{\\tt limitElement}\\\\\\hline\n" ;
    outStream << "{\\bf $\\Psi$ } & {$\\varphi\\ \\ \\omega$}" ;
    for (int i = 1 ; i < numLimElts + 1 ; i++) outStream << "&{\\bf "
        << i << "}" ;
    outStream << "\\\\\\hline\\hline\n" ;

    bool skipDup = true ;

    const Ordinal& psi1a = finiteFunctional(Ordinal::one,zero,zero);
    if (!skipDup) {
        outStream << "$\\Psi(\\Omega^{\\Omega})$&" ;
        outCollLine(outStream,psi1a);
    }
    outPsiRvLine(outStream,psi1a,numLimElts);

    const Ordinal& psi1b = finiteFunctional(Ordinal::one,zero,zero,zero);
    
    
    outPsiRvLine(outStream,psi1b,numLimElts);


    const Ordinal& psi1 = iterativeFunctional(Ordinal::one);
    
    
    outPsiRvLine(outStream,psi1,numLimElts);

    outStream << "$\\Psi(\\Omega^{\\Omega^{\\omega 2}})$&" ;
    const Ordinal& psi1_2 = iterativeFunctional(Ordinal::two);
    outCollLine(outStream,psi1_2);
    outPsiRvLine(outStream,psi1_2,numLimElts);

    const Ordinal& psi1_2w = iterativeFunctional(Ordinal::two,omega,12);
    
    
    outPsiRvLine(outStream,psi1_2w,numLimElts);

    const Ordinal& psi1_2w8 = iterativeFunctional(Ordinal::two,omega,12,8);
    outPsiRvLine(outStream,psi1_2w8,numLimElts);

    

    const Ordinal& psi1_w = iterativeFunctional(omega);
    
    
    outPsiRvLine(outStream,psi1_w,numLimElts);

    const Ordinal& psi1w = iterativeFunctional(omega^omega);
    
    
    outPsiRvLine(outStream,psi1w,numLimElts);

    const Ordinal& o11 = admisLevelFunctional(one,zero,NULL,one,zero);
    
    
    outPsiRvLine(outStream,o11,numLimElts);

    const Ordinal& o11_2=admisLevelFunctional(one,zero,NULL,Ordinal::two,zero);
    
    
    outPsiRvLine(outStream,o11_2,numLimElts);

    outStream << "$\\Psi(\\Omega^{\\Omega^{\\Omega \\omega}})$&" ;
    const Ordinal& o11_w=admisLevelFunctional(one,zero,NULL,omega,zero);
    outCollLine(outStream,o11_w);
    outPsiRvLine(outStream,o11_w,numLimElts);

    outStream << "$\\Psi(\\Omega^{\\Omega^{\\Omega^\\omega}})$&" ;
    const Ordinal& o11w=admisLevelFunctional(one,zero,NULL,zero,one);
    outCollLine(outStream,o11w);
    outPsiRvLine(outStream,o11w,numLimElts);

    const Ordinal& o113a=admisLevelFunctional(one,zero,
        createParameters(&Ordinal::three),zero,one);
    outPsiRvLine(outStream,o113a,numLimElts);

    const Ordinal& o113b=admisLevelFunctional(one,zero,
        createParameters(&Ordinal::five,&Ordinal::three),zero,one);
    outPsiRvLine(outStream,o113b,numLimElts);

    const Ordinal& o113c=admisLevelFunctional(one,zero,
        createParameters(&Ordinal::two,&Ordinal::zero,&Ordinal::zero),zero,one);
    outPsiRvLine(outStream,o113c,numLimElts);

    const Ordinal& o113=admisLevelFunctional(one,Ordinal::three,NULL,zero,one);
    outPsiRvLine(outStream,o113,numLimElts);

    const Ordinal& o11wwa=admisLevelFunctional(one,omega^omega,NULL,zero,one);
    outPsiRvLine(outStream,o11wwa,numLimElts);

    outStream << "$\\Psi(\\Omega^{\\Omega^{\\Omega^{\\omega 2}}})$&" ;
    const Ordinal& o11w3=admisLevelFunctional(Ordinal::two,zero,NULL,one,one);
    outCollLine(outStream,o11w3);
    outPsiRvLine(outStream,o11w3,numLimElts);

    const Ordinal& o11w2=admisLevelFunctional(Ordinal::two,zero,NULL,zero,one);
    outStream << "$\\Psi(\\Omega^{\\Omega^{\\Omega^{\\omega 2}}})$&" ;
    outCollLine(outStream,o11w2);
    outPsiRvLine(outStream,o11w2,numLimElts);

    const Ordinal& o11w2x=admisLevelFunctional(Ordinal::two,psi(omega^omega,zero)+one,
        NULL,zero,one);
    
    
    outPsiRvLine(outStream,o11w2x,numLimElts);

    const Ordinal& o11ww=admisLevelFunctional(omega,zero,NULL,zero,one);
    outStream << "$\\Psi(\\Omega^{\\Omega^{\\Omega^{\\omega \\omega}}})$&" ;
    outCollLine(outStream,o11ww);
    outPsiRvLine(outStream,o11ww,numLimElts);

    outStream << "$\\Psi(\\Omega^{\\Omega^{\\Omega^{\\Omega}}})$&" ;
    const Ordinal& ox1 = admisLevelFunctional(omega1CK,zero,NULL,zero,one);
    outCollLine(outStream,ox1);
    outPsiRvLine(outStream,ox1,numLimElts);

    const Ordinal& w2 = admisLevelFunctional(Ordinal::two,zero);
    outStream << "$\\Psi(\\Omega^{\\Omega^{\\Omega^{\\Omega^\\Omega}}})$&" ;
    const Ordinal& ox2 = admisLevelFunctional(w2,zero,NULL,zero,one);
    outCollLine(outStream,ox2);
    outPsiRvLine(outStream,ox2,numLimElts);

    const Ordinal & ww = admisLevelFunctional(omega,zero);
    outStream << "\\MIndex{$\\Psi(\\varepsilon_{\\Omega+1})$}&" ;
    const Ordinal& oxw = admisLevelFunctional(ww,zero,NULL,zero,one);
    outCollLine(outStream,oxw);

    outStream << "&" ;
    outCollLine(outStream,zero);
    

    outStream << "\\end{tabular}\n" ;
    outStream <<"\\caption{$\\Psi$ collapsing function with {\\tt limitElement}s}\n";
    outStream <<"\\index{$\\Psi$}\n";
    outStream << "\\label{TabAdmisConnPsi}\n" ;
    outStream << "\\end{table}\n" ;

    OutStream::streamManager.pop();
}





static void admisPsiTab()
{
    string tname = "admisPsi" ;
    string fname = tname;
    fname += ".tex" ;
    ofstream outStream(fname.c_str());
    OutStream::streamManager.push(outStream);
    outStream << "\\begin{table}\\centering\n\\begin{tabular}{|l|l|" ;
    for (int i = 1 ; i < psiNumLimElts + 1 ; i++) outStream << "l|" ;
    outStream << "}\\hline\n" ;
    outStream << "\\multicolumn{2}{|c|}{\\bf Notation}&\n\\multicolumn{" << psiNumLimElts <<
        "}{|c|}{\\tt limitElement}\\\\\\hline\n" ;
    outStream << "$\\varphi\\ \\ \\omega $&$ \\Psi$" ;
    for (int i = 1 ; i < psiNumLimElts + 1 ; i++)
        outStream << "&{\\bf " << i << "}" ;
    outStream << "\\\\\\hline\\hline\n" ;

    const Ordinal& o1 = psi(1,0);
    outPsiLine(outStream,o1);

    const Ordinal& o2 = psi(1,1);
    outPsiLine(outStream,o2);

    const Ordinal& o3 = psi(1,omega);
    outPsiLine(outStream,o3);

    const Ordinal& o2z = psi(2,0);
    outPsiLine(outStream,o2z);

    const Ordinal& o21 = psi(2,1);
    outPsiLine(outStream,o21);

    const Ordinal& o2w = psi(2,omega);
    outPsiLine(outStream,o2w);

    const Ordinal& o3z = psi(3,0);
    outPsiLine(outStream,o3z);

    const Ordinal& o9a = psi(3,5);
    outPsiLine(outStream,o9a);

    const Ordinal& o9 = psi(3,omega+5);
    outPsiLine(outStream,o9);

    const Ordinal& ox = psi(omega^omega,omega+5);
    outPsiLine(outStream,ox);

    const Ordinal& o4 = finiteFunctional(1,0,0);
    outPsiLine(outStream,o4);

    const Ordinal& o5 = finiteFunctional(1,omega,12);
    outPsiLine(outStream,o5);

    const Ordinal& o6 = finiteFunctional(omega*omega,omega,12);
    outPsiLine(outStream,o6);

    const Ordinal& o7 = finiteFunctional(1,0,0,0);
    outPsiLine(outStream,o7);

    

    const Ordinal * o = &Ordinal::one ;
    const Ordinal * z = &Ordinal::zero ;
    const Ordinal& o8 = finiteFunctional(createParameters(o,z,z,z,z));
    outPsiLine(outStream,o8);

    

    const Ordinal& p1 = iterativeFunctional(one);
    outPsiLine(outStream,p1);

    const Ordinal& p2 = iterativeFunctional(one,one);
    outPsiLine(outStream,p2);

    const Ordinal& ptwo = iterativeFunctional(Ordinal::two);
    outPsiLine(outStream,ptwo);

    const Ordinal& p4 = iterativeFunctional(Ordinal::four);
    outPsiLine(outStream,p4);

    const Ordinal& pwp1 = iterativeFunctional(omega+one);
    outPsiLine(outStream,pwp1);

    const Ordinal& p3 = iterativeFunctional(omega^omega,Ordinal::four,
        Ordinal::two,Ordinal::five);
    outPsiLine(outStream,p3);

    const Ordinal & pdd = admisLevelFunctional(one,zero,NULL,one,zero);
    outPsiLine(outStream,pdd);

    const Ordinal & pdd3 = admisLevelFunctional(one,zero,NULL,
        omega+Ordinal::three,zero);
    outPsiLine(outStream,pdd3);

    const Ordinal & pgww = admisLevelFunctional(one,zero,NULL,
        finiteFunctional(omega^omega,zero,zero),zero);
    outPsiLine(outStream,pgww);

    const Ordinal& xy = admisLevelFunctional(admisLevelFunctional(Ordinal::two,zero),
        zero,NULL,zero,one);
    outPsiLine(outStream,xy);

    const Ordinal &admadm = admisLevelFunctional(admisLevelFunctional(
        Ordinal::three,zero),zero,NULL,zero,one);
    outPsiLine(outStream,admadm);

    const Ordinal &admadm3 = admisLevelFunctional(admisLevelFunctional(
        Ordinal::three,Ordinal::four),zero,NULL,zero,one);
    outPsiLine(outStream,admadm3);

    const Ordinal &admadm3a = admisLevelFunctional(admisLevelFunctional(
        Ordinal::three,Ordinal::four,createParameters(&Ordinal::five)),
        zero,NULL,zero,one);
    outPsiLine(outStream,admadm3a);

    
    const Ordinal&ten = * new Ordinal(10);
    const Ordinal &ord10 = admisLevelFunctional(admisLevelFunctional(
        ten,zero),zero,NULL,zero,one);
    outPsiLine(outStream,ord10);

    

    outStream << "\\end{tabular}\n" ;
    outStream <<
        "\\caption{$\\Psi$ collapsing function with {\\tt limitElement}s 2}\n";
    outStream <<"\\index{$\\Psi$}\n";
    outStream << "\\label{TabAdmisPsi}\n" ;
    outStream << "\\end{table}\n" ;

    OutStream::streamManager.pop();
}


static void outPsiLimLine(ostream& outStream, const Ordinal &ord,
    int psiNum=psiNumLimElts)
{
    static int lineCount=0;
    const Ordinal * ordAry [psiNum] ;
    outStream  << "&$" << ord.psiNormalForm() << "\n" ;
    for (int i = 1 ; i < psiNum +1 ; i++) outStream << "$&\n$" <<
        (ordAry[i] = &ord.limitElement(i))->psiNormalForm() ;
    
    outStream << "$\n\\\\\n" << ++lineCount << "&$" <<
        ord.texNormalForm() ;
    for (int i = 1 ; i < psiNum +1 ; i++) outStream << "$&\n$" <<
        ordAry[i]->texNormalForm() ;
    outStream << "$\n\\\\\\hline\\hline\n" ;
}




static void admisPsiLimTab()
{
    static const int numElts = 4 ;
    string tname = "admisLimPsi" ;
    string fname = tname;
    fname += ".tex" ;
    ofstream outStream(fname.c_str());
    OutStream::streamManager.push(outStream);
    outStream << "\\begin{table}\\centering{\\footnotesize\n" <<
        "\\begin{tabular}{|r|l|" ;
    for (int i = 1 ; i < numElts + 1 ; i++) outStream << "l|" ;
    outStream << "}\\hline\n" ;
    outStream << "&\\multicolumn{1}{|c|}{\\bf Notation}&\n" <<
        "\\multicolumn{" << numElts <<
        "}{|c|}{\\tt limitElement}\\\\\\hline\n" ;
    outStream << "{\\bf \\#}&$ \\Psi\\ /\\ \\varphi\\ \\ \\omega $" ;
    for (int i = 1 ; i < numElts + 1 ; i++)
        outStream << "&{\\bf " << i << "}" ;
    outStream << "\\\\\\hline\\hline\n" ;

    const Ordinal* ordAry[] = {
        
        &psi(Ordinal::two,zero),
        &psi(Ordinal::three,zero),
        &psi(omega,zero),
        &finiteFunctional(one,zero,zero),
        &finiteFunctional(one,zero,zero,zero),
        &iterativeFunctional(one),
        &iterativeFunctional(Ordinal::two),
        &iterativeFunctional(omega),
        &admisLevelFunctional(one,zero,NULL,one),
        &admisLevelFunctional(one,zero,NULL,omega),
        &admisLevelFunctional(one,zero,NULL,zero,one),
        &admisLevelFunctional(Ordinal::two,zero,NULL,zero,one),
        
        &admisLevelFunctional(omega,zero,NULL,zero,one),

        &zero
    };

    int i = 0 ;
    while (true) {
        const Ordinal * ptr = ordAry[i++] ;
        if (ptr->isZero()) break ;
        outPsiLimLine(outStream,*ptr,numElts);

    }



     outStream << "\\end{tabular}}\n" ;
    outStream <<
        "\\caption{$\\Psi$ collapsing function at critical limits}\n";
    
    outStream << "\\label{TabAdmisLimPsi}\n" ;
    outStream << "\\end{table}\n" ;

    OutStream::streamManager.pop();
}

static void writeText (ostream& out,const char ** lines)
{
    for (const char ** line = lines; *line ; line++)
        out << *line << "\n" ;
}

static void psiBaseLine(ostream&out,const Ordinal&ord, int& lc)
{
    out << lc++ << "&$" << ord.psiNormalForm() << "$&$" << ord.texNormalForm()
        << "$&\\\\\\hline\n" ;

}

static void admisPsiBaseTab()
{
    static const int numElts = 4 ;
    string tname = "admisBasePsi" ;
    string fname = tname;
    fname += ".tex" ;
    ofstream outStream(fname.c_str());
    OutStream::streamManager.push(outStream);

    outStream << "\\begin{table}\n\\centering\n" ;
    outStream << "\\begin{tabular}{|r|l|l|l|}\\hline\n" ;
    outStream << "&\\multicolumn{2}{|c|}{\\bf Notation}&\\\\\\hline\n" ;

    const char * text[] = {
        "{\\bf \\#}&{\\bf $\\Psi$ }&{\\bf $\\varphi\\ \\ \\omega$} &\n",
        "{\\bf Bound} \\\\\\hline\\hline",
        "1&$\\Psi(\\alpha)$ & $\\varepsilon_{\\alpha}$ &\n",
        "$\\alpha < \\varphi(2,0)$\\\\\\hline\n",
        NULL
    };
    int lineCount = 2 ;
    writeText(outStream,text);

    const Ordinal& twelve = * new Ordinal(12) ;
    const Ordinal &ord12 =  psi(Ordinal::two,twelve);
    psiBaseLine(outStream,ord12,lineCount) ;
    outStream << lineCount++ << "&$\\Psi(\\Omega (\\opa))$&" <<
        "$\\varphi(2,\\alpha)$&\n" <<
        "$\\alpha < \\varphi(3,0)$\\\\\\hline\n" ;

    const Ordinal &ord13_5 =  psi(Ordinal::three,Ordinal::five);
    psiBaseLine(outStream,ord13_5,lineCount) ;
    outStream << lineCount++ <<
        "&$\\Psi(\\Omega^2(\\opa))$&$\\varphi(3,\\alpha)$&\n" <<
        "$\\alpha < \\varphi(4,0)$\\\\\\hline\n" ;

    const Ordinal &ord12_x =  psi(twelve,Ordinal::five);
    psiBaseLine(outStream,ord12_x,lineCount) ;
    outStream << lineCount++ << 
        "&$\\Psi(\\Omega^\\beta(\\opa))$ &$\\varphi(1+\\beta,\\alpha)$&\n" <<
        "$\\alpha < \\varphi(1+\\beta,0) \\wedge \\beta <\\varphi(1,0,0)$\n" <<
        "\\\\\\hline\n" ;

    const Ordinal & ord1 = finiteFunctional(one,zero,zero);
    outStream << lineCount++ << "&$" << ord1.psiNormalForm() <<
        "$&$\\varphi(1,0,0) = "
        << ord1.texNormalForm() << "$&\\\\\\hline\n" ;
    

    const Ordinal &ord2 =  finiteFunctional(Ordinal::two,zero,zero);
    psiBaseLine(outStream,ord2,lineCount) ;
    

    const Ordinal &ord3 = finiteFunctional(Ordinal::two,Ordinal::three,
        Ordinal::five);
    psiBaseLine(outStream,ord3,lineCount);

    

    const Ordinal &ord4 = finiteFunctional(Ordinal::one,zero,zero,zero);
    psiBaseLine(outStream,ord4,lineCount);
    

    outStream << lineCount++ << "&$\\Psi(\\Omega^{\\Omega^n })$ &\n" <<
        "$\\varphi(1_1,0_2,...,0_{n+2})$&\\\\\\hline" ;
    outStream << lineCount++ << "&$\\Psi(\\Omega^{\\Omega^n \\alpha_1})$&\n" <<
        "$\\varphi(\\alpha_1,0_2,...,0_{n+2})  $ " <<
        "&$\\alpha_1 < \\varphi(1_1,0_2,...,0_{n+3}) $ \\\\\\hline" ;

    const Ordinal& ord5 = iterativeFunctional(one);
    psiBaseLine(outStream,ord5,lineCount);

    const Ordinal& ord6 = iterativeFunctional(Ordinal::one,Ordinal::five);
    psiBaseLine(outStream,ord6,lineCount);

    outStream << lineCount++ << 
        "&$\\Psi(\\Omega^{\\Omega^\\omega (\\opa)})$ &$\\varphi_1(\\alpha)$\n" ;
    outStream <<
        "&$\\alpha < \\varphi_1(1,0) $ \\\\\\hline\n" ;

    const Ordinal * ords[] = {
        &iterativeFunctional(Ordinal::one,Ordinal::four,Ordinal::two),
        &iterativeFunctional(Ordinal::two),
        &iterativeFunctional(Ordinal::omega),
        NULL
    };

    for (const Ordinal ** ord = ords; *ord; ord++) 
        psiBaseLine(outStream,**ord,lineCount);

    outStream << lineCount++ << 
        "&$\\Psi(\\Omega^{\\Omega^{\\omega^\\alpha}})$&\n" <<
        "$\\varphi_\\alpha $\n" <<
        "&$\\alpha < \\omega_1[1]$ \\\\\\hline\n" ;

    const Ordinal * ords2[] = {
        &admisLevelFunctional(one,zero,NULL,one),
        &admisLevelFunctional(Ordinal::one,zero,NULL,zero,one),
        &admisLevelFunctional(Ordinal::two,zero,NULL,zero,one),
        &admisLevelFunctional(Ordinal::omega,zero,NULL,zero,one),

        NULL
    };

    for (const Ordinal ** ord = ords2; *ord; ord++) 
        psiBaseLine(outStream,**ord,lineCount);
    
    const char * text3[] = {
        
        
        
        "\\end{tabular}\n",
        "\\caption{$\\Psi$ collapsing function with bounds}\n",
        
        "\\index{ordinal collapsing function}\n",
        "\\index{collapsing function, ordinal}\n",
        "\\label{TabOrdColFuncVal}\n",
        "\\end{table}\n", NULL
};
    writeText(outStream,text3);
    OutStream::streamManager.pop();
}



void AdmisLevOrdinal::texDocument()
{
    admisEmbedLimit();
    admisExamp();
    admisLimitEle();
    admisLimitEle2();
    admisLimitEle3();
    
    admisLimitOrd();
    admisArithExamp();
    admisLimitTypeExamp();
    admisNestedExamp();
    admisDrillDownDefExamp();
    admisNestedCollapsingExamp() ;
    admisDescribeNestedCollapse();
    admisCollapseConnect() ;
    admisPsiTab();
    admisPsiLimTab();
    admisPsiBaseTab();

}


