/* mp3encoder.h
 * Copyright (C) 2001 QT4Linux and OpenQuicktime Teams
 *
 * This file is part of OpenQuicktime, a free QuickTime library.
 *
 * Based on QT4Linux by Adam Williams.
 *
 * OpenQuicktime is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * OpenQuicktime is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <audioencoder.h>
#include "lame3.70/lame.h"

typedef struct {
lame_global_flags gf;
WAVEFORMATEX in_fmt;
} MP3Encoder;

MP3Encoder* new_MP3Encoder(WAVEFORMATEX* format);
void delete_MP3Encoder(MP3Encoder*);
int MP3Encoder_SetBitrate(MP3Encoder*,int bitrate);
int MP3Encoder_SetQuality(MP3Encoder*,int quality);
int MP3Encoder_GetFormatSize(MP3Encoder*);
int MP3Encoder_GetFormat(MP3Encoder*,char* extension, int size);
int MP3Encoder_Start(MP3Encoder*);
int MP3Encoder_Convert(MP3Encoder*,char* in_data, int in_size,
		       char* out_data, int out_size,
		       int* size_read, int* size_written);
int MP3Encoder_Close(MP3Encoder*,char* out_data, 
		     int out_size, int* size_read);

