/* mp3encoder.c
 * Copyright (C) 2001 QT4Linux and OpenQuicktime Teams
 *
 * This file is part of OpenQuicktime, a free QuickTime library.
 *
 * Based on QT4Linux by Adam Williams.
 *
 * OpenQuicktime is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * OpenQuicktime is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "../../../config.h"
#include "mp3encoder.h"

MP3Encoder* new_MP3Encoder(WAVEFORMATEX* format)
{
  MP3Encoder* e = (MP3Encoder*) malloc(sizeof(MP3Encoder));
  memcpy(&e->in_fmt,format,sizeof(WAVEFORMATEX));
  lame_init(&e->gf);
  e->gf.silent=1;
  e->gf.padding=1;
  e->gf.VBR=1;
  e->gf.VBR_q = (format->nAvgBytesPerSec - 128000) / 32000;
  //    e->gf.brate = format->nAvgBytesPerSec  /125;
  e->gf.in_samplerate=format->nSamplesPerSec;
  
  e->gf.num_channels=format->nChannels;
  e->gf.inPath=strdup("-");
  e->gf.outPath = strdup("-");
  if(format->nChannels==1)
    e->gf.mode=3;
  else
    e->gf.mode=1;
  return e;
}

void delete_MP3Encoder(MP3Encoder *e)
{
  MP3Encoder_Close(e,0,0,0);
  free(e);
}

int MP3Encoder_SetBitrate(MP3Encoder *e,int bitrate)
{
    fprintf(stderr,"Setting bit rate to %i %i\n",bitrate,bitrate/125);
    e->gf.brate=bitrate/125;
    return 0;
}
int MP3Encoder_SetQuality(MP3Encoder *e,int quality)
{
    e->gf.quality=quality;
    return 0;
}
int MP3Encoder_GetFormatSize(MP3Encoder *e)
{
    return 18;
}
int MP3Encoder_GetFormat(MP3Encoder *e,char* extension, int size)
{
    WAVEFORMATEX wf;
    if(size<18)return -1;
    memcpy(&wf, &e->in_fmt, sizeof(WAVEFORMATEX));
    wf.wFormatTag=0x55;
    wf.nAvgBytesPerSec=e->gf.brate*125;
    wf.nBlockAlign=1;
    wf.cbSize=0;
    memcpy(extension, &wf, sizeof(WAVEFORMATEX));
    return 0;
}
int MP3Encoder_Start(MP3Encoder *e)
{
    lame_init_params(&e->gf);
    return 0;
}
int MP3Encoder_Convert(MP3Encoder *e,char* in_data, int in_size,
     char* out_data, int out_size,
    int* size_read, int* size_written)
{
// #warning not a standard preprocessor directive
// #warning FIXME 8-bit?
    int result;
    if(e->in_fmt.nChannels==1)
	result=lame_encode_buffer(&e->gf, (short*)in_data, (short*)in_data,
         in_size, out_data, out_size);
	 else
	result=lame_encode_buffer_interleaved(&e->gf, (short*)in_data,
         in_size, out_data, out_size);
    if(result<0)result=0;
    if(size_read)*size_read=in_size;
    if(size_written)*size_written=result;
    return 0;
}
int MP3Encoder_Close(MP3Encoder *e,char* out_data, 
		int out_size, int* size_read)
{
    char buffer[7200];
    fprintf (stderr,"MP3Encoder_Close()\n");
    lame_encode_finish(&e->gf, buffer, 7200);
    return 0;
}
