/*
 *  Open Fodder
 *  ---------------
 *
 *  Copyright (C) 2008-2024 Open Fodder
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

// PC: PC Format Demo
const std::vector<sFile> mPCFormatFiles = {
    { "CFCOVER.DAT", "66A8C78BB32C098B744F9F0F039A25A6" },
    { "CANNON2.DAT", "0761BE616F5A1542CA81212C566C6A5A" }
};

// Dos: CD/GOG Release
const std::vector<sFile> mPCFiles = {
    { "CF_ENG.DAT", "EEB82D5A6B14E7E59C8F7B5169BFCD55" }
};

// Dos 2: CD/GOG Release
const std::vector<sFile> mPC2Files = {
    { "CF_ENG.DAT",		"8A3EB9B9F134B2997E6534D4C39B23D6" },
    { "BIRD.SMP",		"EFE57BF26BBA0C7AC35720EB86AE37EA" },
    { "DIE1.SMP",		"124EFA03F13669D59EB03F1812A71624" },
    { "DIE2.SMP",		"902E437B8257231D1494535170A9ED22" },
    { "DIE3.SMP",		"4426AE305E6908FD6A933A3522681CEC" },
    { "DUCK.SMP",		"331F9DA882304EC428DD84051B7EA003" },
    { "ENGINE.SMP",		"AB3EB80B15DF9AD87FC6AB23E5C8ADAF" },
    { "EXPLOSN.SMP",	"18151D71549006032F3099EC1457699C" },
    { "GAMEOVER.AMF",	"0AA5D2C3849D9522C54F24B4900755CA" },
    { "GRENADE.SMP",	"3CA15373E824CEF8622216B2B6835C26" },
    { "GUN.SMP",		"1312B6A5D43BF1D3137CD29D5CE5403A" },
    { "HELI.SMP",		"26E2FAE3C85E728EDFC94B5CF9EA98C0" },
    { "HELIANIM.AMF",	"C70228BF18B4789796132E2B7B5676C7" },
    { "LOADER.AMF",		"23BBA2B5C1863488071515ED0E7B13B1" },
    { "MENU.AMF",		"9C58F6A8E4C79388994C34B6155E2FBA" },
    { "MGUN.SMP",		"16688E86D89D80F9B5F956BE9FC63C65" },
    { "MISSILE.SMP",	"C7625E6E1A6FEA368A104646390AB243" },
    { "ROOK.SMP",		"16233C3D4D205D32720A3F65A224190F" },
    { "SHEEP.SMP",		"99D397E27FCACD3EF7D0ABC42233A558" },
    { "TITLE.AMF",		"7831A09310004BB0F2F6754BA52D0AD5" },
    { "WINLEVEL.AMF",	"1E61F47CE71D24828F2A1E1656786978" },
    { "WINZONE.AMF",	"B9333DBB4BD65AEF6E3BA801D4FDABED" }
};

// Amiga: Floppy Release
const std::vector<sFile> mAmigaFiles = {
    { "1.RAW", "2F00447802B86510784ECC8D1134C942" },
    { "2.RAW", "540BA4FAEB4F8CE75391EF4ED2CDBA6A" },
    { "3.RAW", "4533919895685A4AE9D0A6D6E0DEE2DF" },
    { "4.RAW", "4345942CFF1477A075024F1E39C4DE9D" },
    { "5.RAW", "2FE63C2D4607BE2EDC59AA33E6A79678" },
    { "6.RAW", "CB9F7DF63AF62943F3C54A43A26BEB21" },
    { "7.RAW", "9DA3438B683276274941720CFD949053" },
    { "8.RAW", "E55133FF1B7D53D0D0FE52DC3D1D907E" },
    { "CFTITLE.RAW", "0BDEBDC8A9693C289A2EB1C8D5CA63E9" },
    { "desarmy.lbm", "6E20EC4F2361EC5E2AF1AD7801607B90" },
    { "desbase.bht", "1ADDFEE98A6CC1D949F62433EE2BBDEE" },
    { "DESBASE.BLK", "89AEA1251756F2D0AB770B71A998E63D" },
    { "desbase.hit", "1B90B2C0213541AB2A7828C3EE033D96" },
    { "DESBASE.INS", "F786A62F8050FAD8F3D7583FC7D6B7EE" },
    { "desbase.pal", "0EFBECDB69D7FF6F95E147B6C38E5607" },
    { "DESBASE.SNG", "83541523FFD2AD12AFD7F98E53D4203A" },
    { "desbase.swp", "D63F1CE753077B74A5F543DE8CC37209" },
    { "descopt.lbm", "C51CB1A3AD430D309B389C92839B63CA" },
    { "desfgn2.pl8", "AAB7E80C2F38D183081224070CA5D596" },
    { "desfgnd.pl8", "A343A151C4B644751BEA4A46DA9E1E95" },
    { "desheli.pal", "21913E3B4F89DC81CDA083A0FAFD86B3" },
    { "desmid.pl8", "EE7745F6B5711B8EF7D653400C13AA1F" },
    { "desplay.lbm", "6976107F99E8509C6569DCE432C55472" },
    { "dessky.pl8", "784C1CBDD7BF70B770B0A5857EF4F7B6" },
    { "dessub0.bht", "6FBF3782A8A16DECBAF3E34ECA5C6701" },
    { "DESSUB0.BLK", "C1B808192E53C314980C4CF03F1196FA" },
    { "dessub0.hit", "02079C848FB86EBFA87FC621A1BAF20D" },
    { "dessub0.swp", "3659C67526E293D2F134234B53069244" },
    { "font.pl8", "20331E3A2140B307F7749207F7A7B073" },
    { "FONT.RAW", "DF00FE92FA66EF15FDFB66A66110520D" },
    { "grave32.pal", "5DD21FA5759C74D26363BAB1CE08321D" },
    { "hills.lbm", "1411AACCEC4B4605CE664D18C0EB738D" },
    { "icearmy.lbm", "D998F6677275711FD56C0027504F8BCF" },
    { "icebase.bht", "C896E00F924B40780094202F7435D99A" },
    { "ICEBASE.BLK", "EEDF2742BA789E29E23A0F00D749164A" },
    { "icebase.hit", "DC376A162D23E763AE308D1EA877860F" },
    { "ICEBASE.INS", "A98080C06B186461FAEED944E540CEFE" },
    { "icebase.pal", "7EA341E95E1974422106E040F20F9DF2" },
    { "ICEBASE.SNG", "BC82E70E22DE7A66448AA5CA852A31D5" },
    { "icebase.swp", "49BAB52FC9F634ED0163FB17CD9EF027" },
    { "icecopt.lbm", "408D680145CB92BD9D851462D31BC1FE" },
    { "icefgn2.pl8", "996BB60A8D8962C81A3D5237F1DA8C1B" },
    { "icefgnd.pl8", "EF37E499906F6C33C601A4F5C598079E" },
    { "iceheli.pal", "2D30AA172BF7525053ADF1702D614B2C" },
    { "icemid.pl8", "6ABCCDE1D22965D54612EA18B2B664D9" },
    { "iceplay.lbm", "D07952805584A1195049E58C6CB8A948" },
    { "icesky.pl8", "AADBAB45A7878D40AB427E2DA89BBE29" },
    { "icesub0.bht", "7DDD2F85761C8D243E9737FAAE31A234" },
    { "ICESUB0.BLK", "4234FCFACDEFA50A5F76BC60BC39E7BC" },
    { "icesub0.hit", "C54F4B86420271D5B4D3013700EA0C44" },
    { "icesub0.swp", "1459837D4F3D5E96209F7F781988B854" },
    { "intarmy.lbm", "2782EC87708BEC4CB3C8E552428FB157" },
    { "intbase.bht", "78009ED2010DC94E18316B1486A916C6" },
    { "INTBASE.BLK", "627CCC83737AAE16AF5353BA5556F799" },
    { "intbase.hit", "2D899A1689858558C16596F48AAADB64" },
    { "INTBASE.INS", "5639D17E6724488BA77E24DCC3BE869A" },
    { "intbase.pal", "F7ECD7AFDFF722214BD3361386279C89" },
    { "INTBASE.SNG", "B49AFDA5EE1AA0DEB106DC7CD8D247BA" },
    { "intbase.swp", "676739A5A800B24951677850DE407052" },
    { "intcopt.lbm", "4A9860049923AF09FEC0932592E976F2" },
    { "intfgn2.pl8", "6E6DE3D59C8DD0D63E671591A20F6804" },
    { "intfgnd.pl8", "742DC99D7D1B901D46AD7DC868907776" },
    { "intheli.pal", "21913E3B4F89DC81CDA083A0FAFD86B3" },
    { "intmid.pl8", "46F0F1CD0E01DFFAF9D2AE245D3374BB" },
    { "intplay.lbm", "9C9F0516DF10164B995B171FD777350F" },
    { "intsky.pl8", "9ECB00FD609A624D449C7EB99301BBFC" },
    { "intsub0.bht", "45621B2A6EB37A2907767D1D5903DEC9" },
    { "INTSUB0.BLK", "D8E8F106648D1D3B7BDF6D1CA3753905" },
    { "intsub0.hit", "C44E7E4BFBF2E94655B5900A05E54DFC" },
    { "intsub0.swp", "CB1DBA7D0009538701C00F50CAA0A2D8" },
    { "JON.INS", "B4E1B5C2980A4DC1A3A91E7F8C68C68F" },
    { "JON.SNG", "34C83D7DD0F429EB8BF436C1037DD6A9" },
    { "junarmy.lbm", "F67D7D3C2B96A588BFB0AAE33FE1E186" },
    { "junbase.bht", "91AE45498B1E72AB8C147890CCFA1F15" },
    { "JUNBASE.BLK", "B1023928A64C59D8F49CAF7E28A17624" },
    { "junbase.hit", "D49E276228C93539C12857D18568CFAC" },
    { "JUNBASE.INS", "BBF9C7852AB0EF958496642B15D39BB1" },
    { "junbase.pal", "27DA36F06898A9549A1E4AF4CAC4D8B7" },
    { "JUNBASE.SNG", "B96327898322E13315EA9B1BFCE4D527" },
    { "junbase.swp", "D07A8EA9D22C37F7252993AA9B941427" },
    { "juncopt.lbm", "44BE34CE48631669760CE3439C44DBF8" },
    { "junfgn2.pl8", "93DDAFDE77A0A69420FDF690EB19AFE8" },
    { "junfgnd.pl8", "6341A7652D5C9EF689013DC429DEAD74" },
    { "junheli.pal", "159FE0477094B6DE51D71A977A5E4AED" },
    { "junmid.pl8", "19F1ACED260C1E6F481AD064AF7CC31F" },
    { "junplay.lbm", "27EC1DEB8BC5B6FE4CC47144DC344E60" },
    { "junsky.pl8", "CC35E8634CB2F72FB3220F0378FA41AA" },
    { "junsub0.bht", "4803076EB9656961B23DDDD31D9683BC" },
    { "JUNSUB0.BLK", "17DAA7C0CDCAFC5095B1118EBBAE6963" },
    { "junsub0.hit", "AB61F44685F9C025C27422819C0F46D4" },
    { "junsub0.swp", "AE0181B3EE4997C67F89B5A6E1FA685B" },
    { "junsub1.bht", "E4373BFC0E241714C61FA77DAA9E5A19" },
    { "JUNSUB1.BLK", "BA57F9ECDEB89DD3E27588BA2D1D540F" },
    { "junsub1.hit", "7C7603BD2ADFFC57F514A504D1867FD1" },
    { "junsub1.swp", "F4804ABDD08599E1AFEA6E14ED30863C" },
    { "mapm1.map", "87CFEDC0E35228FE3FC6A8115714671F" },
    { "mapm1.spt", "9363F391620A6CE069F72BA36BB56C83" },
    { "mapm10.map", "0249D6621BE91724EA42B5009649A927" },
    { "mapm10.spt", "67B47EA4940B3A992A4B88EE243FF477" },
    { "mapm11.map", "9AACDF92D838AFDEF2A6D0E84AC63171" },
    { "mapm11.spt", "81C801E7F15C0A4A5069E320049D7598" },
    { "mapm12.map", "30F13EFB9491BC2C87FEB933ED4E1C32" },
    { "mapm12.spt", "EA6CB4B5455796F7C0FD7B98E57BA8A5" },
    { "mapm13.map", "83DF412981AB0FAE7E81D5540E3BF9BB" },
    { "mapm13.spt", "1D58DA489B23A90CCE59F2223112304C" },
    { "mapm14.map", "588976C8C9DD6B1E230FFE9EDD483422" },
    { "mapm14.spt", "6927DF8B1857C592D92ECA3C6C404895" },
    { "mapm15.map", "08D6F085A46275346ED368CE85A3ABB5" },
    { "mapm15.spt", "30A540544787A4E7316550CAE2DAEBE4" },
    { "mapm16.map", "9DE544AB20328243D5D7BE377B22ADCF" },
    { "mapm16.spt", "1C0F82079ED39EB5FAA5239DE9336437" },
    { "mapm17.map", "56BC8A7A24B0E40B997E457392DF7557" },
    { "mapm17.spt", "9FBEF790F49274752C1E0DD4A7865769" },
    { "mapm18.map", "83BF5512CC08EEA27F960D181CB547F7" },
    { "mapm18.spt", "F1A3307D7312D23F32DD260A0A660C46" },
    { "mapm19.map", "75FA184B8C04CB62E7B3A266E7ED0C2D" },
    { "mapm19.spt", "F1B55CCDDC3FE33CCAE6B584FC395E5D" },
    { "mapm2.map", "BFD5C98299D6BCAD35C05EDCC21E2B6A" },
    { "mapm2.spt", "85E5488C763E1F27F03BA5222EA6B0ED" },
    { "mapm20.map", "26E8414699A942DD4BA570C7E057DCCA" },
    { "mapm20.spt", "1AFD66AA9BFBB67D77C0D516E07979BE" },
    { "mapm21.map", "E9D88E934E586C8F04F92DE63E0FD217" },
    { "mapm21.spt", "1557B44DCCC70573CE264B299485BF17" },
    { "mapm22.map", "FD8D578D2B6707CA85336A99D4CBB961" },
    { "mapm22.spt", "D9636125D5C38022D98EB3522D4A30CE" },
    { "mapm23.map", "76E47CDF17AD4E7F897CCC9F06302BD9" },
    { "mapm23.spt", "50465FF35F7C9AE530DAF6080D3A4EDC" },
    { "mapm24.map", "F42697404B27F5718C6E11792293CEFD" },
    { "mapm24.spt", "FCE2966FE1D8BA8865F2DCA709481E24" },
    { "mapm25.map", "E3397B21A1F2B89AC939589AC51CCC8C" },
    { "mapm25.spt", "A614496AB7AE932B5DD2756466CAB415" },
    { "mapm26.map", "237E2D5DA9097CD9DF44DAF4B2D9E7D7" },
    { "mapm26.spt", "3BFB3A08366B10A4C23AD8054B4CCDD9" },
    { "mapm27.map", "13500D082D6674EF8AD62380C7F37EFD" },
    { "mapm27.spt", "3BCE6C34EE3DE7CDCA1D49BA9AC181DF" },
    { "mapm28.map", "E30CA20BDBCCD041B5D648AA25F90D2B" },
    { "mapm28.spt", "05CCCE033154982B3820FE907B4DF4A2" },
    { "mapm29.map", "249F80C064DA3C749529775C1B6DE6DB" },
    { "mapm29.spt", "3C762E5286BA3FAF845E29DB455A29E0" },
    { "mapm3.map", "0338E1163FC61D5033B1730DED2C7E9A" },
    { "mapm3.spt", "B70E042F02CF17986223E935BEEFE698" },
    { "mapm30.map", "0818B093C13C14D1A08D8A22EBA12DEA" },
    { "mapm30.spt", "A59AA6A87F8A2C25176AC4CF7A952C56" },
    { "mapm31.map", "A15CAB7A4429B45550B5F807BEE17139" },
    { "mapm31.spt", "FBFD9BF5CA7FE1B353F300739E4B89D8" },
    { "mapm32.map", "A0FEEA41BCDD44502ACE29B0D3B678D1" },
    { "mapm32.spt", "87E83FBC6B72846666AB61246D42D790" },
    { "mapm33.map", "44AC7495D20AB2F9F71E7AA641DD2763" },
    { "mapm33.spt", "AB9EF2E58F0D052AAEBF09B8D9FC4555" },
    { "mapm34.map", "1BF79B2F821365586FD3A0EF6FAE8746" },
    { "mapm34.spt", "54ADA3E4D5B8519D277D5C0DA1988B0D" },
    { "mapm35.map", "47B9D9400454BA2EC101AFE3D2E6C158" },
    { "mapm35.spt", "C94BDE0F65082BAA0E398CECCBDC17DA" },
    { "mapm36.map", "22617DDB6184D707FC51BC24B4BDFCAB" },
    { "mapm36.spt", "856B5F249B2B907077C326EEAA31C072" },
    { "mapm37.map", "1D2F6C95F87CC7F4ECFF4DEEBEA8464E" },
    { "mapm37.spt", "F95CF8C30BEEEAC5D086D85E1319D40E" },
    { "mapm38.map", "F973679325C690160E0688049279AEB0" },
    { "mapm38.spt", "D68BCC332C9533342CAC59987E80069B" },
    { "mapm39.map", "1B8FFE6130055C7F8C1A923E171D1BD9" },
    { "mapm39.spt", "C8C1D44B54438B1C53598FAC6A875C70" },
    { "mapm4.map", "888FA41C0108A002CA689C17E5824D68" },
    { "mapm4.spt", "FB66076B935AA5790357E6B826C63D05" },
    { "mapm40.map", "6F3C062295A7CFFE37D8F5ADCC192BBE" },
    { "mapm40.spt", "226DFF3CB2B6356BF89EA757FEE18DF7" },
    { "mapm41.map", "96DDC8D0B6D3CD82754D15337F1A8371" },
    { "mapm41.spt", "7F80ABF519A9212B0299D41D11270FE9" },
    { "mapm42.map", "26FFF77E96DF989EBEE95396A322AEEB" },
    { "mapm42.spt", "2FB8016EE02ED9D0E2BD96AAB2201854" },
    { "mapm43.map", "04E3FCC880BA41EF3D661F04BF0BA3B2" },
    { "mapm43.spt", "05DFAD6C1AA019EB72BFAE876DEED236" },
    { "mapm44.map", "70AFD59D7E2D04D019D059F684F33CB8" },
    { "mapm44.spt", "7D2E1A248DC43D297F5350B7A75526F8" },
    { "mapm45.map", "3550423155A252C0B0DF348B66E84962" },
    { "mapm45.spt", "72C300FE0049340BEF058F29C7DE0365" },
    { "mapm46.map", "8E4CB53449163B4C035D372F4AB0FE53" },
    { "mapm46.spt", "48DEAA4F058862025BC522BEF8877A4E" },
    { "mapm47.map", "099A09E90331A674AE2CC17D4A14B127" },
    { "mapm47.spt", "6BBCFBE72B4983C53A262096F93036BE" },
    { "mapm48.map", "0DE73FC8B2FC6E1F9C7802FC4616674C" },
    { "mapm48.spt", "33924B560BF0A23FF6524857DAFA83D1" },
    { "mapm49.map", "2E3969EF5B1F7AFBB753A7EB31541318" },
    { "mapm49.spt", "D3FBE2D7546DBEA57D9E442C5A23A397" },
    { "mapm5.map", "5E8A8B47D967D9C88C04641B1D8CBCEC" },
    { "mapm5.spt", "CF2B3091B2E53042BA18F7AEFEA6E77E" },
    { "mapm50.map", "AEF2A6B134C3DC589FCE6467D5BEE613" },
    { "mapm50.spt", "7D336918CEB91D7DBC46A7580B85DF4F" },
    { "mapm51.map", "3070E54E04C3FAE83767C3C72C39AB6D" },
    { "mapm51.spt", "6A463306D48DE011359CAE0184451628" },
    { "mapm52.map", "58FC41C65DBDC2F2686E3DBA92E4CBE1" },
    { "mapm52.spt", "39149BC04E1CD7E7A58C16ED5D7154FC" },
    { "mapm53.map", "80FF3FE22C0280634F25273938C4227E" },
    { "mapm53.spt", "4096775C0AE5BEF068A50BDE33B1B555" },
    { "mapm54.map", "DCB661ADBBF868C9557ABAABB523B007" },
    { "mapm54.spt", "0D2FEC9E890584B6B0B42A7AC7A0003D" },
    { "mapm55.map", "2D67F46A4BA41902CFC787C552DB554B" },
    { "mapm55.spt", "2F94BFF8B9F0227AA611367710342C0F" },
    { "mapm56.map", "9DC185057091C9E611E4C461625DAC20" },
    { "mapm56.spt", "8CD2D33B779A8226DBAFBB2FEA1C5FE5" },
    { "mapm57.map", "9DFF279E5904D5CFF201C7CB39A7E697" },
    { "mapm57.spt", "1FB22FF561DEE32CAC432D67BE9368B1" },
    { "mapm58.map", "334E8C2C1EAE6E99D29213F27C19706A" },
    { "mapm58.spt", "B711D11EA40FEB4C7C64B1D92E2732EF" },
    { "mapm59.map", "1826DE04606F2257DED0F5B009BC0FC9" },
    { "mapm59.spt", "CC87EC1B714B13C8DFA716F29EDF9088" },
    { "mapm6.map", "C2DC1784ADE8A3818FB031159E395014" },
    { "mapm6.spt", "EA45BD73E655E982C7B12E11A4CE7507" },
    { "mapm60.map", "5764F806A19670734699534B3DCD42E7" },
    { "mapm60.spt", "51E1447FDDA120C414F9432C709E8460" },
    { "mapm61.map", "69926D0AC87B9325300E920BFB962140" },
    { "mapm61.spt", "77E3DE1F0B266C237EBB83B19AF8ABD9" },
    { "mapm62.map", "BE188016E2DD05F6C671A1BD616D15E2" },
    { "mapm62.spt", "1F3342FA6A0EF5631FDCDE7BCDE0D7A5" },
    { "mapm63.map", "B3BC25BA6FAB70D95CA3EED66674F56D" },
    { "mapm63.spt", "64B72EC4366E2FEF84A4E317DE54EECC" },
    { "mapm64.map", "A0C888D26882BAB5B2CAB1F6C582610B" },
    { "mapm64.spt", "FE858138E27CC0F75EE51C8CBBC4C7FF" },
    { "mapm65.map", "BEFC6E4A7269BFEA1A4E98E8AC858CD5" },
    { "mapm65.spt", "3D298C2FB7966C8035634051B5EFD170" },
    { "mapm66.map", "B0E47F3F1C2A80EBB30D5DBFC58D3D90" },
    { "mapm66.spt", "9222B6481597354CE4A15027B0D287A7" },
    { "mapm67.map", "E4AA847974367B2DC2A25CE34D66AEDD" },
    { "mapm67.spt", "A3C59E08649D7F78689C3FA74E64ED13" },
    { "mapm68.map", "05C70402A051DEC7C476168A51FFD223" },
    { "mapm68.spt", "9727CE0DCCBF72736082F390B059B669" },
    { "mapm69.map", "60A765ADB3AB58B89051B3B8729A5DFC" },
    { "mapm69.spt", "D8CB71B1231BF7EFF466673666444721" },
    { "mapm7.map", "ACC9CBE4A6C4ABD62721B706D39B03AE" },
    { "mapm7.spt", "71618692E2F2F087D2AECE67E643575E" },
    { "mapm70.map", "6B2C02F29F986ED88335406603F80658" },
    { "mapm70.spt", "5E3574665AD8064B74B06D84D2396625" },
    { "mapm71.map", "A4EDE77A00634BCDC2A526D5DC3EAB9D" },
    { "mapm71.spt", "94FCCC5DEE72A1B8E0B31D60F6FB8433" },
    { "mapm72.map", "65F8FF7E214408056158040790F7CF52" },
    { "mapm72.spt", "B63F6C9877D868025E7B097A13B3F2C6" },
    { "mapm8.map", "0BDCE811AF3A847A9A1FE36C4DAAF958" },
    { "mapm8.spt", "F4D89F63802D1499112F2C9E15B1B2AB" },
    { "mapm9.map", "633FC6B3B68C6AE4EDD2F04AE01B7B78" },
    { "mapm9.spt", "B8BC1235DFBF3B1FFC9C690E482D29E7" },
    { "morarmy.lbm", "D4C26CBC51831989D14E7F8800A244B3" },
    { "morbase.bht", "101778281E4BF9E895747D5ADFDDF713" },
    { "MORBASE.BLK", "63C071D813DADB06698E17F6C69109FC" },
    { "morbase.hit", "88D4B6F6CC22D2FB079B1FDCAECEA853" },
    { "MORBASE.INS", "F35199AA121B4726CBB3C083D02C23CC" },
    { "morbase.pal", "11707A9B16854E4F837DE5339956C76C" },
    { "MORBASE.SNG", "F8AC4FBE0DA3EE886014073D99FB6D4E" },
    { "morbase.swp", "3F0C27B6D245D281F1CC2A9649E3496B" },
    { "morcopt.lbm", "B34FCED0AE047064CA8188F0D1ED4F1D" },
    { "morfgn2.pl8", "92B2D26F7234286774D879782DBA90EC" },
    { "morfgnd.pl8", "431A05EABCD4D878C99D636FC7E6E5CC" },
    { "morheli.pal", "21913E3B4F89DC81CDA083A0FAFD86B3" },
    { "mormid.pl8", "6D866F0D805946D10AF69685F6F77498" },
    { "morphbig.lbm", "5251D2E85C658EB460C1BF2087DEA290" },
    { "morplay.lbm", "8CB3340414CF5D3AA0AC4CF115D8B452" },
    { "morsky.pl8", "469EDCB987F33163B11903A3B85A8874" },
    { "morsub0.bht", "E6561BBB836B98EC0D226D5A29C57E55" },
    { "MORSUB0.BLK", "EA8F0B8D2DADB6394FA2E53A29D3D52B" },
    { "morsub0.hit", "0639E578C6A8457A6FEB1D3F66D7C804" },
    { "morsub0.swp", "E44E572475F0E4E70D3B4EDE5DAA856A" },
    { "pstuff.lbm", "827C5CF8E0C162700FE5D6778AE13DDE" },
    { "rankfont.lbm", "2894B5CA8746799AA126CAA5734C2CF2" },
    { "SENSPROD.RAW", "2724B5C909CC2FCB5ADF012EAE2DDE9A" },
    { "VIRGPRES.RAW", "BA0A0431E88574BD4D726A52EB2991DA" },
    { "WARX1.INS", "CCE4AB1491AFC0A69BDF4D1451270C86" },
    { "WARX4.SNG", "189EB4A63C441A024173F24F089420E4" },
    { "WON.RAW", "2A8D87B71856865220376E38287AF2F9" }
};

const std::vector<sFile> mAmiga2Files = {
    { "1.PAL", "E11A790C61338A7128DA7703D3139D56" },
    { "1.RAW", "D3866A0FEA2244C738E3753C9B651276" },
    { "2.PAL", "BC0CA21B47115698823FEAD9507E528C" },
    { "2.RAW", "2BDED47684774104ACFA8ABEB13E181B" },
    { "3.PAL", "BC0CA21B47115698823FEAD9507E528C" },
    { "3.RAW", "FC4211A6477337A948D1236F21B9A623" },
    { "4.PAL", "C710D22C93E955EB851774AFACB7A6CE" },
    { "4.RAW", "5689654914F382A54DB0CA1AEDDDE13E" },
    { "5.PAL", "FD8A9785D7F7CCBF9C1CC2F386D9B560" },
    { "5.RAW", "14A20497F6BB1E06852C4338614E7920" },
    { "6.PAL", "84DF2A2D0FDBFDF2E49B04BFDFE6EDA6" },
    { "6.RAW", "E81EB5908D069A34DDE6CDF3924ABFC7" },
    { "7.PAL", "4F91EF51D88F434E66C8F81D57080D86" },
    { "7.RAW", "33C78D1CB3B7B960EDF73BF2E627CA60" },
    { "8.PAL", "7D44454E08A2CEDB25CD90DB2C102BFF" },
    { "8.RAW", "1D124949B2CFF16D7036CE99FFDF203C" },
    { "9.PAL", "BC0CA21B47115698823FEAD9507E528C" },
    { "9.RAW", "60735552F1707C328FB7AEBDAC05DE44" },
    { "A.PAL", "5A3BCAB35D85FD85259EAAAE7342ADAE" },
    { "A.RAW", "B7480A7BD719385F53DBA6BECD2613F4" },
    { "B.PAL", "F3D4BB555BA7923F20D5E65436270E22" },
    { "B.RAW", "8D2E15C3863A07C2D4B06777E75979ED" },
    { "C.PAL", "F3D4BB555BA7923F20D5E65436270E22" },
    { "C.RAW", "165CF389140935A0356B01080272DFAC" },
    { "CFTITLE.PAL", "0ECBFC67867D547CE8D50B54B10278D9" },
    { "CFTITLE.RAW", "4A943902826E1C2952BA599E4FCADDD2" },
    { "D.PAL", "F3D4BB555BA7923F20D5E65436270E22" },
    { "D.RAW", "DF6B85E6396F8E32067A34C0944AA977" },
    { "DESARMY.PAL", "C85EC39DF39A4DFA5EF14E7F136510DC" },
    { "DESARMY.RAW", "B102A4AF6A3DE2DF3A0C93589B093E03" },
    { "DESBASE.BHT", "79EC0CC208047BA7BCFF50071CABA074" },
    { "DESBASE.BLK", "9F0F19DA13F356E89E74211557B4FF2C" },
    { "DESBASE.HIT", "931BC2ACB018C8DD02AFBF7D63A04E82" },
    { "DESBASE.INS", "550F5EDA26554638CD776CA7F5B896D0" },
    { "desbase.pal", "7CC9B7F479B3D96D6D727C48CFA4AC9F" },
    { "DESBASE.SNG", "B943724BC5B21A8177DF9026C7BAAB39" },
    { "DESBASE.SWP", "CF49E8E2F0F522753EC900D1E840E849" },
    { "DESCOPT.PAL", "C85EC39DF39A4DFA5EF14E7F136510DC" },
    { "DESCOPT.RAW", "1F162966B0EE88F05B5F536C124F5AF1" },
    { "desfgn2.pl8", "AF26F3F16A3D3D4503F2A3963999CC35" },
    { "desfgnd.pl8", "A343A151C4B644751BEA4A46DA9E1E95" },
    { "desheli.pal", "F531809D0BECED820511017804100DBF" },
    { "desmid.pl8", "26F0BD6DCAB291B897621D67167501CE" },
    { "DESPLAY.PAL", "4226A68EBDC6AAA3BDDF0AB9ECF70ADB" },
    { "DESPLAY.RAW", "BD7FE75BAFA670E94B09E81236C08930" },
    { "dessky.pl8", "784C1CBDD7BF70B770B0A5857EF4F7B6" },
    { "DESSUB0.BHT", "9003592A4A2274129D67FA13FC24FAED" },
    { "DESSUB0.BLK", "33A019581548538E328BF6327263FCC0" },
    { "DESSUB0.HIT", "825BFCC75922F87914BA66C3B77BC956" },
    { "DESSUB0.SWP", "0C2EE270602A0A952101B1885A739AC3" },
    { "font.pl8", "20331E3A2140B307F7749207F7A7B073" },
    { "FONT.RAW", "DF00FE92FA66EF15FDFB66A66110520D" },
    { "grave32.pal", "3FCA2FA8A2C0689CFC3517D9C06A0ECC" },
    { "HILLS.PAL", "DCCBC8116A26423B9CADCF2B12E68443" },
    { "HILLS.RAW", "46062533A3A176F8F29C17AD5076394E" },
    { "ICEARMY.PAL", "034F99283628233A2D66A54A36D4D3E9" },
    { "ICEARMY.RAW", "F62DA76B1B2F8DAD9532DDFA6C2E7652" },
    { "ICEBASE.BHT", "D949F094359406551BF5AF66EA9A5E7F" },
    { "ICEBASE.BLK", "2EC17F7962D0C48F5F3FD6934E002203" },
    { "ICEBASE.HIT", "D936D1B1C0069BC34D064FEA5FFD3D7F" },
    { "ICEBASE.INS", "1738B8A58182920E73DC98A0DA65AEF5" },
    { "icebase.pal", "F531809D0BECED820511017804100DBF" },
    { "ICEBASE.SNG", "EEEA051381A5436D8F2F55B76B896BEF" },
    { "ICEBASE.SWP", "B469EE7ADA55E9DD11C6AECBE28743C7" },
    { "ICECOPT.PAL", "034F99283628233A2D66A54A36D4D3E9" },
    { "ICECOPT.RAW", "7D113D1FED086688166607BFD7BB0C85" },
    { "icefgn2.pl8", "35B5F53C573592CD3745E8497C54E770" },
    { "icefgnd.pl8", "5992788B90664D97131528E6B60EDB44" },
    { "iceheli.pal", "2D30AA172BF7525053ADF1702D614B2C" },
    { "icemid.pl8", "1FFB856B883F1A3EF9E82BA581B615C5" },
    { "ICEPLAY.PAL", "7193E6684B62137E3BA04C1031F9FC69" },
    { "ICEPLAY.RAW", "EE989D80F97BA7C9C2C20804125D15B5" },
    { "icesky.pl8", "AD2622E0BFCF7EA531884CA6D1D70FD2" },
    { "ICESUB0.BHT", "FC518045A2CAF8190F637CEA7A738A35" },
    { "ICESUB0.BLK", "70385CC1A59A6653D5E78FF848CED2F6" },
    { "ICESUB0.HIT", "40218776D53C159BE6A05A7A89905CBD" },
    { "ICESUB0.SWP", "425CC1E357EBDAFC4F63FA3E010A5107" },
    { "INTARMY.PAL", "69660F0D11F3FFE8402CA0ECF1BF0CE6" },
    { "INTARMY.RAW", "5B9FC712E930E0B0304092A1CE6EFAE4" },
    { "INTBASE.BHT", "D14567268EFA86FD9B5F05BBE8F98C9B" },
    { "INTBASE.BLK", "6CCFD75384579A3F039B6A520D5D5F9A" },
    { "INTBASE.HIT", "85E5EC0B67E2A352D7A4768ADF1574D7" },
    { "INTBASE.INS", "BF2443679ED1D04E16EAB88F68592840" },
    { "intbase.pal", "13589158917E93F36F2B88973C401FF8" },
    { "INTBASE.SNG", "79854A62DFE2C06DFA9BB6F687215678" },
    { "INTBASE.SWP", "6FFCD0EBEADC6B7C86E7ED9FBEE7A9B5" },
    { "INTCOPT.PAL", "69660F0D11F3FFE8402CA0ECF1BF0CE6" },
    { "INTCOPT.RAW", "D82E50E6D79FE6524ABF71975C35A8EF" },
    { "intfgn2.pl8", "CD1D42304EF400E2C13F8D3777F527D8" },
    { "intfgnd.pl8", "F5EE6AB8835581D182E0FB2AAE171275" },
    { "intheli.pal", "21913E3B4F89DC81CDA083A0FAFD86B3" },
    { "intmid.pl8", "B57D9C9659763A2E0CB8D1DF8EFED406" },
    { "INTPLAY.PAL", "1994BE7FE769D93005A4616158046D0A" },
    { "INTPLAY.RAW", "2B70804828931E8A8E57D4813A9FF68C" },
    { "intsky.pl8", "41BC29DAEFC9B2DF21AEE4A469377F0A" },
    { "INTSUB0.BHT", "86A7EB49C6C18461B57C61C93975FBDE" },
    { "INTSUB0.BLK", "E789A5F957F92272F6DE58E4279AC838" },
    { "INTSUB0.HIT", "83C62F606AB9ABD753415F9D37CB0ED8" },
    { "INTSUB0.SWP", "C0F23A50CCC3CEAE6865F992CAF79385" },
    { "JON.INS", "B9875930A6238B8A8CF6AD18AEB3159C" },
    { "JON.SNG", "FD5B0A4682722E5D2E6E6E39D62B6F15" },
    { "JUNARMY.PAL", "605885BA7D394748786E0705207E9656" },
    { "JUNARMY.RAW", "2C9AD140A517FB705B522BAD2D487218" },
    { "JUNBASE.BHT", "2AC0C1750EFFB74FF512BF6EF3AF142B" },
    { "JUNBASE.BLK", "5E82915723AB220D2529ADBA441D6D6C" },
    { "JUNBASE.HIT", "5F8B2881F144C8DFB1AC2F4E7D7927B3" },
    { "JUNBASE.INS", "8613A9DBA69F495C8074AB29B2FF129F" },
    { "junbase.pal", "6FA6B5CF943FBF32E8A44D4726139DBB" },
    { "JUNBASE.SNG", "3800270DDCA694B85169303B51E35726" },
    { "JUNBASE.SWP", "2C04C7BAF91D0620EF7A120F9402FF8F" },
    { "JUNCOPT.PAL", "605885BA7D394748786E0705207E9656" },
    { "JUNCOPT.RAW", "27CB306A775946DF5634F5576C6A6E30" },
    { "junfgn2.pl8", "62BD4C500C94E1E6DE3D34A4D5176B2A" },
    { "junfgnd.pl8", "6341A7652D5C9EF689013DC429DEAD74" },
    { "junheli.pal", "F531809D0BECED820511017804100DBF" },
    { "junmid.pl8", "21A143BE1469FE57A99BCDCDF7B02FF5" },
    { "JUNPLAY.PAL", "F3D5CBE3D754D2FCF3C6F751CF7D73FC" },
    { "JUNPLAY.RAW", "44FD3C1CD8D1EB546FA7424E5D419FB9" },
    { "junsky.pl8", "D0DECD0757A30190E2CFA010AB205E9D" },
    { "JUNSUB0.BHT", "07A62D69CC087F4F6AEE63A44420D138" },
    { "JUNSUB0.BLK", "C15209ED577BEEF90EE62505D5F324DD" },
    { "JUNSUB0.HIT", "E6E81C980DE70EBA962EA8A1047C71D0" },
    { "JUNSUB0.SWP", "230BEC7FE9C211891D1ECFD3D3D1BEE0" },
    { "KILLER.INS", "A688602F4A0EDB511AA3E28EED8ECBDC" },
    { "KILLER.SNG", "9965268B149E3B1DD66246F7874012AB" },
    { "MAPM1.MAP", "FD318F2860734A700BC7D8BD77408EDC" },
    { "MAPM1.SPT", "1C0DA21FEA32ECF32F89BBC853EC567E" },
    { "MAPM2.MAP", "259AE7CB0DA5D7020D85D650F476BEB8" },
    { "MAPM2.SPT", "9E784B7C7F6D6873D7D36704BD664B12" },
    { "MAPM3.MAP", "DD779E30AD16F3D34B50C87B16D76FA2" },
    { "MAPM3.SPT", "5154D3DD7D12434EF875FFE3CB826069" },
    { "MAPM4.MAP", "C0171F8AC2D2F3D91E34521603535106" },
    { "MAPM4.SPT", "53D70FC4CA999F66D05E447BE42B658F" },
    { "MAPM5.MAP", "DD76871153811E38FD93CC5057C5FA8E" },
    { "MAPM5.SPT", "E30B230D0328F2BED07A5AE24CF74704" },
    { "MAPM6.MAP", "0348FD6EDDADB6AE31B4D98F1C56733E" },
    { "MAPM6.SPT", "AA95FD3285B1BB5DB3B433AD74FC2809" },
    { "MAPM7.MAP", "FA8F3A2A0241C5DDB8725B743388F6F9" },
    { "MAPM7.SPT", "23C1A240ED28113E71468D340BA30F52" },
    { "MAPM8.MAP", "B4D45FF6F84ED886FCA103C4750F15CE" },
    { "MAPM8.SPT", "14B0AA4E553647BD44565CEE7F08B839" },
    { "MAPM9.MAP", "DA4E955957F50C423FCFA9F425B71BE6" },
    { "MAPM9.SPT", "12F7789810A35129E3628E5C64F137E8" },
    { "MAPM10.MAP", "74280478704D19506305C0D637189876" },
    { "MAPM10.SPT", "9BA6541E473F5B7FDCAC1055A01C4F05" },
    { "MAPM11.MAP", "CAC25D2FAA9120FBDF455D90583C6E95" },
    { "MAPM11.SPT", "8B5B519E5222F6BA8EEB12B963AB4851" },
    { "MAPM12.MAP", "D2FD9063F97B381E3875C33C1075350D" },
    { "MAPM12.SPT", "3FB060FEC3519C0831B950074795A967" },
    { "MAPM13.MAP", "563C0AC473277E543544E27C421C6BF3" },
    { "MAPM13.SPT", "15014E381B5643C004D3E0F97EB9C722" },
    { "MAPM14.MAP", "A9F010991CF1593B7DAF542C84BF5137" },
    { "MAPM14.SPT", "0B94513BAB5CB5B839B642ABA3CD022F" },
    { "MAPM15.MAP", "014B61156B26D967BAA83AFF1B2D1DA4" },
    { "MAPM15.SPT", "A2AC4FD5DC7047D4978E8ADFD723E09C" },
    { "MAPM16.MAP", "E683667CA6916F28013E3EA5A9EA3F8C" },
    { "MAPM16.SPT", "128E96AE34CF692238C9EEFD7DDF622A" },
    { "MAPM17.MAP", "F7233C8EAAFC97E01243935A9EF7B6F8" },
    { "MAPM17.SPT", "B8FC3F1F340FBE4BFE1BDB4D11EB3F79" },
    { "MAPM18.MAP", "6CA18AA98B8FA59C9BEA1B4A32B6E95A" },
    { "MAPM18.SPT", "F7A7DFF5F08EF80A251E63184DCDECCA" },
    { "MAPM19.MAP", "1C13886A4C70EA46F9EFAB4C621017D9" },
    { "MAPM19.SPT", "47E85C01DE84245E6D716D9BAF837FE4" },
    { "MAPM20.MAP", "C124D52FCDD94C618090904891F195EC" },
    { "MAPM20.SPT", "51044ACC633D63AF9D278B1948857E3A" },
    { "MAPM21.MAP", "31B5FAD4AFB2E82F50E5FA237801B1DE" },
    { "MAPM21.SPT", "45DEEE1D0F2CC0D0F9B7EAED3B93FC4E" },
    { "MAPM22.MAP", "27AA6AAFF1A3C68B1B2B2ECD75CCFF58" },
    { "MAPM22.SPT", "CDD129EA3B02A6CE1E25134DEE397495" },
    { "MAPM23.MAP", "DAE37C3DBA4D4E777E71B70306DD0D00" },
    { "MAPM23.SPT", "6B33E768103D936B32C57B8B2FBB2188" },
    { "MAPM24.MAP", "86B6DCF5AD3529E1AD94BE6F8FBEC7A6" },
    { "MAPM24.SPT", "3DE8928C3B947D258879C206CC38B1CE" },
    { "MAPM25.MAP", "2C0DD2875882FB0691FCA85AE53A4514" },
    { "MAPM25.SPT", "24FF98618F76C914B41A93DEB1CFADD0" },
    { "MAPM26.MAP", "656B4EB92A10D98D14192AF47EF8E7AD" },
    { "MAPM26.SPT", "49791E880855AB87F74E68109045FAC1" },
    { "MAPM27.MAP", "CE7144F203A2415A58C7E1AFB0A11E07" },
    { "MAPM27.SPT", "4C18A3A91080793ADFCA9DA5AA6F4052" },
    { "MAPM28.MAP", "A0FF5EA7A07D01298EC922CFCE8BCAF5" },
    { "MAPM28.SPT", "BCE1D429152C5D06757627C41E34160B" },
    { "MAPM29.MAP", "157805241E8F31655B7E71E839FDB7BA" },
    { "MAPM29.SPT", "33892DF55E45BBD7F9645B0044F2355A" },
    { "MAPM30.MAP", "BF9240CFACA76A9BE7BBAB0FF255B9FE" },
    { "MAPM30.SPT", "97E8E52C13E7CC3FC99C70C39BD6342A" },
    { "MAPM31.MAP", "CC7A926C20688A0F69D95C8952DD4325" },
    { "MAPM31.SPT", "A64D944CD68F6C12164DB7823C5D5F92" },
    { "MAPM32.MAP", "1B45A845B9DA58BBBAD8A7A8969F3883" },
    { "MAPM32.SPT", "C74CCF396029706298EF231367291C81" },
    { "MAPM33.MAP", "7404E27D525E3702DDE128815F635F79" },
    { "MAPM33.SPT", "35D21FC9EA063C08BD0B5EB462E652F0" },
    { "MAPM34.MAP", "EC0F2490FD89C04470E97773D97E6A4C" },
    { "MAPM34.SPT", "E6FE42D339F6280EBBA5891A8CD4EB2E" },
    { "MAPM35.MAP", "33E3398F8488781A878D50F9F7007F46" },
    { "MAPM35.SPT", "DB3747B798D5014854D37079DA395CF3" },
    { "MAPM36.MAP", "9E2F19C5B55781EDF606B9BACBB9B5A4" },
    { "MAPM36.SPT", "FF51F8F291B7068D771A44A0820B8626" },
    { "MAPM37.MAP", "4A9C5EAEF87A13700DCCE2A3FC5A2DDA" },
    { "MAPM37.SPT", "6A35DE274B6060C1ED4E0A6D5BF05478" },
    { "MAPM38.MAP", "9A3400C99DD5D39C8690B9A28BEDB5A8" },
    { "MAPM38.SPT", "3CF324EFB32FCA453AB23EF8948DF2C2" },
    { "MAPM39.MAP", "1F11C119A60AF18539E396096FF02E67" },
    { "MAPM39.SPT", "38B805CD10357482BCE7A3B466402E9B" },
    { "MAPM40.MAP", "90F2FE8BB28D04CB5355036426614561" },
    { "MAPM40.SPT", "09D1FE29A1B1CE9E8508C9B9EBE508D6" },
    { "MAPM41.MAP", "2495D6FD179616E4FA33B3638C250493" },
    { "MAPM41.SPT", "9AD408EA0A7DA3F0C1D3EBB3DC51C954" },
    { "MAPM42.MAP", "8A8D8468F8E4C0E755B60FE786FEEA8E" },
    { "MAPM42.SPT", "B0312DFD78C6728B6F684DD5FB85399D" },
    { "MAPM43.MAP", "5AEB4C45E20F3F783C8807330DFD7D7A" },
    { "MAPM43.SPT", "42D6C22F8BD1018D951723905E4D63B4" },
    { "MAPM44.MAP", "4A146AAFC8C5EFB4B2EF214C2CAC2E18" },
    { "MAPM44.SPT", "B7D4329761FD49033D3A55F516DDCAAF" },
    { "MAPM45.MAP", "F8811FE571EABF6EEF26F74D415A50D6" },
    { "MAPM45.SPT", "DC2FFFF15DB520EBA4BFC1851119488E" },
    { "MAPM46.MAP", "9146BFEF37795A43A2F66C637391965D" },
    { "MAPM46.SPT", "E372FB6F662DF606ADE930346D102AAB" },
    { "MAPM47.MAP", "C8AF0AE61D2B24F1005FF34F4E4B4BE0" },
    { "MAPM47.SPT", "FCC93C7878ADC8D7E8F9B3E800005004" },
    { "MAPM48.MAP", "2C1F8BD95B71CE38B9CAE3E256A34D4F" },
    { "MAPM48.SPT", "D96D2A8A8AD9469EBB24949360C31D6C" },
    { "MAPM49.MAP", "0077A06014D41063A8318209BBBE8CBB" },
    { "MAPM49.SPT", "A147D6A494242B7D7489027B80E05256" },
    { "MAPM50.MAP", "146909A6D47B49036CE2A3CAAAB0904D" },
    { "MAPM50.SPT", "2FC173374FCF640A38EE4F958B006295" },
    { "MAPM51.MAP", "E2A68D802D41D20FD2F0A33C28AEC4B5" },
    { "MAPM51.SPT", "DC2C1CF37B442FA370B7EF51544E6930" },
    { "MAPM52.MAP", "CA813BA715890B1AD5FCD2F4150EAAD0" },
    { "MAPM52.SPT", "9C95B815D6C6CA39A49D7FFD181750D1" },
    { "MAPM53.MAP", "4450F60D40DFACAC8B9A24E1F213F771" },
    { "MAPM53.SPT", "0BE453A15E78520C16B2F7E6110FBC21" },
    { "MAPM54.MAP", "8E24126C0729875D72AF4EA1108F93BF" },
    { "MAPM54.SPT", "2865576DE3E635F8CBC6172DC863A43B" },
    { "MAPM55.MAP", "796B964F5CA05AE556BE2CE8E28E0CB5" },
    { "MAPM55.SPT", "0D31AF5D45689FA0C0E54732373CDB80" },
    { "MAPM56.MAP", "4311991B8E06831C8329FF77E8E62D3D" },
    { "MAPM56.SPT", "92046174E47803B7BE6F075FE0BA37D6" },
    { "MAPM57.MAP", "7A82524334B169967F89B468EFE78D7C" },
    { "MAPM57.SPT", "0F6747D519C8F923AB492984340DDDCB" },
    { "MAPM58.MAP", "80CC1E9C435E0FDBEB0DA328F2DC8975" },
    { "MAPM58.SPT", "AEED1BB46E17911438D097EFD2AD69E0" },
    { "MAPM59.MAP", "45CEE0C32625AD05EBDE8B36F9C156ED" },
    { "MAPM59.SPT", "BF7577AE5FEFC93777E64D6F07795D0D" },
    { "MAPM60.MAP", "A2BC098ECE02D1E8E096CDD0CD6FF59B" },
    { "MAPM60.SPT", "114912401167F2DCDB1577E315629F80" },
    { "MAPM61.MAP", "12BB9A691F668CF5AB81391F968045D0" },
    { "MAPM61.SPT", "56BC62F3249A7B6E48E59C1D00B444CE" },
    { "MAPM62.MAP", "E9832C159B2AEAF1B9881E2308E13C3D" },
    { "MAPM62.SPT", "F4F6030535C8C723E8F934E23AFFC842" },
    { "MAPM63.MAP", "F2D24EBFF7424EAAEA774632AD86A0FF" },
    { "MAPM63.SPT", "4519E68B00CAC278AFF627D00A6473D1" },
    { "MAPM64.MAP", "AF119CD9A2936703F327F873D6FC2FA3" },
    { "MAPM64.SPT", "0499955E017D2A9C9C6DE2544D8A01DC" },
    { "MAPM65.MA1", "33C5399BA5A98E48C78D817B015B7C0B" },
    { "MAPM65.MAP", "33C5399BA5A98E48C78D817B015B7C0B" },
    { "MAPM65.SP1", "70E8789A001A35410A3DB7842A57D5A4" },
    { "MAPM65.SPT", "EC6B1E93D726D467EE7BF87AC4ADFBB1" },
    { "MAPM66.MAP", "B1C2D6940DE1D7AD80BDC4AACED2C2D8" },
    { "MAPM66.SPT", "9DCB1D32245BAE413301AFDB2BB49922" },
    { "MAPM67.MAP", "19CC8C0BF26394949A1AECF2A21C4C08" },
    { "MAPM67.SPT", "80F248DA84BFEEAD92E77AF7C65C7415" },
    { "MAPM68.MAP", "F5E39530B48880D5581FC4CE13B2D679" },
    { "MAPM68.SPT", "DB5F432D018EF24BD3A279A3DFD944FB" },
    { "MAPM69.MAP", "4D7984EF750B551377BBD96FDE14038B" },
    { "MAPM69.SPT", "8771DD712C7E66E1DF733B2BD6B324E8" },
    { "MAPM70.MAP", "7BAC80A15EEF425A8F37401FD772FE30" },
    { "MAPM70.SPT", "97C6FD22CF70A358C4982A06A765C5CC" },
    { "MAPM71.MAP", "91DFDCC594ECE7E297CDDFEDEE33D755" },
    { "MAPM71.SPT", "0D122B5F460B93B312C30251515AEF94" },
    { "MAPM72.MAP", "FD2FE44D09A2AD45B3853DE0A97D0FC0" },
    { "MAPM72.SPT", "C64C9C3C988B3465C36C9317E2843625" },
    { "MORARMY.PAL", "8D3A4C9C96324FA1907F1705F4EEC2F0" },
    { "MORARMY.RAW", "C3E44F95B9EDAD02F8F544FE7334F207" },
    { "MORBASE.BHT", "0D4DEB23F019CDC5C9857FB2CFF67BE1" },
    { "MORBASE.BLK", "1F2B98CCD789723FC07C1FFA689AEDE0" },
    { "MORBASE.HIT", "19C01E1A4F4717C9339363DAEFA0019F" },
    { "MORBASE.INS", "9F0B5C58131F00B9CAAB59473C810FE2" },
    { "morbase.pal", "8376375AAD2157C9D615410598A29FE7" },
    { "MORBASE.SNG", "3068803B805BBD5FBD2015A204049044" },
    { "MORBASE.SWP", "D75075F3ED68D03A7F41B8458C579D15" },
    { "MORCOPT.PAL", "8D3A4C9C96324FA1907F1705F4EEC2F0" },
    { "MORCOPT.RAW", "E81F0B841254EEEE6E737CDE5FE6B071" },
    { "morfgn2.pl8", "92B2D26F7234286774D879782DBA90EC" },
    { "morfgnd.pl8", "431A05EABCD4D878C99D636FC7E6E5CC" },
    { "morheli.pal", "21913E3B4F89DC81CDA083A0FAFD86B3" },
    { "mormid.pl8", "F5759A0E20BD555D1546EAA46BFEFF93" },
    { "MORPHBIG.PAL", "FF9AE44526048D7E33169972BBE417BD" },
    { "MORPHBIG.RAW", "3F3D7520098CDA91906BFDB9E840705B" },
    { "MORPLAY.PAL", "93BE1F30D84A0F4CE860828DB1ECA292" },
    { "MORPLAY.RAW", "0134C1743757BB9D9C7E568113706ED1" },
    { "morsky.pl8", "C71BCE23A2A85C51BBDB681CDAF51C87" },
    { "MORSUB0.BHT", "4FBDCC43CAECBF5101C961129002402E" },
    { "MORSUB0.BLK", "23FB9D12B93CB19E241E1699AB5AEE99" },
    { "MORSUB0.HIT", "84B920297370AB925D6DEE34EE363648" },
    { "MORSUB0.SWP", "18F18C72E32EC34F05219F94EC752765" },
    { "PSTUFF.PAL", "E23D3946DE0B8CFB13D4E9051A8EA35B" },
    { "PSTUFF.RAW", "713A1241AB6B54657813BB047978DB2D" },
    { "RANKFONT.PAL", "450F0F57A428F86CB840DB7E3524695A" },
    { "RANKFONT.RAW", "8C6DF07E3F81463F9FDF5DCF4672DD37" },
    { "SENSPROD.PAL", "A366F4656A325912EDB432669F418734" },
    { "SENSPROD.RAW", "D1EEC3421E2FDE1770027EB628EB19D9" },
    { "VIRGPRES.PAL", "4AE209E7100394C4403115C4C501A958" },
    { "VIRGPRES.RAW", "AAE7706D8F7F6BE0B2FA4BF7C49D4D8B" },
    { "WON.PAL", "B357D789C17FE93392C9D2A89D1CC295" },
    { "WON.RAW", "457CFDD38D2760FB2D5096EC240B0AB9" },
};

// Amiga: CD32 Release
const std::vector<sFile> mAmigaCD32Files = {
    { "1.RAW",	"2F00447802B86510784ECC8D1134C942" },
    { "2.RAW",	"540BA4FAEB4F8CE75391EF4ED2CDBA6A" },
    { "3.RAW",	"4533919895685A4AE9D0A6D6E0DEE2DF" },
    { "4.RAW",	"4345942CFF1477A075024F1E39C4DE9D" },
    { "5.RAW",	"2FE63C2D4607BE2EDC59AA33E6A79678" },
    { "6.RAW",	"CB9F7DF63AF62943F3C54A43A26BEB21" },
    { "7.RAW",	"9DA3438B683276274941720CFD949053" },
    { "8.RAW",	"E55133FF1B7D53D0D0FE52DC3D1D907E" },
    { "CFTITLE.RAW",	"0BDEBDC8A9693C289A2EB1C8D5CA63E9" },
    { "desarmy.lbm",	"6E20EC4F2361EC5E2AF1AD7801607B90" },
    { "desbase.bht",	"7DBD1FF9EFB89C85EEF91CE68B0F6C4D" },
    { "DESBASE.BLK",	"89AEA1251756F2D0AB770B71A998E63D" },
    { "desbase.hit",	"1B90B2C0213541AB2A7828C3EE033D96" },
    { "DESBASE.INS",	"F786A62F8050FAD8F3D7583FC7D6B7EE" },
    { "desbase.pal",	"0EFBECDB69D7FF6F95E147B6C38E5607" },
    { "DESBASE.SNG",	"83541523FFD2AD12AFD7F98E53D4203A" },
    { "desbase.swp",	"D63F1CE753077B74A5F543DE8CC37209" },
    { "descopt.lbm",	"C51CB1A3AD430D309B389C92839B63CA" },
    { "desfgn2.pl8",	"AAB7E80C2F38D183081224070CA5D596" },
    { "desfgnd.pl8",	"A343A151C4B644751BEA4A46DA9E1E95" },
    { "desheli.pal",	"21913E3B4F89DC81CDA083A0FAFD86B3" },
    { "desmid.pl8",		"EE7745F6B5711B8EF7D653400C13AA1F" },
    { "desplay.lbm",	"6976107F99E8509C6569DCE432C55472" },
    { "dessky.pl8",		"784C1CBDD7BF70B770B0A5857EF4F7B6" },
    { "dessub0.bht",	"6FBF3782A8A16DECBAF3E34ECA5C6701" },
    { "DESSUB0.BLK",	"C1B808192E53C314980C4CF03F1196FA" },
    { "dessub0.hit",	"02079C848FB86EBFA87FC621A1BAF20D" },
    { "dessub0.swp",	"3659C67526E293D2F134234B53069244" },
    { "font.pl8",		"20331E3A2140B307F7749207F7A7B073" },
    { "FONT.RAW",		"DF00FE92FA66EF15FDFB66A66110520D" },
    { "grave32.pal",	"5DD21FA5759C74D26363BAB1CE08321D" },
    { "hills.lbm",		"1411AACCEC4B4605CE664D18C0EB738D" },
    { "icearmy.lbm",	"D998F6677275711FD56C0027504F8BCF" },
    { "icebase.bht",	"C896E00F924B40780094202F7435D99A" },
    { "ICEBASE.BLK",	"EEDF2742BA789E29E23A0F00D749164A" },
    { "icebase.hit",	"DC376A162D23E763AE308D1EA877860F" },
    { "ICEBASE.INS",	"A98080C06B186461FAEED944E540CEFE" },
    { "icebase.pal",	"7EA341E95E1974422106E040F20F9DF2" },
    { "ICEBASE.SNG",	"BC82E70E22DE7A66448AA5CA852A31D5" },
    { "icebase.swp",	"49BAB52FC9F634ED0163FB17CD9EF027" },
    { "icecopt.lbm",	"408D680145CB92BD9D851462D31BC1FE" },
    { "icefgn2.pl8",	"996BB60A8D8962C81A3D5237F1DA8C1B" },
    { "icefgnd.pl8",	"EF37E499906F6C33C601A4F5C598079E" },
    { "iceheli.pal",	"2D30AA172BF7525053ADF1702D614B2C" },
    { "icemid.pl8",		"6ABCCDE1D22965D54612EA18B2B664D9" },
    { "iceplay.lbm",	"D07952805584A1195049E58C6CB8A948" },
    { "icesky.pl8",		"AADBAB45A7878D40AB427E2DA89BBE29" },
    { "icesub0.bht",	"7DDD2F85761C8D243E9737FAAE31A234" },
    { "ICESUB0.BLK",	"4234FCFACDEFA50A5F76BC60BC39E7BC" },
    { "icesub0.hit",	"C54F4B86420271D5B4D3013700EA0C44" },
    { "icesub0.swp",	"1459837D4F3D5E96209F7F781988B854" },
    { "intarmy.lbm",	"2782EC87708BEC4CB3C8E552428FB157" },
    { "intbase.bht",	"78009ED2010DC94E18316B1486A916C6" },
    { "INTBASE.BLK",	"627CCC83737AAE16AF5353BA5556F799" },
    { "intbase.hit",	"2D899A1689858558C16596F48AAADB64" },
    { "INTBASE.INS",	"5639D17E6724488BA77E24DCC3BE869A" },
    { "intbase.pal",	"F7ECD7AFDFF722214BD3361386279C89" },
    { "INTBASE.SNG",	"B49AFDA5EE1AA0DEB106DC7CD8D247BA" },
    { "intbase.swp",	"676739A5A800B24951677850DE407052" },
    { "intcopt.lbm",	"4A9860049923AF09FEC0932592E976F2" },
    { "intfgn2.pl8",	"6E6DE3D59C8DD0D63E671591A20F6804" },
    { "intfgnd.pl8",	"742DC99D7D1B901D46AD7DC868907776" },
    { "intheli.pal",	"21913E3B4F89DC81CDA083A0FAFD86B3" },
    { "intmid.pl8",		"46F0F1CD0E01DFFAF9D2AE245D3374BB" },
    { "intplay.lbm",	"9C9F0516DF10164B995B171FD777350F" },
    { "intsky.pl8",		"9ECB00FD609A624D449C7EB99301BBFC" },
    { "intsub0.bht",	"45621B2A6EB37A2907767D1D5903DEC9" },
    { "INTSUB0.BLK",	"D8E8F106648D1D3B7BDF6D1CA3753905" },
    { "intsub0.hit",	"C44E7E4BFBF2E94655B5900A05E54DFC" },
    { "intsub0.swp",	"CB1DBA7D0009538701C00F50CAA0A2D8" },
    { "JON.INS",		"B4E1B5C2980A4DC1A3A91E7F8C68C68F" },
    { "JON.SNG",		"34C83D7DD0F429EB8BF436C1037DD6A9" },
    { "junarmy.lbm",	"F67D7D3C2B96A588BFB0AAE33FE1E186" },
    { "junbase.bht",	"91AE45498B1E72AB8C147890CCFA1F15" },
    { "JUNBASE.BLK",	"B1023928A64C59D8F49CAF7E28A17624" },
    { "junbase.hit",	"D49E276228C93539C12857D18568CFAC" },
    { "JUNBASE.INS",	"BBF9C7852AB0EF958496642B15D39BB1" },
    { "junbase.pal",	"27DA36F06898A9549A1E4AF4CAC4D8B7" },
    { "JUNBASE.SNG",	"B96327898322E13315EA9B1BFCE4D527" },
    { "junbase.swp",	"D07A8EA9D22C37F7252993AA9B941427" },
    { "juncopt.lbm",	"44BE34CE48631669760CE3439C44DBF8" },
    { "junfgn2.pl8",	"93DDAFDE77A0A69420FDF690EB19AFE8" },
    { "junfgnd.pl8",	"6341A7652D5C9EF689013DC429DEAD74" },
    { "junheli.pal",	"159FE0477094B6DE51D71A977A5E4AED" },
    { "junmid.pl8",		"19F1ACED260C1E6F481AD064AF7CC31F" },
    { "junplay.lbm",	"27EC1DEB8BC5B6FE4CC47144DC344E60" },
    { "junsky.pl8",		"CC35E8634CB2F72FB3220F0378FA41AA" },
    { "junsub0.bht",	"4803076EB9656961B23DDDD31D9683BC" },
    { "JUNSUB0.BLK",	"17DAA7C0CDCAFC5095B1118EBBAE6963" },
    { "junsub0.hit",	"AB61F44685F9C025C27422819C0F46D4" },
    { "junsub0.swp",	"AE0181B3EE4997C67F89B5A6E1FA685B" },
    { "junsub1.bht",	"E4373BFC0E241714C61FA77DAA9E5A19" },
    { "JUNSUB1.BLK",	"BA57F9ECDEB89DD3E27588BA2D1D540F" },
    { "junsub1.hit",	"7C7603BD2ADFFC57F514A504D1867FD1" },
    { "junsub1.swp",	"F4804ABDD08599E1AFEA6E14ED30863C" },
    { "mapm1.map",	"87CFEDC0E35228FE3FC6A8115714671F" },
    { "mapm1.spt",	"9363F391620A6CE069F72BA36BB56C83" },
    { "mapm10.map",	"0249D6621BE91724EA42B5009649A927" },
    { "mapm10.spt",	"67B47EA4940B3A992A4B88EE243FF477" },
    { "mapm11.map",	"9AACDF92D838AFDEF2A6D0E84AC63171" },
    { "mapm11.spt",	"81C801E7F15C0A4A5069E320049D7598" },
    { "mapm12.map",	"30F13EFB9491BC2C87FEB933ED4E1C32" },
    { "mapm12.spt",	"EA6CB4B5455796F7C0FD7B98E57BA8A5" },
    { "mapm13.map",	"83DF412981AB0FAE7E81D5540E3BF9BB" },
    { "mapm13.spt",	"1D58DA489B23A90CCE59F2223112304C" },
    { "mapm14.map",	"588976C8C9DD6B1E230FFE9EDD483422" },
    { "mapm14.spt",	"6927DF8B1857C592D92ECA3C6C404895" },
    { "mapm15.map",	"08D6F085A46275346ED368CE85A3ABB5" },
    { "mapm15.spt",	"30A540544787A4E7316550CAE2DAEBE4" },
    { "mapm16.map",	"9DE544AB20328243D5D7BE377B22ADCF" },
    { "mapm16.spt",	"1C0F82079ED39EB5FAA5239DE9336437" },
    { "mapm17.map",	"56BC8A7A24B0E40B997E457392DF7557" },
    { "mapm17.spt",	"9FBEF790F49274752C1E0DD4A7865769" },
    { "mapm18.map",	"83BF5512CC08EEA27F960D181CB547F7" },
    { "mapm18.spt",	"F1A3307D7312D23F32DD260A0A660C46" },
    { "mapm19.map",	"75FA184B8C04CB62E7B3A266E7ED0C2D" },
    { "mapm19.spt",	"F1B55CCDDC3FE33CCAE6B584FC395E5D" },
    { "mapm2.map",	"BFD5C98299D6BCAD35C05EDCC21E2B6A" },
    { "mapm2.spt",	"85E5488C763E1F27F03BA5222EA6B0ED" },
    { "mapm20.map",	"26E8414699A942DD4BA570C7E057DCCA" },
    { "mapm20.spt",	"1AFD66AA9BFBB67D77C0D516E07979BE" },
    { "mapm21.map",	"E9D88E934E586C8F04F92DE63E0FD217" },
    { "mapm21.spt",	"1557B44DCCC70573CE264B299485BF17" },
    { "mapm22.map",	"FD8D578D2B6707CA85336A99D4CBB961" },
    { "mapm22.spt",	"D9636125D5C38022D98EB3522D4A30CE" },
    { "mapm23.map",	"76E47CDF17AD4E7F897CCC9F06302BD9" },
    { "mapm23.spt",	"50465FF35F7C9AE530DAF6080D3A4EDC" },
    { "mapm24.map",	"F42697404B27F5718C6E11792293CEFD" },
    { "mapm24.spt",	"FCE2966FE1D8BA8865F2DCA709481E24" },
    { "mapm25.map",	"E3397B21A1F2B89AC939589AC51CCC8C" },
    { "mapm25.spt",	"A614496AB7AE932B5DD2756466CAB415" },
    { "mapm26.map",	"237E2D5DA9097CD9DF44DAF4B2D9E7D7" },
    { "mapm26.spt",	"3BFB3A08366B10A4C23AD8054B4CCDD9" },
    { "mapm27.map",	"13500D082D6674EF8AD62380C7F37EFD" },
    { "mapm27.spt",	"3BCE6C34EE3DE7CDCA1D49BA9AC181DF" },
    { "mapm28.map",	"E30CA20BDBCCD041B5D648AA25F90D2B" },
    { "mapm28.spt",	"05CCCE033154982B3820FE907B4DF4A2" },
    { "mapm29.map",	"249F80C064DA3C749529775C1B6DE6DB" },
    { "mapm29.spt",	"3C762E5286BA3FAF845E29DB455A29E0" },
    { "mapm3.map",	"0338E1163FC61D5033B1730DED2C7E9A" },
    { "mapm3.spt",	"B70E042F02CF17986223E935BEEFE698" },
    { "mapm30.map",	"0818B093C13C14D1A08D8A22EBA12DEA" },
    { "mapm30.spt",	"A59AA6A87F8A2C25176AC4CF7A952C56" },
    { "mapm31.map",	"A15CAB7A4429B45550B5F807BEE17139" },
    { "mapm31.spt",	"FBFD9BF5CA7FE1B353F300739E4B89D8" },
    { "mapm32.map",	"A0FEEA41BCDD44502ACE29B0D3B678D1" },
    { "mapm32.spt",	"87E83FBC6B72846666AB61246D42D790" },
    { "mapm33.map",	"44AC7495D20AB2F9F71E7AA641DD2763" },
    { "mapm33.spt",	"AB9EF2E58F0D052AAEBF09B8D9FC4555" },
    { "mapm34.map",	"1BF79B2F821365586FD3A0EF6FAE8746" },
    { "mapm34.spt",	"54ADA3E4D5B8519D277D5C0DA1988B0D" },
    { "mapm35.map",	"47B9D9400454BA2EC101AFE3D2E6C158" },
    { "mapm35.spt",	"C94BDE0F65082BAA0E398CECCBDC17DA" },
    { "mapm36.map",	"22617DDB6184D707FC51BC24B4BDFCAB" },
    { "mapm36.spt",	"856B5F249B2B907077C326EEAA31C072" },
    { "mapm37.map",	"1D2F6C95F87CC7F4ECFF4DEEBEA8464E" },
    { "mapm37.spt",	"70D5529303250520AFC235A3FAD06198" },
    { "mapm38.map",	"F973679325C690160E0688049279AEB0" },
    { "mapm38.spt",	"D68BCC332C9533342CAC59987E80069B" },
    { "mapm39.map",	"1B8FFE6130055C7F8C1A923E171D1BD9" },
    { "mapm39.spt",	"C8C1D44B54438B1C53598FAC6A875C70" },
    { "mapm4.map",	"888FA41C0108A002CA689C17E5824D68" },
    { "mapm4.spt",	"FB66076B935AA5790357E6B826C63D05" },
    { "mapm40.map",	"6F3C062295A7CFFE37D8F5ADCC192BBE" },
    { "mapm40.spt",	"226DFF3CB2B6356BF89EA757FEE18DF7" },
    { "mapm41.map",	"96DDC8D0B6D3CD82754D15337F1A8371" },
    { "mapm41.spt",	"7F80ABF519A9212B0299D41D11270FE9" },
    { "mapm42.map",	"26FFF77E96DF989EBEE95396A322AEEB" },
    { "mapm42.spt",	"2FB8016EE02ED9D0E2BD96AAB2201854" },
    { "mapm43.map",	"04E3FCC880BA41EF3D661F04BF0BA3B2" },
    { "mapm43.spt",	"05DFAD6C1AA019EB72BFAE876DEED236" },
    { "mapm44.map",	"70AFD59D7E2D04D019D059F684F33CB8" },
    { "mapm44.spt",	"7D2E1A248DC43D297F5350B7A75526F8" },
    { "mapm45.map",	"3550423155A252C0B0DF348B66E84962" },
    { "mapm45.spt",	"72C300FE0049340BEF058F29C7DE0365" },
    { "mapm46.map",	"8E4CB53449163B4C035D372F4AB0FE53" },
    { "mapm46.spt",	"48DEAA4F058862025BC522BEF8877A4E" },
    { "mapm47.map",	"099A09E90331A674AE2CC17D4A14B127" },
    { "mapm47.spt",	"6BBCFBE72B4983C53A262096F93036BE" },
    { "mapm48.map",	"0DE73FC8B2FC6E1F9C7802FC4616674C" },
    { "mapm48.spt",	"33924B560BF0A23FF6524857DAFA83D1" },
    { "mapm49.map",	"2E3969EF5B1F7AFBB753A7EB31541318" },
    { "mapm49.spt",	"D3FBE2D7546DBEA57D9E442C5A23A397" },
    { "mapm5.map",	"5E8A8B47D967D9C88C04641B1D8CBCEC" },
    { "mapm5.spt",	"CF2B3091B2E53042BA18F7AEFEA6E77E" },
    { "mapm50.map",	"AEF2A6B134C3DC589FCE6467D5BEE613" },
    { "mapm50.spt",	"7D336918CEB91D7DBC46A7580B85DF4F" },
    { "mapm51.map",	"3070E54E04C3FAE83767C3C72C39AB6D" },
    { "mapm51.spt",	"6A463306D48DE011359CAE0184451628" },
    { "mapm52.map",	"58FC41C65DBDC2F2686E3DBA92E4CBE1" },
    { "mapm52.spt",	"39149BC04E1CD7E7A58C16ED5D7154FC" },
    { "mapm53.map",	"80FF3FE22C0280634F25273938C4227E" },
    { "mapm53.spt",	"4096775C0AE5BEF068A50BDE33B1B555" },
    { "mapm54.map",	"DCB661ADBBF868C9557ABAABB523B007" },
    { "mapm54.spt",	"0D2FEC9E890584B6B0B42A7AC7A0003D" },
    { "mapm55.map",	"2D67F46A4BA41902CFC787C552DB554B" },
    { "mapm55.spt",	"2F94BFF8B9F0227AA611367710342C0F" },
    { "mapm56.map",	"9DC185057091C9E611E4C461625DAC20" },
    { "mapm56.spt",	"8CD2D33B779A8226DBAFBB2FEA1C5FE5" },
    { "mapm57.map",	"9DFF279E5904D5CFF201C7CB39A7E697" },
    { "mapm57.spt",	"1FB22FF561DEE32CAC432D67BE9368B1" },
    { "mapm58.map",	"334E8C2C1EAE6E99D29213F27C19706A" },
    { "mapm58.spt",	"B711D11EA40FEB4C7C64B1D92E2732EF" },
    { "mapm59.map",	"1826DE04606F2257DED0F5B009BC0FC9" },
    { "mapm59.spt",	"CC87EC1B714B13C8DFA716F29EDF9088" },
    { "mapm6.map",	"C2DC1784ADE8A3818FB031159E395014" },
    { "mapm6.spt",	"EA45BD73E655E982C7B12E11A4CE7507" },
    { "mapm60.map",	"5764F806A19670734699534B3DCD42E7" },
    { "mapm60.spt",	"51E1447FDDA120C414F9432C709E8460" },
    { "mapm61.map",	"69926D0AC87B9325300E920BFB962140" },
    { "mapm61.spt",	"77E3DE1F0B266C237EBB83B19AF8ABD9" },
    { "mapm62.map",	"BE188016E2DD05F6C671A1BD616D15E2" },
    { "mapm62.spt",	"1F3342FA6A0EF5631FDCDE7BCDE0D7A5" },
    { "mapm63.map",	"B3BC25BA6FAB70D95CA3EED66674F56D" },
    { "mapm63.spt",	"64B72EC4366E2FEF84A4E317DE54EECC" },
    { "mapm64.map",	"A0C888D26882BAB5B2CAB1F6C582610B" },
    { "mapm64.spt",	"FE858138E27CC0F75EE51C8CBBC4C7FF" },
    { "mapm65.map",	"BEFC6E4A7269BFEA1A4E98E8AC858CD5" },
    { "mapm65.spt",	"3D298C2FB7966C8035634051B5EFD170" },
    { "mapm66.map",	"B0E47F3F1C2A80EBB30D5DBFC58D3D90" },
    { "mapm66.spt",	"9222B6481597354CE4A15027B0D287A7" },
    { "mapm67.map",	"E4AA847974367B2DC2A25CE34D66AEDD" },
    { "mapm67.spt",	"A3C59E08649D7F78689C3FA74E64ED13" },
    { "mapm68.map",	"05C70402A051DEC7C476168A51FFD223" },
    { "mapm68.spt",	"9727CE0DCCBF72736082F390B059B669" },
    { "mapm69.map",	"60A765ADB3AB58B89051B3B8729A5DFC" },
    { "mapm69.spt",	"D8CB71B1231BF7EFF466673666444721" },
    { "mapm7.map",	"ACC9CBE4A6C4ABD62721B706D39B03AE" },
    { "mapm7.spt",	"71618692E2F2F087D2AECE67E643575E" },
    { "mapm70.map",	"6B2C02F29F986ED88335406603F80658" },
    { "mapm70.spt",	"5E3574665AD8064B74B06D84D2396625" },
    { "mapm71.map",	"A4EDE77A00634BCDC2A526D5DC3EAB9D" },
    { "mapm71.spt",	"94FCCC5DEE72A1B8E0B31D60F6FB8433" },
    { "mapm72.map",	"65F8FF7E214408056158040790F7CF52" },
    { "mapm72.spt",	"B63F6C9877D868025E7B097A13B3F2C6" },
    { "mapm8.map",	"0BDCE811AF3A847A9A1FE36C4DAAF958" },
    { "mapm8.spt",	"F4D89F63802D1499112F2C9E15B1B2AB" },
    { "mapm9.map",	"633FC6B3B68C6AE4EDD2F04AE01B7B78" },
    { "mapm9.spt",	"B8BC1235DFBF3B1FFC9C690E482D29E7" },
    { "morarmy.lbm",	"D4C26CBC51831989D14E7F8800A244B3" },
    { "morbase.bht",	"101778281E4BF9E895747D5ADFDDF713" },
    { "MORBASE.BLK",	"63C071D813DADB06698E17F6C69109FC" },
    { "morbase.hit",	"88D4B6F6CC22D2FB079B1FDCAECEA853" },
    { "MORBASE.INS",	"F35199AA121B4726CBB3C083D02C23CC" },
    { "morbase.pal",	"11707A9B16854E4F837DE5339956C76C" },
    { "MORBASE.SNG",	"F8AC4FBE0DA3EE886014073D99FB6D4E" },
    { "morbase.swp",	"3F0C27B6D245D281F1CC2A9649E3496B" },
    { "morcopt.lbm",	"B34FCED0AE047064CA8188F0D1ED4F1D" },
    { "morfgn2.pl8",	"92B2D26F7234286774D879782DBA90EC" },
    { "morfgnd.pl8",	"431A05EABCD4D878C99D636FC7E6E5CC" },
    { "morheli.pal",	"21913E3B4F89DC81CDA083A0FAFD86B3" },
    { "mormid.pl8",		"6D866F0D805946D10AF69685F6F77498" },
    { "morphbig.lbm", 	"5251D2E85C658EB460C1BF2087DEA290" },
    { "morplay.lbm",	"8CB3340414CF5D3AA0AC4CF115D8B452" },
    { "morsky.pl8",		"469EDCB987F33163B11903A3B85A8874" },
    { "morsub0.bht",	"E6561BBB836B98EC0D226D5A29C57E55" },
    { "MORSUB0.BLK",	"EA8F0B8D2DADB6394FA2E53A29D3D52B" },
    { "morsub0.hit",	"0639E578C6A8457A6FEB1D3F66D7C804" },
    { "morsub0.swp",	"E44E572475F0E4E70D3B4EDE5DAA856A" },
    { "pstuff.lbm",		"827C5CF8E0C162700FE5D6778AE13DDE" },
    { "rankfont.lbm", 	"2894B5CA8746799AA126CAA5734C2CF2" },
    { "SENSPROD.RAW", 	"2724B5C909CC2FCB5ADF012EAE2DDE9A" },
    { "VIRGPRES.RAW", 	"BA0A0431E88574BD4D726A52EB2991DA" },
    { "WARX1.INS",		"CCE4AB1491AFC0A69BDF4D1451270C86" },
    { "WARX4.SNG",		"189EB4A63C441A024173F24F089420E4" },
    { "WON.RAW",		"E9ABF124FB366BF45E77A04CEC40532F" }
};

// Amiga Format Christmas Special Release
const std::vector<sFile> mAmigaFormatFiles = {
    { "afxarmy.lbm", "0B5D60F527DB05B2444681522AC41FA3" },
    { "afxbase.bht", "4035396EB20D9576AA3F3A4F31C874F9" },
    { "AFXBASE.BLK", "69D55DB3B2EDE64FB936808488D0B960" },
    { "afxbase.hit", "A8C9E63D92E18DFA0BAD6FA7D5F8FA3A" },
    { "AFXBASE.INS", "A98080C06B186461FAEED944E540CEFE" },
    { "afxbase.pal", "1B668D3C7167EE1DA6A39A77E488A200" },
    { "AFXBASE.SNG", "BC82E70E22DE7A66448AA5CA852A31D5" },
    { "afxbase.swp", "6FC0E6A0D87C495CD7DB9E9EDA7AD1FC" },
    { "afxcopt.lbm", "CCA8D9286932ACCC81C57FACF35F1AA2" },
    { "afxsub0.bht", "5257A7FA47A4E9F950B6DFC375B1EEB5" },
    { "AFXSUB0.BLK", "D7AE1DBFD2E2F7639498A26294132CC4" },
    { "afxsub0.hit", "05D394733EA7804BA1276D874448CFDC" },
    { "afxsub0.swp", "24166B1967AA51468AFB5590BEFB3736" },
    { "apmenu.lbm", "C89B3459C95114A434F67BB921E42854" },
    { "mapm1.map", "83B834ACDF20012FFF32497C0AB5D41F" },
    { "mapm1.spt", "8955555248BAB5EFBED5E561BB02FA22" },
    { "mapm2.map", "E1EB8D9F2E3F868633CC66AF8B9F0BFB" },
    { "mapm2.spt", "4E2DA0890E5E3C3A7AC34039B654ECA6" },
    { "pstuff.lbm", "631BA67C90A5502391226A30A3849DC5" }
};

const std::vector<sFile> mAmigaTheOneFiles = {
    { "cftitle.lbm", "D77B802DAFD6073ABB876D9038CE00A3" },
    { "grave32.pal", "5DD21FA5759C74D26363BAB1CE08321D" },
    { "icearmy.lbm", "CEB74AFA8DA5C7BF7B778A44202CEFC4" },
    { "icebase.bht", "8E486F8E57EDC352860AE782D59DEF82" },
    { "icebase.blk", "03A65415BCC7CD4324334DCE4653FF2C" },
    { "icebase.hit", "C739F8C5B63AE6FE316AC2E2ADCE4D91" },
    { "icebase.ins", "B85E2BD7C1BD9C00FE07B2E8E4B5484B" },
    { "icebase.pal", "7EA341E95E1974422106E040F20F9DF2" },
    { "icebase.sng", "70CBB58AA0ED60F8DF6A756B5BEA9892" },
    { "icebase.swp", "D770F6FB8988626886DE000C0557A177" },
    { "icecopt.lbm", "1360E0CBA79FEBE2FDFD245F0D428C88" },
    { "icesub0.bht", "5042BBE5FF70EB2009CA58A9738E94D3" },
    { "icesub0.blk", "F55627BB795C1501CF56CCAC554B2DC3" },
    { "icesub0.hit", "CF7262827907A4D786AAC40F61E961B7" },
    { "icesub0.swp", "3E16806CCDACC1899DD7CF429C0D7ACB" },
    { "junarmy.lbm", "11542A9B6CF13408C43F66950936E06E" },
    { "junbase.bht", "EEAF3AD454ECAA51480A84CC132E92B1" },
    { "junbase.blk", "8F33B228AAE418C9C18CDA948D86E054" },
    { "junbase.hit", "2A8D1AB76FD9387402A4A11DD7539347" },
    { "junbase.ins", "C7AC0BA709C8446239F95878BB4DCE65" },
    { "junbase.pal", "27DA36F06898A9549A1E4AF4CAC4D8B7" },
    { "junbase.sng", "6C2ACFA3FA1B5012DB5DD9BF17980C81" },
    { "junbase.swp", "EE9D6EB648BAF96EC356FB8A3F77A618" },
    { "juncopt.lbm", "E9DC3CC39203D141ECA2F1B64B38CCFF" },
    { "junsub0.bht", "30C5CBE1ABAF76FF19AFC03D8FDB0660" },
    { "junsub0.blk", "08AD7F77011ABE4DD1B2D7DDB06B6A3B" },
    { "junsub0.hit", "213269184B6B7BAB8D555BCEEC6DEF12" },
    { "junsub0.swp", "5FA95031D65F76152589E8887900F876" },
    { "junsub1.bht", "985A67DC52CA7191C4216A6F04D5EB0C" },
    { "junsub1.blk", "D14563C1A31E5590E8B2D9BC545149BB" },
    { "junsub1.hit", "75CA3DA267E8601D89BC4EBABC11407E" },
    { "junsub1.swp", "C551471A99FFF0B02FF7FE11163C63EE" },
    { "magpic.lbm", "297043924E02424C734DBAB2443B02F9" },
    { "mapm1.map", "45DB6C9BD73A5EC451FB9E2BEE3F91FE" },
    { "mapm1.spt", "655B285F8FA5421B70A9DE9C997517F4" },
    { "mapm2.map", "864F0438B1F846AF648A3CA348AB9397" },
    { "mapm2.spt", "48F47F3EE8DEFC445A612F22EB84A635" },
    { "mapm3.map", "10CF513F74AFAD4043EEDDAFDC004D20" },
    { "mapm3.spt", "6E317E11AC3D39A46D39C3A6F5487160" },
    { "morphbig.lbm", "07E1F325F3F40D575D9F1D9A5F5DACF4" },
    { "PRETENTIOUS1.RAW", "F24DA5431A9D5661CDA1BF7106228DC5" },
    { "PRETENTIOUS2.RAW", "D0EA6250E83C09D96DF211F8ABB6AB29" },
    { "PRETENTIOUS3.RAW", "43DFB39943A4B6639085FEE9850DA6EA" },
    { "pstuff.lbm", "E314A882B0C280F86B6E471EA9112E90" },
    { "rankfont.lbm", "3F261EBD25E6AF6B49CBA77BC7D60086" },
    { "sensprod.lbm", "674632BBCC302CF2234476AA87A02986" },
    { "virgpres.lbm", "FFFB28D358220ADCFAB8FBCDB93FB333" },
};

const std::vector<sFile> mAmigaActionFiles = {
    { "apmenu.lbm", "1DAE565C1EFAC3CE8967E31B13640AD8" },
    { "junarmy.lbm", "7775C2ECA7230A2622C6DE2381104CBA" },
    { "junbase.bht", "1D1AEA8B3B2EF9D0CD886DC7F39588D4" },
    { "junbase.blk", "0D3C72390ADF47647339331A7736AC16" },
    { "junbase.hit", "9974819A29D70D7ED1B7D89665C22290" },
    { "junbase.ins", "C7AC0BA709C8446239F95878BB4DCE65" },
    { "junbase.pal", "27DA36F06898A9549A1E4AF4CAC4D8B7" },
    { "junbase.sng", "6C2ACFA3FA1B5012DB5DD9BF17980C81" },
    { "junbase.swp", "6F6F179E0161E00D7BAA8946C98EC188" },
    { "juncopt.lbm", "08DFA50E3C18E57C4A0E7F8749F36526" },
    { "junsub0.bht", "7A550D7B049112CE48F515CAE89CBC2D" },
    { "junsub0.blk", "BFE47F6B31DBE9A2E66F1112B63E24CE" },
    { "junsub0.hit", "019F136162EEF0DE9EBE12DF9B0D2B0C" },
    { "junsub0.swp", "629FD552C113216A23695FA0A38408FB" },
    { "junsub1.bht", "A7B6F71467FA2006D97DB67C43741694" },
    { "junsub1.blk", "70E25A00B8EA9BE9E2C1748A3026AEF2" },
    { "junsub1.hit", "293CA1C5EB584F8D432A2BE60801D37E" },
    { "junsub1.swp", "C551471A99FFF0B02FF7FE11163C63EE" },
    { "mapm1.map", "4EC9CF26BD9BAD9FF2157F52820E9FFD" },
    { "mapm1.spt", "9363F391620A6CE069F72BA36BB56C83" },
    { "mapm2.map", "8FA8FB37CB727B7AFFF4EFB7AF725E32" },
    { "mapm2.spt", "4500BB66226BC678BD116A53C03F88D2" },
    { "mapm3.map", "D347F88815EE3B71F022544D073247FE" },
    { "mapm3.spt", "9FBEF790F49274752C1E0DD4A7865769" },
    { "mapm4.map", "1E78FEA9ADFAC8B0D58FA652B2243D56" },
    { "mapm4.spt", "37F806D97518F883E80F8ED5896377C5" },
    { "pstuff.lbm", "DC04FD82E27E5BACD46D5AF2A617127F" },
};

// Amiga Power Release
const std::vector<sFile> mPlusFiles = {
    { "junbase.bht", "1D1AEA8B3B2EF9D0CD886DC7F39588D4" },
    { "junsub1.bht", "A7B6F71467FA2006D97DB67C43741694" },
    { "junbase.blk", "0D3C72390ADF47647339331A7736AC16" },
    { "junsub1.blk", "70E25A00B8EA9BE9E2C1748A3026AEF2" },
    { "junbase.hit", "9974819A29D70D7ED1B7D89665C22290" },
    { "junsub1.hit", "293CA1C5EB584F8D432A2BE60801D37E" },
    { "junbase.ins", "C7AC0BA709C8446239F95878BB4DCE65" },
    { "1.lbm", "913D9A8557FFF6B346CF779BBDEA1CD9" },
    { "2.lbm", "F846A614A3A5CCA95ED43B47AD8CFEEA" },
    { "3.lbm", "17D5386978C5FCBFBD05BC391F9F5A55" },
    { "4.lbm", "3A44F62EC8283B3E7ECEFD5BCAB7A3EB" },
    { "5.lbm", "459DEC92F89E3BB54AC9B54FFC43C45D" },
    { "6.lbm", "E985757E42925A6250F3624A3761818A" },
    { "7.lbm", "ACEFFCBB87A64432720CB137E9295990" },
    { "8.lbm", "7F017C5075505764E571474C299BE9DA" },
    { "9.lbm", "4289FA75B3ACFD0D248D0AC2D4C15222" },
    { "10.lbm", "921C5CC0FFB15F48F73E3A9737590BA7" },
    { "11.lbm", "059ACB5A8B3FF6B9AF9A35CE728897BE" },
    { "apmenu.lbm", "13C9FF4C69772353173FA4DD4FBC8C6C" },
    { "junarmy.lbm", "A84F78AF89C87F068541A583B7254CFC" },
    { "juncopt.lbm", "08DFA50E3C18E57C4A0E7F8749F36526" },
    { "pstuff.lbm", "DC04FD82E27E5BACD46D5AF2A617127F" },
    { "mapm1.map", "E4FBB58267378F7115EA5031FB619814" },
    { "mapm1.spt", "A4924EB5445CA87B0B9D6F0512B31B5A" },
    { "mapm2.map", "1B07CF4F3575C34CA73E41BDC286379A" },
    { "mapm2.spt", "51AAA7F17411C8479E4499BB8B3F1E07" },
    { "mapm3.map", "A881B3BDD3A37D594BDCD774D8C3D967" },
    { "mapm3.spt", "4D115E6A0EF74E9ED37AE4127825C33B" },
    { "mapm4.map", "A881B3BDD3A37D594BDCD774D8C3D967" },
    { "mapm4.spt", "B569E610AF4D404DE794F0FDB60F2962" },
    { "junbase.pal", "27DA36F06898A9549A1E4AF4CAC4D8B7" },
    { "junbase.sng", "6C2ACFA3FA1B5012DB5DD9BF17980C81" },
    { "junbase.swp", "768E479D6895E64E61F1502021D3E4D6" },
    { "junsub1.swp", "C551471A99FFF0B02FF7FE11163C63EE" }
};

const std::vector<sFile> mAmigaFormat_NotVeryFestiveFiles = {
    { "DESARMY.PAL", "C85EC39DF39A4DFA5EF14E7F136510DC" },
    { "DESARMY.RAW", "B102A4AF6A3DE2DF3A0C93589B093E03" },
    { "DESBASE.BHT", "79EC0CC208047BA7BCFF50071CABA074" },
    { "DESBASE.BLK", "9F0F19DA13F356E89E74211557B4FF2C" },
    { "DESBASE.HIT", "931BC2ACB018C8DD02AFBF7D63A04E82" },
    { "DESBASE.INS", "550F5EDA26554638CD776CA7F5B896D0" },
    { "DESBASE.PAL", "7CC9B7F479B3D96D6D727C48CFA4AC9F" },
    { "DESBASE.SNG", "B943724BC5B21A8177DF9026C7BAAB39" },
    { "DESBASE.SWP", "CF49E8E2F0F522753EC900D1E840E849" },
    { "DESCOPT.PAL", "C85EC39DF39A4DFA5EF14E7F136510DC" },
    { "DESCOPT.RAW", "1F162966B0EE88F05B5F536C124F5AF1" },
    { "DESSUB0.BHT", "9003592A4A2274129D67FA13FC24FAED" },
    { "DESSUB0.BLK", "33A019581548538E328BF6327263FCC0" },
    { "DESSUB0.HIT", "825BFCC75922F87914BA66C3B77BC956" },
    { "DESSUB0.SWP", "0C2EE270602A0A952101B1885A739AC3" },
    { "ICEARMY.PAL", "034F99283628233A2D66A54A36D4D3E9" },
    { "ICEARMY.RAW", "F62DA76B1B2F8DAD9532DDFA6C2E7652" },
    { "ICEBASE.BHT", "D949F094359406551BF5AF66EA9A5E7F" },
    { "ICEBASE.BLK", "2EC17F7962D0C48F5F3FD6934E002203" },
    { "ICEBASE.HIT", "070B6FCE31684E945E46C7C98604E7AB" },
    { "ICEBASE.INS", "1738B8A58182920E73DC98A0DA65AEF5" },
    { "ICEBASE.PAL", "F531809D0BECED820511017804100DBF" },
    { "ICEBASE.SNG", "EEEA051381A5436D8F2F55B76B896BEF" },
    { "ICEBASE.SWP", "B469EE7ADA55E9DD11C6AECBE28743C7" },
    { "ICECOPT.PAL", "034F99283628233A2D66A54A36D4D3E9" },
    { "ICECOPT.RAW", "7D113D1FED086688166607BFD7BB0C85" },
    { "ICESUB0.BHT", "FC518045A2CAF8190F637CEA7A738A35" },
    { "ICESUB0.BLK", "70385CC1A59A6653D5E78FF848CED2F6" },
    { "ICESUB0.HIT", "40218776D53C159BE6A05A7A89905CBD" },
    { "ICESUB0.SWP", "425CC1E357EBDAFC4F63FA3E010A5107" },
    { "MAPM1.MAP", "DD76871153811E38FD93CC5057C5FA8E" },
    { "MAPM1.SPT", "E30B230D0328F2BED07A5AE24CF74704" },
    { "MAPM2.MAP", "CAC25D2FAA9120FBDF455D90583C6E95" },
    { "MAPM2.SPT", "8B5B519E5222F6BA8EEB12B963AB4851" },
    { "MAPM3.MAP", "F7233C8EAAFC97E01243935A9EF7B6F8" },
    { "MAPM3.SPT", "AF771B83CE1A21569486AE4437A44FF0" },
    { "MAPM4.MAP", "31B5FAD4AFB2E82F50E5FA237801B1DE" },
    { "MAPM4.SPT", "45DEEE1D0F2CC0D0F9B7EAED3B93FC4E" },
    { "PSTUFF.PAL", "E23D3946DE0B8CFB13D4E9051A8EA35B" },
    { "PSTUFF.RAW", "713A1241AB6B54657813BB047978DB2D" },
    { "VMENU.PAL", "58491B18128EE48D2CF290A6C5CE355E" },
    { "VMENU.RAW", "BBB7D6CAF06669CEB1D726DF0B010D99" }
};

const std::vector<sFile> mAmigaAlienLevels = {
	{ "INTARMY.PAL", "69660F0D11F3FFE8402CA0ECF1BF0CE6" },
	{ "INTARMY.RAW", "5B9FC712E930E0B0304092A1CE6EFAE4" },
	{ "INTBASE.BHT", "D14567268EFA86FD9B5F05BBE8F98C9B" },
	{ "INTBASE.BLK", "6CCFD75384579A3F039B6A520D5D5F9A" },
	{ "INTBASE.HIT", "7B90FF0596DC778BDC44FE4163D3A7F2" },
	{ "INTBASE.INS", "BF2443679ED1D04E16EAB88F68592840" },
	{ "INTBASE.PAL", "13589158917E93F36F2B88973C401FF8" },
	{ "INTBASE.SNG", "79854A62DFE2C06DFA9BB6F687215678" },
	{ "INTBASE.SWP", "6FFCD0EBEADC6B7C86E7ED9FBEE7A9B5" },
	{ "INTCOPT.PAL", "69660F0D11F3FFE8402CA0ECF1BF0CE6" },
	{ "INTCOPT.RAW", "D82E50E6D79FE6524ABF71975C35A8EF" },
	{ "INTFGN2.PL8", "CD1D42304EF400E2C13F8D3777F527D8" },
	{ "INTFGND.PL8", "F5EE6AB8835581D182E0FB2AAE171275" },
	{ "INTHELI.PAL", "21913E3B4F89DC81CDA083A0FAFD86B3" },
	{ "INTMID.PL8", "B57D9C9659763A2E0CB8D1DF8EFED406" },
	{ "INTPLAY.PAL", "1994BE7FE769D93005A4616158046D0A" },
	{ "INTPLAY.RAW", "2B70804828931E8A8E57D4813A9FF68C" },
	{ "INTSKY.PL8", "41BC29DAEFC9B2DF21AEE4A469377F0A" },
	{ "INTSUB0.BHT", "7A81BDD4E9F5AFD502310953A838F897" },
	{ "INTSUB0.BLK", "E789A5F957F92272F6DE58E4279AC838" },
	{ "INTSUB0.HIT", "B6416BBEB89B9C18015C1D1EFC0D45BF" },
	{ "INTSUB0.SWP", "C0F23A50CCC3CEAE6865F992CAF79385" },
	{ "MAPM1.MAP", "0077A06014D41063A8318209BBBE8CBB" },
	{ "MAPM1.SPT", "A147D6A494242B7D7489027B80E05256" },
	{ "MAPM2.MAP", "146909A6D47B49036CE2A3CAAAB0904D" },
	{ "MAPM2.SPT", "2FC173374FCF640A38EE4F958B006295" },
	{ "MAPM3.MAP", "E2A68D802D41D20FD2F0A33C28AEC4B5" },
	{ "MAPM3.SPT", "DC2C1CF37B442FA370B7EF51544E6930" },
	{ "MAPM4.MAP", "CA813BA715890B1AD5FCD2F4150EAAD0" },
	{ "MAPM4.SPT", "9C95B815D6C6CA39A49D7FFD181750D1" },
	{ "PSTUFF.PAL", "E23D3946DE0B8CFB13D4E9051A8EA35B" },
	{ "PSTUFF.RAW", "713A1241AB6B54657813BB047978DB2D" },
	{ "VMENU.PAL", "D82090EFD847FA0B651C9463043C62A4" },
	{ "VMENU.RAW", "D6A7380CB9B620E8515251C3FD95BE95" },
};
