//
// $Id: MapTest.m,v 1.20 2007/03/28 03:16:52 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "MapTest.h"
#import "Random.h"
#import <ObjectiveLib/Map.h>
#import <ObjectiveLib/Vector.h>
#import <ObjectiveLib/DataOutStream.h>
#import <ObjectiveLib/DataInStream.h>
#import <ObjectiveLib/ObjectOutStream.h>
#import <ObjectiveLib/ObjectInStream.h>
#import "Number.h"
#if defined(OL_NO_OPENSTEP)
#import <ObjectiveLib/Text.h>
#import <ObjectiveLib/Reaper.h>
#else
#import <Foundation/NSString.h>
#import <Foundation/NSValue.h>
#import <Foundation/NSData.h>
#import <Foundation/NSArchiver.h>
#if defined(HAVE_KEYED_ARCHIVES)
#import <Foundation/NSKeyedArchiver.h>
#endif
#endif
#include <stdlib.h>
#if defined(__NEXT_RUNTIME__)
#import <objc/objc-class.h>
#endif

@implementation MapTest

- (void) testBounds
{
    OLMap* m;
    CONSTSTR* keys[] = { @"five", @"one", @"three", @"two" };
    CONSTSTR* vals[] = { @"5", @"1", @"3", @"2" };
    OLAssociativeIterator* itor;
    OLPair* p;
    int i;

    m = [[OLMap alloc] init];
    for (i = 0; i < 4; i++)
        REAP([m insertKey: keys[i] value: vals[i]]);
    itor = REAP([m lowerBound: @"four"]);
    if (![[[itor dereference] first] isEqual: keys[1]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [keys[1] cString], [[[itor dereference] first] cString]];
    }
    if (![[[itor dereference] second] isEqual: vals[1]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [vals[1] cString], [[[itor dereference] second] cString]];
    }
    itor = REAP([m upperBound: @"four"]);
    if (![[[itor dereference] first] isEqual: keys[1]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [keys[1] cString], [[[itor dereference] first] cString]];
    }
    if (![[[itor dereference] second] isEqual: vals[1]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [vals[1] cString], [[[itor dereference] second] cString]];
    }
    itor = REAP([m lowerBound: @"one"]);
    if (![[[itor dereference] first] isEqual: keys[1]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [keys[1] cString], [[[itor dereference] first] cString]];
    }
    if (![[[itor dereference] second] isEqual: vals[1]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [vals[1] cString], [[[itor dereference] second] cString]];
    }
    itor = REAP([m upperBound: @"one"]);
    if (![[[itor dereference] first] isEqual: keys[2]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [keys[2] cString], [[[itor dereference] first] cString]];
    }
    if (![[[itor dereference] second] isEqual: vals[2]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [vals[2] cString], [[[itor dereference] second] cString]];
    }
    p = REAP([m equalRange: @"three"]);
    if (![[[[p first] dereference] first] isEqual: keys[2]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [keys[2] cString], [[[[p first] dereference] first] cString]];
    }
    if (![[[[p first] dereference] second] isEqual: vals[2]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [vals[2] cString], [[[[p first] dereference] second] cString]];
    }
    if (![[[[p second] dereference] first] isEqual: keys[3]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [keys[3] cString], [[[[p second] dereference] first] cString]];
    }
    if (![[[[p second] dereference] second] isEqual: vals[3]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [vals[3] cString], [[[[p second] dereference] second] cString]];
    }
    [m RELEASE];
}

#if !defined(OL_NO_OPENSTEP)
- (void) testCoding
{
    NSMutableData* data;
    NSArchiver* archiver;
    NSData* archData;
    OLMap* m1;
    OLMap* m2;
    OLNumber* k;
    OLNumber* v;
    int i;


    m1 = [[OLMap alloc] init];
    for (i = 0; i< 5000; i++)
    {
        k = [[OLNumber alloc] initWithInt: i];
        v = [[OLNumber alloc] initWithInt: OLRandom() % 1000];
        [m1 assignKey: k value: v];
        [k RELEASE];
        [v RELEASE];
    }
    data = [[NSMutableData alloc] initWithCapacity: 5000];
    archiver = [[NSArchiver alloc] initForWritingWithMutableData: data];
    [archiver encodeRootObject: m1];
    [archiver RELEASE];
    m2 = [NSUnarchiver unarchiveObjectWithData: data];
    [data RELEASE];
    if (![m1 isEqual: m2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The maps should be equal"];
    }
#if defined(HAVE_KEYED_ARCHIVES)
    archData = [NSKeyedArchiver archivedDataWithRootObject: m1];
    m2 = [NSKeyedUnarchiver unarchiveObjectWithData: archData];
    if (![m1 isEqual: m2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The maps should be equal"];
    }
#endif
    [m1 RELEASE];
}
#endif

- (void) testConvenienceAllocators
{
    OLMap* m;
    OLMap* m2;
    OLNumber* num;

    m = REAP([OLMap map]);
    if (![m IS_MEMBER_OF: [OLMap class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            ((Class)[OLMap class])->name, ((Class)[m class])->name];
    }
    if (![m empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The map should be empty"];
    }
    num = [[OLNumber alloc] initWithInt: 1];
    [m assignKey: num value: REAP([num toText])];
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 2];
    [m assignKey: num value: REAP([num toText])];
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 3];
    [m assignKey: num value: REAP([num toText])];
    [num RELEASE];
    m2 = REAP([OLMap mapFrom: REAP([m begin]) to: REAP([m end])]);
    if (![m isEqual: m2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The maps should be equal"];
    }
    num = [[OLNumber alloc] initWithInt: 4];
    [m assignKey: num value: REAP([num toText])];
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 5];
    [m assignKey: num value: REAP([num toText])];
    [num RELEASE];
    m2 = REAP([OLMap mapWithMap: m]);
    if (![m isEqual: m2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The maps should be equal"];
    }
    m = REAP([OLMap mapWithCompare: REAP([OLFunctor functorOfType: OLFunctorType_Greater])]);
    if (![m IS_MEMBER_OF: [OLMap class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            ((Class)[OLMap class])->name, ((Class)[m class])->name];
    }
    if (![m empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The map should be empty"];
    }
    if (![[m keyComp] IS_MEMBER_OF: [OLGreater class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            ((Class)[OLGreater class])->name, ((Class)[[m keyComp] class])->name];
    }
}

- (void) testErase
{
    OLMap* m;
    CONSTSTR* keys[] = { @"five", @"four", @"one", @"three", @"two" };
    CONSTSTR* vals[] = { @"5", @"4", @"1", @"3", @"2" };
    OLAssociativeIterator* itor;
    OLAssociativeIterator* end;
    int i;

    m = [[OLMap alloc] init];
    for (i = 0; i < 5; i++)
        REAP([m insertKey: keys[i] value: vals[i]]);
    REAP([m insertKey: @"six" value: @"6"]);
    itor = REAP([m begin]);
    [OLIterator advanceIterator: itor distance: 3];
    [m erase: itor];
    if ([m size] != 5)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 5, but got %u", [m size]];
    }
    for (itor = REAP([m begin]), end = REAP([m end]), i = 0;
         ![itor isEqual: end]; [itor advance], i++)
    {
        if (![[[itor dereference] first] isEqual: keys[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [keys[i] cString], [[[itor dereference] first] cString]];
        }
        if (![[[itor dereference] second] isEqual: vals[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [vals[i] cString], [[[itor dereference] second] cString]];
        }
    }
    itor = REAP([m begin]);
    [OLIterator advanceIterator: itor distance: 2];
    [m eraseFrom: itor to: end];
    if ([m size] != 2)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 2, but got %u", [m size]];
    }
    for (itor = REAP([m begin]), end = REAP([m end]), i = 0;
         ![itor isEqual: end]; [itor advance], i++)
    {
        if (![[[itor dereference] first] isEqual: keys[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [keys[i] cString], [[[itor dereference] first] cString]];
        }
        if (![[[itor dereference] second] isEqual: vals[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [vals[i] cString], [[[itor dereference] second] cString]];
        }
    }
    i = [m eraseKey: keys[0]];
    if (i != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %i", i];
    }
    if ([m size] != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %u", [m size]];
    }
    itor = REAP([m begin]);
    if (![[[itor dereference] first] isEqual: keys[1]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [keys[1] cString], [[[itor dereference] first] cString]];
    }
    if (![[[itor dereference] second] isEqual: vals[1]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [vals[1] cString], [[[itor dereference] second] cString]];
    }
    [m clear];
    if ([m size] != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 0, but got %u", [m size]];
    }
    if (![m empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The map is empty"];
    }
    [m RELEASE];
}

- (void) testFind
{
    OLMap* m;
    CONSTSTR* keys[] = { @"five", @"four", @"one", @"three", @"two" };
    CONSTSTR* vals[] = { @"5", @"4", @"1", @"3", @"2" };
    OLAssociativeIterator* itor;
    OLAssociativeIterator* end;
    id val;
    int i;

    m = [[OLMap alloc] init];
    for (i = 0; i < 5; i++)
        REAP([m insertKey: keys[i] value: vals[i]]);
    end = REAP([m end]);
    i = [m count: @"one"];
    if (i != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %u", i];
    }
    i = [m count: @"six"];
    if (i != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 0, but got %u", i];
    }
    itor = REAP([m find: @"three"]);
    if ([itor isEqual: end])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "\"three\"should have been found"];
    }
    if (![[[itor dereference] first] isEqual: keys[3]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [keys[3] cString], [[[itor dereference] first] cString]];
    }
    if (![[[itor dereference] second] isEqual: vals[3]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [vals[3] cString], [[[itor dereference] second] cString]];
    }
    itor = REAP([m find: @"doggy"]);
    if (![itor isEqual: end])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "\"doggy\"should not have been found"];
    }
    val = [m valueForKey: @"two"];
    if (![val isEqual: vals[4]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [vals[3] cString], [val cString]];
    }
    val = [m valueForKey: @"dogbite"];
    if (val != nil)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected nil"];
    }
    [m RELEASE];
}

- (void) testInsert
{
    OLMap* m;
    CONSTSTR* strs[] = { @"one", @"two", @"three", @"four", @"five" };
    CONSTSTR* vals[] = { @"1", @"2", @"3", @"4", @"5" };
    CONSTSTR* orderedStrs[] = { @"five", @"four", @"one", @"three", @"two" };
    CONSTSTR* orderedVals[] = { @"5", @"4", @"1", @"3", @"2" };
    int i;
    OLPair* p;
    OLPair* r;
    OLVector* v;
    OLAssociativeIterator* itor;
    OLAssociativeIterator* end;

    m = [[OLMap alloc] init];
    p = [[OLPair alloc] initWithFirst: strs[0] second: vals[0]];
    r = REAP([m insert: p]);
    [p RELEASE];
    if ([m size] != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %u", [m size]];
    }
    if (![[r second] boolValue])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected YES, but got NO"];
    }
    if (![[[[r first] dereference] first] isEqual: strs[0]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [strs[0] cString], [[[[r first] dereference] first] cString]];
    }
    if (![[[[r first] dereference] second] isEqual: vals[0]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [vals[0] cString], [[[[r first] dereference] second] cString]];
    }
    p = [[OLPair alloc] initWithFirst: strs[0] second: vals[1]];
    r = REAP([m insert: p]);
    [p RELEASE];
    if ([m size] != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %u", [m size]];
    }
    if ([[r second] boolValue])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected YES, but got NO"];
    }
    if (![[[[r first] dereference] first] isEqual: strs[0]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [strs[0] cString], [[[[r first] dereference] first] cString]];
    }
    if (![[[[r first] dereference] second] isEqual: vals[0]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [vals[0] cString], [[[[r first] dereference] second] cString]];
    }
    [m assignKey: strs[0] value: vals[1]];
    if ([m size] != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %u", [m size]];
    }
    itor = REAP([m begin]);
    if (![[[itor dereference] first] isEqual: strs[0]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [strs[0] cString], [[[[r first] dereference] first] cString]];
    }
    if (![[[itor dereference] second] isEqual: vals[1]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [vals[1] cString], [[[[r first] dereference] second] cString]];
    }
    [m assignKey: strs[0] value: vals[0]];
    if (![[[itor dereference] first] isEqual: strs[0]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [strs[0] cString], [[[[r first] dereference] first] cString]];
    }
    if (![[[itor dereference] second] isEqual: vals[0]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [vals[0] cString], [[[[r first] dereference] second] cString]];
    }
    v = [[OLVector alloc] init];
    for (i = 1; i < 4; i++)
    {
        p = [[OLPair alloc] initWithFirst: strs[i] second: vals[i]];
        [v pushBack: p];
        [p RELEASE];
    }
    [m insertFrom: REAP([v begin]) to: REAP([v end])];
    [v RELEASE];
    if ([m size] != 4)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 4, but got %u", [m size]];
    }
    end = REAP([m end]);
    for (itor = REAP([m begin]), i = 1; ![itor isEqual: end]; [itor advance], i++)
    {
        if (![[[itor dereference] first] isEqual: orderedStrs[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [orderedStrs[i] cString], [[[itor dereference] first] cString]];
        }
        if (![[[itor dereference] second] isEqual: orderedVals[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [orderedVals[i] cString], [[[itor dereference] second] cString]];
        }
    }
    p = [[OLPair alloc] initWithFirst: strs[4] second: vals[4]];
    itor = REAP([m insertAt: [REAP([m begin]) advance] value: p]);
    [p RELEASE];
    if ([m size] != 5)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 5, but got %u", [m size]];
    }
    if (![[[itor dereference] first] isEqual: strs[4]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [strs[0] cString], [[[itor dereference] first] cString]];
    }
    if (![[[itor dereference] second] isEqual: vals[4]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            [vals[0] cString], [[[itor dereference] second] cString]];
    }
    end = REAP([m end]);
    for (itor = REAP([m begin]), i = 0; ![itor isEqual: end]; [itor advance], i++)
    {
        if (![[[itor dereference] first] isEqual: orderedStrs[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [orderedStrs[i] cString], [[[itor dereference] first] cString]];
        }
        if (![[[itor dereference] second] isEqual: orderedVals[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [orderedVals[i] cString], [[[itor dereference] second] cString]];
        }
    }
    r = REAP([m insertKey: @"doggy" value: @"boy"]);
    if ([m size] != 6)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 6, but got %u", [m size]];
    }
    if (![[r second] boolValue])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected YES, but got NO"];
    }
    if (![[[[r first] dereference] first] isEqual: @"doggy"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"doggy\", but got \"%s\"",
            [[[[r first] dereference] first] cString]];
    }
    if (![[[[r first] dereference] second] isEqual: @"boy"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"boy\", but got \"%s\"",
            [[[[r first] dereference] second] cString]];
    }
    r = REAP([m insertKey: @"doggy" value: @"chuck"]);
    if ([m size] != 6)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 6, but got %u", [m size]];
    }
    if ([[r second] boolValue])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected NO, but got YES"];
    }
    if (![[[[r first] dereference] first] isEqual: @"doggy"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"doggy\", but got \"%s\"",
            [[[[r first] dereference] first] cString]];
    }
    if (![[[[r first] dereference] second] isEqual: @"boy"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"boy\", but got \"%s\"",
            [[[[r first] dereference] second] cString]];
    }
    [m RELEASE];
}

- (void) testInitializers
{
    OLMap* m;
    OLGreater* greater;
    OLVector* v;
    CONSTSTR* strs[] = { @"one", @"two", @"three", @"four", @"five" };
    CONSTSTR* orderedStrs[] = { @"five", @"four", @"one", @"three", @"two" };
    OLNumber* num;
    OLPair* p;
    int i;
    OLAssociativeIterator* b;
    OLAssociativeIterator* e;
    OLMap* m2;

    m = [[OLMap alloc] init];
    if (![m empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The map should be empty"];
    }
    [m RELEASE];
    greater = [[OLGreater alloc] init];
    m = [[OLMap alloc] initWithCompare: greater];
    if (![m empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The map should be empty"];
    }
    if (![[m keyComp] IS_MEMBER_OF: [OLGreater class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The key comparison object is wrong"];
    }
    if (![[m valueComp] IS_MEMBER_OF: [OLGreater class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The value comparison object is wrong"];
    }
    [m RELEASE];
    v = [[OLVector alloc] init];
    for (i = 0; i < 5; i++)
    {
        num = [[OLNumber alloc] initWithInt: i + 1];
        p = [[OLPair alloc] initWithFirst: strs[i] second: num];
        [num RELEASE];
        [v pushBack: p];
        [p RELEASE];
    }
    m = [[OLMap alloc] initFrom: REAP([v begin]) to: REAP([v end])];
    if ([m size] != 5)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 5, but got %u", [m size]];
    }
    for (b = REAP([m begin]), e = REAP([m end]), i = 0; ![b isEqual: e]; [b advance], i++)
    {
        if (![[[b dereference] first] isEqual: orderedStrs[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [orderedStrs[i] cString], [[[b dereference] first] cString]];
        }
        [self logMessage: "[%s] = %i",
            [orderedStrs[i] cString], [[[b dereference] second] intValue]];
    }
    [m RELEASE];
    m = [[OLMap alloc] initFrom: REAP([v begin]) to: REAP([v end]) compare: greater];
    [v RELEASE];
    [greater RELEASE];
    if ([m size] != 5)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 5, but got %u", [m size]];
    }
    [self logMessage: ""];
    for (b = REAP([m begin]), e = REAP([m end]), i = 4; ![b isEqual: e]; [b advance], i--)
    {
        if (![[[b dereference] first] isEqual: orderedStrs[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [orderedStrs[i] cString], [[[b dereference] first] cString]];
        }
        [self logMessage: "[%s] = %i",
            [orderedStrs[i] cString], [[[b dereference] second] intValue]];
    }
    m2 = [[OLMap alloc] initWithMap: m];
    if ([m2 size] != 5)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 5, but got %u", [m2 size]];
    }
    [self logMessage: ""];
    for (b = REAP([m2 begin]), e = REAP([m2 end]), i = 4; ![b isEqual: e]; [b advance], i--)
    {
        if (![[[b dereference] first] isEqual: orderedStrs[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [orderedStrs[i] cString], [[[b dereference] first] cString]];
        }
        [self logMessage: "[%s] = %i",
            [orderedStrs[i] cString], [[[b dereference] second] intValue]];
    }
    if (![m isEqual: m2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The maps must be equal"];
    }
    [m RELEASE];
    [m2 RELEASE];
}

- (void) testIterators
{
    OLMap* m;
    int nums[] = { 4, 3, 5, 1, 2 };
    int orderedNums[] = { 1, 2, 3, 4, 5 };
    int i;
    OLAssociativeIterator* itor;
    OLAssociativeIterator* end;
    OLReverseBidiIterator* rtor;
    OLReverseBidiIterator* rend;
    OLNumber* key;
    OLNumber* value;

    m = [[OLMap alloc] init];
    for (i = 0; i < 5; i++)
    {
        key = [[OLNumber alloc] initWithInt: nums[i]];
        value = [[OLNumber alloc] initWithInt: nums[i] + 1000];
        REAP([m insertKey: key value: value]);
        [key RELEASE];
        [value RELEASE];
    }
    end = REAP([m end]);
    for (itor = REAP([m begin]), i = 0; ![itor isEqual: end]; [itor advance], i++)
    {
        if ([[[itor dereference] first] intValue] != orderedNums[i])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected %i, but got %i",
                orderedNums[i], [[[itor dereference] first] intValue]];
        }
        if ([[[itor dereference] second] intValue] != orderedNums[i] + 1000)
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected %i, but got %i",
                orderedNums[i] + 1000, [[[itor dereference] second] intValue]];
        }
    }
    [itor reverse];
    for (i = 4; i >= 0; i--, [itor reverse])
    {
        if ([[[itor dereference] first] intValue] != orderedNums[i])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected %i, but got %i",
                orderedNums[i], [[[itor dereference] first] intValue]];
        }
        if ([[[itor dereference] second] intValue] != orderedNums[i] + 1000)
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected %i, but got %i",
                orderedNums[i] + 1000, [[[itor dereference] second] intValue]];
        }
    }
    rend = REAP([m rend]);
    for (rtor = REAP([m rbegin]), i = 4; ![rtor isEqual: rend]; [rtor advance], i--)
    {
        if ([[[rtor dereference] first] intValue] != orderedNums[i])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected %i, but got %i",
                orderedNums[i], [[[rtor dereference] first] intValue]];
        }
        if ([[[rtor dereference] second] intValue] != orderedNums[i] + 1000)
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected %i, but got %i",
                orderedNums[i] + 1000, [[[rtor dereference] second] intValue]];
        }
    }
    [rtor reverse];
    for (i = 0; i < 5; i++, [rtor reverse])
    {
        if ([[[rtor dereference] first] intValue] != orderedNums[i])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected %i, but got %i",
                orderedNums[i], [[[rtor dereference] first] intValue]];
        }
        if ([[[rtor dereference] second] intValue] != orderedNums[i] + 1000)
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected %i, but got %i",
                orderedNums[i] + 1000, [[[rtor dereference] second] intValue]];
        }
    }
    [m RELEASE];
}

- (void) testProperties
{
    CONSTSTR* keys[] = { @"one", @"two", @"three" };
    CONSTSTR* vals[] = { @"1", @"2", @"3" };
    OLMap* m;
    OLMap* m2;
    int i;

    m = [[OLMap alloc] init];
    if (![m empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The map is empty"];
    }
    for (i = 0; i < 3; i++)
        REAP([m insertKey: keys[i] value: vals[i]]);
    if ([m empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The map is not empty"];
    }
    m2 = [[OLMap alloc] init];
    if ([m isEqual: m2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The maps are not equal"];
    }
    if (![m2 size] == 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 0, but got %i", [m2 size]];
    }
    [m2 insertFrom: REAP([m begin]) to: REAP([m end])];
    if (![m isEqual: m2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The maps are equal"];
    }
    if ([m maxSize] != [m2 maxSize])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "All maps must have the same max size"];
    }
    [self logMessage: "The max size of a map is %u", [m maxSize]];
    if (![m size] == 3)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 3, but got %i", [m size]];
    }
    if ([m valueComp] != [m keyComp])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Value comp and key comp should point to the same object"];
    }
    [m RELEASE];
    [m2 RELEASE];
}

- (void) testStreaming
{
    OLDataOutStream* dout;
    OLObjectOutStream* oout;
    OLObjectInStream* oin;
    OLMap* map;
    OLMap* readMap;
    OLNumber* k;
    OLNumber* v;
    int i;

    dout = REAP([OLDataOutStream stream]);
    oout = REAP([OLObjectOutStream streamWithOutStream: dout]);
    map = [[OLMap alloc] init];
    for (i = 0; i< 10000; i++)
    {
        k = [[OLNumber alloc] initWithInt: i];
        v = [[OLNumber alloc] initWithInt: OLRandom() % 10000];
        [map assignKey: k value: v];
        [k RELEASE];
        [v RELEASE];
    }
    [oout writeObject: map];
    oin = REAP([OLObjectInStream streamWithInStream:
        REAP([OLDataInStream streamWithBytes: [dout bytes] count: [dout count]])]);
    readMap = REAP([oin readObject]);
    if (![readMap IS_MEMBER_OF: [OLMap class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected OLMap class, but got %s", ((Class)[readMap class])->name];
    }
    if (![readMap isEqual: map])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The maps should be equal"];
    }
    [map RELEASE];
}

- (void) testSwap
{
    OLMap* m;
    OLMap* m2;
    CONSTSTR* keys[] = { @"one", @"two", @"three" };
    CONSTSTR* vals[] = { @"1", @"2", @"3" };
    CONSTSTR* okeys[] = { @"one", @"three", @"two" };
    CONSTSTR* keys2[] = { @"four", @"five", @"six" };
    CONSTSTR* vals2[] = { @"4", @"5", @"6" };
    CONSTSTR* okeys2[] = { @"five", @"four", @"six" };
    int i;
    OLAssociativeIterator* itor;
    OLAssociativeIterator* end;

    m = [[OLMap alloc] init];
    for (i = 0; i < 3; i++)
        REAP([m insertKey: keys[i] value: vals[i]]);
    m2 = [[OLMap alloc] init];
    for (i = 0; i < 3; i++)
        REAP([m2 insertKey: keys2[i] value: vals2[i]]);
    [m swap: m2];
    if ([m size] != 3)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 3, but got %i", [m size]];
    }
    if ([m2 size] != 3)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 3, but got %i", [m2 size]];
    }
    end = REAP([m end]);
    for (itor = REAP([m begin]), i = 0; ![itor isEqual: end]; [itor advance], i++)
    {
        if (![[[itor dereference] first] isEqual: okeys2[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [okeys2[i] cString], [[[itor dereference] first] cString]];
        }
    }
    end = REAP([m2 end]);
    for (itor = REAP([m2 begin]), i = 0; ![itor isEqual: end]; [itor advance], i++)
    {
        if (![[[itor dereference] first] isEqual: okeys[i]])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected \"%s\", but got \"%s\"",
                [okeys[i] cString], [[[itor dereference] first] cString]];
        }
    }
    [m RELEASE];
    [m2 RELEASE];
}

@end
