//
// $Id: HashMultiMapTest.m,v 1.12 2007/03/06 20:42:21 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "HashMultiMapTest.h"
#import <ObjectiveLib/HashMap.h>
#import <ObjectiveLib/Vector.h>
#import <ObjectiveLib/Algorithm.h>
#import "Number.h"
#if defined(OL_NO_OPENSTEP)
#import <ObjectiveLib/Text.h>
#import <ObjectiveLib/Reaper.h>
#else
#import <Foundation/NSString.h>
#import <Foundation/NSValue.h>
#endif
#if defined(__NEXT_RUNTIME__)
#import <objc/objc-class.h>
#else
#import <objc/objc.h>
#endif

@implementation HashMultiMapTest

- (void) testConvenienceAllocators
{
    OLHashMultiMap* m;
    OLHashMultiMap* m2;
    OLNumber* num;

    m = REAP([OLHashMultiMap hashMultiMap]);
    if (![m IS_MEMBER_OF: [OLHashMultiMap class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"%s\", but got \"%s\"",
            ((Class)[OLHashMultiMap class])->name, ((Class)[m class])->name];
    }
    if (![m empty])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The map should be empty"];
    }
    num = [[OLNumber alloc] initWithInt: 1];
    [m assignKey: num value: REAP([num toText])];
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 2];
    [m assignKey: num value: REAP([num toText])];
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 3];
    [m assignKey: num value: REAP([num toText])];
    [num RELEASE];
    m2 = REAP([OLHashMultiMap hashMultiMapFrom: REAP([m begin]) to: REAP([m end])]);
    if (![m isEqual: m2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The maps should be equal"];
    }
    num = [[OLNumber alloc] initWithInt: 4];
    [m assignKey: num value: REAP([num toText])];
    [num RELEASE];
    num = [[OLNumber alloc] initWithInt: 5];
    [m assignKey: num value: REAP([num toText])];
    [num RELEASE];
    m2 = REAP([OLHashMultiMap hashMultiMapWithHashMap: m]);
    if (![m isEqual: m2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The maps should be equal"];
    }
}

- (void) testCounting
{
    OLHashMultiMap* m;
    OLNumber* key;
    OLNumber* val;
    OLPair* pairs[1019];
    OLPair* p;
    int i;
    unsigned count;

    for (i = 0; i < 1000; i++)
    {
        key = [[OLNumber alloc] initWithInt: i];
        val = [[OLNumber alloc] initWithInt: i + 10000];
        pairs[i] = [[OLPair alloc] initWithFirst: key second: val];
        [key RELEASE];
        [val RELEASE];
    }
    for (i = 1000; i < 1019; i++)
    {
        key = [[OLNumber alloc] initWithInt: 543];
        val = [[OLNumber alloc] initWithInt: 543 + 10000];
        pairs[i] = [[OLPair alloc] initWithFirst: key second: val];
        [key RELEASE];
        [val RELEASE];
    }
    p = REAP([OLArrayIterator pairWithPointer: pairs distance: 1019]);
    [OLAlgorithm randomShuffleFrom: [p first] to: [p second]];
    m = [[OLHashMultiMap alloc] initFrom: [p first] to: [p second]];
    for (i = 0; i < 1019; i++)
        [pairs[i] RELEASE];
    key = [[OLNumber alloc] initWithInt: 543];
    count = [m count: key];
    [key RELEASE];
    if (count != 20)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 20, but got %u", count];
    }
    for (i = 0; i < 1000; i++)
    {
        if (i != 543)
        {
            key = [[OLNumber alloc] initWithInt: i];
            count = [m count: key];
            [key RELEASE];
            if (count != 1)
            {
                [self errInFile: __FILE__ line: __LINE__
                    format: "Expected 1, but got %u", count];
            }
        }
    }
    [m RELEASE];
}

- (void) testEqualRange
{
    OLHashMultiMap* m;
    OLNumber* key;
    OLNumber* val;
    OLPair* pairs[1019];
    OLPair* p;
    int i;
    unsigned dist;

    for (i = 0; i < 1000; i++)
    {
        key = [[OLNumber alloc] initWithInt: i];
        val = [[OLNumber alloc] initWithInt: i + 10000];
        pairs[i] = [[OLPair alloc] initWithFirst: key second: val];
        [key RELEASE];
        [val RELEASE];
    }
    for (i = 1000; i < 1019; i++)
    {
        key = [[OLNumber alloc] initWithInt: 543];
        val = [[OLNumber alloc] initWithInt: 543 + 10000];
        pairs[i] = [[OLPair alloc] initWithFirst: key second: val];
        [key RELEASE];
        [val RELEASE];
    }
    p = REAP([OLArrayIterator pairWithPointer: pairs distance: 1019]);
    [OLAlgorithm randomShuffleFrom: [p first] to: [p second]];
    m = [[OLHashMultiMap alloc] initFrom: [p first] to: [p second]];
    for (i = 0; i < 1019; i++)
        [pairs[i] RELEASE];
    key = [[OLNumber alloc] initWithInt: 543];
    p = REAP([m equalRange: key]);
    dist = [OLIterator distanceFrom: [p first] to: [p second]];
    [key RELEASE];
    if (dist != 20)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 20, but got %u", dist];
    }
    for ( ; ![[p first] isEqual: [p second]]; [[p first] advance])
    {
        if ([[[[p first] dereference] first] intValue] != 543)
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected 543, but got %u",
                [[[[p first] dereference] first] intValue]];
        }
    }
    key = [[OLNumber alloc] initWithInt: 544];
    p = REAP([m equalRange: key]);
    dist = [OLIterator distanceFrom: [p first] to: [p second]];
    [key RELEASE];
    if (dist != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 20, but got %u", dist];
    }
    for ( ; ![[p first] isEqual: [p second]]; [[p first] advance])
    {
        if ([[[[p first] dereference] first] intValue] != 544)
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected 544, but got %u",
                [[[[p first] dereference] first] intValue]];
        }
    }
    key = [[OLNumber alloc] initWithInt: 107493];
    p = REAP([m equalRange: key]);
    dist = [OLIterator distanceFrom: [p first] to: [p second]];
    [key RELEASE];
    if (dist != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 0, but got %u", dist];
    }
    [m RELEASE];
}

- (void) testInsert
{
    OLHashMultiMap* m;
    OLPair* p;
    OLHashIterator* r;
    int nums[] = { 1, 1, 2, 3, 2 };
    OLNumber* num;
    OLVector* v;
    int i;
    unsigned count;

    m = [[OLHashMultiMap alloc] init];
    p = [[OLPair alloc] initWithFirst: @"my" second: @"dog"];
    r = REAP([m insert: p]);
    [p RELEASE];
    if ([m size] != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %u", [m size]];
    }
    if (![[[r dereference] first] isEqual: @"my"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"my\", but got \"%s\"",
            [[[r dereference] first] cString]];
    }
    if (![[[r dereference] second] isEqual: @"dog"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"dog\", but got \"%s\"",
            [[[r dereference] first] cString]];
    }
    p = [[OLPair alloc] initWithFirst: @"my" second: @"cat"];
    r = REAP([m insert: p]);
    [p RELEASE];
    if ([m size] != 2)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 2, but got %u", [m size]];
    }
    if (![[[r dereference] first] isEqual: @"my"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"my\", but got \"%s\"",
            [[[r dereference] first] cString]];
    }
    if (![[[r dereference] second] isEqual: @"cat"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"cat\", but got \"%s\"",
            [[[r dereference] second] cString]];
    }
    [m assignKey: @"your" value: @"buddy"];
    if ([m size] != 3)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 3, but got %u", [m size]];
    }
    r = REAP([m find: @"your"]);
    if (![[[r dereference] first] isEqual: @"your"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"your\", but got \"%s\"",
            [[[r dereference] first] cString]];
    }
    if (![[[r dereference] second] isEqual: @"buddy"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"buddy\", but got \"%s\"",
            [[[r dereference] second] cString]];
    }
    r = REAP([m insertKey: @"your" value: @"wife"]);
    if ([m size] != 4)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 4, but got %u", [m size]];
    }
    if (![[[r dereference] first] isEqual: @"your"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"your\", but got \"%s\"",
            [[[r dereference] first] cString]];
    }
    if (![[[r dereference] second] isEqual: @"wife"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"wife\", but got \"%s\"",
            [[[r dereference] second] cString]];
    }
    [m clear];
    v = [[OLVector alloc] init];
    for (i = 0; i < 5; i++)
    {
        num = [[OLNumber alloc] initWithInt: nums[i]];
        p = [[OLPair alloc] initWithFirst: num second: REAP([num toText])];
        [num RELEASE];
        [v pushBack: p];
        [p RELEASE];
    }
    [m insertFrom: REAP([v begin]) to: REAP([v end])];
    [v RELEASE];
    if ([m size] != 5)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 5, but got %u", [m size]];
    }
    num = [[OLNumber alloc] initWithInt: 1];
    count = [m count: num];
    [num RELEASE];
    if (count != 2)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 2, but got %u", count];
    }
    num = [[OLNumber alloc] initWithInt: 2];
    count = [m count: num];
    [num RELEASE];
    if (count != 2)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 2, but got %u", count];
    }
    num = [[OLNumber alloc] initWithInt: 3];
    count = [m count: num];
    [num RELEASE];
    if (count != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %u", count];
    }
    [m RELEASE];
}

- (void) testInitializers
{
    OLHashMultiMap* m;
    OLVector* v;
    CONSTSTR* strs[] = { @"one", @"two", @"one", @"three", @"four", @"four" };
    OLPair* p;
    int i;
    unsigned count;

    v = [[OLVector alloc] init];
    for (i = 0; i < 6; i++)
    {
        p = [[OLPair alloc] initWithFirst: strs[i] second: strs[i]];
        [v pushBack: p];
        [p RELEASE];
    }
    m = [[OLHashMultiMap alloc] initFrom: REAP([v begin]) to: REAP([v end])];
    [v RELEASE];
    if ([m size] != 6)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 6, but got %u", [m size]];
    }
    count = [m count: @"one"];
    if (count != 2)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 2, but got %u", count];
    }
    count = [m count: @"two"];
    if (count != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %u", count];
    }
    count = [m count: @"three"];
    if (count != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %u", count];
    }
    count = [m count: @"four"];
    if (count != 2)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 2, but got %u", count];
    }
    [m RELEASE];
}

@end
