//
// $Id: DataOutStream.m,v 1.9 2007/03/06 20:42:19 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "DataOutStream.h"
#import "Macros.h"
#import "RunTime.h"
#if !defined(OL_NO_OPENSTEP)
#import <Foundation/NSData.h>
#endif
#import <string.h>
#import <stdlib.h>

#define FREE_MY_RESOURCES \
    objc_free(buffer)

@implementation OLDataOutStream

+ (id) stream
{
    OL_BEGIN_AUTO_CTOR(OLDataOutStream)
        init
    OL_END_AUTO_CTOR;
}

- (id) init
{
    [super init];
    buffer = objc_malloc(50);
    insert = buffer;
    end = buffer + 50;
    return self;
}

#if !defined(OL_NO_OPENSTEP)
- (void) dealloc
{
	FREE_MY_RESOURCES;
	SUPER_FREE;
}
#endif

- (const uint8_t*) bytes
{
    return buffer;
}

- (unsigned) count
{
    return insert - buffer;
}

#if !defined(OL_NO_OPENSTEP)
- (NSData*) data
{
    return [NSData dataWithBytes: buffer length: insert - buffer];
}
#endif

#if defined(OL_NO_OPENSTEP)
- (void) freeStreamResources
{
	FREE_MY_RESOURCES;
	[super freeStreamResources];
}
#endif

- (unsigned) writeBytes: (const uint8_t*)bytes count: (unsigned)count
{
    uint8_t* newBuffer;
    unsigned newCapacity;
    unsigned currentCount;

    if (insert + count >= end)
    {
        currentCount = insert - buffer;
        newCapacity = MAX((end - buffer) * 2, currentCount + count);
        newBuffer = objc_malloc(newCapacity);
        memcpy(newBuffer, buffer, currentCount);
        objc_free(buffer);
        buffer = newBuffer;
        insert = buffer + currentCount;
        end = buffer + newCapacity;
    }
    memcpy(insert, bytes, count);
    insert += count;
    return count;
}

@end
