/*
 *  Copyright (C) 2002 Luca Deri <deri@ntop.org>
 *                      
 *  			  http://www.ntop.org/
 *  					
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef WIN32
#include "config.h"
#endif

#if defined(linux) || defined(__linux__)
/*
 * This allows to hide the (minimal) differences between linux and BSD
 */
#define __FAVOR_BSD
#ifndef _BSD_SOURCE
#define _BSD_SOURCE
#endif
#endif /* linux || __linux__ */

#ifdef WIN32
#include <winsock2.h> /* winsock.h is included automatically */
#endif

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <signal.h>
#include <fcntl.h>
#include <ctype.h>
#include <string.h>
#ifndef WIN32
#include <strings.h>
#endif
#include <limits.h>
#include <float.h>
#include <math.h>
#include <sys/types.h>
#ifndef WIN32
#include <sys/socket.h>

#ifdef HAVE_NET_ETHERNET_H
#include <net/ethernet.h>
#endif

#ifdef HAVE_SYS_ETHERNET_H
#include <sys/ethernet.h>
#endif

#include <arpa/inet.h>

#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <net/if.h>

/* Courtesy of Curt Sampson  <cjs@cynic.net> */
#ifdef __NetBSD__
#include <net/if_ether.h>
#endif

#include <netinet/in_systm.h>

#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#endif

#include <pcap.h>

#ifndef WIN32
#include <pthread.h>
#include <stdarg.h>
#include <unistd.h>
#include <syslog.h>
#else /* WIN32 */
#define pthread_t              HANDLE
#define pthread_mutex_t        HANDLE

/*
 * Ethernet address - 6 octets
 */
struct ether_addr {
  u_char ether_addr_octet[6];
};

/*
 * Structure of a 10Mb/s Ethernet header.
 */
struct	ether_header {
  u_char	ether_dhost[6];
  u_char	ether_shost[6];
  u_short	ether_type;
};

#define	ETHERTYPE_IP		0x0800	/* IP protocol */

/* on mingw, tcp_seq is defined - Scott Renfro <scott@renfro.org> */
#if !defined (__GNUC__)
typedef	u_int	tcp_seq;
#endif

/*
 * TCP header.
 * Per RFC 793, September, 1981.
 */
struct tcphdr {
	u_short	th_sport;		/* source port */
	u_short	th_dport;		/* destination port */
	tcp_seq	th_seq;			/* sequence number */
	tcp_seq	th_ack;			/* acknowledgement number */
#if BYTE_ORDER == LITTLE_ENDIAN 
	u_char	th_x2:4,		/* (unused) */
		th_off:4;		/* data offset */
#else
	u_char	th_off:4,		/* data offset */
		th_x2:4;		/* (unused) */
#endif
	u_char	th_flags;
#define	TH_FIN	0x01
#define	TH_SYN	0x02
#define	TH_RST	0x04
#define	TH_PUSH	0x08
#define	TH_ACK	0x10
#define	TH_URG	0x20
	u_short	th_win;			/* window */
	u_short	th_sum;			/* checksum */
	u_short	th_urp;			/* urgent pointer */
};

/* ********************************************* */

struct ip {
#if BYTE_ORDER == LITTLE_ENDIAN 
	u_char	ip_hl:4,		/* header length */
		ip_v:4;			/* version */
#else
	u_char	ip_v:4,			/* version */
		ip_hl:4;		/* header length */
#endif
	u_char	ip_tos;			/* type of service */
	short	ip_len;			/* total length */
	u_short	ip_id;			/* identification */
	short	ip_off;			/* fragment offset field */
#define	IP_DF 0x4000			/* dont fragment flag */
#define	IP_MF 0x2000			/* more fragments flag */
#define	IP_OFFMASK 0x1fff		/* mask for fragmenting bits */
	u_char	ip_ttl;			/* time to live */
	u_char	ip_p;			/* protocol */
	u_short	ip_sum;			/* checksum */
	struct	in_addr ip_src,ip_dst;	/* source and dest address */
};

/* ********************************************* */

/*
 * Udp protocol header.
 * Per RFC 768, September, 1981.
 */
struct udphdr {
	u_short	uh_sport;		/* source port */
	u_short	uh_dport;		/* destination port */
	short	uh_ulen;		/* udp length */
	u_short	uh_sum;			/* udp checksum */
};

#endif /* WIN32 */

/* ************************************ */

/*
 * fallbacks for essential typedefs
 */
#if !defined(HAVE_U_INT64_T)
#if defined(WIN32) && defined(__GNUC__)
typedef unsigned long long u_int64_t; /* on mingw unsigned long is 32 bits */
#else 
#if defined(WIN32)
typedef _int64 u_int64_t;
#else
#if defined(HAVE_UINT64_T)
#define u_int64_t uint64_t
#else
#error "Sorry, I'm unable to define u_int64_t on your platform"
#endif
#endif
#endif
#endif

#if !defined(HAVE_U_INT32_T)
typedef unsigned int u_int32_t;
#endif

#if !defined(HAVE_U_INT16_T)
typedef unsigned short u_int16_t;
#endif

#if !defined(HAVE_U_INT8_T)
typedef unsigned char u_int8_t;
#endif

#if !defined(HAVE_INT32_T)
typedef int int32_t;
#endif

#if !defined(HAVE_INT16_T)
typedef short int16_t;
#endif

#if !defined(HAVE_INT8_T)
typedef char int8_t;
#endif

/* ************************************ */

typedef struct pthreadMutex {
  pthread_mutex_t mutex;
  char   isLocked, isInitialized;
  char   lockFile[64];
  int    lockLine;
  char   unlockFile[64];
  int    unlockLine;
  u_int  numLocks, numReleases;

  time_t lockTime;
  char   maxLockedDurationUnlockFile[64];
  int    maxLockedDurationUnlockLine;
  int    maxLockedDuration;
} PthreadMutex;

#define BUF_SIZE 512

#define TRACE_ERROR     0, __FILE__, __LINE__
#define TRACE_WARNING   1, __FILE__, __LINE__
#define TRACE_NORMAL    2, __FILE__, __LINE__
#define TRACE_INFO      3, __FILE__, __LINE__

#define createMutex(a)     _createMutex(a, __FILE__, __LINE__)
#define accessMutex(a, b)  _accessMutex(a, b, __FILE__, __LINE__)
#define deleteMutex(a)     _deleteMutex(a, __FILE__, __LINE__)
#define tryLockMutex(a, b) _tryLockMutex(a, b, __FILE__, __LINE__)
#define isMutexLocked(a)   _isMutexLocked(a, __FILE__, __LINE__)
#define releaseMutex(a)    _releaseMutex(a, __FILE__, __LINE__)

/* ************************************************ */

extern char *optarg;

/* ************************************************ */

void traceEvent(int eventTraceLevel, char* file, int line, char * format, ...);
int  createThread(pthread_t *threadId, void *(*__start_routine) (void *), char* userParm);
void killThread(pthread_t *threadId);

int _accessMutex(PthreadMutex *mutexId, char* where, char* fileName, int fileLine);
int _releaseMutex(PthreadMutex *mutexId, char* fileName, int fileLine);
int _createMutex(PthreadMutex *mutexId, char* fileName, int fileLine);
void _deleteMutex(PthreadMutex *mutexId, char* fileName, int fileLine);

#ifdef WIN32
#define nprobe_sleep(a /* sec */) waitForNextEvent(1000*a /* ms */)
extern unsigned long waitForNextEvent(unsigned long ulDelay /* ms */);
void initWinsock32();
#define close(fd) closesocket(fd)
#else
int nprobe_sleep(int secs);
#endif

/* ********* NETFLOW ****************** */

#ifdef WIN32
typedef unsigned char u_int8_t;
typedef unsigned short u_int16_t;
typedef unsigned int u_int32_t;
typedef _int64 u_int64_t;
#endif

/*
  For more info see:

  http://www.cisco.com/warp/public/cc/pd/iosw/ioft/neflct/tech/napps_wp.htm

  ftp://ftp.net.ohio-state.edu/users/maf/cisco/
*/

#define FLOW_VERSION_1		 1
#define V1FLOWS_PER_PAK		24

struct flow_ver1_hdr {
  u_int16_t version;     /* Current version=5*/
  u_int16_t count;       /* The number of records in PDU. */
  u_int32_t sysUptime;   /* Current time in msecs since router booted */
  u_int32_t unix_secs;   /* Current seconds since 0000 UTC 1970 */
  u_int32_t unix_nsecs;  /* Residual nanoseconds since 0000 UTC 1970 */
};

struct flow_ver1_rec {
  u_int32_t srcaddr;     /* Source IP Address */
  u_int32_t dstaddr;     /* Destination IP Address */
  u_int32_t nexthop;     /* Next hop router's IP Address */
  u_int16_t input;       /* Input interface index */
  u_int16_t output;      /* Output interface index */
  u_int32_t dPkts;       /* Packets sent in Duration (milliseconds between 1st & last packet in this flow)*/
  u_int32_t dOctets;     /* Octets sent in Duration (milliseconds between 1st & last packet in  this flow)*/
  u_int32_t First;       /* SysUptime at start of flow */
  u_int32_t Last;        /* and of last packet of the flow */
  u_int16_t srcport;     /* TCP/UDP source port number (.e.g, FTP, Telnet, etc.,or equivalent) */
  u_int16_t dstport;     /* TCP/UDP destination port number (.e.g, FTP, Telnet, etc.,or equivalent) */
  u_int16_t pad1;        /* pad to word boundary */
  u_int8_t  prot;        /* IP protocol, e.g., 6=TCP, 17=UDP, etc... */
  u_int8_t  tos;         /* IP Type-of-Service */
  u_int8_t  tcp_flags;   /* Cumulative OR of tcp flags */
  u_int8_t  pad2;        /* pad to word boundary */
  u_int16_t pad3;        /* pad to word boundary */
  u_int8_t  reserved[8]; /* reserved */
};

typedef struct single_flow_ver1_rec {
  struct flow_ver1_hdr flowHeader;
  struct flow_ver1_rec flowRecord[V1FLOWS_PER_PAK+1 /* safe against buffer overflows */];
} NetFlow1Record;

/* ***************************************** */

#define FLOW_VERSION_5		 5
#define V5FLOWS_PER_PAK		30

struct flow_ver5_hdr {
  u_int16_t version;         /* Current version=5*/
  u_int16_t count;           /* The number of records in PDU. */
  u_int32_t sysUptime;       /* Current time in msecs since router booted */
  u_int32_t unix_secs;       /* Current seconds since 0000 UTC 1970 */
  u_int32_t unix_nsecs;      /* Residual nanoseconds since 0000 UTC 1970 */
  u_int32_t flow_sequence;   /* Sequence number of total flows seen */
  u_int8_t  engine_type;     /* Type of flow switching engine (RP,VIP,etc.)*/
  u_int8_t  engine_id;       /* Slot number of the flow switching engine */
};

struct flow_ver5_rec {
  u_int32_t srcaddr;    /* Source IP Address */
  u_int32_t dstaddr;    /* Destination IP Address */
  u_int32_t nexthop;    /* Next hop router's IP Address */
  u_int16_t input;      /* Input interface index */
  u_int16_t output;     /* Output interface index */
  u_int32_t dPkts;      /* Packets sent in Duration (milliseconds between 1st
			   & last packet in this flow)*/
  u_int32_t dOctets;    /* Octets sent in Duration (milliseconds between 1st
			   & last packet in  this flow)*/
  u_int32_t First;      /* SysUptime at start of flow */
  u_int32_t Last;       /* and of last packet of the flow */
  u_int16_t srcport;    /* TCP/UDP source port number (.e.g, FTP, Telnet, etc.,or equivalent) */
  u_int16_t dstport;    /* TCP/UDP destination port number (.e.g, FTP, Telnet, etc.,or equivalent) */
  u_int8_t pad1;        /* pad to word boundary */
  u_int8_t tcp_flags;   /* Cumulative OR of tcp flags */
  u_int8_t prot;        /* IP protocol, e.g., 6=TCP, 17=UDP, etc... */
  u_int8_t tos;         /* IP Type-of-Service */
  u_int16_t dst_as;     /* dst peer/origin Autonomous System */
  u_int16_t src_as;     /* source peer/origin Autonomous System */
  u_int8_t dst_mask;    /* destination route's mask bits */
  u_int8_t src_mask;    /* source route's mask bits */
  u_int16_t pad2;       /* pad to word boundary */
};

typedef struct single_flow_ver5_rec {
  struct flow_ver5_hdr flowHeader;
  struct flow_ver5_rec flowRecord[V5FLOWS_PER_PAK+1 /* safe against buffer overflows */];
} NetFlow5Record;

u_int64_t totExports = 0;
int netFlowOutSocket;
int traceLevel = 5;
struct sockaddr_in netFlowDest;
PthreadMutex theMutex;
int useSyslog = 0;

/* ************************************ */

struct mypcap {
  int fd, snapshot, linktype, tzoff, offset;
  FILE *rfile;

  /* Other fields have been skipped. Please refer
     to pcap-int.h for the full datatype.
  */
};

typedef struct hashBucket {
  u_short proto;          /* protocol (e.g. UDP/TCP..) */
  struct in_addr src;
  u_short sport;
  struct in_addr dst;
  u_short dport;
  unsigned short tcpFlags;
  /* **************** */
  u_long bytesSent, pktSent;
  time_t firstSeenSent, lastSeenSent;
  u_long bytesRcvd, pktRcvd;
  time_t firstSeenRcvd, lastSeenRcvd;
} HashBucket;

/* ************************************ */

#ifndef NTOHL
#define NTOHL(x)    (x) = ntohl(x)
#endif

#define DEFAULT_SNAPLEN 128
#define DUMP_TIMEOUT    60 /* seconds */

/* #define DEBUG  */

#define HASH_SIZE 16384

#ifndef WIN32
#define USE_SYSLOG 1
#endif

extern int getopt(int num, char *const *argv, const char *opts);
extern char *optarg;

#ifdef WIN32
char* printAvailableInterfaces(int i);
#endif

/* *************************** */

/*
#define MAX_DEMO_FLOWS 1000
#define DEMO_MODE
*/
