/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class BinaryExpression
extends OperatorExpression {
    public Expression left;
    public Expression right;
    public Constant optimizedBooleanConstant;

    public BinaryExpression(Expression left, Expression right, int operator) {
        this.left = left;
        this.right = right;
        this.bits |= operator << 6;
        this.sourceStart = left.sourceStart;
        this.sourceEnd = right.sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.right.analyseCode(currentScope, flowContext, this.left.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits()).unconditionalInits();
    }

    public void computeConstant(BlockScope scope, int leftId, int rightId) {
        if (this.left.constant != Constant.NotAConstant && this.right.constant != Constant.NotAConstant) {
            try {
                this.constant = Constant.computeConstantOperation(this.left.constant, leftId, (this.bits & 0xFC0) >> 6, this.right.constant, rightId);
            }
            catch (ArithmeticException e) {
                this.constant = Constant.NotAConstant;
            }
        } else {
            this.constant = Constant.NotAConstant;
            this.optimizedBooleanConstant(leftId, (this.bits & 0xFC0) >> 6, rightId);
        }
    }

    public Constant optimizedBooleanConstant() {
        return this.optimizedBooleanConstant == null ? this.constant : this.optimizedBooleanConstant;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (this.constant != Constant.NotAConstant) {
            if (valueRequired) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
            return;
        }
        this.bits |= 0x20;
        switch ((this.bits & 0xFC0) >> 6) {
            case 14: {
                switch (this.bits & 0xF) {
                    case 11: {
                        codeStream.generateStringAppend(currentScope, this.left, this.right);
                        if (valueRequired) break;
                        codeStream.pop();
                        break;
                    }
                    case 10: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.iadd();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.ladd();
                        break;
                    }
                    case 8: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.dadd();
                        break;
                    }
                    case 9: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.fadd();
                    }
                }
                break;
            }
            case 13: {
                switch (this.bits & 0xF) {
                    case 10: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.isub();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.lsub();
                        break;
                    }
                    case 8: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.dsub();
                        break;
                    }
                    case 9: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.fsub();
                    }
                }
                break;
            }
            case 15: {
                switch (this.bits & 0xF) {
                    case 10: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.imul();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.lmul();
                        break;
                    }
                    case 8: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.dmul();
                        break;
                    }
                    case 9: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.fmul();
                    }
                }
                break;
            }
            case 9: {
                switch (this.bits & 0xF) {
                    case 10: {
                        this.left.generateCode(currentScope, codeStream, true);
                        this.right.generateCode(currentScope, codeStream, true);
                        codeStream.idiv();
                        if (valueRequired) break;
                        codeStream.pop();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(currentScope, codeStream, true);
                        this.right.generateCode(currentScope, codeStream, true);
                        codeStream.ldiv();
                        if (valueRequired) break;
                        codeStream.pop2();
                        break;
                    }
                    case 8: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.ddiv();
                        break;
                    }
                    case 9: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.fdiv();
                    }
                }
                break;
            }
            case 16: {
                switch (this.bits & 0xF) {
                    case 10: {
                        this.left.generateCode(currentScope, codeStream, true);
                        this.right.generateCode(currentScope, codeStream, true);
                        codeStream.irem();
                        if (valueRequired) break;
                        codeStream.pop();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(currentScope, codeStream, true);
                        this.right.generateCode(currentScope, codeStream, true);
                        codeStream.lrem();
                        if (valueRequired) break;
                        codeStream.pop2();
                        break;
                    }
                    case 8: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.drem();
                        break;
                    }
                    case 9: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.frem();
                    }
                }
                break;
            }
            case 2: {
                switch (this.bits & 0xF) {
                    case 10: {
                        if (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 10 && this.left.constant.intValue() == 0) {
                            this.right.generateCode(currentScope, codeStream, false);
                            if (!valueRequired) break;
                            codeStream.iconst_0();
                            break;
                        }
                        if (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 10 && this.right.constant.intValue() == 0) {
                            this.left.generateCode(currentScope, codeStream, false);
                            if (!valueRequired) break;
                            codeStream.iconst_0();
                            break;
                        }
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.iand();
                        break;
                    }
                    case 7: {
                        if (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 7 && this.left.constant.longValue() == 0L) {
                            this.right.generateCode(currentScope, codeStream, false);
                            if (!valueRequired) break;
                            codeStream.lconst_0();
                            break;
                        }
                        if (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 7 && this.right.constant.longValue() == 0L) {
                            this.left.generateCode(currentScope, codeStream, false);
                            if (!valueRequired) break;
                            codeStream.lconst_0();
                            break;
                        }
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.land();
                        break;
                    }
                    case 5: {
                        Label falseLabel = new Label(codeStream);
                        this.generateOptimizedLogicalAnd(currentScope, codeStream, null, falseLabel, valueRequired);
                        if (!falseLabel.hasForwardReferences()) break;
                        if (valueRequired) {
                            codeStream.iconst_1();
                            if ((this.bits & 0x10) != 0) {
                                codeStream.ireturn();
                                falseLabel.place();
                                codeStream.iconst_0();
                                break;
                            }
                            Label endLabel = new Label(codeStream);
                            codeStream.goto_(endLabel);
                            codeStream.decrStackSize(1);
                            falseLabel.place();
                            codeStream.iconst_0();
                            endLabel.place();
                            break;
                        }
                        falseLabel.place();
                    }
                }
                break;
            }
            case 3: {
                switch (this.bits & 0xF) {
                    case 10: {
                        if (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 10 && this.left.constant.intValue() == 0) {
                            this.right.generateCode(currentScope, codeStream, valueRequired);
                            break;
                        }
                        if (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 10 && this.right.constant.intValue() == 0) {
                            this.left.generateCode(currentScope, codeStream, valueRequired);
                            break;
                        }
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.ior();
                        break;
                    }
                    case 7: {
                        if (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 7 && this.left.constant.longValue() == 0L) {
                            this.right.generateCode(currentScope, codeStream, valueRequired);
                            break;
                        }
                        if (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 7 && this.right.constant.longValue() == 0L) {
                            this.left.generateCode(currentScope, codeStream, valueRequired);
                            break;
                        }
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.lor();
                        break;
                    }
                    case 5: {
                        Label falseLabel = new Label(codeStream);
                        this.generateOptimizedLogicalOr(currentScope, codeStream, null, falseLabel, valueRequired);
                        if (!falseLabel.hasForwardReferences()) break;
                        if (valueRequired) {
                            codeStream.iconst_1();
                            if ((this.bits & 0x10) != 0) {
                                codeStream.ireturn();
                                falseLabel.place();
                                codeStream.iconst_0();
                                break;
                            }
                            Label endLabel = new Label(codeStream);
                            codeStream.goto_(endLabel);
                            codeStream.decrStackSize(1);
                            falseLabel.place();
                            codeStream.iconst_0();
                            endLabel.place();
                            break;
                        }
                        falseLabel.place();
                    }
                }
                break;
            }
            case 8: {
                switch (this.bits & 0xF) {
                    case 10: {
                        if (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 10 && this.left.constant.intValue() == 0) {
                            this.right.generateCode(currentScope, codeStream, valueRequired);
                            break;
                        }
                        if (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 10 && this.right.constant.intValue() == 0) {
                            this.left.generateCode(currentScope, codeStream, valueRequired);
                            break;
                        }
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.ixor();
                        break;
                    }
                    case 7: {
                        if (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 7 && this.left.constant.longValue() == 0L) {
                            this.right.generateCode(currentScope, codeStream, valueRequired);
                            break;
                        }
                        if (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 7 && this.right.constant.longValue() == 0L) {
                            this.left.generateCode(currentScope, codeStream, valueRequired);
                            break;
                        }
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.lxor();
                        break;
                    }
                    case 5: {
                        Label falseLabel = new Label(codeStream);
                        this.generateOptimizedLogicalXor(currentScope, codeStream, null, falseLabel, valueRequired);
                        if (!falseLabel.hasForwardReferences()) break;
                        if (valueRequired) {
                            codeStream.iconst_1();
                            if ((this.bits & 0x10) != 0) {
                                codeStream.ireturn();
                                falseLabel.place();
                                codeStream.iconst_0();
                                break;
                            }
                            Label endLabel = new Label(codeStream);
                            codeStream.goto_(endLabel);
                            codeStream.decrStackSize(1);
                            falseLabel.place();
                            codeStream.iconst_0();
                            endLabel.place();
                            break;
                        }
                        falseLabel.place();
                    }
                }
                break;
            }
            case 10: {
                switch (this.bits & 0xF) {
                    case 10: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.ishl();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.lshl();
                    }
                }
                break;
            }
            case 17: {
                switch (this.bits & 0xF) {
                    case 10: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.ishr();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.lshr();
                    }
                }
                break;
            }
            case 19: {
                switch (this.bits & 0xF) {
                    case 10: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.iushr();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                        if (!valueRequired) break;
                        codeStream.lushr();
                    }
                }
                break;
            }
            case 6: {
                Label falseLabel = new Label(codeStream);
                this.generateOptimizedGreaterThan(currentScope, codeStream, null, falseLabel, valueRequired);
                if (!valueRequired) break;
                codeStream.iconst_1();
                if ((this.bits & 0x10) != 0) {
                    codeStream.ireturn();
                    falseLabel.place();
                    codeStream.iconst_0();
                    break;
                }
                Label endLabel = new Label(codeStream);
                codeStream.goto_(endLabel);
                codeStream.decrStackSize(1);
                falseLabel.place();
                codeStream.iconst_0();
                endLabel.place();
                break;
            }
            case 7: {
                Label falseLabel = new Label(codeStream);
                this.generateOptimizedGreaterThanOrEqual(currentScope, codeStream, null, falseLabel, valueRequired);
                if (!valueRequired) break;
                codeStream.iconst_1();
                if ((this.bits & 0x10) != 0) {
                    codeStream.ireturn();
                    falseLabel.place();
                    codeStream.iconst_0();
                    break;
                }
                Label endLabel = new Label(codeStream);
                codeStream.goto_(endLabel);
                codeStream.decrStackSize(1);
                falseLabel.place();
                codeStream.iconst_0();
                endLabel.place();
                break;
            }
            case 4: {
                Label falseLabel = new Label(codeStream);
                this.generateOptimizedLessThan(currentScope, codeStream, null, falseLabel, valueRequired);
                if (!valueRequired) break;
                codeStream.iconst_1();
                if ((this.bits & 0x10) != 0) {
                    codeStream.ireturn();
                    falseLabel.place();
                    codeStream.iconst_0();
                    break;
                }
                Label endLabel = new Label(codeStream);
                codeStream.goto_(endLabel);
                codeStream.decrStackSize(1);
                falseLabel.place();
                codeStream.iconst_0();
                endLabel.place();
                break;
            }
            case 5: {
                Label falseLabel = new Label(codeStream);
                this.generateOptimizedLessThanOrEqual(currentScope, codeStream, null, falseLabel, valueRequired);
                if (!valueRequired) break;
                codeStream.iconst_1();
                if ((this.bits & 0x10) != 0) {
                    codeStream.ireturn();
                    falseLabel.place();
                    codeStream.iconst_0();
                    break;
                }
                Label endLabel = new Label(codeStream);
                codeStream.goto_(endLabel);
                codeStream.decrStackSize(1);
                falseLabel.place();
                codeStream.iconst_0();
                endLabel.place();
            }
        }
        if (valueRequired) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void generateOptimizedBoolean(BlockScope currentScope, CodeStream codeStream, Label trueLabel, Label falseLabel, boolean valueRequired) {
        if (this.constant != Constant.NotAConstant && this.constant.typeID() == 5) {
            super.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
            return;
        }
        switch ((this.bits & 0xFC0) >> 6) {
            case 4: {
                this.generateOptimizedLessThan(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
                return;
            }
            case 5: {
                this.generateOptimizedLessThanOrEqual(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
                return;
            }
            case 6: {
                this.generateOptimizedGreaterThan(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
                return;
            }
            case 7: {
                this.generateOptimizedGreaterThanOrEqual(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
                return;
            }
            case 2: {
                this.generateOptimizedLogicalAnd(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
                return;
            }
            case 3: {
                this.generateOptimizedLogicalOr(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
                return;
            }
            case 8: {
                this.generateOptimizedLogicalXor(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
                return;
            }
        }
        super.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
    }

    public void generateOptimizedGreaterThan(BlockScope currentScope, CodeStream codeStream, Label trueLabel, Label falseLabel, boolean valueRequired) {
        int promotedTypeID = this.left.implicitConversion >> 4;
        if (promotedTypeID == 10) {
            if (this.left.constant != ASTNode.NotAConstant && this.left.constant.intValue() == 0) {
                this.right.generateCode(currentScope, codeStream, valueRequired);
                if (valueRequired) {
                    if (falseLabel == null) {
                        if (trueLabel != null) {
                            codeStream.iflt(trueLabel);
                        }
                    } else if (trueLabel == null) {
                        codeStream.ifge(falseLabel);
                    }
                }
                codeStream.updateLastRecordedEndPC(codeStream.position);
                return;
            }
            if (this.right.constant != ASTNode.NotAConstant && this.right.constant.intValue() == 0) {
                this.left.generateCode(currentScope, codeStream, valueRequired);
                if (valueRequired) {
                    if (falseLabel == null) {
                        if (trueLabel != null) {
                            codeStream.ifgt(trueLabel);
                        }
                    } else if (trueLabel == null) {
                        codeStream.ifle(falseLabel);
                    }
                }
                codeStream.updateLastRecordedEndPC(codeStream.position);
                return;
            }
        }
        this.left.generateCode(currentScope, codeStream, valueRequired);
        this.right.generateCode(currentScope, codeStream, valueRequired);
        if (valueRequired) {
            if (falseLabel == null) {
                if (trueLabel != null) {
                    switch (promotedTypeID) {
                        case 10: {
                            codeStream.if_icmpgt(trueLabel);
                            break;
                        }
                        case 9: {
                            codeStream.fcmpl();
                            codeStream.ifgt(trueLabel);
                            break;
                        }
                        case 7: {
                            codeStream.lcmp();
                            codeStream.ifgt(trueLabel);
                            break;
                        }
                        case 8: {
                            codeStream.dcmpl();
                            codeStream.ifgt(trueLabel);
                        }
                    }
                    codeStream.updateLastRecordedEndPC(codeStream.position);
                    return;
                }
            } else if (trueLabel == null) {
                switch (promotedTypeID) {
                    case 10: {
                        codeStream.if_icmple(falseLabel);
                        break;
                    }
                    case 9: {
                        codeStream.fcmpl();
                        codeStream.ifle(falseLabel);
                        break;
                    }
                    case 7: {
                        codeStream.lcmp();
                        codeStream.ifle(falseLabel);
                        break;
                    }
                    case 8: {
                        codeStream.dcmpl();
                        codeStream.ifle(falseLabel);
                    }
                }
                codeStream.updateLastRecordedEndPC(codeStream.position);
                return;
            }
        }
    }

    public void generateOptimizedGreaterThanOrEqual(BlockScope currentScope, CodeStream codeStream, Label trueLabel, Label falseLabel, boolean valueRequired) {
        int promotedTypeID = this.left.implicitConversion >> 4;
        if (promotedTypeID == 10) {
            if (this.left.constant != ASTNode.NotAConstant && this.left.constant.intValue() == 0) {
                this.right.generateCode(currentScope, codeStream, valueRequired);
                if (valueRequired) {
                    if (falseLabel == null) {
                        if (trueLabel != null) {
                            codeStream.ifle(trueLabel);
                        }
                    } else if (trueLabel == null) {
                        codeStream.ifgt(falseLabel);
                    }
                }
                codeStream.updateLastRecordedEndPC(codeStream.position);
                return;
            }
            if (this.right.constant != ASTNode.NotAConstant && this.right.constant.intValue() == 0) {
                this.left.generateCode(currentScope, codeStream, valueRequired);
                if (valueRequired) {
                    if (falseLabel == null) {
                        if (trueLabel != null) {
                            codeStream.ifge(trueLabel);
                        }
                    } else if (trueLabel == null) {
                        codeStream.iflt(falseLabel);
                    }
                }
                codeStream.updateLastRecordedEndPC(codeStream.position);
                return;
            }
        }
        this.left.generateCode(currentScope, codeStream, valueRequired);
        this.right.generateCode(currentScope, codeStream, valueRequired);
        if (valueRequired) {
            if (falseLabel == null) {
                if (trueLabel != null) {
                    switch (promotedTypeID) {
                        case 10: {
                            codeStream.if_icmpge(trueLabel);
                            break;
                        }
                        case 9: {
                            codeStream.fcmpl();
                            codeStream.ifge(trueLabel);
                            break;
                        }
                        case 7: {
                            codeStream.lcmp();
                            codeStream.ifge(trueLabel);
                            break;
                        }
                        case 8: {
                            codeStream.dcmpl();
                            codeStream.ifge(trueLabel);
                        }
                    }
                    codeStream.updateLastRecordedEndPC(codeStream.position);
                    return;
                }
            } else if (trueLabel == null) {
                switch (promotedTypeID) {
                    case 10: {
                        codeStream.if_icmplt(falseLabel);
                        break;
                    }
                    case 9: {
                        codeStream.fcmpl();
                        codeStream.iflt(falseLabel);
                        break;
                    }
                    case 7: {
                        codeStream.lcmp();
                        codeStream.iflt(falseLabel);
                        break;
                    }
                    case 8: {
                        codeStream.dcmpl();
                        codeStream.iflt(falseLabel);
                    }
                }
                codeStream.updateLastRecordedEndPC(codeStream.position);
                return;
            }
        }
    }

    public void generateOptimizedLessThan(BlockScope currentScope, CodeStream codeStream, Label trueLabel, Label falseLabel, boolean valueRequired) {
        int promotedTypeID = this.left.implicitConversion >> 4;
        if (promotedTypeID == 10) {
            if (this.left.constant != ASTNode.NotAConstant && this.left.constant.intValue() == 0) {
                this.right.generateCode(currentScope, codeStream, valueRequired);
                if (valueRequired) {
                    if (falseLabel == null) {
                        if (trueLabel != null) {
                            codeStream.ifgt(trueLabel);
                        }
                    } else if (trueLabel == null) {
                        codeStream.ifle(falseLabel);
                    }
                }
                codeStream.updateLastRecordedEndPC(codeStream.position);
                return;
            }
            if (this.right.constant != ASTNode.NotAConstant && this.right.constant.intValue() == 0) {
                this.left.generateCode(currentScope, codeStream, valueRequired);
                if (valueRequired) {
                    if (falseLabel == null) {
                        if (trueLabel != null) {
                            codeStream.iflt(trueLabel);
                        }
                    } else if (trueLabel == null) {
                        codeStream.ifge(falseLabel);
                    }
                }
                codeStream.updateLastRecordedEndPC(codeStream.position);
                return;
            }
        }
        this.left.generateCode(currentScope, codeStream, valueRequired);
        this.right.generateCode(currentScope, codeStream, valueRequired);
        if (valueRequired) {
            if (falseLabel == null) {
                if (trueLabel != null) {
                    switch (promotedTypeID) {
                        case 10: {
                            codeStream.if_icmplt(trueLabel);
                            break;
                        }
                        case 9: {
                            codeStream.fcmpg();
                            codeStream.iflt(trueLabel);
                            break;
                        }
                        case 7: {
                            codeStream.lcmp();
                            codeStream.iflt(trueLabel);
                            break;
                        }
                        case 8: {
                            codeStream.dcmpg();
                            codeStream.iflt(trueLabel);
                        }
                    }
                    codeStream.updateLastRecordedEndPC(codeStream.position);
                    return;
                }
            } else if (trueLabel == null) {
                switch (promotedTypeID) {
                    case 10: {
                        codeStream.if_icmpge(falseLabel);
                        break;
                    }
                    case 9: {
                        codeStream.fcmpg();
                        codeStream.ifge(falseLabel);
                        break;
                    }
                    case 7: {
                        codeStream.lcmp();
                        codeStream.ifge(falseLabel);
                        break;
                    }
                    case 8: {
                        codeStream.dcmpg();
                        codeStream.ifge(falseLabel);
                    }
                }
                codeStream.updateLastRecordedEndPC(codeStream.position);
                return;
            }
        }
    }

    public void generateOptimizedLessThanOrEqual(BlockScope currentScope, CodeStream codeStream, Label trueLabel, Label falseLabel, boolean valueRequired) {
        int promotedTypeID = this.left.implicitConversion >> 4;
        if (promotedTypeID == 10) {
            if (this.left.constant != ASTNode.NotAConstant && this.left.constant.intValue() == 0) {
                this.right.generateCode(currentScope, codeStream, valueRequired);
                if (valueRequired) {
                    if (falseLabel == null) {
                        if (trueLabel != null) {
                            codeStream.ifge(trueLabel);
                        }
                    } else if (trueLabel == null) {
                        codeStream.iflt(falseLabel);
                    }
                }
                codeStream.updateLastRecordedEndPC(codeStream.position);
                return;
            }
            if (this.right.constant != ASTNode.NotAConstant && this.right.constant.intValue() == 0) {
                this.left.generateCode(currentScope, codeStream, valueRequired);
                if (valueRequired) {
                    if (falseLabel == null) {
                        if (trueLabel != null) {
                            codeStream.ifle(trueLabel);
                        }
                    } else if (trueLabel == null) {
                        codeStream.ifgt(falseLabel);
                    }
                }
                codeStream.updateLastRecordedEndPC(codeStream.position);
                return;
            }
        }
        this.left.generateCode(currentScope, codeStream, valueRequired);
        this.right.generateCode(currentScope, codeStream, valueRequired);
        if (valueRequired) {
            if (falseLabel == null) {
                if (trueLabel != null) {
                    switch (promotedTypeID) {
                        case 10: {
                            codeStream.if_icmple(trueLabel);
                            break;
                        }
                        case 9: {
                            codeStream.fcmpg();
                            codeStream.ifle(trueLabel);
                            break;
                        }
                        case 7: {
                            codeStream.lcmp();
                            codeStream.ifle(trueLabel);
                            break;
                        }
                        case 8: {
                            codeStream.dcmpg();
                            codeStream.ifle(trueLabel);
                        }
                    }
                    codeStream.updateLastRecordedEndPC(codeStream.position);
                    return;
                }
            } else if (trueLabel == null) {
                switch (promotedTypeID) {
                    case 10: {
                        codeStream.if_icmpgt(falseLabel);
                        break;
                    }
                    case 9: {
                        codeStream.fcmpg();
                        codeStream.ifgt(falseLabel);
                        break;
                    }
                    case 7: {
                        codeStream.lcmp();
                        codeStream.ifgt(falseLabel);
                        break;
                    }
                    case 8: {
                        codeStream.dcmpg();
                        codeStream.ifgt(falseLabel);
                    }
                }
                codeStream.updateLastRecordedEndPC(codeStream.position);
                return;
            }
        }
    }

    public void generateOptimizedLogicalAnd(BlockScope currentScope, CodeStream codeStream, Label trueLabel, Label falseLabel, boolean valueRequired) {
        if ((this.left.implicitConversion & 0xF) == 5) {
            Constant condConst = this.left.optimizedBooleanConstant();
            if (condConst != ASTNode.NotAConstant) {
                if (condConst.booleanValue()) {
                    this.left.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, false);
                    if ((this.bits & 0x20) != 0) {
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                    } else {
                        this.right.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
                    }
                } else {
                    this.left.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, false);
                    Label internalTrueLabel = new Label(codeStream);
                    this.right.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, false);
                    internalTrueLabel.place();
                    if (valueRequired) {
                        if ((this.bits & 0x20) != 0) {
                            codeStream.iconst_0();
                        } else if (falseLabel != null) {
                            codeStream.goto_(falseLabel);
                        }
                    }
                    codeStream.updateLastRecordedEndPC(codeStream.position);
                }
                return;
            }
            condConst = this.right.optimizedBooleanConstant();
            if (condConst != ASTNode.NotAConstant) {
                if (condConst.booleanValue()) {
                    if ((this.bits & 0x20) != 0) {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                    } else {
                        this.left.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
                    }
                    this.right.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, false);
                } else {
                    Label internalTrueLabel = new Label(codeStream);
                    this.left.generateOptimizedBoolean(currentScope, codeStream, internalTrueLabel, falseLabel, false);
                    internalTrueLabel.place();
                    this.right.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, false);
                    if (valueRequired) {
                        if ((this.bits & 0x20) != 0) {
                            codeStream.iconst_0();
                        } else if (falseLabel != null) {
                            codeStream.goto_(falseLabel);
                        }
                    }
                    codeStream.updateLastRecordedEndPC(codeStream.position);
                }
                return;
            }
        }
        this.left.generateCode(currentScope, codeStream, valueRequired);
        this.right.generateCode(currentScope, codeStream, valueRequired);
        if (valueRequired) {
            codeStream.iand();
            if ((this.bits & 0x20) == 0) {
                if (falseLabel == null) {
                    if (trueLabel != null) {
                        codeStream.ifne(trueLabel);
                    }
                } else if (trueLabel == null) {
                    codeStream.ifeq(falseLabel);
                }
            }
        }
        codeStream.updateLastRecordedEndPC(codeStream.position);
    }

    public void generateOptimizedLogicalOr(BlockScope currentScope, CodeStream codeStream, Label trueLabel, Label falseLabel, boolean valueRequired) {
        if ((this.left.implicitConversion & 0xF) == 5) {
            Constant condConst = this.left.optimizedBooleanConstant();
            if (condConst != ASTNode.NotAConstant) {
                if (condConst.booleanValue()) {
                    this.left.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, false);
                    Label internalFalseLabel = new Label(codeStream);
                    this.right.generateOptimizedBoolean(currentScope, codeStream, trueLabel, internalFalseLabel, false);
                    internalFalseLabel.place();
                    if (valueRequired) {
                        if ((this.bits & 0x20) != 0) {
                            codeStream.iconst_1();
                        } else if (trueLabel != null) {
                            codeStream.goto_(trueLabel);
                        }
                    }
                    codeStream.updateLastRecordedEndPC(codeStream.position);
                } else {
                    this.left.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, false);
                    if ((this.bits & 0x20) != 0) {
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                    } else {
                        this.right.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
                    }
                }
                return;
            }
            condConst = this.right.optimizedBooleanConstant();
            if (condConst != ASTNode.NotAConstant) {
                if (condConst.booleanValue()) {
                    Label internalFalseLabel = new Label(codeStream);
                    this.left.generateOptimizedBoolean(currentScope, codeStream, trueLabel, internalFalseLabel, false);
                    internalFalseLabel.place();
                    this.right.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, false);
                    if (valueRequired) {
                        if ((this.bits & 0x20) != 0) {
                            codeStream.iconst_1();
                        } else if (trueLabel != null) {
                            codeStream.goto_(trueLabel);
                        }
                    }
                    codeStream.updateLastRecordedEndPC(codeStream.position);
                } else {
                    if ((this.bits & 0x20) != 0) {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                    } else {
                        this.left.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
                    }
                    this.right.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, false);
                }
                return;
            }
        }
        this.left.generateCode(currentScope, codeStream, valueRequired);
        this.right.generateCode(currentScope, codeStream, valueRequired);
        if (valueRequired) {
            codeStream.ior();
            if ((this.bits & 0x20) == 0) {
                if (falseLabel == null) {
                    if (trueLabel != null) {
                        codeStream.ifne(trueLabel);
                    }
                } else if (trueLabel == null) {
                    codeStream.ifeq(falseLabel);
                }
            }
        }
        codeStream.updateLastRecordedEndPC(codeStream.position);
    }

    public void generateOptimizedLogicalXor(BlockScope currentScope, CodeStream codeStream, Label trueLabel, Label falseLabel, boolean valueRequired) {
        if ((this.left.implicitConversion & 0xF) == 5) {
            Constant condConst = this.left.optimizedBooleanConstant();
            if (condConst != ASTNode.NotAConstant) {
                if (condConst.booleanValue()) {
                    this.left.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, false);
                    this.right.generateOptimizedBoolean(currentScope, codeStream, falseLabel, trueLabel, valueRequired);
                } else {
                    this.left.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, false);
                    if ((this.bits & 0x20) != 0) {
                        this.right.generateCode(currentScope, codeStream, valueRequired);
                    } else {
                        this.right.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
                    }
                }
                return;
            }
            condConst = this.right.optimizedBooleanConstant();
            if (condConst != ASTNode.NotAConstant) {
                if (condConst.booleanValue()) {
                    this.left.generateOptimizedBoolean(currentScope, codeStream, falseLabel, trueLabel, valueRequired);
                    this.right.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, false);
                } else {
                    if ((this.bits & 0x20) != 0) {
                        this.left.generateCode(currentScope, codeStream, valueRequired);
                    } else {
                        this.left.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
                    }
                    this.right.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, false);
                }
                return;
            }
        }
        this.left.generateCode(currentScope, codeStream, valueRequired);
        this.right.generateCode(currentScope, codeStream, valueRequired);
        if (valueRequired) {
            codeStream.ixor();
            if ((this.bits & 0x20) == 0) {
                if (falseLabel == null) {
                    if (trueLabel != null) {
                        codeStream.ifne(trueLabel);
                    }
                } else if (trueLabel == null) {
                    codeStream.ifeq(falseLabel);
                }
            }
        }
        codeStream.updateLastRecordedEndPC(codeStream.position);
    }

    public void generateOptimizedStringBuffer(BlockScope blockScope, CodeStream codeStream, int typeID) {
        if ((this.bits & 0xFC0) >> 6 == 14 && (this.bits & 0xF) == 11) {
            if (this.constant != ASTNode.NotAConstant) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
                codeStream.invokeStringBufferAppendForType(this.implicitConversion & 0xF);
            } else {
                int pc = codeStream.position;
                this.left.generateOptimizedStringBuffer(blockScope, codeStream, this.left.implicitConversion & 0xF);
                codeStream.recordPositionsFrom(pc, this.left.sourceStart);
                pc = codeStream.position;
                this.right.generateOptimizedStringBuffer(blockScope, codeStream, this.right.implicitConversion & 0xF);
                codeStream.recordPositionsFrom(pc, this.right.sourceStart);
            }
        } else {
            super.generateOptimizedStringBuffer(blockScope, codeStream, typeID);
        }
    }

    public void generateOptimizedStringBufferCreation(BlockScope blockScope, CodeStream codeStream, int typeID) {
        if ((this.bits & 0xFC0) >> 6 == 14 && (this.bits & 0xF) == 11) {
            if (this.constant != ASTNode.NotAConstant) {
                codeStream.newStringBuffer();
                codeStream.dup();
                codeStream.ldc(this.constant.stringValue());
                codeStream.invokeStringBufferStringConstructor();
            } else {
                int pc = codeStream.position;
                this.left.generateOptimizedStringBufferCreation(blockScope, codeStream, this.left.implicitConversion & 0xF);
                codeStream.recordPositionsFrom(pc, this.left.sourceStart);
                pc = codeStream.position;
                this.right.generateOptimizedStringBuffer(blockScope, codeStream, this.right.implicitConversion & 0xF);
                codeStream.recordPositionsFrom(pc, this.right.sourceStart);
            }
        } else {
            super.generateOptimizedStringBufferCreation(blockScope, codeStream, typeID);
        }
    }

    public boolean isCompactableOperation() {
        return true;
    }

    public void optimizedBooleanConstant(int leftId, int operator, int rightId) {
        switch (operator) {
            case 2: {
                if (leftId != 5 || rightId != 5) {
                    return;
                }
            }
            case 0: {
                Constant cst = this.left.optimizedBooleanConstant();
                if (cst != ASTNode.NotAConstant) {
                    if (!cst.booleanValue()) {
                        this.optimizedBooleanConstant = cst;
                        return;
                    }
                    cst = this.right.optimizedBooleanConstant();
                    if (cst != ASTNode.NotAConstant) {
                        this.optimizedBooleanConstant = cst;
                    }
                    return;
                }
                cst = this.right.optimizedBooleanConstant();
                if (cst != ASTNode.NotAConstant && !cst.booleanValue()) {
                    this.optimizedBooleanConstant = cst;
                }
                return;
            }
            case 3: {
                if (leftId != 5 || rightId != 5) {
                    return;
                }
            }
            case 1: {
                Constant cst = this.left.optimizedBooleanConstant();
                if (cst != ASTNode.NotAConstant) {
                    if (cst.booleanValue()) {
                        this.optimizedBooleanConstant = cst;
                        return;
                    }
                    cst = this.right.optimizedBooleanConstant();
                    if (cst != ASTNode.NotAConstant) {
                        this.optimizedBooleanConstant = cst;
                    }
                    return;
                }
                cst = this.right.optimizedBooleanConstant();
                if (cst == ASTNode.NotAConstant || !cst.booleanValue()) break;
                this.optimizedBooleanConstant = cst;
            }
        }
    }

    public StringBuffer printExpressionNoParenthesis(int indent, StringBuffer output) {
        this.left.printExpression(indent, output).append(' ').append(this.operatorToString()).append(' ');
        return this.right.printExpression(0, output);
    }

    public TypeBinding resolveType(BlockScope scope) {
        boolean leftIsCast = this.left instanceof CastExpression;
        if (leftIsCast) {
            this.left.bits |= 0x20;
        }
        TypeBinding leftType = this.left.resolveType(scope);
        boolean rightIsCast = this.right instanceof CastExpression;
        if (rightIsCast) {
            this.right.bits |= 0x20;
        }
        TypeBinding rightType = this.right.resolveType(scope);
        if (leftType == null || rightType == null) {
            this.constant = Constant.NotAConstant;
            return null;
        }
        int leftTypeId = leftType.id;
        int rightTypeId = rightType.id;
        if (leftTypeId > 15 || rightTypeId > 15) {
            if (leftTypeId == 11) {
                rightTypeId = 1;
            } else if (rightTypeId == 11) {
                leftTypeId = 1;
            } else {
                this.constant = Constant.NotAConstant;
                scope.problemReporter().invalidOperator(this, leftType, rightType);
                return null;
            }
        }
        if ((this.bits & 0xFC0) >> 6 == 14) {
            if (leftTypeId == 11 && rightType.isArrayType() && ((ArrayBinding)rightType).elementsType(scope) == BaseTypes.CharBinding) {
                scope.problemReporter().signalNoImplicitStringConversionForCharArrayExpression(this.right);
            } else if (rightTypeId == 11 && leftType.isArrayType() && ((ArrayBinding)leftType).elementsType(scope) == BaseTypes.CharBinding) {
                scope.problemReporter().signalNoImplicitStringConversionForCharArrayExpression(this.left);
            }
        }
        int operator = (this.bits & 0xFC0) >> 6;
        int operatorSignature = OperatorExpression.OperatorSignatures[operator][(leftTypeId << 4) + rightTypeId];
        this.left.implicitConversion = operatorSignature >>> 12;
        this.right.implicitConversion = operatorSignature >>> 4 & 0xFF;
        this.bits |= operatorSignature & 0xF;
        switch (operatorSignature & 0xF) {
            case 5: {
                this.resolvedType = BaseTypes.BooleanBinding;
                break;
            }
            case 3: {
                this.resolvedType = BaseTypes.ByteBinding;
                break;
            }
            case 2: {
                this.resolvedType = BaseTypes.CharBinding;
                break;
            }
            case 8: {
                this.resolvedType = BaseTypes.DoubleBinding;
                break;
            }
            case 9: {
                this.resolvedType = BaseTypes.FloatBinding;
                break;
            }
            case 10: {
                this.resolvedType = BaseTypes.IntBinding;
                break;
            }
            case 7: {
                this.resolvedType = BaseTypes.LongBinding;
                break;
            }
            case 11: {
                this.resolvedType = scope.getJavaLangString();
                break;
            }
            default: {
                this.constant = Constant.NotAConstant;
                scope.problemReporter().invalidOperator(this, leftType, rightType);
                return null;
            }
        }
        if (leftIsCast || rightIsCast) {
            CastExpression.checkNeedForArgumentCasts(scope, operator, operatorSignature, this.left, leftTypeId, leftIsCast, this.right, rightTypeId, rightIsCast);
        }
        this.computeConstant(scope, leftTypeId, rightTypeId);
        return this.resolvedType;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.left.traverse(visitor, scope);
            this.right.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

