/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dtree;

public class NodeInfo {
    private int type;
    private Object data;
    private String[] namesOfChildren;
    private String[] namesOfDeletedChildren;

    public NodeInfo(int type, Object data, String[] children, String[] deleted) {
        this.type = type;
        this.data = data;
        this.namesOfChildren = children;
        this.namesOfDeletedChildren = deleted;
    }

    public Object getData() {
        return this.data;
    }

    public String[] getNamesOfChildren() {
        return this.namesOfChildren;
    }

    public String[] getNamesOfDeletedChildren() {
        return this.namesOfDeletedChildren;
    }

    public int getType() {
        return this.type;
    }

    public boolean hasData() {
        return this.type == 0 || this.type == 1;
    }

    public boolean isComplete() {
        return this.getType() == 0;
    }

    public boolean isDeleted() {
        return this.getType() == 2;
    }

    public boolean isDelta() {
        int type = this.getType();
        return type == 1 || type == 3;
    }

    public boolean isEmptyDelta() {
        return this.getType() == 3 && this.getNamesOfChildren().length == 0 && this.getNamesOfDeletedChildren().length == 0;
    }

    public boolean isPresent() {
        return this.getType() != 4;
    }

    static NodeInfo missing() {
        return new NodeInfo(4, null, new String[0], new String[0]);
    }

    public void setData(Object o) {
        this.data = o;
    }

    public void setNamesOfChildren(String[] names) {
        this.namesOfChildren = names;
    }

    public void setNamesOfDeletedChildren(String[] names) {
        this.namesOfDeletedChildren = names;
    }

    public void setType(int type) {
        this.type = type;
    }
}

