/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.Iterator;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;

class NaiveASTFlattener
extends ASTVisitor {
    private StringBuffer buffer = new StringBuffer();

    NaiveASTFlattener() {
    }

    public String getResult() {
        return this.buffer.toString();
    }

    public void reset() {
        this.buffer.setLength(0);
    }

    void printModifiers(int modifiers) {
        if (Modifier.isPublic(modifiers)) {
            this.buffer.append("public ");
        }
        if (Modifier.isProtected(modifiers)) {
            this.buffer.append("protected ");
        }
        if (Modifier.isPrivate(modifiers)) {
            this.buffer.append("private ");
        }
        if (Modifier.isStatic(modifiers)) {
            this.buffer.append("static ");
        }
        if (Modifier.isAbstract(modifiers)) {
            this.buffer.append("abstract ");
        }
        if (Modifier.isFinal(modifiers)) {
            this.buffer.append("final ");
        }
        if (Modifier.isSynchronized(modifiers)) {
            this.buffer.append("synchronized ");
        }
        if (Modifier.isVolatile(modifiers)) {
            this.buffer.append("volatile ");
        }
        if (Modifier.isNative(modifiers)) {
            this.buffer.append("native ");
        }
        if (Modifier.isStrictfp(modifiers)) {
            this.buffer.append("strictfp ");
        }
        if (Modifier.isTransient(modifiers)) {
            this.buffer.append("transient ");
        }
    }

    public boolean visit(AnonymousClassDeclaration node) {
        this.buffer.append("{");
        Iterator it = node.bodyDeclarations().iterator();
        while (it.hasNext()) {
            BodyDeclaration b = (BodyDeclaration)it.next();
            b.accept(this);
        }
        this.buffer.append("}");
        return false;
    }

    public boolean visit(ArrayAccess node) {
        node.getArray().accept(this);
        this.buffer.append("[");
        node.getIndex().accept(this);
        this.buffer.append("]");
        return false;
    }

    public boolean visit(ArrayCreation node) {
        this.buffer.append("new ");
        ArrayType at = node.getType();
        int dims = at.getDimensions();
        Type elementType = at.getElementType();
        elementType.accept(this);
        Iterator it = node.dimensions().iterator();
        while (it.hasNext()) {
            this.buffer.append("[");
            Expression e = (Expression)it.next();
            e.accept(this);
            this.buffer.append("]");
            --dims;
        }
        int i = 0;
        while (i < dims) {
            this.buffer.append("[]");
            ++i;
        }
        if (node.getInitializer() != null) {
            this.buffer.append("=");
            node.getInitializer().accept(this);
        }
        return false;
    }

    public boolean visit(ArrayInitializer node) {
        this.buffer.append("{");
        Iterator it = node.expressions().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept(this);
            this.buffer.append(",");
        }
        this.buffer.append("}");
        return false;
    }

    public boolean visit(ArrayType node) {
        node.getComponentType().accept(this);
        this.buffer.append("[]");
        return false;
    }

    public boolean visit(AssertStatement node) {
        this.buffer.append("assert ");
        node.getExpression().accept(this);
        if (node.getMessage() != null) {
            this.buffer.append(" : ");
            node.getMessage().accept(this);
        }
        this.buffer.append(";");
        return false;
    }

    public boolean visit(Assignment node) {
        node.getLeftHandSide().accept(this);
        this.buffer.append(node.getOperator().toString());
        node.getRightHandSide().accept(this);
        return false;
    }

    public boolean visit(Block node) {
        this.buffer.append("{");
        Iterator it = node.statements().iterator();
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            s.accept(this);
        }
        this.buffer.append("}");
        return false;
    }

    public boolean visit(BooleanLiteral node) {
        if (node.booleanValue()) {
            this.buffer.append("true");
        } else {
            this.buffer.append("false");
        }
        return false;
    }

    public boolean visit(BreakStatement node) {
        this.buffer.append("break");
        if (node.getLabel() != null) {
            this.buffer.append(" ");
            node.getLabel().accept(this);
        }
        this.buffer.append(";");
        return false;
    }

    public boolean visit(CastExpression node) {
        this.buffer.append("(");
        node.getType().accept(this);
        this.buffer.append(")");
        node.getExpression().accept(this);
        return false;
    }

    public boolean visit(CatchClause node) {
        this.buffer.append("catch (");
        node.getException().accept(this);
        this.buffer.append(") ");
        node.getBody().accept(this);
        return false;
    }

    public boolean visit(CharacterLiteral node) {
        this.buffer.append(node.getEscapedValue());
        return false;
    }

    public boolean visit(ClassInstanceCreation node) {
        if (node.getExpression() != null) {
            node.getExpression().accept(this);
            this.buffer.append(".");
        }
        this.buffer.append("new ");
        node.getName().accept(this);
        this.buffer.append("(");
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
        if (node.getAnonymousClassDeclaration() != null) {
            node.getAnonymousClassDeclaration().accept(this);
        }
        return false;
    }

    public boolean visit(CompilationUnit node) {
        ASTNode d;
        if (node.getPackage() != null) {
            node.getPackage().accept(this);
        }
        Iterator it = node.imports().iterator();
        while (it.hasNext()) {
            d = (ImportDeclaration)it.next();
            d.accept(this);
        }
        it = node.types().iterator();
        while (it.hasNext()) {
            d = (TypeDeclaration)it.next();
            d.accept(this);
        }
        return false;
    }

    public boolean visit(ConditionalExpression node) {
        node.getExpression().accept(this);
        this.buffer.append("?");
        node.getThenExpression().accept(this);
        this.buffer.append(":");
        node.getElseExpression().accept(this);
        return false;
    }

    public boolean visit(ConstructorInvocation node) {
        this.buffer.append("this(");
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(");");
        return false;
    }

    public boolean visit(ContinueStatement node) {
        this.buffer.append("continue");
        if (node.getLabel() != null) {
            this.buffer.append(" ");
            node.getLabel().accept(this);
        }
        this.buffer.append(";");
        return false;
    }

    public boolean visit(DoStatement node) {
        this.buffer.append("do ");
        node.getBody().accept(this);
        this.buffer.append(" while (");
        node.getExpression().accept(this);
        this.buffer.append(");");
        return false;
    }

    public boolean visit(EmptyStatement node) {
        this.buffer.append(";");
        return false;
    }

    public boolean visit(ExpressionStatement node) {
        node.getExpression().accept(this);
        this.buffer.append(";");
        return false;
    }

    public boolean visit(FieldAccess node) {
        node.getExpression().accept(this);
        this.buffer.append(".");
        node.getName().accept(this);
        return false;
    }

    public boolean visit(FieldDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        this.printModifiers(node.getModifiers());
        node.getType().accept(this);
        this.buffer.append(" ");
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(";");
        return false;
    }

    public boolean visit(ForStatement node) {
        Expression e;
        this.buffer.append("for (");
        Iterator it = node.initializers().iterator();
        while (it.hasNext()) {
            e = (Expression)it.next();
            e.accept(this);
        }
        this.buffer.append("; ");
        if (node.getExpression() != null) {
            node.getExpression().accept(this);
        }
        this.buffer.append("; ");
        it = node.updaters().iterator();
        while (it.hasNext()) {
            e = (Expression)it.next();
            e.accept(this);
        }
        this.buffer.append(") ");
        node.getBody().accept(this);
        return false;
    }

    public boolean visit(IfStatement node) {
        this.buffer.append("if (");
        node.getExpression().accept(this);
        this.buffer.append(") ");
        node.getThenStatement().accept(this);
        if (node.getElseStatement() != null) {
            this.buffer.append(" else ");
            node.getElseStatement().accept(this);
        }
        return false;
    }

    public boolean visit(ImportDeclaration node) {
        this.buffer.append("import ");
        node.getName().accept(this);
        if (node.isOnDemand()) {
            this.buffer.append(".*");
        }
        this.buffer.append(";");
        return false;
    }

    public boolean visit(InfixExpression node) {
        node.getLeftOperand().accept(this);
        this.buffer.append(node.getOperator().toString());
        node.getRightOperand().accept(this);
        Iterator it = node.extendedOperands().iterator();
        while (it.hasNext()) {
            this.buffer.append(node.getOperator().toString());
            Expression e = (Expression)it.next();
            e.accept(this);
        }
        return false;
    }

    public boolean visit(InstanceofExpression node) {
        node.getLeftOperand().accept(this);
        this.buffer.append(" instanceof ");
        node.getRightOperand().accept(this);
        return false;
    }

    public boolean visit(Initializer node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        this.printModifiers(node.getModifiers());
        node.getBody().accept(this);
        return false;
    }

    public boolean visit(Javadoc node) {
        this.buffer.append(node.getComment());
        return false;
    }

    public boolean visit(LabeledStatement node) {
        node.getLabel().accept(this);
        this.buffer.append(": ");
        node.getBody().accept(this);
        return false;
    }

    public boolean visit(MethodDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        this.printModifiers(node.getModifiers());
        if (!node.isConstructor()) {
            node.getReturnType().accept(this);
            this.buffer.append(" ");
        }
        node.getName().accept(this);
        this.buffer.append("(");
        Iterator it = node.parameters().iterator();
        while (it.hasNext()) {
            SingleVariableDeclaration v = (SingleVariableDeclaration)it.next();
            v.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
        if (!node.thrownExceptions().isEmpty()) {
            this.buffer.append(" throws ");
            it = node.thrownExceptions().iterator();
            while (it.hasNext()) {
                Name n = (Name)it.next();
                n.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(" ");
        }
        if (node.getBody() == null) {
            this.buffer.append(";");
        } else {
            node.getBody().accept(this);
        }
        return false;
    }

    public boolean visit(MethodInvocation node) {
        if (node.getExpression() != null) {
            node.getExpression().accept(this);
            this.buffer.append(".");
        }
        node.getName().accept(this);
        this.buffer.append("(");
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
        return false;
    }

    public boolean visit(NullLiteral node) {
        this.buffer.append("null");
        return false;
    }

    public boolean visit(NumberLiteral node) {
        this.buffer.append(node.getToken());
        return false;
    }

    public boolean visit(PackageDeclaration node) {
        this.buffer.append("package ");
        node.getName().accept(this);
        this.buffer.append(";");
        return false;
    }

    public boolean visit(ParenthesizedExpression node) {
        this.buffer.append("(");
        node.getExpression().accept(this);
        this.buffer.append(")");
        return false;
    }

    public boolean visit(PostfixExpression node) {
        node.getOperand().accept(this);
        this.buffer.append(node.getOperator().toString());
        return false;
    }

    public boolean visit(PrefixExpression node) {
        this.buffer.append(node.getOperator().toString());
        node.getOperand().accept(this);
        return false;
    }

    public boolean visit(PrimitiveType node) {
        this.buffer.append(node.getPrimitiveTypeCode().toString());
        return false;
    }

    public boolean visit(QualifiedName node) {
        node.getQualifier().accept(this);
        this.buffer.append(".");
        node.getName().accept(this);
        return false;
    }

    public boolean visit(ReturnStatement node) {
        this.buffer.append("return");
        if (node.getExpression() != null) {
            this.buffer.append(" ");
            node.getExpression().accept(this);
        }
        this.buffer.append(";");
        return false;
    }

    public boolean visit(SimpleName node) {
        this.buffer.append(node.getIdentifier());
        return false;
    }

    public boolean visit(SimpleType node) {
        return true;
    }

    public boolean visit(SingleVariableDeclaration node) {
        this.printModifiers(node.getModifiers());
        node.getType().accept(this);
        this.buffer.append(" ");
        node.getName().accept(this);
        if (node.getInitializer() != null) {
            this.buffer.append("=");
            node.getInitializer().accept(this);
        }
        return false;
    }

    public boolean visit(StringLiteral node) {
        this.buffer.append(node.getEscapedValue());
        return false;
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (node.getExpression() != null) {
            node.getExpression().accept(this);
            this.buffer.append(".");
        }
        this.buffer.append("super(");
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(");");
        return false;
    }

    public boolean visit(SuperFieldAccess node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept(this);
            this.buffer.append(".");
        }
        this.buffer.append("super.");
        node.getName().accept(this);
        return false;
    }

    public boolean visit(SuperMethodInvocation node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept(this);
            this.buffer.append(".");
        }
        this.buffer.append("super.");
        node.getName().accept(this);
        this.buffer.append("(");
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
        return false;
    }

    public boolean visit(SwitchCase node) {
        if (node.isDefault()) {
            this.buffer.append("default :");
        } else {
            this.buffer.append("case ");
            node.getExpression().accept(this);
            this.buffer.append(":");
        }
        return false;
    }

    public boolean visit(SwitchStatement node) {
        this.buffer.append("switch (");
        node.getExpression().accept(this);
        this.buffer.append(") ");
        this.buffer.append("{");
        Iterator it = node.statements().iterator();
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            s.accept(this);
        }
        this.buffer.append("}");
        return false;
    }

    public boolean visit(SynchronizedStatement node) {
        this.buffer.append("synchronized (");
        node.getExpression().accept(this);
        this.buffer.append(") ");
        node.getBody().accept(this);
        return false;
    }

    public boolean visit(ThisExpression node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept(this);
            this.buffer.append(".");
        }
        this.buffer.append("this");
        return false;
    }

    public boolean visit(ThrowStatement node) {
        this.buffer.append("throw ");
        node.getExpression().accept(this);
        this.buffer.append(";");
        return false;
    }

    public boolean visit(TryStatement node) {
        this.buffer.append("try ");
        node.getBody().accept(this);
        this.buffer.append(" ");
        Iterator it = node.catchClauses().iterator();
        while (it.hasNext()) {
            CatchClause cc = (CatchClause)it.next();
            cc.accept(this);
        }
        if (node.getFinally() != null) {
            this.buffer.append("finally ");
            node.getFinally().accept(this);
        }
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        Iterator it;
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        this.printModifiers(node.getModifiers());
        this.buffer.append(node.isInterface() ? "interface " : "class ");
        node.getName().accept(this);
        this.buffer.append(" ");
        if (node.getSuperclass() != null) {
            this.buffer.append("extends ");
            node.getSuperclass().accept(this);
            this.buffer.append(" ");
        }
        if (!node.superInterfaces().isEmpty()) {
            this.buffer.append(node.isInterface() ? "extends " : "implements ");
            it = node.superInterfaces().iterator();
            while (it.hasNext()) {
                Name n = (Name)it.next();
                n.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(" ");
        }
        this.buffer.append("{");
        it = node.bodyDeclarations().iterator();
        while (it.hasNext()) {
            BodyDeclaration d = (BodyDeclaration)it.next();
            d.accept(this);
        }
        this.buffer.append("}");
        return false;
    }

    public boolean visit(TypeDeclarationStatement node) {
        node.getTypeDeclaration().accept(this);
        this.buffer.append(";");
        return false;
    }

    public boolean visit(TypeLiteral node) {
        node.getType().accept(this);
        this.buffer.append(".class");
        return false;
    }

    public boolean visit(VariableDeclarationExpression node) {
        this.printModifiers(node.getModifiers());
        node.getType().accept(this);
        this.buffer.append(" ");
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(";");
        return false;
    }

    public boolean visit(VariableDeclarationFragment node) {
        node.getName().accept(this);
        int i = 0;
        while (i < node.getExtraDimensions()) {
            this.buffer.append("[]");
            ++i;
        }
        if (node.getInitializer() != null) {
            this.buffer.append("=");
            node.getInitializer().accept(this);
        }
        return false;
    }

    public boolean visit(VariableDeclarationStatement node) {
        this.printModifiers(node.getModifiers());
        node.getType().accept(this);
        this.buffer.append(" ");
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(";");
        return false;
    }

    public boolean visit(WhileStatement node) {
        this.buffer.append("while (");
        node.getExpression().accept(this);
        this.buffer.append(") ");
        node.getBody().accept(this);
        return false;
    }
}

