/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class Policy {
    private static String bundleName = "org.eclipse.core.internal.runtime.messages";
    private static ResourceBundle bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault());

    public static String bind(String id) {
        return Policy.bind(id, null);
    }

    public static String bind(String id, String binding) {
        return Policy.bind(id, new String[]{binding});
    }

    public static String bind(String id, String binding1, String binding2) {
        return Policy.bind(id, new String[]{binding1, binding2});
    }

    public static String bind(String id, String[] bindings) {
        if (id == null) {
            return "No message available";
        }
        String message = null;
        try {
            message = bundle.getString(id);
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing message: " + id + " in: " + bundleName;
        }
        if (bindings == null) {
            return message;
        }
        return MessageFormat.format(message, bindings);
    }

    public static IProgressMonitor monitorFor(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }

    public static IProgressMonitor subMonitorFor(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new SubProgressMonitor(monitor, ticks);
    }

    public static IProgressMonitor subMonitorFor(IProgressMonitor monitor, int ticks, int style) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new SubProgressMonitor(monitor, ticks, style);
    }

    public static void debug(boolean includeDate, String message) {
        if (includeDate) {
            message = new Date(System.currentTimeMillis()) + " - " + message;
        }
        System.out.println(message);
    }
}

