/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.internal.registry.BundleModel;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.ExtensionsParser;
import org.eclipse.core.internal.registry.Factory;
import org.eclipse.core.runtime.MultiStatus;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EclipseBundleListener
implements SynchronousBundleListener {
    private static final String EXTENSIONS_MANIFEST = "extensions.xml";
    private static final String PLUGIN_MANIFEST = "plugin.xml";
    private static final String FRAGMENT_MANIFEST = "fragment.xml";
    private ExtensionRegistry registry;

    public EclipseBundleListener(ExtensionRegistry registry) {
        this.registry = registry;
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 32: {
                this.addBundle(bundle);
                break;
            }
            case 8: {
                this.updateBundle(bundle);
                break;
            }
            case 16: {
                this.removeBundle(bundle);
            }
        }
    }

    public void processBundles(Bundle[] bundles) {
        int i = 0;
        while (i < bundles.length) {
            if (this.isBundleResolved(bundles[i])) {
                this.addBundle(bundles[i]);
            } else {
                this.removeBundle(bundles[i]);
            }
            ++i;
        }
    }

    private boolean isBundleResolved(Bundle bundle) {
        return (bundle.getState() & 0x3C) != 0;
    }

    private void removeBundle(Bundle bundle) {
        this.registry.remove(bundle.getGlobalName(), bundle.getBundleId());
    }

    private void addBundle(Bundle bundle) {
        if (this.registry.getElement(bundle.getGlobalName()) != null) {
            return;
        }
        BundleModel bundleModel = this.getBundleModel(bundle);
        if (bundleModel == null) {
            return;
        }
        this.registry.add(bundleModel);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BundleModel getBundleModel(Bundle bundle) {
        BundleModel bundleModel;
        if (bundle.getBundleId() == 0L) {
            return null;
        }
        InputStream is = null;
        String manifestType = null;
        try {
            URL url = bundle.getEntry(EXTENSIONS_MANIFEST);
            if (url != null) {
                is = url.openStream();
                manifestType = "bundle";
            }
        }
        catch (IOException iOException) {
            is = null;
        }
        boolean isFragment = bundle.isFragment();
        if (is == null) {
            try {
                URL url = bundle.getEntry(isFragment ? FRAGMENT_MANIFEST : PLUGIN_MANIFEST);
                if (url != null) {
                    is = url.openStream();
                    manifestType = isFragment ? "fragment" : "plugin";
                }
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (is == null) {
            return null;
        }
        try {
            try {
                MultiStatus problems = new MultiStatus("org.eclipse.core.runtime", 1, "Registry problems", null);
                Factory factory = new Factory(problems);
                BundleModel bundleModel2 = new ExtensionsParser(factory).parseBundle(new InputSource(is), manifestType);
                bundleModel2.setUniqueIdentifier(bundle.getGlobalName());
                bundleModel2.setId(bundle.getBundleId());
                if (isFragment) {
                    bundleModel2.setHostIdentifier(bundle.getHost().getGlobalName());
                }
                bundleModel = bundleModel2;
                Object var8_14 = null;
            }
            catch (SAXException e) {
                e.printStackTrace();
                BundleModel bundleModel3 = null;
                Object var8_15 = null;
                try {
                    is.close();
                    return bundleModel3;
                }
                catch (IOException iOException) {}
                return bundleModel3;
            }
            catch (IOException e) {
                e.printStackTrace();
                BundleModel bundleModel4 = null;
                Object var8_16 = null;
                try {}
                catch (IOException iOException) {}
                is.close();
                return bundleModel4;
            }
        }
        catch (Throwable throwable) {
            Object var8_17 = null;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            is.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        is.close();
        return bundleModel;
    }

    private void updateBundle(Bundle bundle) {
    }
}

