/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ast.Literal;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.SignaturePattern;

public class WithincodePointcut
extends Pointcut {
    SignaturePattern signature;

    public WithincodePointcut(SignaturePattern signature) {
        this.signature = signature;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo type) {
        return FuzzyBoolean.MAYBE;
    }

    public FuzzyBoolean match(Shadow shadow) {
        return FuzzyBoolean.fromBoolean(this.signature.matches(shadow.getEnclosingCodeSignature(), shadow.getIWorld()));
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(12);
        this.signature.write(s);
        this.writeLocation(s);
    }

    public static Pointcut read(DataInputStream s, ISourceContext context) throws IOException {
        WithincodePointcut ret = new WithincodePointcut(SignaturePattern.read(s, context));
        ret.readLocation(context, s);
        return ret;
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
        this.signature = this.signature.resolveBindings(scope, bindings);
    }

    public void postRead(ResolvedTypeX enclosingType) {
        this.signature.postRead(enclosingType);
    }

    public boolean equals(Object other) {
        if (!(other instanceof WithincodePointcut)) {
            return false;
        }
        WithincodePointcut o = (WithincodePointcut)other;
        return o.signature.equals(this.signature);
    }

    public int hashCode() {
        int result = 43;
        result = 37 * result + this.signature.hashCode();
        return result;
    }

    public String toString() {
        return "withincode(" + this.signature + ")";
    }

    public Test findResidue(Shadow shadow, ExposedState state) {
        return this.match(shadow).alwaysTrue() ? Literal.TRUE : Literal.FALSE;
    }

    public Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
        return new WithincodePointcut(this.signature);
    }
}

