/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.aspectj.util.LangUtil;

public class FileUtil {
    public static final File DEFAULT_PARENT = new File(".");
    public static final List SOURCE_SUFFIXES = Collections.unmodifiableList(Arrays.asList(".java", ".aj"));
    public static final FileFilter ZIP_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return FileUtil.hasZipSuffix(file);
        }

        public String toString() {
            return "ZIP_FILTER";
        }
    };
    public static final FileFilter SOURCE_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return FileUtil.hasSourceSuffix(file);
        }

        public String toString() {
            return "SOURCE_FILTER";
        }
    };
    static final int[] INT_RA = new int[0];
    public static final FileFilter ALL = new FileFilter(){

        public boolean accept(File f) {
            return true;
        }
    };
    public static final FileFilter DIRS_AND_WRITABLE_CLASSES = new FileFilter(){

        public boolean accept(File file) {
            return null != file && (file.isDirectory() || file.canWrite() && file.getName().toLowerCase().endsWith(".class"));
        }
    };
    public static final FileFilter aspectjSourceFileFilter = new FileFilter(){

        public boolean accept(File pathname) {
            String name = pathname.getName().toLowerCase();
            return name.endsWith(".java") || name.endsWith(".aj");
        }
    };
    static final String FILECHARS = "abcdefghijklmnopqrstuvxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public static boolean hasZipSuffix(File file) {
        return null != file && FileUtil.hasZipSuffix(file.getPath());
    }

    public static boolean hasZipSuffix(String path) {
        return null != path && 0 != FileUtil.zipSuffixLength(path);
    }

    public static int zipSuffixLength(File file) {
        return null == file ? 0 : FileUtil.zipSuffixLength(file.getPath());
    }

    public static int zipSuffixLength(String path) {
        String test;
        if (null != path && 4 < path.length() && (".zip".equals(test = path.substring(path.length() - 4).toLowerCase()) || ".jar".equals(test))) {
            return 4;
        }
        return 0;
    }

    public static boolean hasSourceSuffix(File file) {
        return null != file && FileUtil.hasSourceSuffix(file.getPath());
    }

    public static boolean hasSourceSuffix(String path) {
        return null != path && 0 != FileUtil.sourceSuffixLength(path);
    }

    public static int sourceSuffixLength(File file) {
        return null == file ? 0 : FileUtil.sourceSuffixLength(file.getPath());
    }

    public static int sourceSuffixLength(String path) {
        if (LangUtil.isEmpty(path)) {
            return 0;
        }
        Iterator iter = SOURCE_SUFFIXES.iterator();
        while (iter.hasNext()) {
            String suffix = (String)iter.next();
            if (!path.endsWith(suffix) && !path.toLowerCase().endsWith(suffix)) continue;
            return suffix.length();
        }
        return 0;
    }

    public static boolean canReadDir(File dir) {
        return null != dir && dir.canRead() && dir.isDirectory();
    }

    public static boolean canReadFile(File file) {
        return null != file && file.canRead() && file.isFile();
    }

    public static boolean canWriteDir(File dir) {
        return null != dir && dir.canWrite() && dir.isDirectory();
    }

    public static boolean canWriteFile(File file) {
        return null != file && file.canWrite() && file.isFile();
    }

    public static void throwIaxUnlessCanReadFile(File file, String label) {
        if (!FileUtil.canReadFile(file)) {
            throw new IllegalArgumentException(label + " not readable file: " + file);
        }
    }

    public static void throwIaxUnlessCanReadDir(File dir, String label) {
        if (!FileUtil.canReadDir(dir)) {
            throw new IllegalArgumentException(label + " not readable dir: " + dir);
        }
    }

    public static void throwIaxUnlessCanWriteFile(File file, String label) {
        if (!FileUtil.canWriteFile(file)) {
            throw new IllegalArgumentException(label + " not writable file: " + file);
        }
    }

    public static void throwIaxUnlessCanWriteDir(File dir, String label) {
        if (!FileUtil.canWriteDir(dir)) {
            throw new IllegalArgumentException(label + " not writable dir: " + dir);
        }
    }

    public static String[] getPaths(File[] files) {
        if (null == files || 0 == files.length) {
            return new String[0];
        }
        String[] result = new String[files.length];
        int i = 0;
        while (i < result.length) {
            if (null != files[i]) {
                result[i] = files[i].getPath();
            }
            ++i;
        }
        return result;
    }

    public static String[] getPaths(List files) {
        int size;
        int n = size = null == files ? 0 : files.size();
        if (0 == size) {
            return new String[0];
        }
        String[] result = new String[size];
        int i = 0;
        while (i < size) {
            File file = (File)files.get(i);
            if (null != file) {
                result[i] = file.getPath();
            }
            ++i;
        }
        return result;
    }

    public static String fileToClassName(File basedir, File classFile) {
        LangUtil.throwIaxIfNull(classFile, "classFile");
        String classFilePath = FileUtil.normalizedPath(classFile);
        if (!classFilePath.endsWith(".class")) {
            String m = classFile + " does not end with .class";
            throw new IllegalArgumentException(m);
        }
        classFilePath = classFilePath.substring(0, classFilePath.length() - 6);
        if (null != basedir) {
            String basePath = FileUtil.normalizedPath(basedir);
            if (!classFilePath.startsWith(basePath)) {
                String m = classFile + " does not start with " + basedir;
                throw new IllegalArgumentException(m);
            }
            classFilePath = classFilePath.substring(basePath.length() + 1);
        } else {
            int loc;
            String[] suffixes = new String[]{"com", "org", "java", "javax"};
            boolean found = false;
            int i = 0;
            while (!found && i < suffixes.length) {
                loc = classFilePath.indexOf(suffixes[i] + "/");
                if (0 == loc || -1 != loc && '/' == classFilePath.charAt(loc - 1)) {
                    classFilePath = classFilePath.substring(loc);
                    found = true;
                }
                ++i;
            }
            if (!found && -1 != (loc = classFilePath.lastIndexOf("/"))) {
                classFilePath = classFilePath.substring(loc + 1);
            }
        }
        return classFilePath.replace('/', '.');
    }

    public static String normalizedPath(File file, File basedir) {
        String basePath;
        String filePath = FileUtil.normalizedPath(file);
        if (null != basedir && filePath.startsWith(basePath = FileUtil.normalizedPath(basedir)) && (filePath = filePath.substring(basePath.length())).startsWith("/")) {
            filePath = filePath.substring(1);
        }
        return filePath;
    }

    public static String flatten(File[] files, String infix) {
        if (LangUtil.isEmpty(files)) {
            return "";
        }
        return FileUtil.flatten(FileUtil.getPaths(files), infix);
    }

    public static String flatten(String[] paths, String infix) {
        if (null == infix) {
            infix = File.pathSeparator;
        }
        StringBuffer result = new StringBuffer();
        boolean first = true;
        int i = 0;
        while (i < paths.length) {
            String path = paths[i];
            if (null != path) {
                if (first) {
                    first = false;
                } else {
                    result.append(infix);
                }
                result.append(path);
            }
            ++i;
        }
        return result.toString();
    }

    public static String normalizedPath(File file) {
        return null == file ? "" : FileUtil.weakNormalize(file.getAbsolutePath());
    }

    public static String weakNormalize(String path) {
        if (null != path) {
            path = path.replace('\\', '/').trim();
        }
        return path;
    }

    public static String getBestPath(File file) {
        LangUtil.throwIaxIfNull(file, "file");
        if (file.exists()) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException e) {
                return file.getAbsolutePath();
            }
        }
        return file.getPath();
    }

    public static String[] getAbsolutePaths(File[] files) {
        if (null == files || 0 == files.length) {
            return new String[0];
        }
        String[] result = new String[files.length];
        int i = 0;
        while (i < result.length) {
            if (null != files[i]) {
                result[i] = files[i].getAbsolutePath();
            }
            ++i;
        }
        return result;
    }

    public static int deleteContents(File dir) {
        return FileUtil.deleteContents(dir, ALL);
    }

    public static int deleteContents(File dir, FileFilter filter) {
        return FileUtil.deleteContents(dir, filter, true);
    }

    public static int deleteContents(File dir, FileFilter filter, boolean deleteEmptyDirs) {
        if (null == dir) {
            throw new IllegalArgumentException("null dir");
        }
        if (!dir.exists() || !dir.canWrite()) {
            return 0;
        }
        if (!dir.isDirectory()) {
            dir.delete();
            return 1;
        }
        String[] fromFiles = dir.list();
        int result = 0;
        int i = 0;
        while (i < fromFiles.length) {
            String string = fromFiles[i];
            File file = new File(dir, string);
            if (null == filter || filter.accept(file)) {
                if (file.isDirectory()) {
                    result += FileUtil.deleteContents(file, filter, deleteEmptyDirs);
                    if (deleteEmptyDirs && 0 == file.list().length) {
                        file.delete();
                    }
                } else {
                    file.delete();
                    ++result;
                }
            }
            ++i;
        }
        return result;
    }

    public static int copyDir(File fromDir, File toDir) throws IOException {
        return FileUtil.copyDir(fromDir, toDir, null, null);
    }

    public static int copyDir(File fromDir, File toDir, String fromSuffix, String toSuffix) throws IOException {
        return FileUtil.copyDir(fromDir, toDir, fromSuffix, toSuffix, (FileFilter)null);
    }

    public static int copyDir(File fromDir, File toDir, String fromSuffix, String toSuffix, final List collector) throws IOException {
        if (null == collector) {
            return FileUtil.copyDir(fromDir, toDir, fromSuffix, toSuffix);
        }
        FileFilter collect = new FileFilter(){

            public boolean accept(File pathname) {
                return collector.add(pathname);
            }
        };
        return FileUtil.copyDir(fromDir, toDir, fromSuffix, toSuffix, collect);
    }

    public static int copyDir(File fromDir, File toDir, final String fromSuffix, String toSuffix, FileFilter delegate) throws IOException {
        String[] fromFiles;
        int slen;
        if (null == fromDir || !fromDir.canRead()) {
            return 0;
        }
        boolean haveSuffix = null != fromSuffix && 0 < fromSuffix.length();
        int n = slen = !haveSuffix ? 0 : fromSuffix.length();
        if (!toDir.exists()) {
            toDir.mkdirs();
        }
        if (!haveSuffix) {
            fromFiles = fromDir.list();
        } else {
            FilenameFilter filter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return new File(dir, name).isDirectory() || name.endsWith(fromSuffix);
                }
            };
            fromFiles = fromDir.list(filter);
        }
        int result = 0;
        int MAX = null == fromFiles ? 0 : fromFiles.length;
        int i = 0;
        while (i < MAX) {
            String filename = fromFiles[i];
            File fromFile = new File(fromDir, filename);
            if (fromFile.canRead()) {
                if (fromFile.isDirectory()) {
                    result += FileUtil.copyDir(fromFile, new File(toDir, filename), fromSuffix, toSuffix, delegate);
                } else if (fromFile.isFile()) {
                    if (haveSuffix) {
                        filename = filename.substring(0, filename.length() - slen);
                    }
                    if (null != toSuffix) {
                        filename = filename + toSuffix;
                    }
                    File targetFile = new File(toDir, filename);
                    if (null == delegate || delegate.accept(targetFile)) {
                        FileUtil.copyFile(fromFile, targetFile);
                    }
                    ++result;
                }
            }
            ++i;
        }
        return result;
    }

    public static String[] listFiles(File srcDir) {
        ArrayList result = new ArrayList();
        if (null != srcDir && srcDir.canRead()) {
            FileUtil.listFiles(srcDir, null, result);
        }
        return result.toArray(new String[0]);
    }

    public static File[] listFiles(File srcDir, FileFilter fileFilter) {
        ArrayList result = new ArrayList();
        if (null != srcDir && srcDir.canRead()) {
            FileUtil.listFiles(srcDir, result, fileFilter);
        }
        return result.toArray(new File[result.size()]);
    }

    public static File[] getBaseDirFiles(File basedir, String[] paths) {
        return FileUtil.getBaseDirFiles(basedir, paths, null);
    }

    public static File[] getBaseDirFiles(File basedir, String[] paths, String[] suffixes) {
        LangUtil.throwIaxIfNull(basedir, "basedir");
        LangUtil.throwIaxIfNull(paths, "paths");
        File[] result = null;
        if (!LangUtil.isEmpty(suffixes)) {
            ArrayList<File> list = new ArrayList<File>();
            int i = 0;
            while (i < paths.length) {
                boolean listed = false;
                String path = paths[i];
                int j = 0;
                while (!listed && j < suffixes.length) {
                    String suffix = suffixes[j];
                    listed = path.endsWith(suffix);
                    if (listed) {
                        list.add(new File(basedir, paths[i]));
                    }
                    ++j;
                }
                ++i;
            }
            result = list.toArray(new File[0]);
        } else {
            result = new File[paths.length];
            int i = 0;
            while (i < result.length) {
                result[i] = FileUtil.newFile(basedir, paths[i]);
                ++i;
            }
        }
        return result;
    }

    private static File newFile(File dir, String path) {
        if (".".equals(path)) {
            return dir;
        }
        if ("..".equals(path)) {
            File parentDir = dir.getParentFile();
            if (null != parentDir) {
                return parentDir;
            }
            return new File(dir, "..");
        }
        return new File(dir, path);
    }

    public static File[] copyFiles(File srcDir, String[] relativePaths, File destDir) throws IllegalArgumentException, IOException {
        String[] paths = relativePaths;
        FileUtil.throwIaxUnlessCanReadDir(srcDir, "srcDir");
        FileUtil.throwIaxUnlessCanWriteDir(destDir, "destDir");
        LangUtil.throwIaxIfNull(paths, "relativePaths");
        File[] result = new File[paths.length];
        int i = 0;
        while (i < paths.length) {
            String path = paths[i];
            LangUtil.throwIaxIfNull(path, "relativePaths-entry");
            File src = FileUtil.newFile(srcDir, paths[i]);
            File dest = FileUtil.newFile(destDir, path);
            File destParent = dest.getParentFile();
            if (!destParent.exists()) {
                destParent.mkdirs();
            }
            LangUtil.throwIaxIfFalse(FileUtil.canWriteDir(destParent), "dest-entry-parent");
            FileUtil.copyFile(src, dest);
            result[i] = dest;
            ++i;
        }
        return result;
    }

    public static void copyFile(File fromFile, File toFile) throws IOException {
        LangUtil.throwIaxIfNull(fromFile, "fromFile");
        LangUtil.throwIaxIfNull(toFile, "toFile");
        LangUtil.throwIaxIfFalse(!toFile.equals(fromFile), "same file");
        if (toFile.isDirectory()) {
            FileUtil.throwIaxUnlessCanWriteDir(toFile, "toFile");
            if (fromFile.isFile()) {
                File targFile = new File(toFile, fromFile.getName());
                FileUtil.copyValidFiles(fromFile, targFile);
            } else if (fromFile.isDirectory()) {
                FileUtil.copyDir(fromFile, toFile);
            } else {
                LangUtil.throwIaxIfFalse(false, "not dir or file: " + fromFile);
            }
        } else if (toFile.isFile()) {
            if (fromFile.isDirectory()) {
                LangUtil.throwIaxIfFalse(false, "can't copy to file dir: " + fromFile);
            }
            FileUtil.copyValidFiles(fromFile, toFile);
        } else {
            FileUtil.ensureParentWritable(toFile);
            if (fromFile.isFile()) {
                FileUtil.copyValidFiles(fromFile, toFile);
            } else if (fromFile.isDirectory()) {
                toFile.mkdirs();
                FileUtil.throwIaxUnlessCanWriteDir(toFile, "toFile");
                FileUtil.copyDir(fromFile, toFile);
            } else {
                LangUtil.throwIaxIfFalse(false, "not dir or file: " + fromFile);
            }
        }
    }

    public static File ensureParentWritable(File path) {
        LangUtil.throwIaxIfNull(path, "path");
        File pathParent = path.getParentFile();
        if (null == pathParent) {
            pathParent = DEFAULT_PARENT;
        }
        if (!pathParent.canWrite()) {
            pathParent.mkdirs();
        }
        FileUtil.throwIaxUnlessCanWriteDir(pathParent, "pathParent");
        return pathParent;
    }

    public static void copyValidFiles(File fromFile, File toFile) throws IOException {
        FileInputStream in;
        block5: {
            in = null;
            FileOutputStream out = null;
            try {
                in = new FileInputStream(fromFile);
                out = new FileOutputStream(toFile);
                FileUtil.copyStream(in, out);
                Object var5_4 = null;
                if (out == null) break block5;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                throw throwable;
            }
            out.close();
        }
        if (in != null) {
            in.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void copyStream(DataInputStream in, PrintStream out) throws IOException {
        String s;
        LangUtil.throwIaxIfNull(in, "in");
        LangUtil.throwIaxIfNull(in, "out");
        while (null != (s = in.readLine())) {
            void var2_2;
            out.println((String)var2_2);
        }
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int MAX = 4096;
        byte[] buf = new byte[4096];
        int bytesRead = in.read(buf, 0, 4096);
        while (bytesRead != -1) {
            out.write(buf, 0, bytesRead);
            bytesRead = in.read(buf, 0, 4096);
        }
    }

    public static void copyStream(Reader in, Writer out) throws IOException {
        int MAX = 4096;
        char[] buf = new char[4096];
        int bytesRead = in.read(buf, 0, 4096);
        while (bytesRead != -1) {
            out.write(buf, 0, bytesRead);
            bytesRead = in.read(buf, 0, 4096);
        }
    }

    public static File makeNewChildDir(File parent, String child) {
        if (null == parent || !parent.canWrite() || !parent.isDirectory()) {
            throw new IllegalArgumentException("bad parent: " + parent);
        }
        if (null == child) {
            child = "makeNewChildDir";
        } else if (!FileUtil.isValidFileName(child)) {
            throw new IllegalArgumentException("bad child: " + child);
        }
        File result = new File(parent, child);
        int safety = 1000;
        String suffix = FileUtil.randomFileString();
        while (0 < --safety && result.exists()) {
            result = new File(parent, child + suffix);
            suffix = FileUtil.randomFileString();
        }
        if (null == result || result.exists()) {
            System.err.println("exhausted files for child dir in " + parent);
            return null;
        }
        return result.mkdirs() && result.exists() ? result : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File getTempDir(String name) {
        if (null == name) {
            name = "FileUtil_getTempDir";
        } else if (!FileUtil.isValidFileName(name)) {
            throw new IllegalArgumentException(" invalid: " + name);
        }
        File result = null;
        File tempFile = null;
        try {
            try {
                tempFile = File.createTempFile("ignoreMe", ".txt");
                File tempParent = tempFile.getParentFile();
                result = FileUtil.makeNewChildDir(tempParent, name);
            }
            catch (IOException t) {
                result = FileUtil.makeNewChildDir(new File("."), name);
                Object var5_6 = null;
                if (null == tempFile) return result;
                tempFile.delete();
                return result;
            }
            Object var5_5 = null;
            if (null == tempFile) return result;
            tempFile.delete();
            return result;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (null == tempFile) throw throwable;
            tempFile.delete();
            throw throwable;
        }
    }

    public static URL[] getFileURLs(File[] files) {
        if (null == files || 0 == files.length) {
            return new URL[0];
        }
        URL[] result = new URL[files.length];
        int i = 0;
        while (i < result.length) {
            result[i] = FileUtil.getFileURL(files[i]);
            ++i;
        }
        return result;
    }

    public static URL getFileURL(File file) {
        LangUtil.throwIaxIfNull(file, "file");
        URL result = null;
        try {
            String url = "file:" + file.getAbsolutePath().replace('\\', '/');
            result = new URL(url + (file.isDirectory() ? "/" : ""));
        }
        catch (MalformedURLException e) {
            String m = "Util.makeURL(\"" + file.getPath() + "\" MUE " + e.getMessage();
            System.err.println(m);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String writeAsString(File file, String contents) {
        block12: {
            block11: {
                LangUtil.throwIaxIfNull(file, "file");
                if (null == contents) {
                    contents = "";
                }
                out = null;
                try {
                    try {
                        parentDir = file.getParentFile();
                        if (!parentDir.exists() && !parentDir.mkdirs()) {
                            var4_5 = "unable to make parent dir for " + file;
                            var7_8 = null;
                            if (null == out) return var4_5;
                            break block11;
                        }
                        in = new StringReader(contents);
                        out = new FileWriter(file);
                        FileUtil.copyStream(in, out);
                        var5_16 = null;
                        break block12;
                    }
                    catch (IOException e) {
                        var4_7 = LangUtil.unqualifiedClassName(e) + " writing " + file + ": " + e.getMessage();
                        var7_10 = null;
                        if (null == out) return var4_7;
                        try {
                            out.close();
                            return var4_7;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        return var4_7;
                    }
                }
                catch (Throwable var6_17) {
                    var7_11 = null;
                    if (null == out) throw var6_17;
                    try {}
                    catch (IOException e) {
                        throw var6_17;
                    }
                    out.close();
                    throw var6_17;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 158->165)] { 
lbl42:
            // 1 sources

            out.close();
            return var4_5;
lbl44:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var4_5;
        }
        var7_9 = null;
        if (null == out) return var5_16;
        ** try [egrp 2[TRYBLOCK] [2 : 158->165)] { 
lbl51:
        // 1 sources

        out.close();
        return var5_16;
lbl53:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return var5_16;
    }

    public static boolean[] readBooleanArray(DataInputStream s) throws IOException {
        int len = s.readInt();
        boolean[] ret = new boolean[len];
        int i = 0;
        while (i < len) {
            ret[i] = s.readBoolean();
            ++i;
        }
        return ret;
    }

    public static void writeBooleanArray(boolean[] a, DataOutputStream s) throws IOException {
        int len = a.length;
        s.writeInt(len);
        int i = 0;
        while (i < len) {
            s.writeBoolean(a[i]);
            ++i;
        }
    }

    public static int[] readIntArray(DataInputStream s) throws IOException {
        int len = s.readInt();
        int[] ret = new int[len];
        int i = 0;
        while (i < len) {
            ret[i] = s.readInt();
            ++i;
        }
        return ret;
    }

    public static void writeIntArray(int[] a, DataOutputStream s) throws IOException {
        int len = a.length;
        s.writeInt(len);
        int i = 0;
        while (i < len) {
            s.writeInt(a[i]);
            ++i;
        }
    }

    public static String[] readStringArray(DataInputStream s) throws IOException {
        int len = s.readInt();
        String[] ret = new String[len];
        int i = 0;
        while (i < len) {
            ret[i] = s.readUTF();
            ++i;
        }
        return ret;
    }

    public static void writeStringArray(String[] a, DataOutputStream s) throws IOException {
        if (a == null) {
            s.writeInt(0);
            return;
        }
        int len = a.length;
        s.writeInt(len);
        int i = 0;
        while (i < len) {
            s.writeUTF(a[i]);
            ++i;
        }
    }

    public static String readAsString(File file) throws IOException {
        int ch;
        BufferedReader r = new BufferedReader(new FileReader(file));
        StringBuffer b = new StringBuffer();
        while ((ch = r.read()) != -1) {
            b.append((char)ch);
        }
        r.close();
        return b.toString();
    }

    public static String readAsString(InputStream in) throws IOException {
        int ch;
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        StringBuffer b = new StringBuffer();
        while ((ch = r.read()) != -1) {
            b.append((char)ch);
        }
        in.close();
        r.close();
        return b.toString();
    }

    public static byte[] readAsByteArray(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        byte[] ret = FileUtil.readAsByteArray(in);
        in.close();
        return ret;
    }

    public static byte[] readAsByteArray(InputStream inStream) throws IOException {
        int nRead;
        int size = 1024;
        byte[] ba = new byte[size];
        int readSoFar = 0;
        while ((nRead = inStream.read(ba, readSoFar, size - readSoFar)) != -1) {
            if ((readSoFar += nRead) != size) continue;
            int newSize = size * 2;
            byte[] newBa = new byte[newSize];
            System.arraycopy(ba, 0, newBa, 0, size);
            ba = newBa;
            size = newSize;
        }
        byte[] newBa = new byte[readSoFar];
        System.arraycopy(ba, 0, newBa, 0, readSoFar);
        return newBa;
    }

    static String randomFileString() {
        double FILECHARS_length = FILECHARS.length();
        int LEN = 6;
        char[] result = new char[6];
        int index = (int)(Math.random() * 6.0);
        int i = 0;
        while (i < 6) {
            if (index >= 6) {
                index = 0;
            }
            result[index++] = FILECHARS.charAt((int)(Math.random() * FILECHARS_length));
            ++i;
        }
        return new String(result);
    }

    public static InputStream getStreamFromZip(String zipFile, String name) {
        try {
            ZipFile zf = new ZipFile(zipFile);
            try {
                ZipEntry entry = zf.getEntry(name);
                InputStream inputStream = zf.getInputStream(entry);
                Object var6_6 = null;
                return inputStream;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                throw throwable;
            }
        }
        catch (IOException ioe) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void extractJar(String zipFile, String outDir) throws IOException {
        ZipEntry entry;
        ZipInputStream zs = new ZipInputStream(new FileInputStream(zipFile));
        while ((entry = zs.getNextEntry()) != null) {
            void var3_3;
            if (var3_3.isDirectory()) continue;
            byte[] in = FileUtil.readAsByteArray(zs);
            File outFile = new File(outDir + "/" + var3_3.getName());
            outFile.getParentFile().mkdirs();
            FileOutputStream os = new FileOutputStream(outFile);
            os.write(in);
            os.close();
            zs.closeEntry();
        }
        zs.close();
    }

    public static List lineSeek(String sought, List sources, boolean listAll, PrintStream errorSink) {
        if (LangUtil.isEmpty(sought) || LangUtil.isEmpty(sources)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        Iterator iter = sources.iterator();
        while (iter.hasNext()) {
            String path = (String)iter.next();
            String error = FileUtil.lineSeek(sought, path, listAll, result);
            if (null == error || null == errorSink) continue;
            errorSink.println(error);
        }
        return result;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public static String lineSeek(String sought, String sourcePath, boolean listAll, ArrayList sink) {
        block15: {
            String line;
            if (LangUtil.isEmpty(sought) || LangUtil.isEmpty(sourcePath)) {
                return "nothing sought";
            }
            if (LangUtil.isEmpty(sourcePath)) {
                return "no sourcePath";
            }
            File file = new File(sourcePath);
            if (!file.canRead() || !file.isFile()) {
                return "sourcePath not a readable file";
            }
            int lineNum = 0;
            FileReader fin = null;
            fin = new FileReader(file);
            BufferedReader reader = new BufferedReader(fin);
            while (null != (line = reader.readLine())) {
                void var8_9;
                ++lineNum;
                int loc = var8_9.indexOf(sought);
                if (-1 == loc) continue;
                sink.add(sourcePath + ":" + lineNum + ":" + loc);
                if (!listAll) break;
            }
            Object var11_12 = null;
            try {
                if (null != fin) {
                    fin.close();
                }
                break block15;
            }
            catch (IOException e2) {}
            break block15;
            {
                catch (IOException e) {
                    String string = LangUtil.unqualifiedClassName(e) + " reading " + sourcePath + ":" + lineNum;
                    Object var11_13 = null;
                    try {
                        if (null != fin) {
                            fin.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    return string;
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    if (null != fin) {
                        fin.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return null;
    }

    public static BufferedOutputStream makeOutputStream(File file) throws FileNotFoundException {
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    public static boolean sleepPastFinalModifiedTime(File[] files) {
        if (null == files || 0 == files.length) {
            return true;
        }
        long delayUntil = System.currentTimeMillis();
        int i = 0;
        while (i < files.length) {
            long nextModTime;
            File file = files[i];
            if (null != file && file.exists() && (nextModTime = file.lastModified()) > delayUntil) {
                delayUntil = nextModTime;
            }
            ++i;
        }
        return LangUtil.sleepUntil(++delayUntil);
    }

    private static void listFiles(File baseDir, ArrayList result, FileFilter filter) {
        File[] files = baseDir.listFiles();
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            if (f.isDirectory()) {
                FileUtil.listFiles(f, result, filter);
            } else if (filter.accept(f)) {
                result.add(f);
            }
            ++i;
        }
    }

    private static boolean isValidFileName(String input) {
        return null != input && -1 == input.indexOf(File.pathSeparator);
    }

    private static void listFiles(File baseDir, String dir, ArrayList result) {
        String dirPrefix = null == dir ? "" : dir + "/";
        File dirFile = null == dir ? baseDir : new File(baseDir.getPath() + "/" + dir);
        String[] files = dirFile.list();
        int i = 0;
        while (i < files.length) {
            File f = new File(dirFile, files[i]);
            String path = dirPrefix + files[i];
            if (f.isDirectory()) {
                FileUtil.listFiles(baseDir, path, result);
            } else {
                result.add(path);
            }
            ++i;
        }
    }

    private FileUtil() {
        throw new Error("utility class");
    }

    public static List makeClasspath(URL[] urls) {
        LinkedList<String> ret = new LinkedList<String>();
        if (urls != null) {
            int i = 0;
            while (i < urls.length) {
                ret.add(urls[i].getPath());
                ++i;
            }
        }
        return ret;
    }

    public static class Pipe
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;
        private final long sleep;
        private ByteArrayOutputStream snoop;
        private long totalWritten;
        private Throwable thrown;
        private boolean halt;
        private final boolean closeInput;
        private final boolean closeOutput;
        private boolean finishStream;
        private boolean done;

        Pipe(InputStream in, OutputStream out) {
            this(in, out, 100L, false, false);
        }

        Pipe(InputStream in, OutputStream out, long sleep, boolean closeInput, boolean closeOutput) {
            LangUtil.throwIaxIfNull(in, "in");
            LangUtil.throwIaxIfNull(out, "out");
            this.in = in;
            this.out = out;
            this.closeInput = closeInput;
            this.closeOutput = closeOutput;
            this.sleep = Math.min(0L, Math.max(60000L, sleep));
        }

        public void setSnoop(ByteArrayOutputStream snoop) {
            this.snoop = snoop;
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            block27: {
                block25: {
                    block24: {
                        this.totalWritten = 0L;
                        if (this.halt) {
                            return;
                        }
                        MAX = 4096;
                        buf = new byte[4096];
                        count = this.in.read(buf, 0, 4096);
                        block12: while (this.halt && this.finishStream && 0 < count) {
                            while (true) {
                                this.out.write(buf, 0, count);
                                mySnoop = this.snoop;
                                if (null != mySnoop) {
                                    mySnoop.write(buf, 0, count);
                                }
                                this.totalWritten += (long)count;
                                if (!this.halt || this.finishStream) {
                                    if (!this.halt && 0L < this.sleep) {
                                        Thread.sleep(this.sleep);
                                    }
                                    if (!this.halt || this.finishStream) {
                                        count = this.in.read(buf, 0, 4096);
                                        continue block12;
                                    }
                                }
                                break block24;
                                break;
                            }
                        }
                        if (this.halt) break block24;
                        if (-1 != count) ** continue;
                    }
                    var6_6 = null;
                    this.halt = true;
                    if (!this.closeInput) break block25;
                    try {
                        this.in.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (this.closeOutput) {
                    try {
                        this.out.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                this.done = true;
                this.completing(this.totalWritten, this.thrown);
                {
                    break block27;
                    catch (Throwable e) {
                        this.thrown = e;
                        var6_7 = null;
                        this.halt = true;
                        if (this.closeInput) {
                            try {
                                this.in.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        if (this.closeOutput) {
                            try {
                                this.out.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        this.done = true;
                        this.completing(this.totalWritten, this.thrown);
                    }
                }
                catch (Throwable var5_12) {
                    var6_8 = null;
                    this.halt = true;
                    if (this.closeInput) {
                        try {
                            this.in.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    if (this.closeOutput) {
                        try {
                            this.out.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    this.done = true;
                    this.completing(this.totalWritten, this.thrown);
                    throw var5_12;
                }
            }
        }

        public boolean halt(boolean wait, boolean finishStream) {
            if (!this.halt) {
                this.halt = true;
            }
            if (wait) {
                while (!this.done) {
                    Pipe pipe = this;
                    synchronized (pipe) {
                        this.notifyAll();
                    }
                    if (this.done) continue;
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
            return this.halt;
        }

        public long totalWritten() {
            return this.totalWritten;
        }

        public Throwable getThrown() {
            return this.thrown;
        }

        protected void completing(long totalWritten, Throwable thrown) {
        }
    }
}

