/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc.trace;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.log.Log;
import com.mysql.jdbc.log.StandardLogger;
import java.io.PrintStream;
import java.sql.SQLException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;

public class Tracer {
    private Log standardLogger = new StandardLogger("MySQL", false);
    private ThreadLocal stream = new ThreadLocal(){

        protected Object initialValue() {
            return System.err;
        }
    };
    private ThreadLocal log = new ThreadLocal(){

        protected Object initialValue() {
            return Tracer.this.standardLogger;
        }
    };
    private ThreadLocal callDepth = new ThreadLocal(){

        protected Object initialValue() {
            return new Integer(0);
        }
    };
    private static Throwable ajc$initFailureCause;
    public static final Tracer ajc$perSingletonInstance;

    static {
        try {
            Tracer.ajc$postClinit();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public void ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(JoinPoint thisJoinPoint) {
        this.entry(thisJoinPoint, false);
    }

    public void ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Object o, JoinPoint thisJoinPoint) {
        this.exit(thisJoinPoint, false, o);
    }

    private PrintStream getStream() {
        return (PrintStream)this.stream.get();
    }

    private void setStream(PrintStream s) {
        this.stream.set(s);
    }

    private int getCallDepth() {
        return (Integer)this.callDepth.get();
    }

    private void setCallDepth(int n) {
        this.callDepth.set(new Integer(n));
    }

    private Log getLog() {
        return (Log)this.log.get();
    }

    private void setLog(Log l) {
        this.log.set(l);
    }

    private void entry(JoinPoint jp, boolean isConstructor) {
        if (jp.getTarget() instanceof Connection) {
            if ("getLog".equals(jp.getSignature().getName())) {
                return;
            }
            try {
                Log connectionLog = ((Connection)jp.getTarget()).getLog();
                if (this.getLog() != connectionLog) {
                    this.setLog(connectionLog);
                }
            }
            catch (SQLException sQLException) {}
        }
        if ("com.mysql.jdbc.Buffer".equals(jp.getSignature().getDeclaringTypeName()) && ("toString".equals(jp.getSignature().getName()) || "dumpClampedBytes".equals(jp.getSignature().getName()))) {
            return;
        }
        if ("com.mysql.jdbc.StringUtils".equals(jp.getSignature().getDeclaringTypeName()) && "dumpAsHex".equals(jp.getSignature().getName())) {
            return;
        }
        this.setCallDepth(this.getCallDepth() + 1);
        this.printEntering(jp, isConstructor);
    }

    private void exit(JoinPoint jp, boolean isConstructor, Object returnValue) {
        if (jp.getTarget() instanceof Connection && "getLog".equals(jp.getSignature().getName())) {
            return;
        }
        if ("com.mysql.jdbc.Buffer".equals(jp.getSignature().getDeclaringTypeName()) && ("toString".equals(jp.getSignature().getName()) || "dumpClampedBytes".equals(jp.getSignature().getName()))) {
            return;
        }
        if ("com.mysql.jdbc.StringUtils".equals(jp.getSignature().getDeclaringTypeName()) && "dumpAsHex".equals(jp.getSignature().getName())) {
            return;
        }
        this.printExiting(jp, isConstructor, returnValue);
        this.setCallDepth(this.getCallDepth() - 1);
    }

    private void printEntering(JoinPoint jp, boolean isConstructor) {
        if (this.getLog().isTraceEnabled()) {
            StringBuffer buf = new StringBuffer(80);
            this.printIndent(buf);
            buf.append("--> ");
            buf.append(jp.getSourceLocation().getFileName());
            buf.append(":");
            buf.append(jp.getSourceLocation().getLine());
            buf.append(" ");
            buf.append(jp.getSignature().getDeclaringTypeName());
            buf.append(".");
            buf.append(jp.getSignature().getName());
            this.printParameters(jp, buf);
            this.getLog().logTrace(buf);
        }
    }

    private void printExiting(JoinPoint jp, boolean isConstructor, Object returnValue) {
        if (this.getLog().isTraceEnabled()) {
            StringBuffer buf = new StringBuffer(80);
            this.printIndent(buf);
            buf.append("<--  ");
            buf.append(jp.getSourceLocation().getFileName());
            buf.append(":");
            buf.append(jp.getSourceLocation().getLine());
            buf.append(" ");
            buf.append(jp.getSignature().getDeclaringTypeName());
            buf.append(".");
            buf.append(jp.getSignature().getName());
            buf.append("(..) returning ");
            boolean isString = returnValue instanceof String;
            if (isString) {
                buf.append("\"");
            }
            buf.append(returnValue);
            if (isString) {
                buf.append("\"");
            }
            this.getLog().logTrace(buf);
        }
    }

    private void printIndent(StringBuffer buf) {
        int i = 0;
        while (i < this.getCallDepth()) {
            buf.append(" ");
            ++i;
        }
    }

    private void printParameters(JoinPoint jp, StringBuffer buf) {
        Object[] params = jp.getArgs();
        buf.append("(");
        int i = 0;
        while (i < params.length) {
            boolean isString = params[i] instanceof String;
            if (isString) {
                buf.append("\"");
            }
            if (params[i] != null) {
                Class<?> paramClass = params[i].getClass();
                String paramClassName = null;
                if (paramClass != null) {
                    paramClassName = paramClass.getName();
                }
                if (paramClassName != null && "com.mysql.jdbc.Buffer".equals(paramClassName) || "com.mysql.jdbc.ByteArrayBuffer".equals(paramClassName) || "com.mysql.jdbc.ChannelBuffer".equals(paramClassName)) {
                    buf.append("Network packet, data follows:\n\n");
                    buf.append(params[i]);
                    buf.append("\n\n");
                } else {
                    buf.append(params[i]);
                }
            } else {
                buf.append("null");
            }
            if (isString) {
                buf.append("\"");
            }
            if (i < params.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append(")");
    }

    public static Tracer aspectOf() {
        Tracer tracer = ajc$perSingletonInstance;
        if (tracer != null) {
            return tracer;
        }
        throw new NoAspectBoundException("com_mysql_jdbc_trace_Tracer", ajc$initFailureCause);
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    private static void ajc$postClinit() {
        ajc$perSingletonInstance = new Tracer();
    }
}

