/* $Header: /usr/cvsroot/libutf/findword.c,v 1.1.1.1 2006/05/26 20:14:56 agc Exp $ */

/*
 * Copyright © 1996-2006 Alistair Crooks.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include <config.h>

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#include <stdio.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include "utf.h"
#include "ure.h"

extern char	*optarg;
extern int	optind;

int
main(int argc, char **argv)
{
	FILE	*fp;
	char	buf[BUFSIZ];
	char	*lang;
	char	*word;
	int	icase;
	int	i;

	lang = (char *) NULL;
	icase = 0;
	while ((i = getopt(argc, argv, "a:i")) != -1) {
		switch(i) {
		case 'a':
			lang = optarg;
			break;
		case 'i':
			icase = 1;
			break;
		}
	}
	if ((fp = fopen(argv[optind], "r")) == (FILE *) NULL) {
		(void) fprintf(stderr, "can't open `%s'\n", argv[optind]);
		exit(1);
	}
	while (fgets(buf, sizeof(buf), fp) != (char *) NULL) {
		buf[utfbytes(buf) - 1] = 0;
		word = utfrune(buf, '\t');
		*word++ = 0;
		if (utflangcmp(buf, word, lang, icase) == 0) {
			printf("`%s' is `%s'\n", buf, word);
		}
	}
	(void) fclose(fp);
	exit(0);
}
