/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SYNCML_INTERNALS_H
#define _SYNCML_INTERNALS_H

#include <glib.h>
#include <string.h>
#include <glib/gprintf.h>
#include <sys/stat.h>
#include <stdint.h>
#include <stddef.h>
#include <stdlib.h>

#include "config.h"

#include <errno.h>
extern int errno;

#if defined(sun) && defined(__SVR4)
#define __FUNCTION__ __func__
#endif

#define smlAssert(x) if (!(x)) { fprintf(stderr, "%s:%i:E:%s: Assertion \"" #x "\" failed\n", __FILE__, __LINE__, __FUNCTION__); abort();}
#define smlAssertMsg(x, msg) if (!(x)) { fprintf(stderr, "%s:%i:E:%s: %s\n", __FILE__, __LINE__, __FUNCTION__, msg); abort();}
#define segfault_me char **blablabla = NULL; *blablabla = "test";

#define return_if_fail(condition) do {                                            \
  if (!(condition)) {                                                                   \
    return;                                                                             \
  } } while (0)

#define return_val_if_fail(condition, val) do {                                   \
  if (!(condition)) {                                                                   \
    return (val);                                                                       \
  } } while (0)

#include "sml_support.h"
#include "sml_parse.h"

#endif
