# Fuzz testing

Modern fuzz testers are very effective and we wish to use them to ensure that no silly bugs creep into BoringSSL.

We primarily use Clang's [libFuzzer](http://llvm.org/docs/LibFuzzer.html) for fuzz testing and there are a number of fuzz testing functions in `fuzz/`. They are not built by default because they require libFuzzer at build time.

In order to build the fuzz tests you will need at least Clang 3.7. Pass `-DFUZZ=1` on the CMake command line to enable building BoringSSL with coverage and AddressSanitizer, and to build the fuzz test binaries. You'll probably need to set the `CC` and `CXX` environment variables too, like this:

```
CC=clang CXX=clang++ cmake -GNinja -DFUZZ=1 ..
```

In order for the fuzz tests to link, the linker needs to find libFuzzer. This is not commonly provided and you may need to download the [Clang source code](http://llvm.org/releases/download.html) and do the following:

```
cd llvm-3.7.0.src/lib
clang -c -g -O2 -std=c++11 Fuzzer/*.cpp -IFuzzer
ar q libFuzzer.a *.o
```

Then copy `libFuzzer.a` to the top-level of your BoringSSL source directory.

From the `build/` directory, you can then run the fuzzers. For example:

```
./fuzz/cert -max_len=4000 -jobs=32 -workers=32 ../fuzz/cert_corpus/
```

The `max_len` argument is often important because, without it, libFuzzer defaults to limiting all test cases to 64 bytes, which is often insufficient for the formats that we wish to fuzz. The arguments to `jobs` and `workers` should be the number of cores that you wish to dedicate to fuzzing.

There are directories in `fuzz/` for each of the fuzzing tests which contain seed files for fuzzing. Some of the seed files were generated manually but many of them are “interesting” results generated by the fuzzing itself. (Where “interesting” means that it triggered a previously unknown path in the code.)

Here are the recommended values of `max_len` for each test.

| Test      | `max_len` value |
|-----------|-----------------|
| `privkey` | 2048            |
| `cert`    | 3072            |
| `server`  | 1024            |
| `client`  | 4096            |
