/**
 * @file ar.c AR module
 *
 * $Id: header.c,v 1.3 2003/01/01 06:22:31 chipx86 Exp $
 *
 * @Copyright (C) 2001-2003 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include "ar.h"

CxStatus
cxArValidateMagic(CxFP *fp)
{
	char magic[AR_MAGIC_LEN];

	if (cxRead(magic, AR_MAGIC_LEN, 1, fp) != 1)
		return CX_EOF;

	if (strncmp(magic, AR_MAGIC, AR_MAGIC_LEN))
		return CX_INVALID_FORMAT;

	return CX_SUCCESS;
}

CxStatus
cxArReadHeader(CxFP *fp, CxArHeader *header)
{
	size_t len;

	if (fp == NULL || header == NULL)
		return 0;
	
	memset(header, 0, AR_HEADER_LEN);

	len = cxRead(header, 1, AR_HEADER_LEN, fp);

	if (len == AR_HEADER_LEN)
	{
		if (strncmp(header->fmag, AR_FMAG, 2))
			return CX_CORRUPT;

		return CX_SUCCESS;
	}
	else if (len == 0)
	{
		return CX_EOF;
	}

	return CX_CORRUPT;
}
