/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt4;

import com.intellij.lang.jvm.JvmModifier;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\fH\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\"\u0018\u0010\u0006\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0003\"\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0018\u0010\u0007\u001a\u00020\b*\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\r\"\u0018\u0010\u0010\u001a\u00020\b*\u00020\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u001a\u0010\u0014\u001a\u0004\u0018\u00010\b*\u00020\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\"\u0018\u0010\u0016\u001a\u00020\u0011*\u00020\u00178@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\"\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u0017*\u00020\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\"\u001a\u0010\u001d\u001a\u0004\u0018\u00010\b*\u00020\u00178@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"isPrivate", "", "Lcom/intellij/psi/PsiModifierListOwner;", "(Lcom/intellij/psi/PsiModifierListOwner;)Z", "isFinal", "isAbstract", "isStatic", "signature", "", "Lcom/intellij/psi/PsiMethod;", "getSignature", "(Lcom/intellij/psi/PsiMethod;)Ljava/lang/String;", "Lcom/intellij/psi/PsiField;", "(Lcom/intellij/psi/PsiField;)Ljava/lang/String;", "getAsmFieldSignature", "field", "qualifiedName", "Lcom/intellij/psi/PsiType;", "getQualifiedName", "(Lcom/intellij/psi/PsiType;)Ljava/lang/String;", "simpleNameOrNull", "getSimpleNameOrNull", "defaultType", "Lcom/intellij/psi/PsiClass;", "getDefaultType", "(Lcom/intellij/psi/PsiClass;)Lcom/intellij/psi/PsiType;", "resolvedClass", "getResolvedClass", "(Lcom/intellij/psi/PsiType;)Lcom/intellij/psi/PsiClass;", "qualifiedNameWithDollars", "getQualifiedNameWithDollars", "(Lcom/intellij/psi/PsiClass;)Ljava/lang/String;", "kotlin-annotation-processing"})
public final class UtilsKt {
    public static final boolean isPrivate(@NotNull PsiModifierListOwner $this$isPrivate) {
        Intrinsics.checkNotNullParameter((Object)$this$isPrivate, (String)"<this>");
        return $this$isPrivate.hasModifier(JvmModifier.PRIVATE);
    }

    public static final boolean isFinal(@NotNull PsiModifierListOwner $this$isFinal) {
        Intrinsics.checkNotNullParameter((Object)$this$isFinal, (String)"<this>");
        return $this$isFinal.hasModifier(JvmModifier.FINAL);
    }

    public static final boolean isAbstract(@NotNull PsiModifierListOwner $this$isAbstract) {
        Intrinsics.checkNotNullParameter((Object)$this$isAbstract, (String)"<this>");
        return $this$isAbstract.hasModifier(JvmModifier.ABSTRACT);
    }

    public static final boolean isStatic(@NotNull PsiModifierListOwner $this$isStatic) {
        Intrinsics.checkNotNullParameter((Object)$this$isStatic, (String)"<this>");
        return $this$isStatic.hasModifier(JvmModifier.STATIC);
    }

    @NotNull
    public static final String getSignature(@NotNull PsiMethod $this$signature) {
        Intrinsics.checkNotNullParameter((Object)$this$signature, (String)"<this>");
        String string = ClassUtil.getAsmMethodSignature((PsiMethod)$this$signature);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsmMethodSignature(...)");
        return string;
    }

    @NotNull
    public static final String getSignature(@NotNull PsiField $this$signature) {
        Intrinsics.checkNotNullParameter((Object)$this$signature, (String)"<this>");
        return UtilsKt.getAsmFieldSignature($this$signature);
    }

    private static final String getAsmFieldSignature(PsiField field) {
        String string = ClassUtil.getBinaryPresentation((PsiType)field.getType());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBinaryPresentation(...)");
        return string;
    }

    @NotNull
    public static final String getQualifiedName(@NotNull PsiType $this$qualifiedName) {
        Intrinsics.checkNotNullParameter((Object)$this$qualifiedName, (String)"<this>");
        String string = $this$qualifiedName.getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
        CharSequence charSequence = string;
        Regex regex = new Regex("<.*>");
        String string2 = "";
        return regex.replace(charSequence, string2);
    }

    @Nullable
    public static final String getSimpleNameOrNull(@NotNull PsiType $this$simpleNameOrNull) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$simpleNameOrNull, (String)"<this>");
        if ($this$simpleNameOrNull instanceof PsiPrimitiveType) {
            return ((PsiPrimitiveType)$this$simpleNameOrNull).getName();
        }
        PsiClass resolvedClass = UtilsKt.getResolvedClass($this$simpleNameOrNull);
        if (resolvedClass instanceof PsiTypeParameter) {
            string = ((PsiTypeParameter)resolvedClass).getName();
        } else {
            PsiClass psiClass = resolvedClass;
            string = psiClass != null ? psiClass.getName() : null;
        }
        return string;
    }

    @NotNull
    public static final PsiType getDefaultType(@NotNull PsiClass $this$defaultType) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultType, (String)"<this>");
        PsiClassType psiClassType = PsiTypesUtil.getClassType((PsiClass)$this$defaultType);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"getClassType(...)");
        return (PsiType)psiClassType;
    }

    @Nullable
    public static final PsiClass getResolvedClass(@NotNull PsiType $this$resolvedClass) {
        Intrinsics.checkNotNullParameter((Object)$this$resolvedClass, (String)"<this>");
        PsiClassType psiClassType = $this$resolvedClass instanceof PsiClassType ? (PsiClassType)$this$resolvedClass : null;
        return psiClassType != null ? psiClassType.resolve() : null;
    }

    @Nullable
    public static final String getQualifiedNameWithDollars(@NotNull PsiClass $this$qualifiedNameWithDollars) {
        Intrinsics.checkNotNullParameter((Object)$this$qualifiedNameWithDollars, (String)"<this>");
        String string = PsiUtil.getPackageName((PsiClass)$this$qualifiedNameWithDollars);
        if (string == null) {
            return null;
        }
        String packageName = string;
        if (StringsKt.isBlank((CharSequence)packageName)) {
            String string2 = $this$qualifiedNameWithDollars.getQualifiedName();
            if (string2 == null || (string2 = StringsKt.replace$default((String)string2, (String)".", (String)"$", (boolean)false, (int)4, null)) == null) {
                return null;
            }
            return string2;
        }
        String string3 = $this$qualifiedNameWithDollars.getQualifiedName();
        if (string3 == null) {
            return null;
        }
        String qualifiedName = string3;
        String className = StringsKt.substringAfter$default((String)qualifiedName, (String)(packageName + '.'), null, (int)2, null);
        String classNameWithDollars = StringsKt.replace$default((String)className, (String)".", (String)"$", (boolean)false, (int)4, null);
        return packageName + '.' + classNameWithDollars;
    }
}

