/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtVisitor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\n\u0010\t\u001a\u0004\u0018\u00010\nH&J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0001H\u0016J5\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u0015\"\u0004\b\u0001\u0010\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u00160\u00182\u0006\u0010\u0019\u001a\u0002H\u0016H\u0016\u00a2\u0006\u0002\u0010\u001aR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u000b\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0013\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/psi/KtDoubleColonExpression;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "receiverExpression", "getReceiverExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "hasQuestionMarks", "", "getHasQuestionMarks", "()Z", "findColonColon", "Lcom/intellij/psi/PsiElement;", "doubleColonTokenReference", "getDoubleColonTokenReference", "()Lcom/intellij/psi/PsiElement;", "lhs", "getLhs", "setReceiverExpression", "", "newReceiverExpression", "isEmptyLHS", "accept", "R", "D", "visitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "psi"})
public interface KtDoubleColonExpression
extends KtExpression {
    @Nullable
    default public KtExpression getReceiverExpression() {
        PsiElement psiElement = this.getNode().getFirstChildNode().getPsi();
        return psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
    }

    default public boolean getHasQuestionMarks() {
        Iterator<ASTNode> iterator2 = SequencesKt.generateSequence(this.getNode().getFirstChildNode(), (Function1)hasQuestionMarks.1.INSTANCE).iterator();
        while (iterator2.hasNext()) {
            ASTNode element = iterator2.next();
            IElementType iElementType = element.getElementType();
            if (Intrinsics.areEqual(iElementType, KtTokens.QUEST)) {
                return true;
            }
            if (!Intrinsics.areEqual(iElementType, KtTokens.COLONCOLON)) continue;
            return false;
        }
        throw new IllegalStateException(("Double colon expression must have '::': " + this.getText()).toString());
    }

    @Nullable
    public PsiElement findColonColon();

    @NotNull
    default public PsiElement getDoubleColonTokenReference() {
        PsiElement psiElement = this.findColonColon();
        Intrinsics.checkNotNull(psiElement);
        return psiElement;
    }

    @Nullable
    default public PsiElement getLhs() {
        return this.getDoubleColonTokenReference().getPrevSibling();
    }

    default public void setReceiverExpression(@NotNull KtExpression newReceiverExpression) {
        Intrinsics.checkNotNullParameter(newReceiverExpression, "newReceiverExpression");
        KtExpression oldReceiverExpression = this.getReceiverExpression();
        PsiElement psiElement = oldReceiverExpression;
        if (psiElement == null || (psiElement = psiElement.replace(newReceiverExpression)) == null) {
            psiElement = this.addBefore(newReceiverExpression, this.getDoubleColonTokenReference());
        }
    }

    default public boolean isEmptyLHS() {
        return this.getLhs() == null;
    }

    @Override
    default public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitDoubleColonExpression(this, data);
    }
}

