/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoExtensionsKt;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCase;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCasesKt;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallInfo;
import org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\u00020\t*\u00020\u0007H\u0014J\f\u0010\n\u001a\u00020\t*\u00020\u0007H\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/js/translate/callTranslator/InvokeIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallCase;", "<init>", "()V", "canApply", "", "callInfo", "Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallInfo;", "dispatchReceiver", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "bothReceivers", "js.translator"})
public final class InvokeIntrinsic
extends FunctionCallCase {
    @NotNull
    public static final InvokeIntrinsic INSTANCE = new InvokeIntrinsic();

    private InvokeIntrinsic() {
    }

    public final boolean canApply(@NotNull FunctionCallInfo callInfo) {
        Intrinsics.checkNotNullParameter(callInfo, "callInfo");
        CallableDescriptor callableDescriptor = CallInfoExtensionsKt.getCallableDescriptor(callInfo);
        if (callableDescriptor instanceof FunctionInvokeDescriptor) {
            return true;
        }
        if (!Intrinsics.areEqual(callableDescriptor.getName(), OperatorNameConventions.INVOKE) || callableDescriptor.getExtensionReceiverParameter() == null) {
            return false;
        }
        int parameterCount = callableDescriptor.getValueParameters().size() + 1;
        DeclarationDescriptor declarationDescriptor = callableDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
        DeclarationDescriptor funDeclaration = declarationDescriptor;
        return Intrinsics.areEqual(funDeclaration, DescriptorUtilsKt.getBuiltIns(callableDescriptor).getFunction(parameterCount));
    }

    @Override
    @NotNull
    protected JsExpression dispatchReceiver(@NotNull FunctionCallInfo $this$dispatchReceiver) {
        Intrinsics.checkNotNullParameter($this$dispatchReceiver, "<this>");
        JsExpression jsExpression = $this$dispatchReceiver.getDispatchReceiver();
        Intrinsics.checkNotNull(jsExpression);
        return new JsInvocation(jsExpression, $this$dispatchReceiver.getArgumentsInfo().getTranslateArguments());
    }

    @Override
    @NotNull
    protected JsExpression bothReceivers(@NotNull FunctionCallInfo $this$bothReceivers) {
        Intrinsics.checkNotNullParameter($this$bothReceivers, "<this>");
        JsExpression jsExpression = $this$bothReceivers.getDispatchReceiver();
        Intrinsics.checkNotNull(jsExpression);
        CallArgumentTranslator.ArgumentsInfo argumentsInfo = $this$bothReceivers.getArgumentsInfo();
        JsExpression jsExpression2 = $this$bothReceivers.getExtensionReceiver();
        Intrinsics.checkNotNull(jsExpression2);
        return new JsInvocation(jsExpression, FunctionCallCasesKt.argsWithReceiver(argumentsInfo, jsExpression2));
    }
}

