/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u0004\u0018\u00010\u0005*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsNameRemappingTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "replacements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "<init>", "(Ljava/util/Map;)V", "replacement", "getReplacement", "(Lorg/jetbrains/kotlin/js/backend/ast/JsName;)Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "visit", "", "nameRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "backend.js"})
final class JsNameRemappingTransformer
extends JsVisitorWithContextImpl {
    @NotNull
    private final Map<JsName, JsExpression> replacements;

    public JsNameRemappingTransformer(@NotNull Map<JsName, ? extends JsExpression> replacements) {
        Intrinsics.checkNotNullParameter(replacements, "replacements");
        this.replacements = replacements;
    }

    private final JsExpression getReplacement(JsName $this$replacement) {
        return this.replacements.get($this$replacement);
    }

    public boolean visit(@NotNull JsNameRef nameRef, @NotNull JsContext<JsNode> ctx) {
        Intrinsics.checkNotNullParameter(nameRef, "nameRef");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        super.visit(nameRef, ctx);
        if (nameRef.getQualifier() != null) {
            return true;
        }
        HasMetadata hasMetadata = nameRef.getName();
        if (hasMetadata == null || (hasMetadata = this.getReplacement((JsName)hasMetadata)) == null) {
            return true;
        }
        HasMetadata replacement = hasMetadata;
        if (((SourceInfoAwareJsNode)replacement).getSource() == null) {
            ((SourceInfoAwareJsNode)replacement).setSource(nameRef.getSource());
        }
        ctx.replaceMe((JsNode)((Object)replacement));
        return false;
    }
}

