/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnosticWithNullability;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedError;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/diagnostics/ConeUnresolvedTypeQualifierError;", "Lorg/jetbrains/kotlin/fir/resolve/diagnostics/ConeUnresolvedError;", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnosticWithNullability;", "qualifiers", "", "Lorg/jetbrains/kotlin/fir/types/FirQualifierPart;", "isNullable", "", "<init>", "(Ljava/util/List;Z)V", "getQualifiers", "()Ljava/util/List;", "()Z", "qualifier", "", "getQualifier", "()Ljava/lang/String;", "reason", "getReason", "semantics"})
public final class ConeUnresolvedTypeQualifierError
implements ConeDiagnosticWithNullability,
ConeUnresolvedError {
    @NotNull
    private final List<FirQualifierPart> qualifiers;
    private final boolean isNullable;

    public ConeUnresolvedTypeQualifierError(@NotNull List<? extends FirQualifierPart> qualifiers, boolean isNullable) {
        Intrinsics.checkNotNullParameter(qualifiers, "qualifiers");
        this.qualifiers = qualifiers;
        this.isNullable = isNullable;
    }

    @NotNull
    public final List<FirQualifierPart> getQualifiers() {
        return this.qualifiers;
    }

    @Override
    public boolean isNullable() {
        return this.isNullable;
    }

    @Override
    @NotNull
    public String getQualifier() {
        return CollectionsKt.joinToString$default(this.qualifiers, ".", null, null, 0, null, ConeUnresolvedTypeQualifierError::_get_qualifier_$lambda$0, 30, null);
    }

    @Override
    @NotNull
    public String getReason() {
        return "Symbol not found for " + this.getQualifier() + (this.isNullable() ? "?" : "");
    }

    private static final CharSequence _get_qualifier_$lambda$0(FirQualifierPart it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string2 = it.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        return string2;
    }
}

