/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extra;

import com.intellij.psi.PsiElement;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R*\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00110\u0015j\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0011`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/RedundantCallOfConversionMethod;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isRedundant", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "qualifiedClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "targetClassMap", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "checkers"})
public final class RedundantCallOfConversionMethod
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final RedundantCallOfConversionMethod INSTANCE = new RedundantCallOfConversionMethod();
    @NotNull
    private static final HashMap<String, ClassId> targetClassMap;

    private RedundantCallOfConversionMethod() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!(expression2 instanceof FirFunctionCall)) {
            return;
        }
        String string2 = ((FirFunctionCall)expression2).getCalleeReference().getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        String functionName = string2;
        ClassId classId = targetClassMap.get(functionName);
        if (classId == null) {
            return;
        }
        ClassId qualifiedType = classId;
        FirExpression firExpression = ((FirFunctionCall)expression2).getExplicitReceiver();
        boolean bl = firExpression != null ? this.isRedundant(firExpression, qualifiedType, context.getSession()) : false;
        if (bl) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirFunctionCall)expression2).getSource(), FirErrors.INSTANCE.getREDUNDANT_CALL_OF_CONVERSION_METHOD(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final boolean isRedundant(FirExpression $this$isRedundant, ClassId qualifiedClassId, FirSession session2) {
        Object object;
        if ($this$isRedundant instanceof FirLiteralExpression) {
            object = ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getResolvedType($this$isRedundant));
        } else if (FirTypeUtilsKt.getResolvedType($this$isRedundant) instanceof ConeFlexibleType) {
            object = null;
        } else {
            PsiElement psiElement = UtilsKt.getPsi($this$isRedundant);
            object = !((psiElement != null ? psiElement.getParent() : null) instanceof KtSafeQualifiedExpression) && (UtilsKt.getPsi($this$isRedundant) instanceof KtSafeQualifiedExpression || ConeTypeUtilsKt.isMarkedNullable(FirTypeUtilsKt.getResolvedType($this$isRedundant))) ? null : (ConeTypeUtilsKt.isMarkedNullable(FirTypeUtilsKt.getResolvedType($this$isRedundant)) ? null : FirHelpersKt.fullyExpandedClassId(FirTypeUtilsKt.getResolvedType($this$isRedundant), session2));
        }
        ClassId thisType = object;
        return Intrinsics.areEqual(thisType, qualifiedClassId);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to("toString", StandardClassIds.INSTANCE.getString()), TuplesKt.to("toDouble", StandardClassIds.INSTANCE.getDouble()), TuplesKt.to("toFloat", StandardClassIds.INSTANCE.getFloat()), TuplesKt.to("toLong", StandardClassIds.INSTANCE.getLong()), TuplesKt.to("toInt", StandardClassIds.INSTANCE.getInt()), TuplesKt.to("toChar", StandardClassIds.INSTANCE.getChar()), TuplesKt.to("toShort", StandardClassIds.INSTANCE.getShort()), TuplesKt.to("toByte", StandardClassIds.INSTANCE.getByte()), TuplesKt.to("toULong", StandardClassIds.INSTANCE.getULong()), TuplesKt.to("toUInt", StandardClassIds.INSTANCE.getUInt()), TuplesKt.to("toUShort", StandardClassIds.INSTANCE.getUShort()), TuplesKt.to("toUByte", StandardClassIds.INSTANCE.getUByte())};
        targetClassMap = MapsKt.hashMapOf(pairArray);
    }
}

