/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a>\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0019\u0010\u0003\u001a\u0015\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\u0002\b\u00062\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0002\b\u0006\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\tH\u0002\u00a8\u0006\n"}, d2={"isMaybeMainFunction", "", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "getPlatformName", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "isPlatformStatic", "isValidMainFunctionParameter", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "semantics"})
@SourceDebugExtension(value={"SMAP\nmainFunctionDetection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 mainFunctionDetection.kt\norg/jetbrains/kotlin/fir/MainFunctionDetectionKt\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n71#2:65\n1557#3:66\n1628#3,3:67\n*S KotlinDebug\n*F\n+ 1 mainFunctionDetection.kt\norg/jetbrains/kotlin/fir/MainFunctionDetectionKt\n*L\n36#1:65\n44#1:66\n44#1:67,3\n*E\n"})
public final class MainFunctionDetectionKt {
    /*
     * WARNING - void declaration
     */
    public static final boolean isMaybeMainFunction(@NotNull FirSimpleFunction $this$isMaybeMainFunction, @NotNull Function1<? super FirSimpleFunction, String> getPlatformName, @NotNull Function1<? super FirSimpleFunction, Boolean> isPlatformStatic) {
        boolean bl;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$isMaybeMainFunction, "<this>");
        Intrinsics.checkNotNullParameter(getPlatformName, "getPlatformName");
        Intrinsics.checkNotNullParameter(isPlatformStatic, "isPlatformStatic");
        FirSimpleFunction $this$isLocal$iv = $this$isMaybeMainFunction;
        boolean $i$f$isLocal = false;
        if (Intrinsics.areEqual($this$isLocal$iv.getStatus().getVisibility(), Visibilities.Local.INSTANCE)) {
            return false;
        }
        if (!((Collection)$this$isMaybeMainFunction.getTypeParameters()).isEmpty()) {
            return false;
        }
        if (!ConeBuiltinTypeUtilsKt.isUnit(FirTypeUtilsKt.getConeType($this$isMaybeMainFunction.getReturnTypeRef()))) {
            return false;
        }
        boolean isTopLevel = ClassMembersKt.containingClassLookupTag($this$isMaybeMainFunction) == null;
        String string2 = getPlatformName.invoke($this$isMaybeMainFunction);
        if (string2 == null) {
            String string3 = $this$isMaybeMainFunction.getName().asString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
        }
        if (!Intrinsics.areEqual(string2, "main")) {
            return false;
        }
        Iterable $this$map$iv = $this$isMaybeMainFunction.getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getReturnTypeRef());
        }
        FirReceiverParameter firReceiverParameter = $this$isMaybeMainFunction.getReceiverParameter();
        List valueParametersTypes = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)CollectionsKt.listOfNotNull(firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null));
        switch (valueParametersTypes.size()) {
            case 0: {
                if (isTopLevel && Intrinsics.areEqual($this$isMaybeMainFunction.getName().asString(), "main")) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                bl = MainFunctionDetectionKt.isValidMainFunctionParameter(FirTypeUtilsKt.getConeType((FirTypeRef)CollectionsKt.single(valueParametersTypes)));
                break;
            }
            default: {
                bl = false;
            }
        }
        boolean hasValidParameters = bl;
        return hasValidParameters && (isTopLevel || isPlatformStatic.invoke($this$isMaybeMainFunction) != false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isValidMainFunctionParameter(ConeKotlinType $this$isValidMainFunctionParameter) {
        if (!ConeBuiltinTypeUtilsKt.isArrayType($this$isValidMainFunctionParameter)) return false;
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.arrayElementType$default($this$isValidMainFunctionParameter, false, 1, null);
        if (coneKotlinType == null) return false;
        if (!ConeBuiltinTypeUtilsKt.isString(coneKotlinType)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (ConeTypeProjectionKt.getVariance($this$isValidMainFunctionParameter) == Variance.IN_VARIANCE) return false;
        return true;
    }
}

