/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/cfg/WhenOnNullableExhaustivenessChecker;", "", "<init>", "()V", "getMissingCases", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "nullable", "", "getNullCaseIfMissing", "frontend"})
final class WhenOnNullableExhaustivenessChecker {
    @NotNull
    public static final WhenOnNullableExhaustivenessChecker INSTANCE = new WhenOnNullableExhaustivenessChecker();

    private WhenOnNullableExhaustivenessChecker() {
    }

    @NotNull
    public final List<WhenMissingCase> getMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context, boolean nullable) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        return nullable ? this.getNullCaseIfMissing(expression2, context) : CollectionsKt.emptyList();
    }

    private final List<WhenMissingCase> getNullCaseIfMissing(KtWhenExpression expression2, BindingContext context) {
        for (KtWhenEntry entry : expression2.getEntries()) {
            for (KtWhenCondition condition : entry.getConditions()) {
                KtExpression it;
                if (!(condition instanceof KtWhenConditionWithExpression)) continue;
                if (((KtWhenConditionWithExpression)condition).getExpression() == null) continue;
                boolean bl = false;
                KotlinType type2 = context.getType(it);
                if (type2 == null || !KotlinBuiltIns.isNullableNothing(type2)) continue;
                return CollectionsKt.emptyList();
            }
        }
        return CollectionsKt.listOf(WhenMissingCase.NullIsMissing.INSTANCE);
    }
}

