/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.CachedFieldsForObjectInstances;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.JvmStaticAnnotationLoweringKt;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.lazy.IrLazyFunctionBase;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/SingletonObjectJvmStaticTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "cachedFields", "Lorg/jetbrains/kotlin/backend/jvm/CachedFieldsForObjectInstances;", "<init>", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/backend/jvm/CachedFieldsForObjectInstances;)V", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "transformFunction", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitMemberAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "backend.jvm.lower"})
public final class SingletonObjectJvmStaticTransformer
extends IrElementTransformerVoid {
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final CachedFieldsForObjectInstances cachedFields;

    public SingletonObjectJvmStaticTransformer(@NotNull IrBuiltIns irBuiltIns, @NotNull CachedFieldsForObjectInstances cachedFields) {
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        Intrinsics.checkNotNullParameter(cachedFields, "cachedFields");
        this.irBuiltIns = irBuiltIns;
        this.cachedFields = cachedFields;
    }

    @Override
    @NotNull
    public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        this.transformFunction(declaration);
        return super.visitSimpleFunction(declaration);
    }

    private final void transformFunction(IrFunction function2) {
        block2: {
            if (!JvmStaticAnnotationLoweringKt.isJvmStaticInObject(function2)) break block2;
            IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
            if (irValueParameter != null) {
                IrValueParameter oldDispatchReceiverParameter = irValueParameter;
                boolean bl = false;
                function2.setDispatchReceiverParameter(null);
                if (!(function2 instanceof IrLazyFunctionBase)) {
                    JvmIrUtilsKt.replaceThisByStaticReference(function2, this.cachedFields, IrUtilsKt.getParentAsClass(function2), oldDispatchReceiverParameter);
                }
            }
        }
    }

    @Override
    @NotNull
    public IrExpression visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        IrSymbolOwner callee = expression2.getSymbol().getOwner();
        if (callee instanceof IrFunction) {
            this.transformFunction((IrFunction)callee);
        }
        if (callee instanceof IrProperty) {
            IrSimpleFunction it;
            IrSimpleFunction irSimpleFunction = ((IrProperty)callee).getGetter();
            if (irSimpleFunction != null) {
                it = irSimpleFunction;
                boolean bl = false;
                this.transformFunction(it);
            }
            IrSimpleFunction irSimpleFunction2 = ((IrProperty)callee).getSetter();
            if (irSimpleFunction2 != null) {
                it = irSimpleFunction2;
                boolean bl = false;
                this.transformFunction(it);
            }
        }
        if (callee instanceof IrDeclaration && JvmStaticAnnotationLoweringKt.isJvmStaticInObject((IrDeclaration)callee)) {
            return JvmStaticAnnotationLoweringKt.access$makeStatic(expression2, this.irBuiltIns, null);
        }
        return expression2;
    }
}

