/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithAssignedFileType;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightVirtualFileBase
extends VirtualFile
implements VirtualFileWithAssignedFileType {
    private FileType myFileType;
    private String myName;
    private long myModStamp;
    private boolean myIsWritable = true;
    private boolean myValid = true;
    private VirtualFile myOriginalFile;
    private static final MyVirtualFileSystem ourFileSystem = new MyVirtualFileSystem();

    public LightVirtualFileBase(String name2, FileType fileType, long modificationStamp) {
        this.myName = name2;
        this.myFileType = fileType;
        this.myModStamp = modificationStamp;
    }

    public void setFileType(FileType fileType) {
        this.myFileType = fileType;
    }

    public VirtualFile getOriginalFile() {
        return this.myOriginalFile;
    }

    public void setOriginalFile(VirtualFile originalFile) {
        this.myOriginalFile = originalFile;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        MyVirtualFileSystem myVirtualFileSystem = ourFileSystem;
        if (myVirtualFileSystem == null) {
            LightVirtualFileBase.$$$reportNull$$$0(0);
        }
        return myVirtualFileSystem;
    }

    @Override
    @Nullable
    public FileType getAssignedFileType() {
        return this.myFileType;
    }

    @Override
    @NotNull
    public String getPath() {
        VirtualFile parent2 = this.getParent();
        String string2 = (parent2 == null ? "" : parent2.getPath()) + "/" + this.getName();
        if (string2 == null) {
            LightVirtualFileBase.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            LightVirtualFileBase.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    public boolean isWritable() {
        return this.myIsWritable;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.myValid;
    }

    @Override
    public VirtualFile getParent() {
        return null;
    }

    @Override
    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    @Override
    public long getModificationStamp() {
        return this.myModStamp;
    }

    protected void setModificationStamp(long stamp) {
        this.myModStamp = stamp;
    }

    @Override
    public long getTimeStamp() {
        return 0L;
    }

    @Override
    public long getLength() {
        try {
            return this.contentsToByteArray().length;
        }
        catch (IOException e) {
            e.printStackTrace();
            assert (false);
            return 0L;
        }
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    @Override
    public void setWritable(boolean writable) {
        this.myIsWritable = writable;
    }

    @Override
    public void rename(Object requestor, @NotNull String newName) throws IOException {
        if (newName == null) {
            LightVirtualFileBase.$$$reportNull$$$0(3);
        }
        this.assertWritable();
        this.myName = newName;
    }

    void assertWritable() {
        if (!this.isWritable()) {
            throw new IncorrectOperationException("File is not writable: " + this);
        }
    }

    @Override
    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull String name2) throws IOException {
        if (name2 == null) {
            LightVirtualFileBase.$$$reportNull$$$0(4);
        }
        this.assertWritable();
        VirtualFile virtualFile = super.createChildDirectory(requestor, name2);
        if (virtualFile == null) {
            LightVirtualFileBase.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull String name2) throws IOException {
        if (name2 == null) {
            LightVirtualFileBase.$$$reportNull$$$0(6);
        }
        this.assertWritable();
        VirtualFile virtualFile = super.createChildData(requestor, name2);
        if (virtualFile == null) {
            LightVirtualFileBase.$$$reportNull$$$0(7);
        }
        return virtualFile;
    }

    @Override
    public void delete(Object requestor) throws IOException {
        this.assertWritable();
        super.delete(requestor);
    }

    @Override
    public void move(Object requestor, @NotNull VirtualFile newParent) throws IOException {
        if (newParent == null) {
            LightVirtualFileBase.$$$reportNull$$$0(8);
        }
        this.assertWritable();
        super.move(requestor, newParent);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setBinaryContent(byte @NotNull [] content, long newModificationStamp, long l) throws IOException {
        void newTimeStamp;
        if (content == null) {
            LightVirtualFileBase.$$$reportNull$$$0(9);
        }
        this.assertWritable();
        super.setBinaryContent(content, newModificationStamp, (long)newTimeStamp);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setBinaryContent(byte @NotNull [] content, long newModificationStamp, long newTimeStamp, Object object) throws IOException {
        void requestor;
        if (content == null) {
            LightVirtualFileBase.$$$reportNull$$$0(10);
        }
        this.assertWritable();
        super.setBinaryContent(content, newModificationStamp, newTimeStamp, requestor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LightVirtualFileBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LightVirtualFileBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildData";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createChildData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setBinaryContent";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyVirtualFileSystem
    extends DeprecatedVirtualFileSystem
    implements NonPhysicalFileSystem {
        private MyVirtualFileSystem() {
            this.startEventPropagation();
        }

        @Override
        @NotNull
        public String getProtocol() {
            return "mock";
        }

        @Override
        @Nullable
        public VirtualFile findFileByPath(@NotNull String path) {
            if (path == null) {
                MyVirtualFileSystem.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        public void refresh(boolean asynchronous) {
        }

        @Override
        @Nullable
        public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
            if (path == null) {
                MyVirtualFileSystem.$$$reportNull$$$0(1);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "path";
            objectArray2[1] = "com/intellij/testFramework/LightVirtualFileBase$MyVirtualFileSystem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findFileByPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refreshAndFindFileByPath";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

