/***************************************************************************
	timer.c - timer & frame rate functions

    begin                : 24 Mar 2003
    copyright            : (C) 2003 by Paul Rahme
****************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
****************************************************************************/

#include "main.h"
#include "timer.h"

#include "input.h"

Uint32	elapsedTime;			// no of milliseconds the program has been running
Uint32	secondEndTime;			// when SDL_GetTicks() > this value, another second has passed
int		frameRate;				// no of frames processed this second
Uint32	elapsedFrameTime;		// no of milliseconds since the last frame

// Resets the game timer & frame rate counter
void TM_Init(void)
{
	elapsedTime = SDL_GetTicks();
	secondEndTime = 0;
	frameRate = 0;
	elapsedFrameTime = 0;
}

// Updates the game timer & frame rate counter
// Call once a frame
void TM_UpdateTimer(void)
{
	int prevFrameElapsedTime;

	frameRate++;
	prevFrameElapsedTime = elapsedTime;
	elapsedTime = SDL_GetTicks();
	if (gamePaused)
	{
		elapsedFrameTime = 0;
	} else {
		elapsedFrameTime = (elapsedTime - prevFrameElapsedTime);
	}

	if (elapsedTime > secondEndTime)
	{
		#ifdef DEBUG_FRAMERATE
		printf("elapsedTime = %i ms, last frame's elapsedFrameTime = %i ms, frameRate = %i fps.\n",
			elapsedTime, elapsedFrameTime, frameRate);
		#endif
		secondEndTime = elapsedTime + 1000;
		frameRate = 0;
	}
}
