/***************************************************************************
	audio.h - music & sound code - header

    begin                : 20 June 2004
    copyright            : (C) 2004 by Paul Rahme
****************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
****************************************************************************/

// -------------------------------------------------------------------------------------------------
// Consts and structures
// -------------------------------------------------------------------------------------------------

enum AUD_Songs
{
	SONG_DUMMY,
	// ---------------
	AUD_NO_OF_SONGS
};

extern const char *AUD_SongNames[AUD_NO_OF_SONGS];

enum AUD_Sounds
{
	SND_WEAK_SHOT,
	// ----------------
	AUD_NO_OF_SOUNDS
};

extern const char *AUD_SoundNames[AUD_NO_OF_SOUNDS];

// -------------------------------------------------------------------------------------------------
// Variables
// -------------------------------------------------------------------------------------------------


// -------------------------------------------------------------------------------------------------
// Macros
// -------------------------------------------------------------------------------------------------


// -------------------------------------------------------------------------------------------------
// Functions
// -------------------------------------------------------------------------------------------------

// Initialises audio
void AUD_Init();

// Starts the specified sound effect playing, and calculates stereo from the x position (0-639)
// _volume can be -1 for default or 0-255, _freq can be -1 for default or actual hz.
void AUD_PlaySound(enum AUD_Sounds _soundID, int _xPos, int _volume, int _freq);

// Loads the specified module and starts it playing, forcing it to restart the song if required
void AUD_StartSong(enum AUD_Songs _song, int _forceRestart);

// Updates the audio - call once per frame
void AUD_Update();

// Stops the current song
void AUD_HaltSong();

// Shuts down audio
void AUD_Kill();
