/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.reconstructor;

import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Method;
import jd.core.model.classfile.constant.ConstantMethodref;
import jd.core.model.classfile.constant.ConstantNameAndType;
import jd.core.model.instruction.bytecode.instruction.DupLoad;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNew;
import jd.core.model.instruction.bytecode.instruction.Invokespecial;
import jd.core.model.instruction.bytecode.instruction.New;
import jd.core.process.analyzer.classfile.reconstructor.NewInstructionReconstructorBase;
import jd.core.process.analyzer.util.ReconstructorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewInstructionReconstructor
extends NewInstructionReconstructorBase {
    public static void Reconstruct(ClassFile classFile, Method method, List<Instruction> list) {
        int dupStoreIndex = 0;
        while (dupStoreIndex < list.size()) {
            if (list.get((int)dupStoreIndex).opcode == 264) {
                DupStore ds = (DupStore)list.get(dupStoreIndex);
                if (ds.objectref.opcode == 187) {
                    int invokespecialIndex = dupStoreIndex;
                    int length = list.size();
                    while (++invokespecialIndex < length) {
                        Instruction instruction = list.get(invokespecialIndex);
                        if (instruction.opcode != 183) continue;
                        Invokespecial is = (Invokespecial)instruction;
                        if (is.objectref.opcode != 263) continue;
                        DupLoad dl = (DupLoad)is.objectref;
                        if (dl.offset != ds.offset) continue;
                        ConstantPool constants = classFile.getConstantPool();
                        ConstantMethodref cmr = constants.getConstantMethodref(is.index);
                        ConstantNameAndType cnat = constants.getConstantNameAndType(cmr.name_and_type_index);
                        if (cnat.name_index != constants.instanceConstructorIndex) continue;
                        New nw = (New)ds.objectref;
                        InvokeNew invokeNew = new InvokeNew(274, is.offset, nw.lineNumber, is.index, is.args);
                        Instruction parentFound = ReconstructorUtil.ReplaceDupLoad(list, invokespecialIndex + 1, ds, invokeNew);
                        list.remove(invokespecialIndex);
                        if (parentFound == null) {
                            list.set(dupStoreIndex, invokeNew);
                        } else {
                            list.remove(dupStoreIndex--);
                        }
                        NewInstructionReconstructor.InitAnonymousClassConstructorParameterName(classFile, method, invokeNew);
                        break;
                    }
                }
            }
            ++dupStoreIndex;
        }
    }
}

