/*
Copyright 1997, Isect
*/
#include <stdio.h>
#include <errno.h>
#include "isdio.h"

#ifdef LPWORKER
extern int ntprint(isdHeader *, char *);
#endif

int 
main(int argc, char **argv)
{
	int bytes;
	SOCKET sock;
	isdHeader header;
	char *msgBuffer;

	unsigned long allPacks, allBytes, yourPacks, yourBytes;

	char stats[512];

	if (argc >= ISDARGMAX) {
		if ((sock = isdConnect(argv)) != -1) {
			allPacks = allBytes = yourPacks = yourBytes = 0;
			for (;;) {
				if (msgBuffer = isdRecv(sock, &header)) {
					allPacks++, yourPacks++;
					allBytes += header.len;
					yourBytes += header.len;
#ifdef LPWORKER
					ntprint(&header, msgBuffer);
#endif
#ifdef DDEWORKER
					ddeFunctions(sock, &header, msgBuffer);
/*
ddeFunctions() handles sending back all the messages.  letting
it handle the xactions really makes things easier
*/
#else
					if (header.more == 0) {
						sprintf(stats,
							" AllPacks   AllBytes  YourPacks  YourBytes\n"
							"---------  ---------  ---------  ---------\n"
							"%9d  %9d  %9d  %9d\n",
							allPacks, allBytes, yourPacks, yourBytes);

						fputs(stats, stderr);
						bytes = isdSend(sock, stats, -1, &header);
						if (bytes == -1)
							fprintf(stderr, "%s: isdSend() reply\n", argv[ISDARGWID], strerror(errno));
						yourPacks = yourBytes = 0;
					}
#endif
				}
				else
					break;
			}
			fprintf(stderr, "Worker %s exiting\n", argv[ISDARGWID], strerror(errno));
			isdLogout(sock);
		}
		else
			fprintf(stderr, "isdConnect(): %s\n",  strerror(errno));
	}
	else
		fprintf(stderr, "Worker must be started with argc >= %d\n", ISDARGMAX);
	return 0;
}
