#include "tvfuncs.h"
/*
8/10/1999 NaN in fmod() fixed by Stefaan A Eeclels
*/

static double 
tv2double(struct timeval tv)
{
	return (double) (tv.tv_sec * 1000.0 + tv.tv_usec / 1000.0);
}

static struct timeval 
double2tv(double dtime)
{
	struct timeval tv;

	tv.tv_sec = (long) (dtime / 1000.0);
	tv.tv_usec = (long) ((dtime - tv.tv_sec * 1000.0) * 1000.0);

	return tv;
}

struct timeval  
tvMinus(struct timeval *time1, struct timeval *time2)
{
	struct timeval tv;
	long whole, part;

	if (time1->tv_usec < time2->tv_usec) {
		time1->tv_sec--;
		time1->tv_usec += 1000000;
	}

	part = time1->tv_usec - time2->tv_usec;
	whole = time1->tv_sec - time2->tv_sec;

	tv.tv_sec = whole;
	tv.tv_usec = part;

	return tv;
}

#include "isectd.h"

struct timeval 
tvAverage(struct timeval avgtime, struct timeval thistime, int alltimes)
{
	double sumtime;
	struct timeval tval;

	sumtime = tv2double(avgtime);

 	sumtime *= (alltimes - 1);

	sumtime += tv2double(thistime);
	sumtime /= alltimes;

	return double2tv(sumtime);
}

