#include "isectd.h"
#include <time.h>

char *
isdStatClientQueue(char *cp, int argc, char **argv)
{
	Node *node;
	isdClient *client;

	cp += ADDBYTES(sprintf(cp,
						   "%5s  " "%-16s" "%5s" "%8s  " "%-16s" "%7s" "%10s" "%7s" "%7s" "%12s" "%12s" "%12s" "%5s\n",
						   "id", "service", "pri", "ready?", "hostname", "pid", "xactions", "from", "to", "login secs", "avg. resp.", "last resp.", "fd"));

	for (node = isdData.PriList.head; node != QNULL; node = node->next) {
		client = (isdClient *) node;
		cp += ADDBYTES(sprintf(cp, "%1c%4d  %-16s%5d%8s  %-16s%7d%10d%7d%7d% 12d%12d.%03d%12d.%03d%5d\n",
							   client->blockable ? '*' : ' ',
							   client->id,
							   ((isdService *) client->service)->name,
							   client->priority,
			  					client->ready ? "yes" : client->blocked ? "blocked" : "no",
							   client->loghost,
							   client->hostpid,
							   client->Transactions,
							   client->fromCount,
							   client->toCount,
							   time(0) - client->login_time,
							   client->AverageTime.tv_sec, client->AverageTime.tv_usec / 1000,
							   client->LastTime.tv_sec, client->LastTime.tv_usec / 1000,
							   client->socket));
	}

	return cp;
}
