#include "isectd.h"

void 
isdIdleWorker(isdWorker * worker)
{
	isdClient *client;

	client = worker->client;

	worker->client = NULL;

	if (client) {
		client->worker = NULL;
		if (client->socket == INVALID_SOCKET)
			isdClientEOF(client);
	}

	if (worker->stopped)
		InsertHead(&isdData.LazyWorkers, RemoveNode((Node *) worker));
	else {
		if (!FD_ISSET(worker->socket, &isdData.writefds))
			FD_SET(worker->socket, &isdData.writefds);
		InsertHead(&isdData.IdleWorkers, RemoveNode((Node *) worker));
	}
}
